/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.property.inspector;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.PropertiesManager;
import com.android.tools.idea.common.property.inspector.InspectorComponent;
import com.android.tools.idea.common.property.inspector.InspectorProvider;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class InspectorProviders<PropMgr extends PropertiesManager<PropMgr>>
implements LafManagerListener,
Disposable {
    protected final PropMgr myPropertiesManager;

    public InspectorProviders(PropMgr propertiesManager, Disposable parentDisposable) {
        this.myPropertiesManager = propertiesManager;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        LafManager.getInstance().addLafManagerListener((LafManagerListener)this);
    }

    @NotNull
    public List<InspectorComponent<PropMgr>> createInspectorComponents(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull PropMgr propertiesManager) {
        if (components == null) {
            InspectorProviders.$$$reportNull$$$0(0);
        }
        if (properties == null) {
            InspectorProviders.$$$reportNull$$$0(1);
        }
        if (propertiesManager == null) {
            InspectorProviders.$$$reportNull$$$0(2);
        }
        List<InspectorProvider<PropMgr>> providers = this.getProviders();
        ArrayList<InspectorComponent<PropMgr>> inspectors = new ArrayList<InspectorComponent<PropMgr>>(providers.size());
        if (components.isEmpty()) {
            ImmutableList immutableList = ImmutableList.of(this.getNullProvider().createCustomInspector(components, properties, propertiesManager));
            if (immutableList == null) {
                InspectorProviders.$$$reportNull$$$0(3);
            }
            return immutableList;
        }
        for (InspectorProvider<PropMgr> provider : providers) {
            if (!provider.isApplicable(components, properties, propertiesManager)) continue;
            inspectors.add(provider.createCustomInspector(components, properties, propertiesManager));
        }
        ArrayList<InspectorComponent<PropMgr>> arrayList = inspectors;
        if (arrayList == null) {
            InspectorProviders.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public void lookAndFeelChanged(LafManager source) {
        this.getProviders().forEach(InspectorProvider::resetCache);
        ((PropertiesManager)this.myPropertiesManager).updateSelection();
    }

    public void dispose() {
        LafManager.getInstance().removeLafManagerListener((LafManagerListener)this);
    }

    protected abstract List<InspectorProvider<PropMgr>> getProviders();

    protected abstract InspectorProvider<PropMgr> getNullProvider();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesManager";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/property/inspector/InspectorProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/property/inspector/InspectorProviders";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createInspectorComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createInspectorComponents";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

