/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.property2.impl.model;

import com.android.tools.adtui.model.stdui.ValueChangedListener;
import com.android.tools.idea.common.property2.api.HelpSupport;
import com.android.tools.idea.common.property2.api.InspectorLineModel;
import com.android.tools.idea.common.property2.api.PropertyEditorModel;
import com.android.tools.idea.common.property2.api.PropertyItem;
import com.intellij.openapi.actionSystem.AnAction;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\r\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020$H\u0016J\b\u0010+\u001a\u00020)H\u0016J\b\u0010,\u001a\u00020)H\u0016J\b\u0010-\u001a\u00020)H\u0004J\b\u0010.\u001a\u00020)H\u0016J\u0010\u0010/\u001a\u00020)2\u0006\u00100\u001a\u00020\u001cH\u0016J\b\u00101\u001a\u00020)H\u0016J\u0010\u00102\u001a\u00020)2\u0006\u0010*\u001a\u00020$H\u0016J\b\u00103\u001a\u00020)H\u0016J\b\u00104\u001a\u00020)H\u0016J\b\u00105\u001a\u00020)H\u0016R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\r\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR$\u0010\u0010\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\t\"\u0004\b\u0012\u0010\u000bR\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR$\u0010\u0005\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u001c8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u001e\"\u0004\b \u0010!R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010%\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\t\"\u0004\b'\u0010\u000b\u00a8\u00066"}, d2={"Lcom/android/tools/idea/common/property2/impl/model/BasePropertyEditorModel;", "Lcom/android/tools/idea/common/property2/api/PropertyEditorModel;", "property", "Lcom/android/tools/idea/common/property2/api/PropertyItem;", "(Lcom/android/tools/idea/common/property2/api/PropertyItem;)V", "value", "", "blockUpdates", "getBlockUpdates", "()Z", "setBlockUpdates", "(Z)V", "<set-?>", "focusRequest", "getFocusRequest", "setFocusRequest", "hasFocus", "getHasFocus", "setHasFocus", "lineModel", "Lcom/android/tools/idea/common/property2/api/InspectorLineModel;", "getLineModel", "()Lcom/android/tools/idea/common/property2/api/InspectorLineModel;", "setLineModel", "(Lcom/android/tools/idea/common/property2/api/InspectorLineModel;)V", "getProperty", "()Lcom/android/tools/idea/common/property2/api/PropertyItem;", "tooltip", "", "getTooltip", "()Ljava/lang/String;", "getValue", "setValue", "(Ljava/lang/String;)V", "valueChangeListeners", "", "Lcom/android/tools/adtui/model/stdui/ValueChangedListener;", "visible", "getVisible", "setVisible", "addListener", "", "listener", "enterKeyPressed", "f1KeyPressed", "fireValueChanged", "focusGained", "focusLost", "editedValue", "refresh", "removeListener", "requestFocus", "shiftF1KeyPressed", "updateValueFromProperty", "intellij.android.designer"})
public abstract class BasePropertyEditorModel
implements PropertyEditorModel {
    private final List<ValueChangedListener> valueChangeListeners;
    private boolean visible;
    private boolean hasFocus;
    private boolean focusRequest;
    @Nullable
    private InspectorLineModel lineModel;
    private boolean blockUpdates;
    @NotNull
    private final PropertyItem property;

    @Override
    @NotNull
    public String getValue() {
        String string = this.getProperty().getValue();
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public void setValue(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        CharSequence charSequence = value;
        PropertyItem propertyItem = this.getProperty();
        boolean bl = charSequence.length() == 0;
        propertyItem.setValue(bl ? null : value);
        this.refresh();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getVisible() {
        if (!this.visible) return false;
        InspectorLineModel inspectorLineModel = this.getLineModel();
        if (inspectorLineModel == null) return true;
        if (inspectorLineModel.getHidden()) return false;
        return true;
    }

    @Override
    public void setVisible(boolean value) {
        this.visible = value;
        this.fireValueChanged();
    }

    @Override
    public final boolean getHasFocus() {
        return this.hasFocus;
    }

    private final void setHasFocus(boolean bl) {
        this.hasFocus = bl;
    }

    public final boolean getFocusRequest() {
        return this.focusRequest;
    }

    private final void setFocusRequest(boolean bl) {
        this.focusRequest = bl;
    }

    @Override
    public void requestFocus() {
        if (!this.hasFocus) {
            this.focusRequest = true;
            this.fireValueChanged();
            this.focusRequest = false;
        }
    }

    @NotNull
    public final String getTooltip() {
        return this.getProperty().getTooltipForValue();
    }

    @Override
    @Nullable
    public InspectorLineModel getLineModel() {
        return this.lineModel;
    }

    @Override
    public void setLineModel(@Nullable InspectorLineModel inspectorLineModel) {
        this.lineModel = inspectorLineModel;
    }

    public void enterKeyPressed() {
        InspectorLineModel inspectorLineModel = this.getLineModel();
        if (inspectorLineModel == null) {
            return;
        }
        InspectorLineModel line = inspectorLineModel;
        line.getGotoNextLine().invoke((Object)line);
    }

    public void f1KeyPressed() {
        block1: {
            PropertyItem propertyItem = this.getProperty();
            if (!(propertyItem instanceof HelpSupport)) {
                propertyItem = null;
            }
            HelpSupport helpSupport = (HelpSupport)((Object)propertyItem);
            if (helpSupport == null) break block1;
            helpSupport.help();
        }
    }

    public void shiftF1KeyPressed() {
        block1: {
            PropertyItem propertyItem = this.getProperty();
            if (!(propertyItem instanceof HelpSupport)) {
                propertyItem = null;
            }
            HelpSupport helpSupport = (HelpSupport)((Object)propertyItem);
            if (helpSupport == null) break block1;
            helpSupport.secondaryHelp();
        }
    }

    @Override
    public void refresh() {
        this.updateValueFromProperty();
        this.fireValueChanged();
    }

    public void updateValueFromProperty() {
    }

    public void focusGained() {
        this.hasFocus = true;
    }

    public void focusLost(@NotNull String editedValue) {
        Intrinsics.checkParameterIsNotNull((Object)editedValue, (String)"editedValue");
        this.hasFocus = false;
        if (Intrinsics.areEqual((Object)editedValue, (Object)this.getValue()) ^ true) {
            this.setValue(editedValue);
        }
    }

    @Override
    public void addListener(@NotNull ValueChangedListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.valueChangeListeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull ValueChangedListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.valueChangeListeners.remove(listener2);
    }

    protected final boolean getBlockUpdates() {
        return this.blockUpdates;
    }

    protected final void setBlockUpdates(boolean value) {
        this.blockUpdates = value;
        this.fireValueChanged();
    }

    protected final void fireValueChanged() {
        if (!this.blockUpdates) {
            Iterable $receiver$iv = this.valueChangeListeners;
            for (Object element$iv : $receiver$iv) {
                ValueChangedListener it = (ValueChangedListener)element$iv;
                it.valueChanged();
            }
        }
    }

    @Override
    @NotNull
    public PropertyItem getProperty() {
        return this.property;
    }

    public BasePropertyEditorModel(@NotNull PropertyItem property2) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
        this.property = property2;
        BasePropertyEditorModel basePropertyEditorModel = this;
        basePropertyEditorModel.valueChangeListeners = list = (List)new ArrayList();
        this.visible = true;
    }

    @Override
    public boolean getActionButtonFocusable() {
        return PropertyEditorModel.DefaultImpls.getActionButtonFocusable(this);
    }

    @Override
    @Nullable
    public Icon getActionIcon(boolean focused) {
        return PropertyEditorModel.DefaultImpls.getActionIcon(this, focused);
    }

    @Override
    @Nullable
    public AnAction getButtonAction() {
        return PropertyEditorModel.DefaultImpls.getButtonAction(this);
    }
}

