/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.property2.impl.model;

import com.android.tools.adtui.model.stdui.ValueChangedListener;
import com.android.tools.idea.common.property2.api.InspectorLineModel;
import com.android.tools.idea.common.property2.impl.model.CollapsibleLabelModel;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.text.Matcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fJ\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000eJ\b\u0010\u0014\u001a\u00020\u0010H\u0002J\u0006\u0010\u0015\u001a\u00020\u0010J\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0010H\u0002J\u000e\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fJ\u0006\u0010\u001d\u001a\u00020\u0010J\u000e\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000eJ\b\u0010\u001f\u001a\u00020\u0010H\u0002J\b\u0010 \u001a\u00020\u0010H\u0002R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/common/property2/impl/model/InspectorPanelModel;", "", "()V", "value", "", "filter", "getFilter", "()Ljava/lang/String;", "setFilter", "(Ljava/lang/String;)V", "lines", "", "Lcom/android/tools/idea/common/property2/api/InspectorLineModel;", "listeners", "Lcom/android/tools/adtui/model/stdui/ValueChangedListener;", "add", "", "line", "addValueChangedListener", "listener", "applyFilter", "clear", "enterInFilter", "", "findClosestNextLine", "lineIndex", "", "fireValueChanged", "moveToNextLineEditor", "propertyValuesChanged", "removeValueChangedListener", "restoreGroups", "updateFiltering", "intellij.android.designer"})
public final class InspectorPanelModel {
    private List<ValueChangedListener> listeners;
    private final List<InspectorLineModel> lines;
    @NotNull
    private String filter;

    @NotNull
    public final String getFilter() {
        return this.filter;
    }

    public final void setFilter(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.filter = value;
        this.updateFiltering();
    }

    public final void clear() {
        this.lines.clear();
    }

    public final void moveToNextLineEditor(@NotNull InspectorLineModel line) {
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        int index = this.lines.indexOf(line);
        if (index < 0) {
            return;
        }
        InspectorLineModel inspectorLineModel = this.findClosestNextLine(index);
        if (inspectorLineModel == null) {
            return;
        }
        InspectorLineModel nextLine = inspectorLineModel;
        nextLine.requestFocus();
    }

    private final InspectorLineModel findClosestNextLine(int lineIndex) {
        int index = (lineIndex + 1) % this.lines.size();
        while (index != lineIndex) {
            InspectorLineModel line = this.lines.get(index);
            if (line.getVisible() && line.getFocusable()) {
                return line;
            }
            index = (index + 1) % this.lines.size();
        }
        return null;
    }

    public final void propertyValuesChanged() {
        Iterable $receiver$iv = this.lines;
        for (Object element$iv : $receiver$iv) {
            InspectorLineModel it = (InspectorLineModel)element$iv;
            it.refresh();
        }
    }

    public final void add(@NotNull InspectorLineModel line) {
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        this.lines.add(line);
    }

    public final void addValueChangedListener(@NotNull ValueChangedListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    public final void removeValueChangedListener(@NotNull ValueChangedListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean enterInFilter() {
        CollapsibleLabelModel label;
        Object object;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        CharSequence charSequence = this.filter;
        if (charSequence.length() == 0) {
            return false;
        }
        Iterable iterable = $receiver$iv = (Iterable)this.lines;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            InspectorLineModel it = (InspectorLineModel)element$iv$iv;
            if (!it.getVisible()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List visibleLabels = (List)destination$iv$iv;
        if (visibleLabels.size() != 1) {
            return false;
        }
        Object e = visibleLabels.get(0);
        if (!(e instanceof CollapsibleLabelModel)) {
            e = null;
        }
        if ((object = (label = (CollapsibleLabelModel)e)) == null || (object = ((CollapsibleLabelModel)object).getEditorModel()) == null) {
            return false;
        }
        Object editor = object;
        editor.requestFocus();
        return true;
    }

    private final void updateFiltering() {
        CharSequence charSequence = this.filter;
        if (charSequence.length() > 0) {
            this.applyFilter();
        } else {
            this.restoreGroups();
        }
        this.fireValueChanged();
    }

    private final void applyFilter() {
        MinusculeMatcher matcher = NameUtil.buildMatcher((String)('*' + this.filter)).build();
        Iterable $receiver$iv = this.lines;
        for (Object element$iv : $receiver$iv) {
            InspectorLineModel line = (InspectorLineModel)element$iv;
            if (line instanceof CollapsibleLabelModel) {
                CollapsibleLabelModel collapsibleLabelModel = (CollapsibleLabelModel)line;
                MinusculeMatcher minusculeMatcher = matcher;
                Intrinsics.checkExpressionValueIsNotNull((Object)minusculeMatcher, (String)"matcher");
                collapsibleLabelModel.hideForSearch(line.isMatch((Matcher)minusculeMatcher));
                continue;
            }
            if (line.isSearchable()) {
                line.setFilter(this.filter);
                continue;
            }
            MinusculeMatcher minusculeMatcher = matcher;
            Intrinsics.checkExpressionValueIsNotNull((Object)minusculeMatcher, (String)"matcher");
            line.setVisible(line.isMatch((Matcher)minusculeMatcher));
        }
    }

    private final void restoreGroups() {
        Iterable $receiver$iv = CollectionsKt.reversed((Iterable)this.lines);
        for (Object element$iv : $receiver$iv) {
            InspectorLineModel line = (InspectorLineModel)element$iv;
            if (line instanceof CollapsibleLabelModel) {
                ((CollapsibleLabelModel)line).restoreAfterSearch();
                continue;
            }
            if (line.isSearchable()) {
                line.setFilter("");
                continue;
            }
            line.setVisible(true);
        }
    }

    private final void fireValueChanged() {
        Iterable $receiver$iv = this.listeners;
        for (Object element$iv : $receiver$iv) {
            ValueChangedListener it = (ValueChangedListener)element$iv;
            it.valueChanged();
        }
    }

    public InspectorPanelModel() {
        List list;
        InspectorPanelModel inspectorPanelModel = this;
        inspectorPanelModel.listeners = list = (List)new ArrayList();
        inspectorPanelModel = this;
        inspectorPanelModel.lines = list = (List)new ArrayList();
        this.filter = "";
    }
}

