/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.BlueprintColorSet;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import com.intellij.reference.SoftReference;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SceneContext {
    ColorSet myColorSet;
    Long myTime = System.currentTimeMillis();
    int myMouseX = -1;
    int myMouseY = -1;
    private boolean myShowOnlySelection = false;
    private static SceneContext lazySingleton;
    private static WeakHashMap<SceneView, SoftReference<SceneViewTransform>> cache;

    private SceneContext() {
    }

    public void setShowOnlySelection(boolean value) {
        this.myShowOnlySelection = value;
    }

    public long getTime() {
        return this.myTime;
    }

    public void setTime(long time2) {
        this.myTime = time2;
    }

    public void setMouseLocation(int x, int y) {
        this.myMouseX = x;
        this.myMouseY = y;
    }

    public int getMouseX() {
        return this.myMouseX;
    }

    public int getMouseY() {
        return this.myMouseY;
    }

    public void repaint() {
    }

    public int getSwingXDip(float x) {
        return (int)x;
    }

    public int getSwingYDip(float y) {
        return (int)y;
    }

    public int getSwingX(int x) {
        return x;
    }

    public int getSwingY(int y) {
        return y;
    }

    public int getSwingDimensionDip(float dim) {
        return (int)dim;
    }

    public int getSwingDimension(int dim) {
        return dim;
    }

    public ColorSet getColorSet() {
        return this.myColorSet;
    }

    public double getScale() {
        return 1.0;
    }

    public static SceneContext get() {
        if (lazySingleton == null) {
            lazySingleton = new SceneContext();
            SceneContext.lazySingleton.myColorSet = new BlueprintColorSet();
        }
        return lazySingleton;
    }

    public static SceneContext get(SceneView sceneView) {
        if (cache.containsKey(sceneView)) {
            SceneViewTransform viewTransform;
            SoftReference<SceneViewTransform> viewTransformRef = cache.get(sceneView);
            SceneViewTransform sceneViewTransform = viewTransform = viewTransformRef != null ? (SceneViewTransform)viewTransformRef.get() : null;
            if (viewTransform != null) {
                return viewTransform;
            }
        }
        SceneViewTransform sceneViewTransform = new SceneViewTransform(sceneView);
        sceneViewTransform.myColorSet = sceneView.getColorSet();
        cache.put(sceneView, (SoftReference<SceneViewTransform>)new SoftReference((Object)sceneViewTransform));
        return sceneViewTransform;
    }

    @Nullable
    public DesignSurface getSurface() {
        return null;
    }

    public void setToolTip(@Nullable String toolTip) {
    }

    public float pxToDp(int px) {
        return (float)px * Coordinates.DEFAULT_DENSITY;
    }

    public boolean showOnlySelection() {
        return this.myShowOnlySelection;
    }

    static {
        cache = new WeakHashMap();
    }

    private static class SceneViewTransform
    extends SceneContext {
        SceneView mySceneView;

        public SceneViewTransform(SceneView sceneView) {
            this.mySceneView = sceneView;
        }

        @Override
        public void setToolTip(@Nullable String toolTip) {
            this.mySceneView.setToolTip(toolTip);
        }

        @Override
        @NotNull
        public DesignSurface getSurface() {
            DesignSurface designSurface = this.mySceneView.getSurface();
            if (designSurface == null) {
                SceneViewTransform.$$$reportNull$$$0(0);
            }
            return designSurface;
        }

        @Override
        public double getScale() {
            return this.mySceneView.getScale();
        }

        @Override
        public int getSwingXDip(float x) {
            return Coordinates.getSwingX(this.mySceneView, Coordinates.dpToPx(this.mySceneView, x));
        }

        @Override
        public int getSwingYDip(float y) {
            return Coordinates.getSwingY(this.mySceneView, Coordinates.dpToPx(this.mySceneView, y));
        }

        @Override
        public int getSwingX(int x) {
            return Coordinates.getSwingX(this.mySceneView, x);
        }

        @Override
        public int getSwingY(int y) {
            return Coordinates.getSwingY(this.mySceneView, y);
        }

        @Override
        public float pxToDp(int px) {
            return Coordinates.pxToDp(this.mySceneView, px);
        }

        @Override
        public void repaint() {
            this.mySceneView.getSurface().needsRepaint();
        }

        @Override
        public int getSwingDimensionDip(float dim) {
            return Coordinates.getSwingDimension(this.mySceneView, Coordinates.dpToPx(this.mySceneView, dim));
        }

        @Override
        public int getSwingDimension(int dim) {
            return Coordinates.getSwingDimension(this.mySceneView, dim);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/common/scene/SceneContext$SceneViewTransform", "getSurface"));
        }
    }
}

