/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.DefaultHitProvider;
import com.android.tools.idea.common.scene.HitProvider;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecoratorFactory;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.util.PropertiesMap;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SceneManager
implements Disposable {
    public static final boolean SUPPORTS_LOCKING = false;
    @NotNull
    private final NlModel myModel;
    @NotNull
    private final DesignSurface myDesignSurface;
    @NotNull
    private final Scene myScene;
    @NotNull
    private SceneView mySceneView;
    @NotNull
    private final HitProvider myHitProvider;

    public SceneManager(@NotNull NlModel model, @NotNull DesignSurface surface) {
        if (model == null) {
            SceneManager.$$$reportNull$$$0(0);
        }
        if (surface == null) {
            SceneManager.$$$reportNull$$$0(1);
        }
        this.myHitProvider = new DefaultHitProvider();
        this.myModel = model;
        this.myDesignSurface = surface;
        Disposer.register((Disposable)model, (Disposable)this);
        this.myScene = new Scene(this, this.myDesignSurface);
    }

    protected void createSceneView() {
        this.mySceneView = this.doCreateSceneView();
        this.myDesignSurface.addLayers(this.getLayers());
    }

    @NotNull
    protected abstract SceneView doCreateSceneView();

    public void updateSceneView() {
        this.myDesignSurface.removeLayers(this.getLayers());
        this.getLayers().forEach(Layer::dispose);
        this.createSceneView();
    }

    @NotNull
    public SceneView getSceneView() {
        SceneView sceneView = this.mySceneView;
        if (sceneView == null) {
            SceneManager.$$$reportNull$$$0(2);
        }
        return sceneView;
    }

    @NotNull
    public ImmutableList<Layer> getLayers() {
        ImmutableList<Layer> immutableList = this.mySceneView.getLayers();
        if (immutableList == null) {
            SceneManager.$$$reportNull$$$0(3);
        }
        return immutableList;
    }

    public void dispose() {
        this.getLayers().forEach(Disposer::dispose);
    }

    public void update() {
        ImmutableList<NlComponent> components = this.getModel().getComponents();
        Scene scene = this.getScene();
        if (components.isEmpty()) {
            scene.removeAllComponents();
            scene.setRoot(null);
            return;
        }
        HashSet<SceneComponent> usedComponents = new HashSet<SceneComponent>();
        HashSet<SceneComponent> oldComponents = new HashSet<SceneComponent>(scene.getSceneComponents());
        NlComponent rootComponent = this.getRoot();
        if (this.myScene.getRoot() != null && rootComponent != this.myScene.getRoot().getNlComponent()) {
            scene.removeAllComponents();
            scene.setRoot(null);
        }
        SceneComponent root = this.createHierarchy(rootComponent);
        scene.setRoot(root);
        if (root != null) {
            this.updateFromComponent(root, usedComponents);
        }
        oldComponents.removeAll(usedComponents);
        oldComponents.removeIf(component -> component instanceof TemporarySceneComponent);
        oldComponents.forEach(scene::removeComponent);
        scene.needsRebuildList();
    }

    @NotNull
    protected NlComponent getRoot() {
        NlComponent nlComponent = ((NlComponent)this.getModel().getComponents().get(0)).getRoot();
        if (nlComponent == null) {
            SceneManager.$$$reportNull$$$0(4);
        }
        return nlComponent;
    }

    public static boolean isComponentLocked(@NotNull NlComponent component) {
        if (component == null) {
            SceneManager.$$$reportNull$$$0(5);
        }
        return false;
    }

    @Nullable
    protected SceneComponent createHierarchy(@NotNull NlComponent component) {
        SceneComponent sceneComponent;
        if (component == null) {
            SceneManager.$$$reportNull$$$0(6);
        }
        if ((sceneComponent = this.getScene().getSceneComponent(component)) == null) {
            sceneComponent = new SceneComponent(this.getScene(), component, this.getHitProvider(component));
        }
        sceneComponent.setToolLocked(SceneManager.isComponentLocked(component));
        HashSet<SceneComponent> oldChildren = new HashSet<SceneComponent>(sceneComponent.getChildren());
        for (NlComponent nlChild : component.getChildren()) {
            SceneComponent child = this.createHierarchy(nlChild);
            oldChildren.remove(child);
            if (child == null || child.getParent() == sceneComponent) continue;
            sceneComponent.addChild(child);
        }
        for (SceneComponent child : oldChildren) {
            if (child instanceof TemporarySceneComponent && child.getParent() == sceneComponent || child.getParent() != sceneComponent) continue;
            child.removeFromParent();
        }
        return sceneComponent;
    }

    protected final void updateFromComponent(@NotNull SceneComponent component, @NotNull Set<SceneComponent> seenComponents) {
        if (component == null) {
            SceneManager.$$$reportNull$$$0(7);
        }
        if (seenComponents == null) {
            SceneManager.$$$reportNull$$$0(8);
        }
        seenComponents.add(component);
        this.updateFromComponent(component);
        for (SceneComponent child : component.getChildren()) {
            this.updateFromComponent(child, seenComponents);
        }
        this.postUpdateFromComponent(component);
    }

    protected void postUpdateFromComponent(@NotNull SceneComponent component) {
        if (component == null) {
            SceneManager.$$$reportNull$$$0(9);
        }
    }

    @NotNull
    public abstract TemporarySceneComponent createTemporaryComponent(@NotNull NlComponent var1);

    protected void updateFromComponent(SceneComponent sceneComponent) {
        sceneComponent.setToolLocked(false);
    }

    @NotNull
    protected DesignSurface getDesignSurface() {
        DesignSurface designSurface = this.myDesignSurface;
        if (designSurface == null) {
            SceneManager.$$$reportNull$$$0(10);
        }
        return designSurface;
    }

    @NotNull
    public NlModel getModel() {
        NlModel nlModel = this.myModel;
        if (nlModel == null) {
            SceneManager.$$$reportNull$$$0(11);
        }
        return nlModel;
    }

    @NotNull
    public Scene getScene() {
        Scene scene = this.myScene;
        if (scene == null) {
            SceneManager.$$$reportNull$$$0(12);
        }
        return scene;
    }

    public abstract void requestRender();

    public void requestLayoutAndRender(boolean animate) {
    }

    public abstract void layout(boolean var1);

    @NotNull
    public abstract SceneDecoratorFactory getSceneDecoratorFactory();

    public abstract Map<Object, PropertiesMap> getDefaultProperties();

    @NotNull
    protected HitProvider getHitProvider(@NotNull NlComponent component) {
        if (component == null) {
            SceneManager.$$$reportNull$$$0(13);
        }
        HitProvider hitProvider = this.myHitProvider;
        if (hitProvider == null) {
            SceneManager.$$$reportNull$$$0(14);
        }
        return hitProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/scene/SceneManager";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seenComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/scene/SceneManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayers";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDesignSurface";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getScene";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getHitProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isComponentLocked";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createHierarchy";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateFromComponent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "postUpdateFromComponent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getHitProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

