/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.LerpValue;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DrawCommand;
import com.android.tools.idea.common.scene.draw.DrawCommandSerializationHelperKt;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tB\u0015\b\u0012\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rB\u000f\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000fB)\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0011\u001a\u00020\u0005\u0012\u0006\u0010\u0012\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\fH\u0016R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/common/scene/draw/DrawFilledCircle;", "Lcom/android/tools/idea/common/scene/draw/DrawCommand;", "myLevel", "", "myCenter", "Ljava/awt/Point;", "myColor", "Ljava/awt/Color;", "radius", "(ILjava/awt/Point;Ljava/awt/Color;I)V", "sp", "", "", "([Ljava/lang/String;)V", "s", "(Ljava/lang/String;)V", "level", "center", "color", "Lcom/android/tools/idea/common/scene/LerpValue;", "(ILjava/awt/Point;Ljava/awt/Color;Lcom/android/tools/idea/common/scene/LerpValue;)V", "getLevel", "paint", "", "g", "Ljava/awt/Graphics2D;", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "serialize", "intellij.android.designer"})
public final class DrawFilledCircle
implements DrawCommand {
    private final int level;
    private final Point center;
    private final Color color;
    private final LerpValue radius;

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    @NotNull
    public String serialize() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        return DrawCommandSerializationHelperKt.buildString(string, this.level, DrawCommandSerializationHelperKt.pointToString(this.center), DrawCommandSerializationHelperKt.colorToString(this.color), DrawCommandSerializationHelperKt.lerpToString(this.radius));
    }

    @Override
    public void paint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        Graphics g2;
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)sceneContext, (String)"sceneContext");
        int r = this.radius.getValue(sceneContext.getTime());
        Graphics graphics = g2 = g.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)graphics, (String)"g2");
        graphics.setColor(this.color);
        g2.fillOval(this.center.x - r, this.center.y - r, 2 * r, 2 * r);
        g2.dispose();
        if (r != this.radius.getEnd()) {
            sceneContext.repaint();
        }
    }

    public DrawFilledCircle(int level, @NotNull Point center, @NotNull Color color, @NotNull LerpValue radius) {
        Intrinsics.checkParameterIsNotNull((Object)center, (String)"center");
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        Intrinsics.checkParameterIsNotNull((Object)radius, (String)"radius");
        this.level = level;
        this.center = center;
        this.color = color;
        this.radius = radius;
    }

    public DrawFilledCircle(int myLevel, @NotNull Point myCenter, @NotNull Color myColor, int radius) {
        Intrinsics.checkParameterIsNotNull((Object)myCenter, (String)"myCenter");
        Intrinsics.checkParameterIsNotNull((Object)myColor, (String)"myColor");
        this(myLevel, myCenter, myColor, new LerpValue(radius));
    }

    private DrawFilledCircle(String[] sp) {
        String string = sp[0];
        DrawFilledCircle drawFilledCircle = this;
        int n = Integer.parseInt(string);
        drawFilledCircle(n, DrawCommandSerializationHelperKt.stringToPoint(sp[1]), DrawCommandSerializationHelperKt.stringToColor(sp[2]), DrawCommandSerializationHelperKt.stringToLerp(sp[3]));
    }

    public DrawFilledCircle(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        this(DrawCommandSerializationHelperKt.parse(s, 4));
    }
}

