/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DrawCommand;
import com.android.tools.idea.common.scene.draw.DrawCommandSerializationHelperKt;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\b\u0012\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007B5\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u0012\b\b\u0001\u0010\f\u001a\u00020\r\u0012\b\b\u0001\u0010\u000e\u001a\u00020\t\u0012\b\b\u0003\u0010\u000f\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\tH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0004H\u0016R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/common/scene/draw/DrawRectangle;", "Lcom/android/tools/idea/common/scene/draw/DrawCommand;", "sp", "", "", "([Ljava/lang/String;)V", "s", "(Ljava/lang/String;)V", "level", "", "rectangle", "Ljava/awt/Rectangle;", "color", "Ljava/awt/Color;", "brushThickness", "arcSize", "(ILjava/awt/Rectangle;Ljava/awt/Color;II)V", "getLevel", "paint", "", "g", "Ljava/awt/Graphics2D;", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "serialize", "intellij.android.designer"})
public final class DrawRectangle
implements DrawCommand {
    private final int level;
    private final Rectangle rectangle;
    private final Color color;
    private final int brushThickness;
    private final int arcSize;

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    @NotNull
    public String serialize() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        return DrawCommandSerializationHelperKt.buildString(string, this.level, DrawCommandSerializationHelperKt.rectToString(this.rectangle), DrawCommandSerializationHelperKt.colorToString(this.color), this.brushThickness, this.arcSize);
    }

    @Override
    public void paint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)sceneContext, (String)"sceneContext");
        Graphics graphics = g.create();
        if (graphics == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D g2 = (Graphics2D)graphics;
        g2.setColor(this.color);
        g2.setStroke(new BasicStroke(this.brushThickness));
        g2.drawRoundRect(this.rectangle.x, this.rectangle.y, this.rectangle.width, this.rectangle.height, this.arcSize, this.arcSize);
        g2.dispose();
    }

    public DrawRectangle(int level, @NotNull Rectangle rectangle, @NotNull Color color, int brushThickness, int arcSize) {
        Intrinsics.checkParameterIsNotNull((Object)rectangle, (String)"rectangle");
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        this.level = level;
        this.rectangle = rectangle;
        this.color = color;
        this.brushThickness = brushThickness;
        this.arcSize = arcSize;
    }

    public /* synthetic */ DrawRectangle(int n, Rectangle rectangle, Color color, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x10) != 0) {
            n3 = 0;
        }
        this(n, rectangle, color, n2, n3);
    }

    private DrawRectangle(String[] sp) {
        String string = sp[0];
        DrawRectangle drawRectangle = this;
        int n = Integer.parseInt(string);
        string = sp[3];
        Color color = DrawCommandSerializationHelperKt.stringToColor(sp[2]);
        Rectangle rectangle = DrawCommandSerializationHelperKt.stringToRect(sp[1]);
        int n2 = Integer.parseInt(string);
        string = sp[4];
        int n3 = Integer.parseInt(string);
        drawRectangle(n, rectangle, color, n2, n3);
    }

    public DrawRectangle(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        this(DrawCommandSerializationHelperKt.parse(s, 5));
    }
}

