/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw.test;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class CheckDisplayList
extends JPanel {
    DisplayList list;
    int count = 0;
    long time = System.nanoTime();
    public static final Color BLUEPRINT_BG_COLOR = new Color(1258866);
    String simpleList = "DrawNlComponentFrame,0,0,1000,1000,1,1000,1000\nClip,0,0,1000,1000\nDrawComponentBackground,450,490,100,20,1,false\nDrawTextRegion,450,490,100,20,0,0,false,false,5,5,28,1.0,\"\"\nDrawNlComponentFrame,450,490,100,20,1,20,20\nDrawConnection,2,450x490x100x20,0,0x0x1000x1000,0,1,false,0,0,false,0.5,0,0,0\nDrawConnection,2,450x490x100x20,1,0x0x1000x1000,1,1,false,0,0,false,0.5,0,0,0\nDrawConnection,2,450x490x100x20,2,0x0x1000x1000,2,1,false,0,0,false,0.5,0,0,0\nDrawConnection,2,450x490x100x20,3,0x0x1000x1000,3,1,false,0,0,false,0.5,0,0,0\nUNClip\n";

    public CheckDisplayList() {
        this.list = DisplayList.getDisplayList(this.simpleList);
        this.setBackground(Color.BLUE);
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(BLUEPRINT_BG_COLOR);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.list != null) {
            this.list.paint((Graphics2D)g, SceneContext.get());
        }
        ++this.count;
        if (System.nanoTime() - this.time > 1000000000L) {
            double total = (double)(System.nanoTime() - this.time) * 1.0E-9;
            System.out.println(" " + (float)((double)this.count / total) + " fps");
            this.count = 0;
            this.time = System.nanoTime();
        }
        this.repaint();
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Spring");
        f.setBounds(new Rectangle(1100, 1100));
        f.setDefaultCloseOperation(3);
        CheckDisplayList p = new CheckDisplayList();
        f.setContentPane(p);
        f.validate();
        f.setVisible(true);
    }
}

