/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.target;

import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawAnchor;
import com.android.tools.idea.uibuilder.scene.decorator.DecoratorUtilities;
import com.android.tools.idea.uibuilder.scene.target.Notch;
import com.android.tools.idea.uibuilder.scene.target.TargetSnapper;
import com.google.common.collect.ImmutableList;
import java.awt.Point;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AnchorTarget
extends BaseTarget
implements Notch.Provider {
    private static final boolean DEBUG_RENDERER = false;
    private static final int ANCHOR_SIZE = 3;
    private static final int EXPANDED_SIZE = 200;
    @NotNull
    protected final Type myType;
    protected int myLastX;
    protected int myLastY;
    private boolean myExpandArea;
    protected final TargetSnapper mySnapper;

    public AnchorTarget(@NotNull Type type) {
        if (type == null) {
            AnchorTarget.$$$reportNull$$$0(0);
        }
        this.myLastX = -1;
        this.myLastY = -1;
        this.myExpandArea = false;
        this.mySnapper = new TargetSnapper();
        this.myType = type;
    }

    @NotNull
    public Type getType() {
        Type type = this.myType;
        if (type == null) {
            AnchorTarget.$$$reportNull$$$0(1);
        }
        return type;
    }

    protected abstract boolean isConnected();

    @Override
    public boolean canChangeSelection() {
        return false;
    }

    @Override
    public void setExpandSize(boolean expand) {
        this.myExpandArea = expand;
    }

    @Override
    public void setMouseHovered(boolean over) {
        if (over != this.mIsOver) {
            this.changeMouseOverState(over);
            this.myComponent.getScene().needsRebuildList();
            this.myComponent.getScene().repaint();
        }
    }

    private void changeMouseOverState(boolean newValue) {
        String dir;
        this.mIsOver = newValue;
        switch (this.myType) {
            case LEFT: {
                dir = "left";
                break;
            }
            case TOP: {
                dir = "north";
                break;
            }
            case RIGHT: {
                dir = "right";
                break;
            }
            case BOTTOM: {
                dir = "bottom";
                break;
            }
            default: {
                dir = "baseline";
            }
        }
        DecoratorUtilities.ViewStates mode = DecoratorUtilities.ViewStates.SELECTED;
        if (this.mIsOver) {
            mode = DecoratorUtilities.ViewStates.WILL_DESTROY;
        }
        DecoratorUtilities.setTimeChange(this.myComponent.getNlComponent(), dir, mode);
    }

    protected boolean isTargeted() {
        return this.mIsOver && !this.myComponent.isSelected();
    }

    @Override
    public void onComponentSelectionChanged(boolean selection) {
        String dir;
        switch (this.myType) {
            case LEFT: {
                dir = "left";
                break;
            }
            case TOP: {
                dir = "north";
                break;
            }
            case RIGHT: {
                dir = "right";
                break;
            }
            case BOTTOM: {
                dir = "bottom";
                break;
            }
            default: {
                dir = "baseline";
            }
        }
        DecoratorUtilities.ViewStates mode = selection ? DecoratorUtilities.ViewStates.SELECTED : DecoratorUtilities.ViewStates.NORMAL;
        DecoratorUtilities.setTimeChange(this.myComponent.getNlComponent(), dir, mode);
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        float d;
        float ratio;
        if (sceneTransform == null) {
            AnchorTarget.$$$reportNull$$$0(2);
        }
        if ((ratio = 1.0f / (float)sceneTransform.getScale()) > 2.0f) {
            ratio = 2.0f;
        }
        float size = 3.0f * ratio;
        float minWidth = 4.0f * size;
        float minHeight = 4.0f * size;
        if ((float)(r - l) < minWidth) {
            d = (minWidth - (float)(r - l)) / 2.0f;
            l = (int)((float)l - d);
            r = (int)((float)r + d);
        }
        if ((float)(b - t) < minHeight) {
            d = (minHeight - (float)(b - t)) / 2.0f;
            t = (int)((float)t - d);
            b = (int)((float)b + d);
        }
        int w = r - l;
        int h = b - t;
        int mw = l + w / 2;
        int mh = t + h / 2;
        switch (this.myType) {
            case LEFT: {
                this.myLeft = (float)l - size;
                this.myTop = (float)mh - size;
                this.myRight = (float)l + size;
                this.myBottom = (float)mh + size;
                if (!this.myExpandArea) break;
                this.myLeft = l - 200;
                this.myTop = t;
                this.myBottom = b;
                break;
            }
            case TOP: {
                this.myLeft = (float)mw - size;
                this.myTop = (float)t - size;
                this.myRight = (float)mw + size;
                this.myBottom = (float)t + size;
                if (!this.myExpandArea) break;
                this.myTop = t - 200;
                this.myLeft = l;
                this.myRight = r;
                break;
            }
            case RIGHT: {
                this.myLeft = (float)r - size;
                this.myTop = (float)mh - size;
                this.myRight = (float)r + size;
                this.myBottom = (float)mh + size;
                if (!this.myExpandArea) break;
                this.myRight = r + 200;
                this.myTop = t;
                this.myBottom = b;
                break;
            }
            case BOTTOM: {
                this.myLeft = (float)mw - size;
                this.myTop = (float)b - size;
                this.myRight = (float)mw + size;
                this.myBottom = (float)b + size;
                if (!this.myExpandArea) break;
                this.myBottom = b + 200;
                this.myLeft = l;
                this.myRight = r;
                break;
            }
            case BASELINE: {
                this.myLeft = (float)l + size;
                this.myTop = (float)(t + this.myComponent.getBaseline()) - size / 2.0f;
                this.myRight = (float)r - size;
                this.myBottom = (float)(t + this.myComponent.getBaseline()) + size / 2.0f;
            }
        }
        return false;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (list == null) {
            AnchorTarget.$$$reportNull$$$0(3);
        }
        if (sceneContext == null) {
            AnchorTarget.$$$reportNull$$$0(4);
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.myComponent.isDragging() && !this.isConnected()) {
            return;
        }
        DrawAnchor.Mode mode = this.getDrawMode();
        DrawAnchor.Type type = this.getDrawType();
        boolean drawAsConnected = this.getDrawAsConnected();
        if (mode != DrawAnchor.Mode.DO_NOT_DRAW) {
            DrawAnchor.add(list, sceneContext, this.myLeft, this.myTop, this.myRight, this.myBottom, type, drawAsConnected, mode);
        }
    }

    @Override
    public void addHit(@NotNull SceneContext transform2, @NotNull ScenePicker picker) {
        if (transform2 == null) {
            AnchorTarget.$$$reportNull$$$0(5);
        }
        if (picker == null) {
            AnchorTarget.$$$reportNull$$$0(6);
        }
        if (!this.isEnabled()) {
            return;
        }
        picker.addRect(this, 0, transform2.getSwingXDip(this.myLeft), transform2.getSwingYDip(this.myTop), transform2.getSwingXDip(this.myRight), transform2.getSwingYDip(this.myBottom));
    }

    protected abstract boolean isEnabled();

    @NotNull
    protected abstract DrawAnchor.Mode getDrawMode();

    @NotNull
    private DrawAnchor.Type getDrawType() {
        DrawAnchor.Type type = this.myType == Type.BASELINE ? DrawAnchor.Type.BASELINE : DrawAnchor.Type.NORMAL;
        if (type == null) {
            AnchorTarget.$$$reportNull$$$0(7);
        }
        return type;
    }

    private boolean getDrawAsConnected() {
        return this.isConnected() && !this.isTargeted();
    }

    @Override
    public int getPreferenceLevel() {
        return 70;
    }

    @Override
    public void mouseDown(int x, int y) {
        this.myLastX = -1;
        this.myLastY = -1;
        this.mySnapper.reset();
        this.mySnapper.gatherNotches(this.myComponent);
    }

    @Override
    public void mouseDrag(int x, int y, @NotNull List<Target> ignored) {
        if (ignored == null) {
            AnchorTarget.$$$reportNull$$$0(8);
        }
        Optional<Point> p = this.mySnapper.trySnapCircle(x, y);
        this.myLastX = p.map(point -> point.x).orElse(x);
        this.myLastY = p.map(point -> point.y).orElse(y);
    }

    @Override
    public void mouseRelease(int x, int y, @NotNull List<Target> ignored) {
        if (ignored == null) {
            AnchorTarget.$$$reportNull$$$0(9);
        }
        this.myLastX = -1;
        this.myLastY = -1;
    }

    @Override
    public String getToolTipText() {
        return this.isConnected() ? "Delete Connection" : "Create Connection";
    }

    @Override
    public void fill(@NotNull SceneComponent owner, @NotNull SceneComponent snappableComponent, @NotNull ImmutableList.Builder<Notch> notchBuilder) {
        int y;
        int x;
        if (owner == null) {
            AnchorTarget.$$$reportNull$$$0(10);
        }
        if (snappableComponent == null) {
            AnchorTarget.$$$reportNull$$$0(11);
        }
        if (notchBuilder == null) {
            AnchorTarget.$$$reportNull$$$0(12);
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.myComponent.isDragging() && !this.isConnected()) {
            return;
        }
        switch (this.getType()) {
            case LEFT: {
                x = owner.getDrawX();
                y = owner.getDrawY() + owner.getDrawHeight() / 2;
                break;
            }
            case TOP: {
                x = owner.getDrawX() + owner.getDrawWidth() / 2;
                y = owner.getDrawY();
                break;
            }
            case RIGHT: {
                x = owner.getDrawX() + owner.getDrawWidth();
                y = owner.getDrawY() + owner.getDrawHeight() / 2;
                break;
            }
            case BOTTOM: {
                x = owner.getDrawX() + owner.getDrawWidth() / 2;
                y = owner.getDrawY() + owner.getDrawHeight();
                break;
            }
            default: {
                x = -1;
                y = -1;
            }
        }
        Notch.Circle notch2 = new Notch.Circle(owner, x, y, null);
        notch2.setGap(9);
        notch2.setTarget(this);
        notchBuilder.add((Object)notch2);
    }

    @Nullable
    public static AnchorTarget findAnchorTarget(@NotNull SceneComponent component, @NotNull Type type) {
        if (component == null) {
            AnchorTarget.$$$reportNull$$$0(13);
        }
        if (type == null) {
            AnchorTarget.$$$reportNull$$$0(14);
        }
        for (Target target : component.getTargets()) {
            if (!(target instanceof AnchorTarget) || ((AnchorTarget)target).myType != type) continue;
            return (AnchorTarget)target;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/scene/target/AnchorTarget";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneTransform";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "picker";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snappableComponent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notchBuilder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/scene/target/AnchorTarget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDrawType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "layout";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addHit";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mouseDrag";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mouseRelease";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fill";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findAnchorTarget";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Type {
        LEFT,
        TOP,
        RIGHT,
        BOTTOM,
        BASELINE;


        public int getMask() {
            switch (this) {
                case LEFT: {
                    return DecoratorUtilities.MASK_LEFT;
                }
                case TOP: {
                    return DecoratorUtilities.MASK_TOP;
                }
                case RIGHT: {
                    return DecoratorUtilities.MASK_RIGHT;
                }
                case BOTTOM: {
                    return DecoratorUtilities.MASK_BOTTOM;
                }
                case BASELINE: {
                    return DecoratorUtilities.MASK_BASELINE;
                }
            }
            return 0;
        }
    }
}

