/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.configuration.NightModeQualifier;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.ide.common.resources.configuration.UiModeQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.io.IAbstractFile;
import com.android.resources.Density;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.NightMode;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenSize;
import com.android.resources.UiMode;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationFileState;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.io.BufferingFileWrapper;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.utils.SparseIntArray;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.android.uipreview.VirtualFileWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationMatcher {
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.rendering.ConfigurationMatcher");
    @NotNull
    private final Configuration myConfiguration;
    @NotNull
    private final ConfigurationManager myManager;
    @Nullable
    private final LocalResourceRepository myResources;
    @Nullable
    private final ResourceNamespace myNamespace;
    @Nullable
    private final VirtualFile myFile;

    public ConfigurationMatcher(@NotNull Configuration configuration, @Nullable VirtualFile file) {
        if (configuration == null) {
            ConfigurationMatcher.$$$reportNull$$$0(0);
        }
        this.myConfiguration = configuration;
        this.myFile = file;
        this.myManager = this.myConfiguration.getConfigurationManager();
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getOrCreateInstance(this.myManager.getModule());
        if (repositoryManager == null) {
            this.myResources = null;
            this.myNamespace = null;
        } else {
            this.myResources = repositoryManager.getAppResources(true);
            this.myNamespace = repositoryManager.getNamespace();
        }
    }

    public boolean isCurrentFileBestMatchFor(@NotNull FolderConfiguration config) {
        if (config == null) {
            ConfigurationMatcher.$$$reportNull$$$0(1);
        }
        if (this.myResources != null && this.myNamespace != null && this.myFile != null) {
            VirtualFile match;
            ResourceReference reference2 = new ResourceReference(this.myNamespace, ConfigurationMatcher.getResourceType(this.myFile), ResourceHelper.getResourceName(this.myFile));
            List<VirtualFile> files2 = ConfigurationMatcher.getMatchingFiles(this.myResources, reference2, config, new HashSet<ResourceReference>(), true, 0);
            VirtualFile virtualFile = match = files2.isEmpty() ? null : files2.get(0);
            if (match != null) {
                return this.myFile.equals(match);
            }
            LOG.debug("Current file is not a match for the given config.");
        }
        return false;
    }

    private static ResourceType getResourceType(@NotNull VirtualFile file) {
        List related;
        ResourceFolderType folderType;
        String parentName;
        if (file == null) {
            ConfigurationMatcher.$$$reportNull$$$0(2);
        }
        ResourceType type = ResourceType.LAYOUT;
        VirtualFile parent = file.getParent();
        if (parent != null && !(parentName = parent.getName()).startsWith("layout") && (folderType = ResourceHelper.getFolderType(file)) != null && !(related = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType)).isEmpty()) {
            type = (ResourceType)related.get(0);
        }
        return type;
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull IAbstractFile file) {
        if (file == null) {
            ConfigurationMatcher.$$$reportNull$$$0(3);
        }
        if (file instanceof VirtualFileWrapper) {
            return ((VirtualFileWrapper)file).getFile();
        }
        if (file instanceof BufferingFileWrapper) {
            BufferingFileWrapper wrapper = (BufferingFileWrapper)file;
            File ioFile = wrapper.getFile();
            return LocalFileSystem.getInstance().findFileByIoFile(ioFile);
        }
        LOG.warn("Unexpected type of match file: " + file.getClass().getName());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<VirtualFile> getBestFileMatches() {
        if (this.myResources != null && this.myNamespace != null && this.myFile != null) {
            FolderConfiguration config = this.myConfiguration.getFullConfig();
            VersionQualifier prevQualifier = config.getVersionQualifier();
            config.setVersionQualifier(null);
            List<VirtualFile> list = ConfigurationMatcher.getMatchingFiles(this.myResources, this.myFile, this.myNamespace, ConfigurationMatcher.getResourceType(this.myFile), config);
            List<VirtualFile> list2 = list;
            if (list2 == null) {
                ConfigurationMatcher.$$$reportNull$$$0(4);
            }
            return list2;
            finally {
                config.setVersionQualifier(prevQualifier);
            }
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            ConfigurationMatcher.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public static List<VirtualFile> getMatchingFiles(@NotNull AbstractResourceRepository repository, @NotNull VirtualFile file, @NotNull ResourceNamespace namespace, @NotNull ResourceType type, @NotNull FolderConfiguration config) {
        if (repository == null) {
            ConfigurationMatcher.$$$reportNull$$$0(6);
        }
        if (file == null) {
            ConfigurationMatcher.$$$reportNull$$$0(7);
        }
        if (namespace == null) {
            ConfigurationMatcher.$$$reportNull$$$0(8);
        }
        if (type == null) {
            ConfigurationMatcher.$$$reportNull$$$0(9);
        }
        if (config == null) {
            ConfigurationMatcher.$$$reportNull$$$0(10);
        }
        ResourceReference reference2 = new ResourceReference(namespace, type, ResourceHelper.getResourceName(file));
        List<VirtualFile> list = ConfigurationMatcher.getMatchingFiles(repository, reference2, config, new HashSet<ResourceReference>(), false, 0);
        if (list == null) {
            ConfigurationMatcher.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    private static List<VirtualFile> getMatchingFiles(@NotNull AbstractResourceRepository repository, @NotNull ResourceReference reference2, @NotNull FolderConfiguration config, @NotNull Set<ResourceReference> seenResources, boolean firstOnly, int depth) {
        if (repository == null) {
            ConfigurationMatcher.$$$reportNull$$$0(12);
        }
        if (reference2 == null) {
            ConfigurationMatcher.$$$reportNull$$$0(13);
        }
        if (config == null) {
            ConfigurationMatcher.$$$reportNull$$$0(14);
        }
        if (seenResources == null) {
            ConfigurationMatcher.$$$reportNull$$$0(15);
        }
        if (depth >= 50 || !seenResources.add(reference2)) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                ConfigurationMatcher.$$$reportNull$$$0(16);
            }
            return list;
        }
        List matchingItems = repository.getResourceItems(reference2.getNamespace(), reference2.getResourceType(), reference2.getName());
        if (matchingItems.isEmpty()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                ConfigurationMatcher.$$$reportNull$$$0(17);
            }
            return list;
        }
        ArrayList<VirtualFile> output = new ArrayList<VirtualFile>();
        List matches = config.findMatchingConfigurables(matchingItems);
        for (ResourceItem match : matches) {
            ResourceUrl url;
            String value;
            if (firstOnly && !output.isEmpty()) break;
            ResourceValue resourceValue2 = match.getResourceValue();
            if (resourceValue2 != null && (value = resourceValue2.getValue()) != null && value.startsWith("@") && (url = ResourceUrl.parse((String)value)) != null && url.type == reference2.getResourceType() && !url.isFramework()) {
                ResourceNamespace namespace = ResourceNamespace.fromNamespacePrefix((String)url.namespace, (ResourceNamespace)reference2.getNamespace(), (ResourceNamespace.Resolver)resourceValue2.getNamespaceResolver());
                if (namespace == null) continue;
                ResourceReference ref = new ResourceReference(namespace, reference2.getResourceType(), url.name);
                output.addAll(ConfigurationMatcher.getMatchingFiles(repository, ref, config, seenResources, firstOnly, depth + 1));
                continue;
            }
            VirtualFile virtualFile = ResourceHelper.getSourceAsVirtualFile(match);
            if (virtualFile == null) continue;
            output.add(virtualFile);
        }
        ArrayList<VirtualFile> arrayList = output;
        if (arrayList == null) {
            ConfigurationMatcher.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @NotNull
    public List<com.android.tools.idea.rendering.Locale> getPrioritizedLocales() {
        List<com.android.tools.idea.rendering.Locale> projectLocales = this.myManager.getLocales();
        ArrayList<com.android.tools.idea.rendering.Locale> locales = new ArrayList<com.android.tools.idea.rendering.Locale>(projectLocales.size() + 1);
        com.android.tools.idea.rendering.Locale current = this.myManager.getLocale();
        locales.add(current);
        for (com.android.tools.idea.rendering.Locale locale : projectLocales) {
            if (locale.equals(current)) continue;
            locales.add(locale);
        }
        ArrayList<com.android.tools.idea.rendering.Locale> arrayList = locales;
        if (arrayList == null) {
            ConfigurationMatcher.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    void adaptConfigSelection(boolean needBestMatch) {
        FolderConfiguration currentConfig;
        boolean needConfigChange = true;
        boolean currentConfigIsCompatible = false;
        State selectedState = this.myConfiguration.getDeviceState();
        FolderConfiguration editedConfig = this.myConfiguration.getEditedConfig();
        Module module = this.myConfiguration.getModule();
        if (selectedState != null && editedConfig.isMatchFor(currentConfig = Configuration.getFolderConfig(module, selectedState, this.myConfiguration.getLocale(), this.myConfiguration.getTarget()))) {
            currentConfigIsCompatible = true;
            if (!needBestMatch || this.isCurrentFileBestMatchFor(currentConfig)) {
                needConfigChange = false;
            }
        }
        if (needConfigChange) {
            List<com.android.tools.idea.rendering.Locale> localeList = this.getPrioritizedLocales();
            FolderConfiguration testConfig = new FolderConfiguration();
            State matchState = null;
            Device device = this.myConfiguration.getDevice();
            IAndroidTarget target = this.myConfiguration.getTarget();
            if (device != null && target != null) {
                VersionQualifier versionQualifier = new VersionQualifier(target.getVersion().getFeatureLevel());
                block0: for (State state : device.getAllStates()) {
                    testConfig.set(Configuration.getFolderConfig(module, state, this.myConfiguration.getLocale(), target));
                    testConfig.setVersionQualifier(versionQualifier);
                    for (int i = 0; i < localeList.size(); ++i) {
                        com.android.tools.idea.rendering.Locale locale = localeList.get(i);
                        testConfig.setLocaleQualifier(locale.qualifier);
                        if (!editedConfig.isMatchFor(testConfig) || !this.isCurrentFileBestMatchFor(testConfig)) continue;
                        matchState = state;
                        break block0;
                    }
                }
            }
            if (matchState != null) {
                this.myConfiguration.startBulkEditing();
                this.myConfiguration.setDeviceState(matchState);
                this.myConfiguration.setEffectiveDevice(device, matchState);
                this.myConfiguration.finishBulkEditing();
            } else {
                this.findAndSetCompatibleConfig(currentConfigIsCompatible);
            }
        }
    }

    void findAndSetCompatibleConfig(boolean favorCurrentConfig) {
        ConfigMatch match;
        int max;
        int start;
        List<com.android.tools.idea.rendering.Locale> localeList = this.getPrioritizedLocales();
        List<Device> deviceList = this.myManager.getDevices();
        FolderConfiguration editedConfig = this.myConfiguration.getEditedConfig();
        FolderConfiguration currentConfig = this.myConfiguration.getFullConfig();
        ArrayList<ConfigMatch> anyMatches = new ArrayList<ConfigMatch>();
        ArrayList<ConfigMatch> bestMatches = new ArrayList<ConfigMatch>();
        int localeHostMatch = this.getLocaleMatch();
        ArrayList<ConfigBundle> configBundles = new ArrayList<ConfigBundle>(200);
        if (editedConfig.getLocaleQualifier() != null || localeHostMatch == -1) {
            start = 0;
            max = localeList.size();
        } else {
            start = localeHostMatch;
            max = localeHostMatch + 1;
        }
        for (int i = start; i < max; ++i) {
            com.android.tools.idea.rendering.Locale l = localeList.get(i);
            ConfigBundle bundle = new ConfigBundle();
            bundle.config.setLocaleQualifier(l.qualifier);
            bundle.localeIndex = i;
            configBundles.add(bundle);
        }
        ConfigurationMatcher.addDockModeToBundles(configBundles);
        ConfigurationMatcher.addNightModeToBundles(configBundles);
        this.addRenderTargetToBundles(configBundles);
        com.android.tools.idea.rendering.Locale currentLocale = this.myConfiguration.getLocale();
        IAndroidTarget currentTarget = this.myConfiguration.getTarget();
        Module module = this.myConfiguration.getModule();
        for (Device device : deviceList) {
            for (State state : device.getAllStates()) {
                FolderConfiguration stateConfig = Configuration.getFolderConfig(module, state, currentLocale, currentTarget);
                for (ConfigBundle bundle : configBundles) {
                    FolderConfiguration testConfig = new FolderConfiguration();
                    testConfig.set(stateConfig);
                    testConfig.add(bundle.config);
                    if (!editedConfig.isMatchFor(testConfig)) continue;
                    anyMatches.add(new ConfigMatch(testConfig, device, state, bundle));
                    if (!this.isCurrentFileBestMatchFor(testConfig)) continue;
                    bestMatches.add(new ConfigMatch(testConfig, device, state, bundle));
                }
            }
        }
        if (bestMatches.isEmpty()) {
            if (favorCurrentConfig) {
                if (!editedConfig.isMatchFor(currentConfig)) {
                    LOG.warn("favorCurrentConfig can only be true if the current config is compatible");
                }
                LOG.warn(String.format("'%1$s' is not a best match for any device/locale combination for %2$s.\nDisplaying it with '%3$s'.", editedConfig.toDisplayString(), this.myConfiguration.getFile(), currentConfig.toDisplayString()));
            } else if (!anyMatches.isEmpty()) {
                match = this.selectConfigMatch(anyMatches);
                this.myConfiguration.startBulkEditing();
                this.myConfiguration.setEffectiveDevice(match.device, match.state);
                this.myConfiguration.setUiMode(UiMode.getByIndex((int)match.bundle.dockModeIndex));
                this.myConfiguration.setNightMode(NightMode.getByIndex((int)match.bundle.nightModeIndex));
                this.myConfiguration.finishBulkEditing();
                LOG.warn(String.format("'%1$s' is not a best match for any device/locale combination for %2$s.\nDisplaying it with\n  %3$s\nwhich is compatible, but will actually be displayed with another more specific version of the layout.", editedConfig.toDisplayString(), this.myConfiguration.getFile(), currentConfig.toDisplayString()));
            }
        } else {
            match = this.selectConfigMatch(bestMatches);
            this.myConfiguration.startBulkEditing();
            this.myConfiguration.setEffectiveDevice(match.device, match.state);
            this.myConfiguration.setUiMode(UiMode.getByIndex((int)match.bundle.dockModeIndex));
            this.myConfiguration.setNightMode(NightMode.getByIndex((int)match.bundle.nightModeIndex));
            this.myConfiguration.finishBulkEditing();
        }
    }

    private void addRenderTargetToBundles(List<ConfigBundle> configBundles) {
        IAndroidTarget target = this.myManager.getTarget();
        if (target != null) {
            int apiLevel = target.getVersion().getFeatureLevel();
            for (ConfigBundle bundle : configBundles) {
                bundle.config.setVersionQualifier(new VersionQualifier(apiLevel));
            }
        }
    }

    private static void addDockModeToBundles(List<ConfigBundle> addConfig) {
        ArrayList<ConfigBundle> list = new ArrayList<ConfigBundle>();
        for (ConfigBundle bundle : addConfig) {
            int index = 0;
            for (UiMode mode : UiMode.values()) {
                ConfigBundle b = new ConfigBundle(bundle);
                b.config.setUiModeQualifier(new UiModeQualifier(mode));
                b.dockModeIndex = index++;
                list.add(b);
            }
        }
        addConfig.clear();
        addConfig.addAll(list);
    }

    private static void addNightModeToBundles(List<ConfigBundle> addConfig) {
        ArrayList<ConfigBundle> list = new ArrayList<ConfigBundle>();
        for (ConfigBundle bundle : addConfig) {
            int index = 0;
            for (NightMode mode : NightMode.values()) {
                ConfigBundle b = new ConfigBundle(bundle);
                b.config.setNightModeQualifier(new NightModeQualifier(mode));
                b.nightModeIndex = index++;
                list.add(b);
            }
        }
        addConfig.clear();
        addConfig.addAll(list);
    }

    private int getLocaleMatch() {
        Locale defaultLocale = Locale.getDefault();
        if (defaultLocale != null) {
            LocaleQualifier qualifier;
            com.android.tools.idea.rendering.Locale locale;
            int l;
            String currentLanguage = defaultLocale.getLanguage();
            String currentRegion = defaultLocale.getCountry();
            List<com.android.tools.idea.rendering.Locale> localeList = this.myManager.getLocales();
            int count = localeList.size();
            for (l = 0; l < count; ++l) {
                locale = localeList.get(l);
                qualifier = locale.qualifier;
                if (!Objects.equals(qualifier.getLanguage(), currentLanguage) || qualifier.getRegion() != null && !qualifier.getRegion().equals(currentRegion)) continue;
                return l;
            }
            for (l = 0; l < count; ++l) {
                locale = localeList.get(l);
                qualifier = locale.qualifier;
                if (!Objects.equals(qualifier.getLanguage(), currentLanguage)) continue;
                return l;
            }
        }
        return 0;
    }

    @NotNull
    private ConfigMatch selectConfigMatch(@NotNull List<ConfigMatch> matches) {
        FileDocumentManager documentManager;
        VirtualFile file;
        Editor activeEditor;
        int apiLevel;
        if (matches == null) {
            ConfigurationMatcher.$$$reportNull$$$0(20);
        }
        List<String> deviceIds = this.myManager.getStateManager().getProjectState().getDeviceIds();
        HashMap idRank = Maps.newHashMapWithExpectedSize((int)deviceIds.size());
        int rank = 0;
        for (String id : deviceIds) {
            idRank.put(id, rank++);
        }
        Comparator<ConfigMatch> comparator2 = null;
        IAndroidTarget projectTarget = this.myManager.getProjectTarget();
        if (projectTarget != null && (apiLevel = projectTarget.getVersion().getFeatureLevel()) >= 11 && apiLevel < 14) {
            comparator2 = new TabletConfigComparator(idRank);
        }
        if (comparator2 == null) {
            comparator2 = new PhoneConfigComparator(idRank);
        }
        Collections.sort(matches, comparator2);
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.myManager.getProject());
        if (editorManager instanceof FileEditorManagerImpl && (activeEditor = ((FileEditorManagerImpl)editorManager).getSelectedTextEditor(true)) != null && (file = (documentManager = FileDocumentManager.getInstance()).getFile(activeEditor.getDocument())) != null && !file.equals(this.myFile) && file.getFileType() == StdFileTypes.XML && ResourceHelper.getFolderType(this.myFile) == ResourceHelper.getFolderType(file)) {
            Configuration configuration = this.myManager.getConfiguration(file);
            FolderConfiguration fullConfig = configuration.getFullConfig();
            for (ConfigMatch match : matches) {
                if (!fullConfig.equals((Object)match.testConfig)) continue;
                ConfigMatch configMatch = match;
                if (configMatch == null) {
                    ConfigurationMatcher.$$$reportNull$$$0(21);
                }
                return configMatch;
            }
        }
        ConfigMatch configMatch = matches.get(0);
        if (configMatch == null) {
            ConfigurationMatcher.$$$reportNull$$$0(22);
        }
        return configMatch;
    }

    @Nullable
    public static VirtualFile getBetterMatch(@NotNull Configuration configuration, @Nullable Device device, @Nullable String stateName, @Nullable com.android.tools.idea.rendering.Locale locale, @Nullable IAndroidTarget target) {
        if (configuration == null) {
            ConfigurationMatcher.$$$reportNull$$$0(23);
        }
        VirtualFile file = configuration.getFile();
        Module module = configuration.getModule();
        if (file != null && module != null) {
            ResourceRepositoryManager repositoryManager;
            FolderConfiguration currentConfig;
            State selectedState;
            if (device == null) {
                device = configuration.getDevice();
            }
            if (stateName == null) {
                State deviceState = configuration.getDeviceState();
                String string = stateName = deviceState != null ? deviceState.getName() : null;
            }
            if ((selectedState = ConfigurationFileState.getState(device, stateName)) == null) {
                return null;
            }
            if (locale == null) {
                locale = configuration.getLocale();
            }
            if (target == null) {
                target = configuration.getTarget();
            }
            if ((currentConfig = Configuration.getFolderConfig(module, selectedState, locale, target)) != null && (repositoryManager = ResourceRepositoryManager.getOrCreateInstance(module)) != null) {
                List types;
                LocalResourceRepository resources = repositoryManager.getAppResources(true);
                ResourceFolderType folderType = ResourceHelper.getFolderType(file);
                if (folderType != null && !(types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType)).isEmpty()) {
                    ResourceType type = (ResourceType)types.get(0);
                    List<VirtualFile> matches = ConfigurationMatcher.getMatchingFiles(resources, file, repositoryManager.getNamespace(), type, currentConfig);
                    if (!matches.contains(file) && !matches.isEmpty()) {
                        return matches.get(0);
                    }
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/configurations/ConfigurationMatcher";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seenResources";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/configurations/ConfigurationMatcher";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBestFileMatches";
                break;
            }
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchingFiles";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrioritizedLocales";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "selectConfigMatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isCurrentFileBestMatchFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getResourceType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingFiles";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "selectConfigMatch";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getBetterMatch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhoneConfigComparator
    implements Comparator<ConfigMatch> {
        private static final String PREFERRED_ID = "Nexus 4";
        private final SparseIntArray mDensitySort = new SparseIntArray(4);
        private final Map<String, Integer> mIdRank;

        public PhoneConfigComparator(Map<String, Integer> idRank) {
            int i = 0;
            this.mDensitySort.put(Density.HIGH.getDpiValue(), ++i);
            this.mDensitySort.put(Density.MEDIUM.getDpiValue(), ++i);
            this.mDensitySort.put(Density.XHIGH.getDpiValue(), ++i);
            this.mDensitySort.put(Density.DPI_400.getDpiValue(), ++i);
            this.mDensitySort.put(Density.XXHIGH.getDpiValue(), ++i);
            this.mDensitySort.put(Density.DPI_560.getDpiValue(), ++i);
            this.mDensitySort.put(Density.XXXHIGH.getDpiValue(), ++i);
            this.mDensitySort.put(Density.DPI_420.getDpiValue(), ++i);
            this.mDensitySort.put(Density.DPI_360.getDpiValue(), ++i);
            this.mDensitySort.put(Density.DPI_280.getDpiValue(), ++i);
            this.mDensitySort.put(Density.TV.getDpiValue(), ++i);
            this.mDensitySort.put(Density.LOW.getDpiValue(), ++i);
            this.mIdRank = idRank;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(ConfigMatch o1, ConfigMatch o2) {
            FolderConfiguration config2;
            FolderConfiguration config1 = o1 != null ? o1.testConfig : null;
            FolderConfiguration folderConfiguration = config2 = o2 != null ? o2.testConfig : null;
            if (config1 == null) {
                if (config2 != null) return -1;
                return 0;
            }
            if (config2 == null) {
                return 1;
            }
            String n1 = o1.device.getId();
            String n2 = o2.device.getId();
            Integer rank1 = this.mIdRank.get(o1.device.getId());
            Integer rank2 = this.mIdRank.get(o2.device.getId());
            if (rank1 != null) {
                if (rank2 == null) return -1;
                int delta = rank1 - rank2;
                if (delta != 0) {
                    return delta;
                }
            } else if (rank2 != null) {
                return 1;
            }
            if (n1.equals(PREFERRED_ID)) {
                if (!n2.equals(PREFERRED_ID)) return -1;
                return 0;
            }
            if (n2.equals(PREFERRED_ID)) {
                return 1;
            }
            int dpi1 = Density.DEFAULT_DENSITY;
            int dpi2 = Density.DEFAULT_DENSITY;
            DensityQualifier dpiQualifier1 = config1.getDensityQualifier();
            if (dpiQualifier1 != null) {
                Density value = dpiQualifier1.getValue();
                dpi1 = value != null ? value.getDpiValue() : Density.DEFAULT_DENSITY;
            }
            dpi1 = this.mDensitySort.get(dpi1, 100);
            DensityQualifier dpiQualifier2 = config2.getDensityQualifier();
            if (dpiQualifier2 != null) {
                Density value = dpiQualifier2.getValue();
                dpi2 = value != null ? value.getDpiValue() : Density.DEFAULT_DENSITY;
            }
            if (dpi1 != (dpi2 = this.mDensitySort.get(dpi2, 100))) return dpi1 - dpi2;
            ScreenOrientation so1 = ScreenOrientation.PORTRAIT;
            ScreenOrientationQualifier orientationQualifier1 = config1.getScreenOrientationQualifier();
            if (orientationQualifier1 != null && (so1 = orientationQualifier1.getValue()) == null) {
                so1 = ScreenOrientation.PORTRAIT;
            }
            ScreenOrientation so2 = ScreenOrientation.PORTRAIT;
            ScreenOrientationQualifier orientationQualifier2 = config2.getScreenOrientationQualifier();
            if (orientationQualifier2 != null && (so2 = orientationQualifier2.getValue()) == null) {
                so2 = ScreenOrientation.PORTRAIT;
            }
            if (so1 == ScreenOrientation.PORTRAIT) {
                if (so2 != ScreenOrientation.PORTRAIT) return -1;
                return 0;
            }
            if (so2 != ScreenOrientation.PORTRAIT) return 0;
            return 1;
        }
    }

    private static class TabletConfigComparator
    implements Comparator<ConfigMatch> {
        private final Map<String, Integer> mIdRank;
        private static final String PREFERRED_ID = "Nexus 10";

        private TabletConfigComparator(Map<String, Integer> idRank) {
            this.mIdRank = idRank;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(ConfigMatch o1, ConfigMatch o2) {
            ScreenSize ss2;
            FolderConfiguration config2;
            FolderConfiguration config1 = o1 != null ? o1.testConfig : null;
            FolderConfiguration folderConfiguration = config2 = o2 != null ? o2.testConfig : null;
            if (config1 == null) {
                if (config2 != null) return -1;
                return 0;
            }
            if (config2 == null) {
                return 1;
            }
            String n1 = o1.device.getId();
            String n2 = o2.device.getId();
            Integer rank1 = this.mIdRank.get(o1.device.getId());
            Integer rank2 = this.mIdRank.get(o2.device.getId());
            if (rank1 != null) {
                if (rank2 == null) return -1;
                int delta = rank1 - rank2;
                if (delta != 0) {
                    return delta;
                }
            } else if (rank2 != null) {
                return 1;
            }
            if (n1.equals(PREFERRED_ID)) {
                if (!n2.equals(PREFERRED_ID)) return -1;
                return 0;
            }
            if (n2.equals(PREFERRED_ID)) {
                return 1;
            }
            ScreenSizeQualifier size1 = config1.getScreenSizeQualifier();
            ScreenSizeQualifier size2 = config2.getScreenSizeQualifier();
            ScreenSize ss1 = size1 != null ? size1.getValue() : ScreenSize.NORMAL;
            ScreenSize screenSize = ss2 = size2 != null ? size2.getValue() : ScreenSize.NORMAL;
            if (ss1 == ScreenSize.XLARGE) {
                ScreenOrientationQualifier orientation2;
                ScreenOrientation so2;
                ScreenOrientation so1;
                if (ss2 != ScreenSize.XLARGE) return -1;
                ScreenOrientationQualifier orientation1 = config1.getScreenOrientationQualifier();
                ScreenOrientation screenOrientation = so1 = orientation1 == null ? null : orientation1.getValue();
                if (so1 == null) {
                    so1 = ScreenOrientation.PORTRAIT;
                }
                ScreenOrientation screenOrientation2 = so2 = (orientation2 = config2.getScreenOrientationQualifier()) == null ? null : orientation2.getValue();
                if (so2 == null) {
                    so2 = ScreenOrientation.PORTRAIT;
                }
                if (so1 == ScreenOrientation.LANDSCAPE) {
                    if (so2 != ScreenOrientation.LANDSCAPE) return -1;
                    return 0;
                }
                if (so2 != ScreenOrientation.LANDSCAPE) return 0;
                return 1;
            }
            if (ss2 != ScreenSize.XLARGE) return 0;
            return 1;
        }
    }

    private static class ConfigMatch {
        final FolderConfiguration testConfig;
        final Device device;
        final State state;
        final ConfigBundle bundle;

        public ConfigMatch(@NotNull FolderConfiguration testConfig, @NotNull Device device, @NotNull State state, @NotNull ConfigBundle bundle) {
            if (testConfig == null) {
                ConfigMatch.$$$reportNull$$$0(0);
            }
            if (device == null) {
                ConfigMatch.$$$reportNull$$$0(1);
            }
            if (state == null) {
                ConfigMatch.$$$reportNull$$$0(2);
            }
            if (bundle == null) {
                ConfigMatch.$$$reportNull$$$0(3);
            }
            this.testConfig = testConfig;
            this.device = device;
            this.state = state;
            this.bundle = bundle;
        }

        public String toString() {
            return this.device.getDisplayName() + " - " + this.state.getName() + " - " + this.bundle;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "testConfig";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "device";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "state";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "bundle";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/configurations/ConfigurationMatcher$ConfigMatch";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ConfigBundle {
        private final FolderConfiguration config = new FolderConfiguration();
        private int localeIndex;
        private int dockModeIndex;
        private int nightModeIndex;

        private ConfigBundle() {
        }

        private ConfigBundle(ConfigBundle bundle) {
            this.config.set(bundle.config);
            this.localeIndex = bundle.localeIndex;
            this.dockModeIndex = bundle.dockModeIndex;
            this.nightModeIndex = bundle.nightModeIndex;
        }

        public String toString() {
            return this.config.getQualifierString();
        }
    }
}

