/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationAction;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.RtlAction;
import com.android.tools.idea.editors.strings.StringResourceEditorProvider;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.rendering.FlagManager;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import icons.AndroidIcons;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocaleMenuAction
extends DropDownAction {
    private static final String DEFAULT_LOCALE_LABEL = "Default (en-us)";
    private final ConfigurationHolder myRenderContext;

    public LocaleMenuAction(@NotNull ConfigurationHolder renderContext) {
        if (renderContext == null) {
            LocaleMenuAction.$$$reportNull$$$0(0);
        }
        super("", "Locale for Preview", null);
        this.myRenderContext = renderContext;
        Presentation presentation = this.getTemplatePresentation();
        this.updatePresentation(presentation);
    }

    protected boolean updateActions() {
        this.removeAll();
        Configuration conf = this.myRenderContext.getConfiguration();
        String currentLocalLabel = LocaleMenuAction.getLocaleLabel(conf == null ? Locale.ANY : conf.getLocale(), false);
        List<Locale> locales = this.getRelevantLocales();
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null && !locales.isEmpty()) {
            String title = LocaleMenuAction.getLocaleLabel(Locale.ANY, false);
            this.add(new SetLocaleAction(this.myRenderContext, title, Locale.ANY, currentLocalLabel.equals(title)));
            this.addSeparator();
            Collections.sort(locales, Locale.LANGUAGE_CODE_COMPARATOR);
            for (Locale locale : locales) {
                title = LocaleMenuAction.getLocaleLabel(locale, false);
                VirtualFile better = ConfigurationMatcher.getBetterMatch(configuration, null, null, locale, null);
                if (better != null) {
                    title = ConfigurationAction.getBetterMatchLabel(LocaleMenuAction.getLocaleLabel(locale, true), better, configuration.getFile());
                }
                this.add(new SetLocaleAction(this.myRenderContext, title, locale, currentLocalLabel.equals(title)));
            }
            this.addSeparator();
        }
        this.add(new EditTranslationAction());
        if (configuration != null && !LocaleMenuAction.hasAnyRtlLocales(configuration, locales)) {
            this.add((AnAction)new RtlAction(this.myRenderContext));
        }
        return true;
    }

    private static boolean hasAnyRtlLocales(@NotNull Configuration configuration, @NotNull List<Locale> locales) {
        LayoutLibrary layoutlib;
        if (configuration == null) {
            LocaleMenuAction.$$$reportNull$$$0(1);
        }
        if (locales == null) {
            LocaleMenuAction.$$$reportNull$$$0(2);
        }
        if ((layoutlib = RenderService.getLayoutLibrary(configuration.getModule(), configuration.getTarget())) == null) {
            return false;
        }
        return locales.stream().anyMatch(locale -> layoutlib.isRtl(locale.toLocaleId()));
    }

    @NotNull
    private List<Locale> getRelevantLocales() {
        LocalResourceRepository projectResources;
        ArrayList<Locale> locales = new ArrayList<Locale>();
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration == null) {
            List<Locale> list = Collections.emptyList();
            if (list == null) {
                LocaleMenuAction.$$$reportNull$$$0(3);
            }
            return list;
        }
        Module module = configuration.getConfigurationManager().getModule();
        LocaleQualifier specificLocale = configuration.getEditedConfig().getLocaleQualifier();
        if (specificLocale != null) {
            List<VirtualFile> variations = ResourceHelper.getResourceVariations(configuration.getFile(), false);
            for (VirtualFile variation : variations) {
                FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)variation.getParent().getName());
                if (config == null || config.getLocaleQualifier() != null) continue;
                specificLocale = null;
                break;
            }
        }
        SortedSet languages = (projectResources = ResourceRepositoryManager.getProjectResources(module)) != null ? projectResources.getLocales() : Collections.emptySet();
        for (LocaleQualifier l : languages) {
            if (specificLocale != null && !specificLocale.isMatchFor((ResourceQualifier)l)) continue;
            locales.add(Locale.create(l));
        }
        ArrayList<Locale> arrayList = locales;
        if (arrayList == null) {
            LocaleMenuAction.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        this.updatePresentation(e.getPresentation());
    }

    private void updatePresentation(Presentation presentation) {
        boolean visible;
        Configuration configuration = this.myRenderContext.getConfiguration();
        boolean bl = visible = configuration != null;
        if (visible) {
            Locale locale = configuration.getLocale();
            presentation.setIcon(locale != Locale.ANY && FlagManager.showFlagsForLanguages() ? locale.getFlagImage() : StudioIcons.LayoutEditor.Toolbar.LANGUAGE);
            String brief = LocaleMenuAction.getLocaleLabel(locale, true) + " ";
            presentation.setText(brief);
        } else {
            presentation.setIcon(AndroidIcons.Globe);
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    public static String getLocaleLabel(@Nullable Locale locale, boolean brief) {
        if (locale == null || !locale.hasLanguage()) {
            return DEFAULT_LOCALE_LABEL;
        }
        String languageCode = locale.qualifier.getLanguage();
        assert (languageCode != null);
        String languageName = LocaleManager.getLanguageName((String)languageCode);
        if (!locale.hasRegion()) {
            if (languageName != null) {
                return String.format("%1$s (%2$s)", languageName, languageCode);
            }
            return languageCode;
        }
        String regionCode = locale.qualifier.getRegion();
        assert (regionCode != null) : locale.qualifier;
        if (!brief && languageName != null) {
            String regionName = LocaleManager.getRegionName((String)regionCode);
            if (regionName != null) {
                return String.format("%1$s (%2$s) in %3$s (%4$s)", languageName, languageCode, regionName, regionCode);
            }
            return String.format("%1$s (%2$s) in %3$s", languageName, languageCode, regionCode);
        }
        return String.format("%1$s (%2$s / %3$s)", languageName, languageCode, regionCode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locales";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/configurations/LocaleMenuAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/configurations/LocaleMenuAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelevantLocales";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasAnyRtlLocales";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class EditTranslationAction
    extends AnAction {
        public EditTranslationAction() {
            super("Edit Translations...", null, null);
        }

        public void actionPerformed(AnActionEvent e) {
            Configuration configuration = LocaleMenuAction.this.myRenderContext.getConfiguration();
            if (configuration != null) {
                Module module = configuration.getConfigurationManager().getModule();
                StringResourceEditorProvider.openEditor(module);
            }
        }
    }

    private class SetLocaleAction
    extends ConfigurationAction {
        private final Locale myLocale;

        public SetLocaleAction(ConfigurationHolder renderContext, @NotNull String title, Locale locale, boolean isCurrentLocale) {
            if (locale == null) {
                SetLocaleAction.$$$reportNull$$$0(0);
            }
            super(renderContext, title);
            this.myLocale = locale;
            if (isCurrentLocale) {
                this.getTemplatePresentation().setIcon(AllIcons.Actions.Checked);
            } else if (FlagManager.showFlagsForLanguages() && locale != Locale.ANY) {
                this.getTemplatePresentation().setIcon(locale.getFlagImage());
            }
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            super.actionPerformed(e);
            LocaleMenuAction.this.updateActions();
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (configuration == null) {
                SetLocaleAction.$$$reportNull$$$0(1);
            }
            if (commit) {
                this.setProjectWideLocale();
            } else {
                configuration.getEditedConfig().setLayoutDirectionQualifier(null);
                configuration.setLocale(this.myLocale);
            }
        }

        @Override
        protected void pickedBetterMatch(@NotNull VirtualFile file, @NotNull VirtualFile old) {
            if (file == null) {
                SetLocaleAction.$$$reportNull$$$0(2);
            }
            if (old == null) {
                SetLocaleAction.$$$reportNull$$$0(3);
            }
            super.pickedBetterMatch(file, old);
            Configuration configuration = this.myRenderContext.getConfiguration();
            if (configuration != null) {
                this.setProjectWideLocale();
            }
        }

        private void setProjectWideLocale() {
            Configuration configuration = this.myRenderContext.getConfiguration();
            if (configuration != null) {
                configuration.getConfigurationManager().setLocale(this.myLocale);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "locale";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "old";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/configurations/LocaleMenuAction$SetLocaleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateConfiguration";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "pickedBetterMatch";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

