/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001\u001a,\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012H\u0002\u001a,\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012H\u0002\u001a$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012\u001a\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0016\u001a\u00020\u0017\u001a$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012\u001a$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012\u001a\u0010\u0010\u001b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a$\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012\u001a\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u001a.\u0010\u001f\u001a\u0010\u0012\f\u0012\n  *\u0004\u0018\u00010\u00010\u00010\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012H\u0007\u001a$\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012\u001a\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0016\u001a\u00020\u0017\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"ANDROID_THEME", "", "ANDROID_THEME_PREFIX", "MAX_RECENTLY_USED_THEMES", "", "PROJECT_THEME", "PROJECT_THEME_PREFIX", "RECENTLY_USED_THEMES_PROPERTY", "addRecentlyUsedTheme", "", "project", "Lcom/intellij/openapi/project/Project;", "theme", "getFilteredByPrefixSortedByName", "", "Lcom/android/tools/idea/editors/theme/datamodels/ConfiguredThemeEditorStyle;", "themes", "excludedPrefixes", "", "getFilteredNames", "excludedNames", "getFrameworkThemeNames", "themeResolver", "Lcom/android/tools/idea/editors/theme/ThemeResolver;", "getFrameworkThemes", "getLibraryThemeNames", "getLibraryThemes", "getPreferredThemeName", "getProjectThemeNames", "getProjectThemes", "getPublicThemes", "getRecentlyUsedThemes", "kotlin.jvm.PlatformType", "getRecommendedThemeNames", "getRecommendedThemes", "intellij.android.core"})
@JvmName(name="ThemeUtils")
public final class ThemeUtils {
    private static final String ANDROID_THEME = "android:Theme";
    private static final String ANDROID_THEME_PREFIX = "android:Theme.";
    private static final String PROJECT_THEME_PREFIX = "Theme.";
    private static final String PROJECT_THEME = "Theme";
    private static final String RECENTLY_USED_THEMES_PROPERTY = "android.recentlyUsedThemes";
    private static final int MAX_RECENTLY_USED_THEMES = 5;

    @NotNull
    public static final String getPreferredThemeName(@NotNull String theme) {
        Intrinsics.checkParameterIsNotNull((Object)theme, (String)"theme");
        if (Intrinsics.areEqual((Object)theme, (Object)ANDROID_THEME) || Intrinsics.areEqual((Object)theme, (Object)PROJECT_THEME)) {
            return PROJECT_THEME;
        }
        return StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)theme, (CharSequence)ANDROID_THEME_PREFIX), (CharSequence)PROJECT_THEME_PREFIX), (CharSequence)"@style/");
    }

    @NotNull
    public static final List<ConfiguredThemeEditorStyle> getFrameworkThemes(@NotNull ThemeResolver themeResolver) {
        Intrinsics.checkParameterIsNotNull((Object)themeResolver, (String)"themeResolver");
        ImmutableList<ConfiguredThemeEditorStyle> immutableList = themeResolver.getFrameworkThemes();
        Intrinsics.checkExpressionValueIsNotNull(immutableList, (String)"themeResolver.frameworkThemes");
        return ThemeUtils.getFilteredByPrefixSortedByName$default(ThemeUtils.getPublicThemes((List)immutableList), null, 2, null);
    }

    @NotNull
    public static final List<String> getFrameworkThemeNames(@NotNull ThemeResolver themeResolver, @NotNull Set<String> excludedNames) {
        Intrinsics.checkParameterIsNotNull((Object)themeResolver, (String)"themeResolver");
        Intrinsics.checkParameterIsNotNull(excludedNames, (String)"excludedNames");
        return ThemeUtils.getFilteredNames(ThemeUtils.getFrameworkThemes(themeResolver), excludedNames);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List getFrameworkThemeNames$default(ThemeResolver themeResolver, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        return ThemeUtils.getFrameworkThemeNames(themeResolver, set);
    }

    @NotNull
    public static final List<ConfiguredThemeEditorStyle> getProjectThemes(@NotNull ThemeResolver themeResolver) {
        Intrinsics.checkParameterIsNotNull((Object)themeResolver, (String)"themeResolver");
        ImmutableList<ConfiguredThemeEditorStyle> immutableList = themeResolver.getLocalThemes();
        Intrinsics.checkExpressionValueIsNotNull(immutableList, (String)"themeResolver.localThemes");
        return ThemeUtils.getFilteredByPrefixSortedByName$default(ThemeUtils.getPublicThemes((List)immutableList), null, 2, null);
    }

    @NotNull
    public static final List<String> getProjectThemeNames(@NotNull ThemeResolver themeResolver, @NotNull Set<String> excludedNames) {
        Intrinsics.checkParameterIsNotNull((Object)themeResolver, (String)"themeResolver");
        Intrinsics.checkParameterIsNotNull(excludedNames, (String)"excludedNames");
        return ThemeUtils.getFilteredNames(ThemeUtils.getProjectThemes(themeResolver), excludedNames);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List getProjectThemeNames$default(ThemeResolver themeResolver, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        return ThemeUtils.getProjectThemeNames(themeResolver, set);
    }

    @NotNull
    public static final List<ConfiguredThemeEditorStyle> getLibraryThemes(@NotNull ThemeResolver themeResolver, @NotNull Set<String> excludedNames) {
        Intrinsics.checkParameterIsNotNull((Object)themeResolver, (String)"themeResolver");
        Intrinsics.checkParameterIsNotNull(excludedNames, (String)"excludedNames");
        ImmutableList<ConfiguredThemeEditorStyle> immutableList = themeResolver.getExternalLibraryThemes();
        Intrinsics.checkExpressionValueIsNotNull(immutableList, (String)"themeResolver.externalLibraryThemes");
        return ThemeUtils.getFilteredByPrefixSortedByName(ThemeUtils.getPublicThemes((List)immutableList), SetsKt.setOf((Object[])new String[]{"Base.", "Platform."}));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List getLibraryThemes$default(ThemeResolver themeResolver, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        return ThemeUtils.getLibraryThemes(themeResolver, set);
    }

    @NotNull
    public static final List<String> getLibraryThemeNames(@NotNull ThemeResolver themeResolver, @NotNull Set<String> excludedNames) {
        Intrinsics.checkParameterIsNotNull((Object)themeResolver, (String)"themeResolver");
        Intrinsics.checkParameterIsNotNull(excludedNames, (String)"excludedNames");
        ImmutableList<ConfiguredThemeEditorStyle> immutableList = themeResolver.getExternalLibraryThemes();
        Intrinsics.checkExpressionValueIsNotNull(immutableList, (String)"themeResolver.externalLibraryThemes");
        return ThemeUtils.getFilteredNames(ThemeUtils.getPublicThemes((List)immutableList), excludedNames);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List getLibraryThemeNames$default(ThemeResolver themeResolver, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        return ThemeUtils.getLibraryThemeNames(themeResolver, set);
    }

    @NotNull
    public static final List<ConfiguredThemeEditorStyle> getRecommendedThemes(@NotNull ThemeResolver themeResolver) {
        Intrinsics.checkParameterIsNotNull((Object)themeResolver, (String)"themeResolver");
        List<ResourceReference> recommendedThemes = themeResolver.getRecommendedThemes();
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.sequenceOf((Object[])new List[]{ThemeUtils.getLibraryThemes$default(themeResolver, null, 2, null), ThemeUtils.getFrameworkThemes(themeResolver)})), (Function1)((Function1)new Function1<ConfiguredThemeEditorStyle, Boolean>(recommendedThemes){
            final /* synthetic */ List $recommendedThemes;

            public final boolean invoke(@NotNull ConfiguredThemeEditorStyle it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$recommendedThemes.contains(it.getStyleReference());
            }
            {
                this.$recommendedThemes = list;
                super(1);
            }
        })));
    }

    @NotNull
    public static final List<String> getRecommendedThemeNames(@NotNull ThemeResolver themeResolver, @NotNull Set<String> excludedNames) {
        Intrinsics.checkParameterIsNotNull((Object)themeResolver, (String)"themeResolver");
        Intrinsics.checkParameterIsNotNull(excludedNames, (String)"excludedNames");
        return ThemeUtils.getFilteredNames(ThemeUtils.getRecommendedThemes(themeResolver), excludedNames);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List getRecommendedThemeNames$default(ThemeResolver themeResolver, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        return ThemeUtils.getRecommendedThemeNames(themeResolver, set);
    }

    @JvmOverloads
    @NotNull
    public static final List<String> getRecentlyUsedThemes(@NotNull Project project, @NotNull Set<String> excludedNames) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(excludedNames, (String)"excludedNames");
        Object object = PropertiesComponent.getInstance((Project)project).getValues(RECENTLY_USED_THEMES_PROPERTY);
        if (object == null || (object = ArraysKt.asList((Object[])object)) == null || (object = CollectionsKt.minus((Iterable)((Iterable)object), (Iterable)excludedNames)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ List getRecentlyUsedThemes$default(Project project, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        return ThemeUtils.getRecentlyUsedThemes(project, set);
    }

    @JvmOverloads
    @NotNull
    public static final List<String> getRecentlyUsedThemes(@NotNull Project project) {
        return ThemeUtils.getRecentlyUsedThemes$default(project, null, 2, null);
    }

    public static final void addRecentlyUsedTheme(@NotNull Project project, @NotNull String theme) {
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)theme, (String)"theme");
        Object object = PropertiesComponent.getInstance((Project)project).getValues(RECENTLY_USED_THEMES_PROPERTY);
        if (object == null || (object = ArraysKt.toSet((Object[])object)) == null) {
            object = SetsKt.emptySet();
        }
        Object old = object;
        Collection collection = $receiver$iv = (Collection)CollectionsKt.take((Iterable)SetsKt.plus((Set)SetsKt.setOf((Object)theme), (Iterable)((Iterable)old)), (int)5);
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray2 = stringArray;
        PropertiesComponent.getInstance((Project)project).setValues(RECENTLY_USED_THEMES_PROPERTY, stringArray2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ConfiguredThemeEditorStyle> getPublicThemes(List<? extends ConfiguredThemeEditorStyle> themes) {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)themes;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ConfiguredThemeEditorStyle it = (ConfiguredThemeEditorStyle)element$iv$iv;
            if (!it.isPublic()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ConfiguredThemeEditorStyle> getFilteredByPrefixSortedByName(List<? extends ConfiguredThemeEditorStyle> themes, Set<String> excludedPrefixes) {
        void $receiver$iv$iv;
        Iterable $receiver$iv = themes;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            boolean bl;
            block4: {
                ConfiguredThemeEditorStyle theme = (ConfiguredThemeEditorStyle)element$iv$iv;
                Iterable $receiver$iv2 = excludedPrefixes;
                if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv2) {
                        String prefix = (String)element$iv;
                        String string = theme.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"theme.name");
                        if (!StringsKt.startsWith$default((String)string, (String)prefix, (boolean)false, (int)2, null)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        iterable = $receiver$iv;
        Comparator comparator2 = new Comparator<T>(){

            public final int compare(T a, T b) {
                ConfiguredThemeEditorStyle it = (ConfiguredThemeEditorStyle)a;
                Comparable comparable = (Comparable)((Object)it.getQualifiedName());
                it = (ConfiguredThemeEditorStyle)b;
                Comparable comparable2 = comparable;
                String string = it.getQualifiedName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator2);
    }

    static /* bridge */ /* synthetic */ List getFilteredByPrefixSortedByName$default(List list, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        return ThemeUtils.getFilteredByPrefixSortedByName(list, set);
    }

    private static final List<String> getFilteredNames(List<? extends ConfiguredThemeEditorStyle> themes, Set<String> excludedNames) {
        String it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = themes;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            ConfiguredThemeEditorStyle configuredThemeEditorStyle = (ConfiguredThemeEditorStyle)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = ((ThemeEditorStyle)((Object)it)).getQualifiedName();
            collection.add(string);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (String)element$iv$iv;
            if (excludedNames.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static /* bridge */ /* synthetic */ List getFilteredNames$default(List list, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        return ThemeUtils.getFilteredNames(list, set);
    }
}

