/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.resources.Density;
import com.android.resources.NightMode;
import com.android.resources.UiMode;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.NestedConfiguration;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.Locale;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VaryingConfiguration
extends NestedConfiguration {
    private int myVariation;
    private int myVariationCount;
    private int myAlternate;
    private Device myPrevParentDevice;
    private Device myPrevDevice;

    private VaryingConfiguration(@NotNull Configuration configuration) {
        if (configuration == null) {
            VaryingConfiguration.$$$reportNull$$$0(0);
        }
        super(configuration);
    }

    @NotNull
    public static VaryingConfiguration create(@NotNull Configuration parent) {
        if (parent == null) {
            VaryingConfiguration.$$$reportNull$$$0(1);
        }
        VaryingConfiguration varyingConfiguration = new VaryingConfiguration(parent);
        if (varyingConfiguration == null) {
            VaryingConfiguration.$$$reportNull$$$0(2);
        }
        return varyingConfiguration;
    }

    @NotNull
    public static VaryingConfiguration create(@NotNull VaryingConfiguration other, @NotNull Configuration parent) {
        if (other == null) {
            VaryingConfiguration.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            VaryingConfiguration.$$$reportNull$$$0(4);
        }
        VaryingConfiguration configuration = new VaryingConfiguration(parent);
        configuration.startBulkEditing();
        VaryingConfiguration.initFrom(configuration, other, other);
        configuration.myAlternate = other.myAlternate;
        configuration.myVariation = other.myVariation;
        configuration.myVariationCount = other.myVariationCount;
        configuration.finishBulkEditing();
        VaryingConfiguration varyingConfiguration = configuration;
        if (varyingConfiguration == null) {
            VaryingConfiguration.$$$reportNull$$$0(5);
        }
        return varyingConfiguration;
    }

    public int getAlternateFlags() {
        return this.myAlternate;
    }

    @Override
    protected void syncFolderConfig() {
        super.syncFolderConfig();
        this.updateDisplayName();
    }

    public void setVariation(int variation) {
        this.myVariation = variation;
        this.myVariationCount = Math.max(this.myVariationCount, variation + 1);
    }

    public void setVariationCount(int count) {
        this.myVariationCount = count;
    }

    public void updateDisplayName() {
        this.setDisplayName(this.computeDisplayName());
    }

    @Override
    @NotNull
    public Locale getLocale() {
        if (this.isOverridingLocale()) {
            Locale locale = super.getLocale();
            if (locale == null) {
                VaryingConfiguration.$$$reportNull$$$0(6);
            }
            return locale;
        }
        Locale locale = this.myParent.getLocale();
        if (this.isAlternatingLocale()) {
            List<Locale> locales = this.getConfigurationManager().getLocales();
            for (Locale l : locales) {
                if (l.equals(locale)) continue;
                locale = l;
                break;
            }
        }
        Locale locale2 = locale;
        if (locale2 == null) {
            VaryingConfiguration.$$$reportNull$$$0(7);
        }
        return locale2;
    }

    @Override
    @Nullable
    public IAndroidTarget getTarget() {
        ConfigurationManager manager;
        IAndroidTarget[] targets;
        if (this.isOverridingTarget()) {
            return super.getTarget();
        }
        IAndroidTarget target = this.myParent.getTarget();
        if (this.isAlternatingTarget() && target != null && (targets = (manager = this.getConfigurationManager()).getTargets()).length > 0) {
            IAndroidTarget mostRecent = manager.getHighestApiTarget();
            if (target.equals(mostRecent)) {
                AndroidModuleInfo info = AndroidModuleInfo.getInstance(manager.getModule());
                if (info != null) {
                    int minSdkVersion2 = info.getMinSdkVersion().getFeatureLevel();
                    for (IAndroidTarget t : targets) {
                        if (t.getVersion().getFeatureLevel() < minSdkVersion2 || !ConfigurationManager.isLayoutLibTarget(t)) continue;
                        target = t;
                        break;
                    }
                }
            } else {
                target = mostRecent;
            }
        }
        return target;
    }

    @Override
    @Nullable
    public Device getDevice() {
        if (this.isOverridingDevice()) {
            return super.getDevice();
        }
        Device device = this.myParent.getDevice();
        if (this.isAlternatingDevice() && device != null) {
            if (device == this.myPrevParentDevice) {
                return this.myPrevDevice;
            }
            this.myPrevParentDevice = device;
            List<Device> devices = this.getConfigurationManager().getDevices();
            boolean isTv = HardwareConfigHelper.isTv((Device)device);
            boolean isWear = HardwareConfigHelper.isWear((Device)device);
            double smallest = 100.0;
            double biggest = 1.0;
            for (Device d : devices) {
                double size = VaryingConfiguration.getScreenSize(d);
                if (size < 0.0 || isTv != HardwareConfigHelper.isTv((Device)d) || isWear != HardwareConfigHelper.isWear((Device)d)) continue;
                if (size >= biggest) {
                    biggest = size;
                }
                if (!(size <= smallest)) continue;
                smallest = size;
            }
            int bucketCount = this.myVariationCount + 1;
            double inchesPerBucket = (biggest - smallest) / (double)bucketCount;
            double overriddenSize = VaryingConfiguration.getScreenSize(device);
            int overriddenBucket = (int)((overriddenSize - smallest) / inchesPerBucket);
            int bucket = this.myVariation < overriddenBucket ? this.myVariation : this.myVariation + 1;
            double from = inchesPerBucket * (double)bucket + smallest;
            double to = from + inchesPerBucket;
            if (biggest - to < 0.1) {
                to = biggest + 0.1;
            }
            boolean canScaleNinePatch = this.supports(10);
            for (Device d : devices) {
                Density density;
                double size;
                if (isTv != HardwareConfigHelper.isTv((Device)d) || isWear != HardwareConfigHelper.isWear((Device)d) || !((size = VaryingConfiguration.getScreenSize(d)) >= from) || !(size < to) || !canScaleNinePatch && ((density = VaryingConfiguration.getDensity(d)) == null || !density.isRecommended() || density == Density.LOW)) continue;
                device = d;
                break;
            }
            this.myPrevDevice = device;
        }
        return device;
    }

    @Nullable
    private static Density getDensity(@NotNull Device device) {
        Hardware hardware;
        Screen screen;
        if (device == null) {
            VaryingConfiguration.$$$reportNull$$$0(8);
        }
        if ((screen = (hardware = device.getDefaultHardware()).getScreen()) != null) {
            return screen.getPixelDensity();
        }
        return null;
    }

    private static double getScreenSize(@NotNull Device device) {
        Hardware hardware;
        Screen screen;
        if (device == null) {
            VaryingConfiguration.$$$reportNull$$$0(9);
        }
        if ((screen = (hardware = device.getDefaultHardware()).getScreen()) != null) {
            return screen.getDiagonalLength();
        }
        return -1.0;
    }

    @Override
    @Nullable
    public State getDeviceState() {
        Device device;
        if (this.isOverridingDeviceState()) {
            return super.getDeviceState();
        }
        State state = this.myParent.getDeviceState();
        if (this.isAlternatingDeviceState() && state != null) {
            State next = this.getNextDeviceState(state);
            if (next != null) {
                return next;
            }
            return state;
        }
        if ((this.isAlternatingDevice() || this.isOverridingDevice()) && state != null && (device = this.getDevice()) != null) {
            return device.getState(state.getName());
        }
        return state;
    }

    @Override
    @NotNull
    public NightMode getNightMode() {
        if (this.isOverridingNightMode()) {
            NightMode nightMode = super.getNightMode();
            if (nightMode == null) {
                VaryingConfiguration.$$$reportNull$$$0(10);
            }
            return nightMode;
        }
        NightMode nightMode = this.myParent.getNightMode();
        if (this.isAlternatingNightMode()) {
            nightMode = nightMode == NightMode.NIGHT ? NightMode.NOTNIGHT : NightMode.NIGHT;
        }
        NightMode nightMode2 = nightMode;
        if (nightMode2 == null) {
            VaryingConfiguration.$$$reportNull$$$0(11);
        }
        return nightMode2;
    }

    @Override
    @NotNull
    public UiMode getUiMode() {
        if (this.isOverridingUiMode()) {
            UiMode uiMode = super.getUiMode();
            if (uiMode == null) {
                VaryingConfiguration.$$$reportNull$$$0(12);
            }
            return uiMode;
        }
        UiMode uiMode = this.myParent.getUiMode();
        if (this.isAlternatingUiMode()) {
            UiMode[] values2 = UiMode.values();
            uiMode = values2[(uiMode.ordinal() + 1) % values2.length];
        }
        UiMode uiMode2 = uiMode;
        if (uiMode2 == null) {
            VaryingConfiguration.$$$reportNull$$$0(13);
        }
        return uiMode2;
    }

    @Override
    @Nullable
    public String computeDisplayName() {
        return VaryingConfiguration.computeDisplayName(this.getOverrideFlags() | this.myAlternate, this);
    }

    public void setAlternateLocale(boolean alternate) {
        this.myAlternate = alternate ? (this.myAlternate |= 0x10) : (this.myAlternate &= 0xFFFFFFEF);
    }

    public final boolean isAlternatingLocale() {
        return (this.myAlternate & 0x10) != 0;
    }

    public void setAlternateTarget(boolean alternate) {
        this.myAlternate = alternate ? (this.myAlternate |= 0x20) : (this.myAlternate &= 0xFFFFFFDF);
    }

    public final boolean isAlternatingTarget() {
        return (this.myAlternate & 0x20) != 0;
    }

    public void setAlternateDevice(boolean alternate) {
        this.myAlternate = alternate ? (this.myAlternate |= 2) : (this.myAlternate &= 0xFFFFFFFD);
    }

    public final boolean isAlternatingDevice() {
        return (this.myAlternate & 2) != 0;
    }

    public void setAlternateDeviceState(boolean alternate) {
        this.myAlternate = alternate ? (this.myAlternate |= 4) : (this.myAlternate &= 0xFFFFFFFB);
    }

    public final boolean isAlternatingDeviceState() {
        return (this.myAlternate & 4) != 0;
    }

    public void setAlternateNightMode(boolean alternate) {
        this.myAlternate = alternate ? (this.myAlternate |= 0x40) : (this.myAlternate &= 0xFFFFFFBF);
    }

    public final boolean isAlternatingNightMode() {
        return (this.myAlternate & 0x40) != 0;
    }

    public void setAlternateUiMode(boolean alternate) {
        this.myAlternate = alternate ? (this.myAlternate |= 0x80) : (this.myAlternate &= 0xFFFFFF7F);
    }

    public final boolean isAlternatingUiMode() {
        return (this.myAlternate & 0x80) != 0;
    }

    @Override
    public boolean changed(int flags) {
        this.updated(flags);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/configurations/VaryingConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/configurations/VaryingConfiguration";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocale";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNightMode";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUiMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDensity";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getScreenSize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

