/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.connection.assistant.actions;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.assistant.AssistActionState;
import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.datamodel.DefaultActionState;
import com.android.tools.idea.assistant.view.StatefulButtonMessage;
import com.android.tools.idea.assistant.view.UIUtils;
import com.android.tools.idea.connection.assistant.actions.ButtonMessage;
import com.android.tools.idea.connection.assistant.actions.CustomSuccessState;
import com.android.tools.idea.connection.assistant.actions.ListUsbDevicesAction;
import com.android.tools.idea.connection.assistant.actions.ListUsbDevicesActionStateManager;
import com.android.tools.usb.Platform;
import com.android.tools.usb.UsbDevice;
import com.android.tools.usb.UsbDeviceCollector;
import com.android.tools.usb.UsbDeviceCollectorImpl;
import com.android.utils.HtmlBuilder;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ConnectionAssistantEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J$\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u001b\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u000bH\u0007J\u0006\u0010\u001d\u001a\u00020\rR\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/connection/assistant/actions/ListUsbDevicesActionStateManager;", "Lcom/android/tools/idea/assistant/AssistActionStateManager;", "Lcom/intellij/openapi/Disposable;", "()V", "myDevicesFuture", "Ljava/util/concurrent/CompletableFuture;", "", "Lcom/android/tools/usb/UsbDevice;", "myProject", "Lcom/intellij/openapi/project/Project;", "usbDeviceCollector", "Lcom/android/tools/usb/UsbDeviceCollector;", "dispose", "", "generateMessage", "Lcom/android/tools/idea/connection/assistant/actions/ButtonMessage;", "getDevices", "getId", "", "getState", "Lcom/android/tools/idea/assistant/AssistActionState;", "project", "actionData", "Lcom/android/tools/idea/assistant/datamodel/ActionData;", "getStateDisplay", "Lcom/android/tools/idea/assistant/view/StatefulButtonMessage;", "message", "init", "deviceCollector", "refresh", "Companion", "connection-assistant"})
public final class ListUsbDevicesActionStateManager
extends AssistActionStateManager
implements Disposable {
    private UsbDeviceCollector usbDeviceCollector;
    private Project myProject;
    private CompletableFuture<List<UsbDevice>> myDevicesFuture;
    private static ListUsbDevicesActionStateManager myInstance;
    public static final Companion Companion;

    @Override
    public void init(@NotNull Project project, @NotNull ActionData actionData) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)actionData, (String)"actionData");
        this.init(project, actionData, (UsbDeviceCollector)new UsbDeviceCollectorImpl());
    }

    public final void init(@NotNull Project project, @NotNull ActionData actionData, @NotNull UsbDeviceCollector deviceCollector) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)actionData, (String)"actionData");
        Intrinsics.checkParameterIsNotNull((Object)deviceCollector, (String)"deviceCollector");
        this.myProject = project;
        this.usbDeviceCollector = deviceCollector;
        ListUsbDevicesActionStateManager.Companion.setMyInstance(this);
        this.refresh();
        Disposer.register((Disposable)((Disposable)project), (Disposable)this);
    }

    private final CompletableFuture<List<UsbDevice>> getDevices() {
        CompletableFuture<List<UsbDevice>> completableFuture = this.myDevicesFuture;
        if (completableFuture == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDevicesFuture");
        }
        CompletionStage completionStage = completableFuture.exceptionally((Function)getDevices.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"myDevicesFuture.exceptio\u2026emptyList()\n      }\n    )");
        return completionStage;
    }

    public final void refresh() {
        UsbDeviceCollector usbDeviceCollector = this.usbDeviceCollector;
        if (usbDeviceCollector == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"usbDeviceCollector");
        }
        this.myDevicesFuture = usbDeviceCollector.listUsbDevices();
        this.getDevices().thenAccept(new Consumer<List<? extends UsbDevice>>(this){
            final /* synthetic */ ListUsbDevicesActionStateManager this$0;

            public final void accept(List<UsbDevice> it) {
                if (!ListUsbDevicesActionStateManager.access$getMyProject$p(this.this$0).isDisposed()) {
                    UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.CONNECTION_ASSISTANT_EVENT).setConnectionAssistantEvent(ConnectionAssistantEvent.newBuilder().setType(ConnectionAssistantEvent.ConnectionAssistantEventType.USB_DEVICES_DETECTED).setUsbDevicesDetected(it.size())));
                    this.this$0.refreshDependencyState(ListUsbDevicesActionStateManager.access$getMyProject$p(this.this$0));
                }
            }
            {
                this.this$0 = listUsbDevicesActionStateManager;
            }
        });
        Project project = this.myProject;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myProject");
        }
        this.refreshDependencyState(project);
    }

    public void dispose() {
        CompletableFuture<List<UsbDevice>> completableFuture = this.myDevicesFuture;
        if (completableFuture == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDevicesFuture");
        }
        completableFuture.cancel(true);
    }

    @Override
    @NotNull
    public AssistActionState getState(@NotNull Project project, @NotNull ActionData actionData) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)actionData, (String)"actionData");
        CompletableFuture<List<UsbDevice>> completableFuture = this.myDevicesFuture;
        if (completableFuture == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDevicesFuture");
        }
        if (!completableFuture.isDone()) {
            return DefaultActionState.IN_PROGRESS;
        }
        return this.getDevices().get().isEmpty() ? (AssistActionState)DefaultActionState.ERROR_RETRY : (AssistActionState)CustomSuccessState.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public StatefulButtonMessage getStateDisplay(@NotNull Project project, @NotNull ActionData actionData, @Nullable String message) {
        void title;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)actionData, (String)"actionData");
        ButtonMessage buttonMessage = this.generateMessage();
        String string = buttonMessage.component1();
        String body = buttonMessage.component2();
        return new StatefulButtonMessage((String)title, this.getState(project, actionData), body);
    }

    @Override
    @NotNull
    public String getId() {
        return ListUsbDevicesAction.Companion.getACTION_ID();
    }

    private final ButtonMessage generateMessage() {
        Iterable $receiver$iv;
        CompletableFuture<List<UsbDevice>> completableFuture = this.myDevicesFuture;
        if (completableFuture == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDevicesFuture");
        }
        if (!completableFuture.isDone()) {
            return new ButtonMessage("Loading...", null, 2, null);
        }
        CompletableFuture<List<UsbDevice>> completableFuture2 = this.myDevicesFuture;
        if (completableFuture2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDevicesFuture");
        }
        List<UsbDevice> list = completableFuture2.get();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"myDevicesFuture.get()");
        Iterable iterable = $receiver$iv = (Iterable)list;
        Object object = new Comparator<T>(){

            public final int compare(T a, T b) {
                UsbDevice it = (UsbDevice)a;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (UsbDevice)b;
                Comparable comparable2 = comparable;
                String string = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        List devices = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)object);
        HtmlBuilder titleHtmlBuilder = new HtmlBuilder().openHtmlBody();
        iterable = devices;
        if (!iterable.isEmpty()) {
            titleHtmlBuilder.addHtml("<span style=\"color: " + UIUtils.getCssColor(UIUtils.getSuccessColor()) + ";\">Android Studio detected the following " + devices.size() + " USB device(s):</span>");
        } else {
            titleHtmlBuilder.addHtml("<span style=\"color: " + UIUtils.getCssColor(UIUtils.getFailureColor()) + ";\">" + AndroidBundle.message("connection.assistant.usb.no_devices.title", new Object[0]) + "</span>");
        }
        HtmlBuilder bodyHtmlBuilder = new HtmlBuilder().openHtmlBody();
        object = devices;
        if (!object.isEmpty()) {
            Iterable $receiver$iv2 = devices;
            for (Object element$iv : $receiver$iv2) {
                UsbDevice $name_$_$_productId = (UsbDevice)element$iv;
                String name = $name_$_$_productId.component1();
                String productId = $name_$_$_productId.component3();
                bodyHtmlBuilder.addHtml("<p>").addHtml("<b>" + name + "</b> (" + productId + ')').newlineIfNecessary().addHtml("</p>");
            }
        } else {
            bodyHtmlBuilder.addHtml("<p>" + AndroidBundle.message("connection.assistant.usb.no_devices.body", new Object[0]) + "</p>").newlineIfNecessary();
        }
        UsbDeviceCollector usbDeviceCollector = this.usbDeviceCollector;
        if (usbDeviceCollector == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"usbDeviceCollector");
        }
        if (Intrinsics.areEqual((Object)usbDeviceCollector.getPlatform(), (Object)Platform.Windows)) {
            bodyHtmlBuilder.addHtml("<p><b>Install device drivers.</b> If you want to connect a device for testing, then you need to install the appropriate USB drivers. For more information, read the <a href=\"https://developer.android.com/studio/run/oem-usb.html\">online documentation</a>.</p>");
        }
        HtmlBuilder htmlBuilder = titleHtmlBuilder.closeHtmlBody();
        Intrinsics.checkExpressionValueIsNotNull((Object)htmlBuilder, (String)"titleHtmlBuilder.closeHtmlBody()");
        String string = htmlBuilder.getHtml();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"titleHtmlBuilder.closeHtmlBody().html");
        HtmlBuilder htmlBuilder2 = bodyHtmlBuilder.closeHtmlBody();
        Intrinsics.checkExpressionValueIsNotNull((Object)htmlBuilder2, (String)"bodyHtmlBuilder.closeHtmlBody()");
        return new ButtonMessage(string, htmlBuilder2.getHtml());
    }

    static {
        Companion = new Companion(null);
    }

    @NotNull
    public static final /* synthetic */ Project access$getMyProject$p(ListUsbDevicesActionStateManager $this) {
        Project project = $this.myProject;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myProject");
        }
        return project;
    }

    public static final /* synthetic */ void access$setMyProject$p(ListUsbDevicesActionStateManager $this, @NotNull Project project) {
        $this.myProject = project;
    }

    @NotNull
    public static final /* synthetic */ ListUsbDevicesActionStateManager access$getMyInstance$cp() {
        ListUsbDevicesActionStateManager listUsbDevicesActionStateManager = myInstance;
        if (listUsbDevicesActionStateManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myInstance");
        }
        return listUsbDevicesActionStateManager;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/connection/assistant/actions/ListUsbDevicesActionStateManager$Companion;", "", "()V", "myInstance", "Lcom/android/tools/idea/connection/assistant/actions/ListUsbDevicesActionStateManager;", "getMyInstance", "()Lcom/android/tools/idea/connection/assistant/actions/ListUsbDevicesActionStateManager;", "setMyInstance", "(Lcom/android/tools/idea/connection/assistant/actions/ListUsbDevicesActionStateManager;)V", "getInstance", "connection-assistant"})
    public static final class Companion {
        private final ListUsbDevicesActionStateManager getMyInstance() {
            return ListUsbDevicesActionStateManager.access$getMyInstance$cp();
        }

        private final void setMyInstance(ListUsbDevicesActionStateManager listUsbDevicesActionStateManager) {
            myInstance = listUsbDevicesActionStateManager;
        }

        @NotNull
        public final ListUsbDevicesActionStateManager getInstance() {
            return this.getMyInstance();
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ ListUsbDevicesActionStateManager access$getMyInstance$p(Companion $this) {
            return $this.getMyInstance();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

