/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.connection.assistant.actions;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.assistant.AssistActionState;
import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.datamodel.DefaultActionState;
import com.android.tools.idea.assistant.view.StatefulButtonMessage;
import com.android.tools.idea.assistant.view.UIUtils;
import com.android.tools.idea.concurrent.EdtExecutor;
import com.android.tools.idea.connection.assistant.actions.ButtonMessage;
import com.android.tools.idea.connection.assistant.actions.CustomSuccessState;
import com.android.tools.idea.connection.assistant.actions.RestartAdbAction;
import com.android.utils.HtmlBuilder;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ConnectionAssistantEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.io.File;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0016J\u001b\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u001bH\u0002\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#H\u0016J\"\u0010$\u001a\u00020%2\u0006\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#2\b\u0010&\u001a\u0004\u0018\u00010\u001eH\u0016J\u0018\u0010'\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\fH\u0002J\u0010\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\nH\u0016J\b\u0010+\u001a\u00020\u000eH\u0016J\u0010\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\nH\u0002R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/android/tools/idea/connection/assistant/actions/RestartAdbActionStateManager;", "Lcom/android/tools/idea/assistant/AssistActionStateManager;", "Lcom/android/ddmlib/AndroidDebugBridge$IDebugBridgeChangeListener;", "Lcom/android/ddmlib/AndroidDebugBridge$IDeviceChangeListener;", "Lcom/intellij/openapi/Disposable;", "()V", "myAdbFuture", "Lcom/google/common/util/concurrent/ListenableFuture;", "Lcom/android/ddmlib/AndroidDebugBridge;", "myLoading", "", "myProject", "Lcom/intellij/openapi/project/Project;", "bridgeChanged", "", "bridge", "deviceChanged", "device", "Lcom/android/ddmlib/IDevice;", "changeMask", "", "deviceConnected", "deviceDisconnected", "dispose", "generateMessage", "Lcom/android/tools/idea/connection/assistant/actions/ButtonMessage;", "devices", "", "([Lcom/android/ddmlib/IDevice;)Lcom/android/tools/idea/connection/assistant/actions/ButtonMessage;", "getId", "", "getState", "Lcom/android/tools/idea/assistant/AssistActionState;", "project", "actionData", "Lcom/android/tools/idea/assistant/datamodel/ActionData;", "getStateDisplay", "Lcom/android/tools/idea/assistant/view/StatefulButtonMessage;", "message", "init", "initDebugBridge", "restartCompleted", "isSuccessful", "restartInitiated", "setLoading", "loading", "connection-assistant"})
public final class RestartAdbActionStateManager
extends AssistActionStateManager
implements AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IDeviceChangeListener,
Disposable {
    private Project myProject;
    private ListenableFuture<AndroidDebugBridge> myAdbFuture;
    private boolean myLoading;

    @Override
    public void init(@NotNull Project project, @NotNull ActionData actionData) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)actionData, (String)"actionData");
        Project project2 = this.myProject = project;
        if (project2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myProject");
        }
        this.initDebugBridge(project2);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        Disposer.register((Disposable)((Disposable)project), (Disposable)this);
        this.refreshDependencyState(project);
    }

    @Override
    @NotNull
    public String getId() {
        return RestartAdbAction.Companion.getACTION_ID();
    }

    @Override
    @NotNull
    public AssistActionState getState(@NotNull Project project, @NotNull ActionData actionData) {
        block8: {
            block7: {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)actionData, (String)"actionData");
                if (this.myLoading) {
                    return DefaultActionState.IN_PROGRESS;
                }
                if (this.myAdbFuture == null) {
                    return DefaultActionState.INCOMPLETE;
                }
                ListenableFuture<AndroidDebugBridge> listenableFuture = this.myAdbFuture;
                if (listenableFuture == null) {
                    Intrinsics.throwNpe();
                }
                if (!listenableFuture.isDone()) {
                    return DefaultActionState.IN_PROGRESS;
                }
                AndroidDebugBridge adb = AndroidDebugBridge.getBridge();
                if (adb == null) break block7;
                IDevice[] iDeviceArray = adb.getDevices();
                Intrinsics.checkExpressionValueIsNotNull((Object)iDeviceArray, (String)"adb.devices");
                Object[] objectArray = iDeviceArray;
                if (!(objectArray.length == 0)) break block8;
            }
            return DefaultActionState.ERROR_RETRY;
        }
        return CustomSuccessState.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public StatefulButtonMessage getStateDisplay(@NotNull Project project, @NotNull ActionData actionData, @Nullable String message) {
        void title;
        ButtonMessage buttonMessage;
        AssistActionState state;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)actionData, (String)"actionData");
        AssistActionState assistActionState = state = this.getState(project, actionData);
        if (Intrinsics.areEqual((Object)assistActionState, (Object)DefaultActionState.IN_PROGRESS)) {
            String string = AndroidBundle.message("connection.assistant.loading", new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"AndroidBundle.message(\"c\u2026ction.assistant.loading\")");
            buttonMessage = new ButtonMessage(string, null, 2, null);
        } else if (Intrinsics.areEqual((Object)assistActionState, (Object)CustomSuccessState.INSTANCE) || Intrinsics.areEqual((Object)assistActionState, (Object)DefaultActionState.ERROR_RETRY)) {
            IDevice[] adb;
            IDevice[] iDeviceArray = adb = AndroidDebugBridge.getBridge();
            int deviceCount = adb != null && (iDeviceArray = iDeviceArray.getDevices()) != null ? ((Object[])iDeviceArray).length : -1;
            UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.CONNECTION_ASSISTANT_EVENT).setConnectionAssistantEvent(ConnectionAssistantEvent.newBuilder().setType(ConnectionAssistantEvent.ConnectionAssistantEventType.ADB_DEVICES_DETECTED).setAdbDevicesDetected(deviceCount)));
            if (adb != null) {
                IDevice[] iDeviceArray2 = adb.getDevices();
                Intrinsics.checkExpressionValueIsNotNull((Object)iDeviceArray2, (String)"adb.devices");
                buttonMessage = this.generateMessage(iDeviceArray2);
            } else {
                String string = AndroidBundle.message("connection.assistant.adb.failure", new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"AndroidBundle.message(\"c\u2026n.assistant.adb.failure\")");
                buttonMessage = new ButtonMessage(string, null, 2, null);
            }
        } else {
            String string = AndroidBundle.message("connection.assistant.adb.unexpected", new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"AndroidBundle.message(\"c\u2026ssistant.adb.unexpected\")");
            buttonMessage = new ButtonMessage(string, null, 2, null);
        }
        ButtonMessage buttonMessage2 = buttonMessage;
        String string = buttonMessage2.component1();
        String body = buttonMessage2.component2();
        return new StatefulButtonMessage((String)title, state, body);
    }

    private final ButtonMessage generateMessage(IDevice[] devices) {
        ButtonMessage buttonMessage;
        Object[] objectArray = devices;
        if (objectArray.length == 0) {
            HtmlBuilder htmlBuilder = new HtmlBuilder().addHtml(AndroidBundle.message("connection.assistant.adb.no_devices.title", new Object[0])).newlineIfNecessary();
            Intrinsics.checkExpressionValueIsNotNull((Object)htmlBuilder, (String)"HtmlBuilder().addHtml(An\u2026e\")).newlineIfNecessary()");
            String string = htmlBuilder.getHtml();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"HtmlBuilder().addHtml(An\u2026newlineIfNecessary().html");
            HtmlBuilder htmlBuilder2 = new HtmlBuilder().addHtml("<p>" + AndroidBundle.message("connection.assistant.adb.no_devices.body", new Object[0]) + "</p>");
            Intrinsics.checkExpressionValueIsNotNull((Object)htmlBuilder2, (String)"HtmlBuilder().addHtml(\"<\u2026.no_devices.body\")}</p>\")");
            buttonMessage = new ButtonMessage(string, htmlBuilder2.getHtml());
        } else {
            HtmlBuilder htmlBuilder = new HtmlBuilder().addHtml("<span style=\"color: " + UIUtils.getCssColor(UIUtils.getSuccessColor()) + ";\">" + AndroidBundle.message("connection.assistant.adb.devices", new Object[0]) + "</span>");
            Intrinsics.checkExpressionValueIsNotNull((Object)htmlBuilder, (String)"HtmlBuilder().addHtml(\"<\u2026\")\n          + \"</span>\")");
            String title = htmlBuilder.getHtml();
            HtmlBuilder htmlBodyBuilder = new HtmlBuilder();
            for (Object element$iv : (Object[])devices) {
                IDevice device = (IDevice)element$iv;
                htmlBodyBuilder.addHtml("<p><span>" + device.getName() + "</span>").newline().addHtml("<span style=\"font-size: 80%; font-weight: lighter;\">" + device.getVersion() + "</span></p>").newline();
            }
            String string = title;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"title");
            buttonMessage = new ButtonMessage(string, htmlBodyBuilder.getHtml());
        }
        return buttonMessage;
    }

    private final void setLoading(boolean loading) {
        this.myLoading = loading;
        Project project = this.myProject;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myProject");
        }
        this.refreshDependencyState(project);
    }

    private final void initDebugBridge(Project project) {
        File file = AndroidSdkUtils.getAdb(project);
        if (file == null) {
            return;
        }
        File adb = file;
        ListenableFuture<AndroidDebugBridge> listenableFuture = AdbService.getInstance().getDebugBridge(adb);
        if (listenableFuture == null) {
            return;
        }
        this.myAdbFuture = listenableFuture;
        Futures.addCallback(this.myAdbFuture, (FutureCallback)((FutureCallback)new FutureCallback<AndroidDebugBridge>(this, project){
            final /* synthetic */ RestartAdbActionStateManager this$0;
            final /* synthetic */ Project $project;

            public void onSuccess(@Nullable AndroidDebugBridge bridge) {
                this.this$0.refreshDependencyState(this.$project);
            }

            public void onFailure(@Nullable Throwable t) {
                this.this$0.refreshDependencyState(this.$project);
            }
            {
                this.this$0 = $outer;
                this.$project = $captured_local_variable$1;
            }
        }), (Executor)((Executor)EdtExecutor.INSTANCE));
    }

    public void dispose() {
        AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    public void bridgeChanged(@Nullable AndroidDebugBridge bridge) {
    }

    public void restartInitiated() {
        this.setLoading(true);
    }

    public void restartCompleted(boolean isSuccessful) {
        this.setLoading(false);
    }

    public void deviceConnected(@NotNull IDevice device) {
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        Project project = this.myProject;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myProject");
        }
        this.refreshDependencyState(project);
    }

    public void deviceDisconnected(@NotNull IDevice device) {
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        Project project = this.myProject;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myProject");
        }
        this.refreshDependencyState(project);
    }

    public void deviceChanged(@NotNull IDevice device, int changeMask) {
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        Project project = this.myProject;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myProject");
        }
        this.refreshDependencyState(project);
    }
}

