/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.tools.idea.databinding.DataBindingProjectComponent;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.databinding.LightBrClass;
import com.android.tools.idea.databinding.ModuleDataBinding;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrClassFinder
extends PsiElementFinder {
    private final DataBindingProjectComponent myComponent;
    private CachedValue<Map<String, PsiClass>> myClassByPackageCache;

    public BrClassFinder(DataBindingProjectComponent component) {
        this.myComponent = component;
        this.myClassByPackageCache = CachedValuesManager.getManager((Project)component.getProject()).createCachedValue(() -> {
            HashMap<String, LightBrClass> classes = new HashMap<String, LightBrClass>();
            for (AndroidFacet facet : this.myComponent.getDataBindingEnabledFacets()) {
                if (!ModuleDataBinding.getInstance(facet).isEnabled()) continue;
                classes.put(DataBindingUtil.getBrQualifiedName(facet), DataBindingUtil.getOrCreateBrClassFor(facet));
            }
            return CachedValueProvider.Result.create(classes, (Object[])new Object[]{this.myComponent});
        }, false);
    }

    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            BrClassFinder.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            BrClassFinder.$$$reportNull$$$0(1);
        }
        if (!this.isEnabled() || !qualifiedName.endsWith("BR")) {
            return null;
        }
        PsiClass psiClass = (PsiClass)((Map)this.myClassByPackageCache.getValue()).get(qualifiedName);
        if (psiClass == null) {
            return null;
        }
        PsiFile containingFile = psiClass.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (!scope.accept(virtualFile)) {
            return null;
        }
        return psiClass;
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            BrClassFinder.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            BrClassFinder.$$$reportNull$$$0(3);
        }
        if (!this.isEnabled()) {
            if (PsiClass.EMPTY_ARRAY == null) {
                BrClassFinder.$$$reportNull$$$0(4);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass aClass = this.findClass(qualifiedName, scope);
        if (aClass == null) {
            if (PsiClass.EMPTY_ARRAY == null) {
                BrClassFinder.$$$reportNull$$$0(5);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass[] psiClassArray = new PsiClass[]{aClass};
        if (psiClassArray == null) {
            BrClassFinder.$$$reportNull$$$0(6);
        }
        return psiClassArray;
    }

    @Nullable
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            BrClassFinder.$$$reportNull$$$0(7);
        }
        return null;
    }

    private boolean isEnabled() {
        return DataBindingUtil.inMemoryClassGenerationIsEnabled() && this.myComponent.hasAnyDataBindingEnabledFacet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/databinding/BrClassFinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/databinding/BrClassFinder";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

