/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.tools.idea.databinding.DataBindingProjectComponent;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.databinding.ProjectResourceCachedValueProvider;
import com.android.tools.idea.databinding.ResourceCacheValueProvider;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingPackageFinder
extends PsiElementFinder {
    private final DataBindingProjectComponent myComponent;
    private final CachedValue<Map<String, PsiPackage>> myPackageCache;

    public DataBindingPackageFinder(DataBindingProjectComponent component) {
        this.myComponent = component;
        this.myPackageCache = CachedValuesManager.getManager((Project)this.myComponent.getProject()).createCachedValue((CachedValueProvider)new ProjectResourceCachedValueProvider<Map<String, PsiPackage>, Set<String>>(this.myComponent, new ModificationTracker[0]){

            @Override
            @NotNull
            protected Map<String, PsiPackage> merge(List<Set<String>> results) {
                HashMap merged = Maps.newHashMap();
                for (Set<String> result2 : results) {
                    for (String qualifiedPackage : result2) {
                        if (merged.containsKey(qualifiedPackage)) continue;
                        merged.put(qualifiedPackage, DataBindingPackageFinder.this.myComponent.getOrCreateDataBindingPsiPackage(qualifiedPackage));
                    }
                }
                HashMap hashMap = merged;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(0);
                }
                return hashMap;
            }

            @Override
            ResourceCacheValueProvider<Set<String>> createCacheProvider(AndroidFacet facet) {
                return new ResourceCacheValueProvider<Set<String>>(facet, null, new ModificationTracker[0]){

                    @Override
                    Set<String> doCompute() {
                        LocalResourceRepository moduleResources = ResourceRepositoryManager.getModuleResources(this.getFacet());
                        Map<String, DataBindingInfo> dataBindingResourceFiles = moduleResources.getDataBindingResourceFiles();
                        if (dataBindingResourceFiles == null) {
                            return Collections.emptySet();
                        }
                        HashSet result2 = Sets.newHashSet();
                        for (DataBindingInfo info : dataBindingResourceFiles.values()) {
                            result2.add(info.getPackageName());
                        }
                        return result2;
                    }

                    @Override
                    Set<String> defaultValue() {
                        return Collections.emptySet();
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/DataBindingPackageFinder$1", "merge"));
            }
        }, false);
    }

    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            DataBindingPackageFinder.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            DataBindingPackageFinder.$$$reportNull$$$0(1);
        }
        return null;
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            DataBindingPackageFinder.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            DataBindingPackageFinder.$$$reportNull$$$0(3);
        }
        if (PsiClass.EMPTY_ARRAY == null) {
            DataBindingPackageFinder.$$$reportNull$$$0(4);
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @Nullable
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            DataBindingPackageFinder.$$$reportNull$$$0(5);
        }
        if (!this.isEnabled()) {
            return null;
        }
        return (PsiPackage)((Map)this.myPackageCache.getValue()).get(qualifiedName);
    }

    private boolean isEnabled() {
        return DataBindingUtil.inMemoryClassGenerationIsEnabled() && this.myComponent.hasAnyDataBindingEnabledFacet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/databinding/DataBindingPackageFinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/databinding/DataBindingPackageFinder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

