/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.databinding.DataBindingMode;
import com.android.tools.idea.databinding.DataBindingProjectComponent;
import com.android.tools.idea.databinding.LightBindingClass;
import com.android.tools.idea.databinding.LightBrClass;
import com.android.tools.idea.databinding.ModuleDataBinding;
import com.android.tools.idea.databinding.config.DataBindingConfiguration;
import com.android.tools.idea.lang.databinding.DbFile;
import com.android.tools.idea.lang.databinding.psi.DbTokenTypes;
import com.android.tools.idea.lang.databinding.psi.PsiDbConstantValue;
import com.android.tools.idea.lang.databinding.psi.PsiDbDefaults;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.PsiDataBindingResourceItem;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.FileContentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.dom.layout.Import;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingUtil {
    static Logger LOG = Logger.getInstance((String)"databinding");
    public static final String BR = "BR";
    private static AtomicLong ourDataBindingEnabledModificationCount = new AtomicLong(0L);
    private static AtomicBoolean ourCreateInMemoryClasses = new AtomicBoolean(false);
    private static List<String> VIEW_PACKAGE_ELEMENTS = Arrays.asList("View", "ViewGroup", "TextureView", "SurfaceView");
    private static AtomicBoolean ourReadInMemoryClassGenerationSettings = new AtomicBoolean(false);
    public static ModificationTracker DATA_BINDING_ENABLED_TRACKER = () -> ourDataBindingEnabledModificationCount.longValue();

    private static void invalidateJavaCodeOnOpenDataBindingProjects() {
        ourDataBindingEnabledModificationCount.incrementAndGet();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            DataBindingProjectComponent component = (DataBindingProjectComponent)project.getComponent(DataBindingProjectComponent.class);
            if (component == null) continue;
            boolean invalidated = DataBindingUtil.invalidateAllSources(component);
            if (!invalidated) {
                return;
            }
            PsiModificationTracker tracker = PsiManager.getInstance((Project)project).getModificationTracker();
            if (tracker instanceof PsiModificationTrackerImpl) {
                ((PsiModificationTrackerImpl)tracker).incCounter();
            }
            FileContentUtil.reparseFiles((Project)project, Collections.emptyList(), (boolean)true);
        }
        ourDataBindingEnabledModificationCount.incrementAndGet();
    }

    public static boolean invalidateAllSources(DataBindingProjectComponent component) {
        boolean invalidated = false;
        for (AndroidFacet facet : component.getDataBindingEnabledFacets()) {
            LocalResourceRepository moduleResources = ResourceRepositoryManager.getModuleResources(facet);
            Map<String, DataBindingInfo> dataBindingResourceFiles = moduleResources.getDataBindingResourceFiles();
            if (dataBindingResourceFiles == null) continue;
            for (DataBindingInfo info : dataBindingResourceFiles.values()) {
                PsiFile containingFile;
                PsiClass psiClass = info.getPsiClass();
                if (psiClass == null || (containingFile = psiClass.getContainingFile()) == null) continue;
                containingFile.subtreeChanged();
                invalidated = true;
            }
        }
        return invalidated;
    }

    public static boolean inMemoryClassGenerationIsEnabled() {
        if (!ourReadInMemoryClassGenerationSettings.getAndSet(true)) {
            ourCreateInMemoryClasses.set(DataBindingUtil.calculateEnableInMemoryClasses());
        }
        return ourCreateInMemoryClasses.get();
    }

    public static void recalculateEnableInMemoryClassGeneration() {
        boolean oldValue;
        boolean newValue = DataBindingUtil.calculateEnableInMemoryClasses();
        if (newValue != (oldValue = ourCreateInMemoryClasses.getAndSet(newValue))) {
            LOG.debug("Data binding in memory completion value change. (old, new)", new Object[]{oldValue, newValue});
            ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(DataBindingUtil::invalidateJavaCodeOnOpenDataBindingProjects));
        }
    }

    private static boolean calculateEnableInMemoryClasses() {
        DataBindingConfiguration config = DataBindingConfiguration.getInstance();
        return config.CODE_NAVIGATION_MODE == DataBindingConfiguration.CodeNavigationMode.XML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LightBrClass getOrCreateBrClassFor(AndroidFacet facet) {
        ModuleDataBinding dataBinding = ModuleDataBinding.getInstance(facet);
        assert (dataBinding != null);
        LightBrClass existing = dataBinding.getLightBrClass();
        if (existing == null) {
            AndroidFacet androidFacet = facet;
            synchronized (androidFacet) {
                existing = dataBinding.getLightBrClass();
                if (existing == null) {
                    existing = new LightBrClass(PsiManager.getInstance((Project)facet.getModule().getProject()), facet);
                    dataBinding.setLightBrClass(existing);
                }
            }
        }
        return existing;
    }

    static PsiType parsePsiType(String text, AndroidFacet facet, PsiElement context) {
        PsiElementFactory instance = PsiElementFactory.SERVICE.getInstance((Project)facet.getModule().getProject());
        try {
            PsiType type = instance.createTypeFromText(text, context);
            if (type instanceof PsiClassReferenceType && ((PsiClassReferenceType)type).getClassName() == null) {
                return null;
            }
            return type;
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    public static PsiType resolveViewPsiType(DataBindingInfo.ViewWithId viewWithId, AndroidFacet facet) {
        String viewClassName = DataBindingUtil.getViewClassName(viewWithId.tag, facet);
        if (StringUtil.isNotEmpty((String)viewClassName)) {
            return DataBindingUtil.parsePsiType(viewClassName, facet, null);
        }
        return null;
    }

    @Nullable
    private static String getViewClassName(XmlTag tag, AndroidFacet facet) {
        String elementName = DataBindingUtil.getViewName(tag);
        if (elementName != null && elementName.indexOf(46) == -1) {
            if (VIEW_PACKAGE_ELEMENTS.contains(elementName)) {
                return "android.view." + elementName;
            }
            if ("WebView".equals(elementName)) {
                return "android.webkit." + elementName;
            }
            if ("merge".equals(elementName)) {
                return DataBindingUtil.getViewClassNameFromMerge(tag, facet);
            }
            if ("include".equals(elementName)) {
                return DataBindingUtil.getViewClassNameFromInclude(tag, facet);
            }
            if ("ViewStub".equals(elementName)) {
                DataBindingMode mode = ModuleDataBinding.getInstance(facet).getDataBindingMode();
                return mode.viewStubProxy;
            }
            return "android.widget." + elementName;
        }
        return elementName;
    }

    private static String getViewClassNameFromInclude(XmlTag tag, AndroidFacet facet) {
        String reference2 = DataBindingUtil.getViewClassNameFromLayoutReferenceTag(tag, facet);
        return reference2 == null ? "android.view.View" : reference2;
    }

    private static String getViewClassNameFromMerge(XmlTag tag, AndroidFacet facet) {
        return DataBindingUtil.getViewClassNameFromLayoutReferenceTag(tag, facet);
    }

    private static String getViewClassNameFromLayoutReferenceTag(XmlTag tag, AndroidFacet facet) {
        String layout2 = tag.getAttributeValue("layout");
        if (layout2 == null) {
            return null;
        }
        LocalResourceRepository moduleResources = ResourceRepositoryManager.getOrCreateInstance(facet).getModuleResources(false);
        if (moduleResources == null) {
            return null;
        }
        ResourceUrl resourceUrl = ResourceUrl.parse((String)layout2);
        if (resourceUrl == null || resourceUrl.type != ResourceType.LAYOUT) {
            return null;
        }
        DataBindingInfo info = moduleResources.getDataBindingInfoForLayout(resourceUrl.name);
        if (info == null) {
            return null;
        }
        return info.getQualifiedName();
    }

    @Nullable
    private static String getViewName(XmlTag tag) {
        String viewName = tag.getName();
        if ("view".equals(viewName)) {
            viewName = tag.getAttributeValue("class", "http://schemas.android.com/apk/res/android");
        }
        return viewName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PsiClass getOrCreatePsiClass(DataBindingInfo info) {
        PsiClass psiClass = info.getPsiClass();
        if (psiClass == null) {
            DataBindingInfo dataBindingInfo = info;
            synchronized (dataBindingInfo) {
                psiClass = info.getPsiClass();
                if (psiClass == null) {
                    psiClass = new LightBindingClass(info.getFacet(), PsiManager.getInstance((Project)info.getProject()), info);
                    info.setPsiClass(psiClass);
                }
            }
        }
        return psiClass;
    }

    public static String convertToJavaClassName(String name) {
        int dotIndex = name.indexOf(46);
        if (dotIndex >= 0) {
            name = name.substring(0, dotIndex);
        }
        String[] split = name.split("[_-]");
        StringBuilder out = new StringBuilder();
        for (String section : split) {
            out.append(StringUtil.capitalize((String)section));
        }
        return out.toString();
    }

    public static String convertToJavaFieldName(String name) {
        int dotIndex = name.indexOf(46);
        if (dotIndex >= 0) {
            name = name.substring(0, dotIndex);
        }
        String[] split = name.split("[_-]");
        StringBuilder out = new StringBuilder();
        boolean first = true;
        for (String section : split) {
            if (first) {
                first = false;
                out.append(section);
                continue;
            }
            out.append(StringUtil.capitalize((String)section));
        }
        return out.toString();
    }

    public static String getBrQualifiedName(AndroidFacet facet) {
        return DataBindingUtil.getGeneratedPackageName(facet) + "." + BR;
    }

    public static String getGeneratedPackageName(AndroidFacet facet) {
        return MergedManifest.get(facet).getPackage();
    }

    public static void incrementModificationCount() {
        ourDataBindingEnabledModificationCount.incrementAndGet();
    }

    @Nullable
    public static String getBindingExprDefault(@NotNull XmlAttribute psiAttribute) {
        XmlAttributeValue attrValue;
        if (psiAttribute == null) {
            DataBindingUtil.$$$reportNull$$$0(0);
        }
        if ((attrValue = psiAttribute.getValueElement()) instanceof PsiLanguageInjectionHost) {
            PsiDbDefaults defaults;
            Ref injections = Ref.create();
            InjectedLanguageManager.getInstance((Project)psiAttribute.getProject()).enumerate((PsiElement)attrValue, (injectedPsi, places) -> {
                if (injectedPsi instanceof DbFile) {
                    injections.set((Object)injectedPsi);
                }
            });
            if (injections.get() != null && (defaults = (PsiDbDefaults)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)injections.get()), PsiDbDefaults.class)) != null) {
                PsiDbConstantValue constantValue = defaults.getConstantValue();
                ASTNode stringLiteral = constantValue.getNode().findChildByType(DbTokenTypes.STRING_LITERAL);
                if (stringLiteral == null) {
                    return constantValue.getText();
                }
                String text = stringLiteral.getText();
                if (text.length() > 1) {
                    return text.substring(1, text.length() - 1);
                }
                return text;
            }
        }
        return null;
    }

    @Nullable
    public static String getBindingExprDefault(@NotNull String exprn) {
        if (exprn == null) {
            DataBindingUtil.$$$reportNull$$$0(1);
        }
        if (!exprn.contains(DbTokenTypes.DEFAULT_KEYWORD.toString())) {
            return null;
        }
        Pattern defaultCheck = Pattern.compile(",\\s*default\\s*=\\s*");
        int index = 0;
        Matcher matcher = defaultCheck.matcher(exprn);
        while (matcher.find()) {
            index = matcher.end();
        }
        String def = exprn.substring(index, exprn.length() - 1).trim();
        if (def.startsWith("\"") && def.endsWith("\"")) {
            def = def.substring(1, def.length() - 1);
        }
        return def;
    }

    public static boolean isBindingExpression(@NotNull String string) {
        if (string == null) {
            DataBindingUtil.$$$reportNull$$$0(2);
        }
        return string.startsWith("@{") || string.startsWith("@={");
    }

    @Nullable
    public static String getAlias(@NotNull Import anImport) {
        XmlAttributeValue value;
        GenericAttributeValue<PsiElement> type;
        if (anImport == null) {
            DataBindingUtil.$$$reportNull$$$0(3);
        }
        String aliasValue = null;
        String typeValue = null;
        GenericAttributeValue<String> alias = anImport.getAlias();
        if (alias != null && alias.getXmlAttributeValue() != null) {
            aliasValue = alias.getXmlAttributeValue().getValue();
        }
        if ((type = anImport.getType()) != null && (value = type.getXmlAttributeValue()) != null) {
            typeValue = value.getValue();
        }
        return DataBindingUtil.getAlias(typeValue, aliasValue);
    }

    @Nullable
    public static String getAlias(@NotNull PsiDataBindingResourceItem anImport) {
        if (anImport == null) {
            DataBindingUtil.$$$reportNull$$$0(4);
        }
        return DataBindingUtil.getAlias(anImport.getTypeDeclaration(), anImport.getExtra("alias"));
    }

    private static String getAlias(@Nullable String type, @Nullable String alias) {
        int d;
        if (alias != null || type == null) {
            return alias;
        }
        int i = type.lastIndexOf(46);
        int n = i = i > (d = type.lastIndexOf(36)) ? i : d;
        if (i < 0) {
            return type;
        }
        return type.length() > i + 1 ? type.substring(i + 1) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAttribute";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exprn";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anImport";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/databinding/DataBindingUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getBindingExprDefault";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isBindingExpression";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getAlias";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

