/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.IDevice;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.tools.idea.ddms.DeviceNameProperties;
import com.android.tools.idea.ddms.DeviceNamePropertiesProvider;
import com.android.tools.idea.ddms.DeviceNameRendererEx;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.google.common.collect.Sets;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import icons.AndroidIcons;
import java.util.HashSet;
import java.util.List;
import javax.swing.JList;
import javax.swing.JTable;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceRenderer {
    private DeviceRenderer() {
    }

    public static void renderDeviceName(@NotNull IDevice d, @NotNull DeviceNameProperties deviceProperties, @NotNull ColoredTextContainer component, boolean showSerialNumber) {
        if (d == null) {
            DeviceRenderer.$$$reportNull$$$0(0);
        }
        if (deviceProperties == null) {
            DeviceRenderer.$$$reportNull$$$0(1);
        }
        if (component == null) {
            DeviceRenderer.$$$reportNull$$$0(2);
        }
        DeviceRenderer.renderDeviceName(d, deviceProperties, component, showSerialNumber, null);
    }

    public static void renderDeviceName(@NotNull IDevice d, @NotNull DeviceNameProperties deviceNameProperties, @NotNull ColoredTextContainer component, boolean showSerialNumber, @Nullable AvdManager avdManager) {
        if (d == null) {
            DeviceRenderer.$$$reportNull$$$0(3);
        }
        if (deviceNameProperties == null) {
            DeviceRenderer.$$$reportNull$$$0(4);
        }
        if (component == null) {
            DeviceRenderer.$$$reportNull$$$0(5);
        }
        component.setIcon(d.isEmulator() ? AndroidIcons.Ddms.Emulator2 : AndroidIcons.Ddms.RealDevice);
        String name = d.isEmulator() ? DeviceRenderer.getEmulatorDeviceName(d, avdManager) : DeviceRenderer.getDeviceName(deviceNameProperties);
        component.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        IDevice.DeviceState deviceState = d.getState();
        if (deviceState != IDevice.DeviceState.ONLINE) {
            String state = String.format("%1$s [%2$s] ", d.getSerialNumber(), d.getState());
            component.append(state, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        } else if (showSerialNumber) {
            String state = String.format("%1$s ", d.getSerialNumber());
            component.append(state, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        }
        if (deviceState != IDevice.DeviceState.DISCONNECTED && deviceState != IDevice.DeviceState.OFFLINE) {
            component.append(DevicePropertyUtil.getBuild(deviceNameProperties.getBuildVersion(), null, deviceNameProperties.getApiLevel()), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @NotNull
    private static String getEmulatorDeviceName(@NotNull IDevice d, @Nullable AvdManager avdManager) {
        AvdInfo info;
        if (d == null) {
            DeviceRenderer.$$$reportNull$$$0(6);
        }
        String avdName = d.getAvdName();
        if (avdManager != null && (info = avdManager.getAvd(avdName, true)) != null) {
            avdName = (String)info.getProperties().get("avd.ini.displayname");
        }
        if (avdName == null) {
            avdName = d.getSerialNumber();
        }
        String string = String.format("%1$s %2$s ", AndroidBundle.message("android.emulator", new Object[0]), avdName);
        if (string == null) {
            DeviceRenderer.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static String getDeviceName(@NotNull DeviceNameProperties deviceNameProperties) {
        if (deviceNameProperties == null) {
            DeviceRenderer.$$$reportNull$$$0(8);
        }
        String string = String.format("%1$s %2$s ", DevicePropertyUtil.getManufacturer(deviceNameProperties.getManufacturer(), false, ""), DevicePropertyUtil.getModel(deviceNameProperties.getModel(), ""));
        if (string == null) {
            DeviceRenderer.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String getDeviceName(@NotNull IDevice d) {
        if (d == null) {
            DeviceRenderer.$$$reportNull$$$0(10);
        }
        String string = String.format("%1$s %2$s ", DevicePropertyUtil.getManufacturer(d, ""), DevicePropertyUtil.getModel(d, ""));
        if (string == null) {
            DeviceRenderer.$$$reportNull$$$0(11);
        }
        return string;
    }

    public static boolean shouldShowSerialNumbers(@NotNull List<IDevice> devices) {
        if (devices == null) {
            DeviceRenderer.$$$reportNull$$$0(12);
        }
        HashSet myNames = Sets.newHashSet();
        for (IDevice currentDevice : devices) {
            if (currentDevice.isEmulator()) continue;
            String currentName = DeviceRenderer.getDeviceName(currentDevice);
            if (myNames.contains(currentName)) {
                return true;
            }
            myNames.add(currentName);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceProperties";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceNameProperties";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ddms/DeviceRenderer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ddms/DeviceRenderer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmulatorDeviceName";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "renderDeviceName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEmulatorDeviceName";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDeviceName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "shouldShowSerialNumbers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DeviceNameRenderer
    extends ColoredTableCellRenderer {
        private static final ExtensionPointName<DeviceNameRendererEx> EP_NAME = ExtensionPointName.create((String)"com.android.run.deviceNameRenderer");
        private final DeviceNameRendererEx[] myRenderers;
        private final AvdManager myAvdManager;
        private final DeviceNamePropertiesProvider myDeviceNamePropertiesProvider;

        public DeviceNameRenderer(@Nullable AvdManager avdManager, @NotNull DeviceNamePropertiesProvider deviceNamePropertiesProvider) {
            if (deviceNamePropertiesProvider == null) {
                DeviceNameRenderer.$$$reportNull$$$0(0);
            }
            this.myRenderers = (DeviceNameRendererEx[])EP_NAME.getExtensions();
            this.myAvdManager = avdManager;
            this.myDeviceNamePropertiesProvider = deviceNamePropertiesProvider;
        }

        protected void customizeCellRenderer(JTable table2, Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (!(value instanceof IDevice)) {
                return;
            }
            IDevice device = (IDevice)value;
            for (DeviceNameRendererEx renderer : this.myRenderers) {
                if (!renderer.isApplicable(device)) continue;
                renderer.render(device, (ColoredTextContainer)this);
                return;
            }
            DeviceRenderer.renderDeviceName(device, this.myDeviceNamePropertiesProvider.get(device), (ColoredTextContainer)this, false, this.myAvdManager);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceNamePropertiesProvider", "com/android/tools/idea/ddms/DeviceRenderer$DeviceNameRenderer", "<init>"));
        }
    }

    static final class DeviceComboBoxRenderer
    extends ColoredListCellRenderer<IDevice> {
        @NotNull
        private String myEmptyText;
        private boolean myShowSerial;
        private DeviceNamePropertiesProvider myDeviceNamePropertiesProvider;

        public DeviceComboBoxRenderer(@NotNull String emptyText, boolean showSerial, @NotNull DeviceNamePropertiesProvider deviceNamePropertiesProvider) {
            if (emptyText == null) {
                DeviceComboBoxRenderer.$$$reportNull$$$0(0);
            }
            if (deviceNamePropertiesProvider == null) {
                DeviceComboBoxRenderer.$$$reportNull$$$0(1);
            }
            this.myEmptyText = emptyText;
            this.myShowSerial = showSerial;
            this.myDeviceNamePropertiesProvider = deviceNamePropertiesProvider;
        }

        public void setShowSerial(boolean showSerial) {
            this.myShowSerial = showSerial;
        }

        protected void customizeCellRenderer(@NotNull JList<? extends IDevice> list, IDevice value, int index, boolean selected, boolean focused) {
            if (list == null) {
                DeviceComboBoxRenderer.$$$reportNull$$$0(2);
            }
            if (value == null) {
                this.append(this.myEmptyText, SimpleTextAttributes.ERROR_ATTRIBUTES);
                return;
            }
            DeviceRenderer.renderDeviceName(value, this.myDeviceNamePropertiesProvider.get(value), (ColoredTextContainer)this, this.myShowSerial);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "emptyText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deviceNamePropertiesProvider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/ddms/DeviceRenderer$DeviceComboBoxRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

