/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.IDevice;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.avdmanager.EmulatorAdvFeatures;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.AbstractDeviceAction;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.run.DeviceStateCache;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.utils.ILogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import icons.AndroidIcons;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class ScreenRecorderAction
extends AbstractDeviceAction {
    private static final String PKG_NAME = "";
    private final Project myProject;
    private final DeviceStateCache<CompletableFuture> myCache;

    public ScreenRecorderAction(@NotNull Project project, @NotNull DeviceContext context) {
        if (project == null) {
            ScreenRecorderAction.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ScreenRecorderAction.$$$reportNull$$$0(1);
        }
        super(context, AndroidBundle.message("android.ddms.actions.screenrecord", new Object[0]), AndroidBundle.message("android.ddms.actions.screenrecord.description", new Object[0]), AndroidIcons.Ddms.ScreenRecorder);
        this.myProject = project;
        this.myCache = new DeviceStateCache((Disposable)project);
    }

    boolean isEmulatorAndSupportsEmuRecording(@NotNull IDevice device) {
        if (device == null) {
            ScreenRecorderAction.$$$reportNull$$$0(2);
        }
        if (device.isEmulator()) {
            AndroidSdkHandler handler = AndroidSdks.getInstance().tryToChooseSdkHandler();
            return EmulatorAdvFeatures.emulatorSupportsScreenRecording(handler, (ProgressIndicator)new StudioLoggerProgressIndicator(ScreenRecorderAction.class), (ILogger)new LogWrapper(Logger.getInstance(ScreenRecorderAction.class)));
        }
        return false;
    }

    @Override
    protected boolean isEnabled() {
        if (!super.isEnabled()) {
            return false;
        }
        IDevice device = this.myDeviceContext.getSelectedDevice();
        if (this.isEmulatorAndSupportsEmuRecording(device)) {
            return true;
        }
        CompletableFuture<Boolean> cf = this.myCache.get(device, PKG_NAME);
        if (cf == null) {
            cf = CompletableFuture.supplyAsync(() -> device.supportsFeature(IDevice.Feature.SCREEN_RECORD));
            this.myCache.put(device, PKG_NAME, cf);
        }
        return cf.getNow(false);
    }

    @Override
    protected void performAction(@NotNull IDevice device) {
        if (device == null) {
            ScreenRecorderAction.$$$reportNull$$$0(3);
        }
        boolean useEmuScreenRecording = this.isEmulatorAndSupportsEmuRecording(device);
        new com.android.tools.idea.ddms.screenrecord.ScreenRecorderAction(this.myProject, device, useEmuScreenRecording).performAction();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/ddms/actions/ScreenRecorderAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isEmulatorAndSupportsEmuRecording";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "performAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

