/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.screenrecord;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.EmulatorConsole;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.ScreenRecorderOptions;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.ddms.screenrecord.ScreenRecorderOptionsDialog;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.intellij.CommonBundle;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileTypes.NativeFileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenRecorderAction {
    private static final String TITLE = "Screen Recorder";
    private static final String MEDIA_UNSUPPORTED_ERROR = "-1010";
    @NonNls
    private static final String REMOTE_PATH = "/sdcard/ddmsrec.mp4";
    private static final String EMU_TMP_FILENAME = "tmp.webm";
    private static VirtualFile ourLastSavedFolder;
    private final Project myProject;
    private final IDevice myDevice;
    private boolean mUseEmuRecording;
    private String mHostRecordingFileName;

    public ScreenRecorderAction(@NotNull Project p, @NotNull IDevice device, boolean useEmuRecording) {
        if (p == null) {
            ScreenRecorderAction.$$$reportNull$$$0(0);
        }
        if (device == null) {
            ScreenRecorderAction.$$$reportNull$$$0(1);
        }
        this.mUseEmuRecording = false;
        this.mHostRecordingFileName = null;
        this.myProject = p;
        this.myDevice = device;
        this.mUseEmuRecording = useEmuRecording;
    }

    public void performAction() {
        ScreenRecorderOptionsDialog dialog = new ScreenRecorderOptionsDialog(this.myProject);
        if (!dialog.showAndGet()) {
            return;
        }
        ScreenRecorderOptions options = dialog.getOptions();
        CountDownLatch latch = new CountDownLatch(1);
        CollectingOutputReceiver receiver = new CollectingOutputReceiver(latch);
        if (this.mUseEmuRecording) {
            try {
                AndroidSdkHandler handler = AndroidSdks.getInstance().tryToChooseSdkHandler();
                AvdManager avdManager = AvdManager.getInstance((AndroidSdkHandler)handler, (ILogger)new LogWrapper(Logger.getInstance(ScreenRecorderAction.class)));
                AvdInfo avdInfo = avdManager.getAvd(this.myDevice.getAvdName(), true);
                this.mHostRecordingFileName = avdInfo.getDataFolderPath() + File.separator + EMU_TMP_FILENAME;
            }
            catch (Exception e) {
                ScreenRecorderAction.showError(this.myProject, "Unexpected error while launching screen recorder", e);
            }
        }
        boolean showTouchEnabled = this.isShowTouchEnabled(this.myDevice);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (options.showTouches != showTouchEnabled) {
                this.setShowTouch(this.myDevice, options.showTouches);
            }
            try {
                if (this.mHostRecordingFileName != null) {
                    EmulatorConsole console = EmulatorConsole.getConsole((IDevice)this.myDevice);
                    if (console != null) {
                        console.startEmulatorScreenRecording(ScreenRecorderAction.getEmulatorScreenRecorderOptions(this.mHostRecordingFileName, options));
                    }
                } else {
                    this.myDevice.startScreenRecorder(REMOTE_PATH, options, (IShellOutputReceiver)receiver);
                }
            }
            catch (Exception e) {
                ScreenRecorderAction.showError(this.myProject, "Unexpected error while launching screen recorder", e);
                latch.countDown();
            }
            finally {
                if (options.showTouches != showTouchEnabled) {
                    this.setShowTouch(this.myDevice, showTouchEnabled);
                }
            }
        });
        ScreenRecorderTask screenRecorderShellTask = new ScreenRecorderTask(this.myProject, this.myDevice, latch, receiver, this.mHostRecordingFileName);
        screenRecorderShellTask.setCancelText("Stop Recording");
        screenRecorderShellTask.queue();
    }

    private void setShowTouch(@NotNull IDevice device, boolean isEnabled) {
        if (device == null) {
            ScreenRecorderAction.$$$reportNull$$$0(2);
        }
        int value = isEnabled ? 1 : 0;
        try {
            device.executeShellCommand("settings put system show_touches " + value, (IShellOutputReceiver)new NullOutputReceiver());
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e) {
            Logger.getInstance(ScreenRecorderAction.class).warn("Failed to set show taps to " + isEnabled, e);
        }
    }

    private boolean isShowTouchEnabled(@NotNull IDevice device) {
        if (device == null) {
            ScreenRecorderAction.$$$reportNull$$$0(3);
        }
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        try {
            device.executeShellCommand("settings get system show_touches", (IShellOutputReceiver)receiver);
            String output = receiver.getOutput();
            return output.equals("1");
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e) {
            Logger.getInstance(ScreenRecorderAction.class).warn("Failed to retrieve setting", e);
            return false;
        }
    }

    static String getEmulatorScreenRecorderOptions(@NotNull String filePath, @NotNull ScreenRecorderOptions options) {
        if (filePath == null) {
            ScreenRecorderAction.$$$reportNull$$$0(4);
        }
        if (options == null) {
            ScreenRecorderAction.$$$reportNull$$$0(5);
        }
        StringBuilder sb = new StringBuilder();
        if (options.width > 0 && options.height > 0) {
            sb.append("--size ");
            sb.append(options.width);
            sb.append('x');
            sb.append(options.height);
            sb.append(' ');
        }
        if (options.bitrateMbps > 0) {
            sb.append("--bit-rate ");
            sb.append(options.bitrateMbps * 1000000);
            sb.append(' ');
        }
        if (options.timeLimit > 0L) {
            sb.append("--time-limit ");
            long seconds = TimeUnit.SECONDS.convert(options.timeLimit, options.timeLimitUnits);
            if (seconds > 180L) {
                seconds = 180L;
            }
            sb.append(seconds);
            sb.append(' ');
        }
        sb.append(filePath);
        return sb.toString();
    }

    private static void showError(@Nullable Project project, @NotNull String message, @Nullable Throwable throwable) {
        if (message == null) {
            ScreenRecorderAction.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (message == null) {
                ScreenRecorderAction.$$$reportNull$$$0(7);
            }
            String msg = message;
            if (throwable != null) {
                msg = msg + (throwable.getLocalizedMessage() != null ? ": " + throwable.getLocalizedMessage() : "");
            }
            Messages.showErrorDialog((Project)project, (String)msg, (String)TITLE);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/ddms/screenrecord/ScreenRecorderAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setShowTouch";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isShowTouchEnabled";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getEmulatorScreenRecorderOptions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "showError";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$showError$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PullRecordingTask
    extends Task.Modal {
        private final String myLocalPath;
        private final IDevice myDevice;

        public PullRecordingTask(@Nullable Project project, @NotNull IDevice device, @NotNull String localFilePath) {
            if (device == null) {
                PullRecordingTask.$$$reportNull$$$0(0);
            }
            if (localFilePath == null) {
                PullRecordingTask.$$$reportNull$$$0(1);
            }
            super(project, ScreenRecorderAction.TITLE, false);
            this.myDevice = device;
            this.myLocalPath = localFilePath;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                PullRecordingTask.$$$reportNull$$$0(2);
            }
            try {
                this.myDevice.pullFile(ScreenRecorderAction.REMOTE_PATH, this.myLocalPath);
                this.myDevice.removeRemotePackage(ScreenRecorderAction.REMOTE_PATH);
            }
            catch (Exception e) {
                ScreenRecorderAction.showError(this.myProject, "Unexpected error while copying video recording from device", e);
            }
        }

        private void openSavedFile() {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(this.myLocalPath);
            if (file != null) {
                NativeFileType.openAssociatedApplication((VirtualFile)file);
            }
        }

        public void onSuccess() {
            assert (this.myProject != null);
            if (ShowFilePathAction.isSupported()) {
                int exitCode = Messages.showYesNoCancelDialog((Project)this.myProject, (String)("Video Recording saved as " + this.myLocalPath), (String)ScreenRecorderAction.TITLE, (String)"Open", (String)("Show in " + ShowFilePathAction.getFileManagerName()), (String)CommonBundle.getOkButtonText(), (Icon)Messages.getInformationIcon());
                if (exitCode == 0) {
                    this.openSavedFile();
                } else if (exitCode == 1) {
                    ShowFilePathAction.openFile((File)new File(this.myLocalPath));
                }
            } else if (Messages.showOkCancelDialog((Project)this.myProject, (String)("Video Recording saved as " + this.myLocalPath), (String)ScreenRecorderAction.TITLE, (String)"Open File", (String)CommonBundle.getOkButtonText(), (Icon)Messages.getInformationIcon()) == 0) {
                this.openSavedFile();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "device";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localFilePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/ddms/screenrecord/ScreenRecorderAction$PullRecordingTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ScreenRecorderTask
    extends Task.Modal {
        private final IDevice myDevice;
        private final CountDownLatch myCompletionLatch;
        private final CollectingOutputReceiver myReceiver;
        private String mHostTmpFileName;

        public ScreenRecorderTask(@NotNull Project project, @NotNull IDevice device, @NotNull CountDownLatch completionLatch, @NotNull CollectingOutputReceiver receiver, @Nullable String hostTmpFileName) {
            if (project == null) {
                ScreenRecorderTask.$$$reportNull$$$0(0);
            }
            if (device == null) {
                ScreenRecorderTask.$$$reportNull$$$0(1);
            }
            if (completionLatch == null) {
                ScreenRecorderTask.$$$reportNull$$$0(2);
            }
            if (receiver == null) {
                ScreenRecorderTask.$$$reportNull$$$0(3);
            }
            super(project, ScreenRecorderAction.TITLE, true);
            this.mHostTmpFileName = null;
            this.myDevice = device;
            this.myCompletionLatch = completionLatch;
            this.myReceiver = receiver;
            this.mHostTmpFileName = hostTmpFileName;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                ScreenRecorderTask.$$$reportNull$$$0(4);
            }
            int elapsedTime = 0;
            indicator.setIndeterminate(true);
            block2: while (true) {
                try {
                    while (!this.myCompletionLatch.await(1L, TimeUnit.SECONDS)) {
                        indicator.setText(String.format("Recording...%1$d %2$s elapsed", ++elapsedTime, StringUtil.pluralize((String)"second", (int)elapsedTime)));
                        EmulatorConsole console = null;
                        if (this.mHostTmpFileName != null && (console = EmulatorConsole.getConsole((IDevice)this.myDevice)) == null) {
                            indicator.cancel();
                        }
                        if (!indicator.isCanceled() && elapsedTime < 180) continue;
                        if (this.mHostTmpFileName != null) {
                            if (console != null) {
                                console.stopScreenRecording();
                            }
                        } else {
                            this.myReceiver.cancel();
                        }
                        indicator.setText("Stopping...");
                        this.myCompletionLatch.await(1L, TimeUnit.SECONDS);
                        break block2;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        public void onFinished() {
            if (this.mHostTmpFileName != null) {
                this.pullEmulatorRecording();
            } else {
                this.pullRecording();
            }
        }

        private void pullEmulatorRecording() {
            VirtualFile baseDir;
            FileSaverDescriptor descriptor = new FileSaverDescriptor("Save As", "", new String[]{"webm"});
            FileSaverDialog saveFileDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, this.myProject);
            VirtualFileWrapper fileWrapper = saveFileDialog.save(baseDir = ourLastSavedFolder != null ? ourLastSavedFolder : VfsUtil.getUserHomeDir(), ScreenRecorderTask.getDefaultFileName(".webm"));
            if (fileWrapper == null) {
                return;
            }
            File f = fileWrapper.getFile();
            ourLastSavedFolder = VfsUtil.findFileByIoFile((File)f.getParentFile(), (boolean)false);
            try {
                FileUtils.copyFile((File)new File(this.mHostTmpFileName), (File)f);
            }
            catch (IOException e) {
                ScreenRecorderAction.showError(this.myProject, "Unable to copy file to destination", e);
            }
        }

        private void pullRecording() {
            VirtualFile baseDir;
            if (this.myReceiver.getOutput().contains(ScreenRecorderAction.MEDIA_UNSUPPORTED_ERROR)) {
                Messages.showErrorDialog((String)this.myReceiver.getOutput(), (String)"Screen Recorder Error");
                return;
            }
            FileSaverDescriptor descriptor = new FileSaverDescriptor("Save As", "", new String[]{"mp4"});
            FileSaverDialog saveFileDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, this.myProject);
            VirtualFileWrapper fileWrapper = saveFileDialog.save(baseDir = ourLastSavedFolder != null ? ourLastSavedFolder : VfsUtil.getUserHomeDir(), ScreenRecorderTask.getDefaultFileName(".mp4"));
            if (fileWrapper == null) {
                return;
            }
            File f = fileWrapper.getFile();
            ourLastSavedFolder = VfsUtil.findFileByIoFile((File)f.getParentFile(), (boolean)false);
            new PullRecordingTask(this.myProject, this.myDevice, f.getAbsolutePath()).queue();
        }

        private static String getDefaultFileName(String extension) {
            Calendar now = Calendar.getInstance();
            String fileName = "device-%tF-%tH%tM%tS";
            return String.format(SystemInfo.isMac ? fileName + extension : fileName, now, now, now, now);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "device";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "completionLatch";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiver";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/ddms/screenrecord/ScreenRecorderAction$ScreenRecorderTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

