/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.android.SdkConstants;
import com.android.tools.idea.debug.AndroidResolveHelper;
import com.android.tools.idea.debug.ResourceIdResolver;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.google.common.util.concurrent.Atomics;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationsRenderer {
    @NotNull
    public static Result render(@Nullable ResourceIdResolver resolver, @NotNull PsiAnnotation annotation, int value) {
        String qualifiedName;
        if (annotation == null) {
            AnnotationsRenderer.$$$reportNull$$$0(0);
        }
        if ((qualifiedName = AnnotationsRenderer.getQualifiedName(annotation)) == null) {
            Result result2 = AnnotationsRenderer.renderUnknown(null, value);
            if (result2 == null) {
                AnnotationsRenderer.$$$reportNull$$$0(1);
            }
            return result2;
        }
        if (ResourceEvaluator.COLOR_INT_ANNOTATION.isEquals(qualifiedName)) {
            Result result3 = AnnotationsRenderer.renderColorInt(value);
            if (result3 == null) {
                AnnotationsRenderer.$$$reportNull$$$0(2);
            }
            return result3;
        }
        if (qualifiedName.endsWith("Res")) {
            Result result4 = AnnotationsRenderer.renderResourceRefAnnotation(resolver, value, qualifiedName);
            if (result4 == null) {
                AnnotationsRenderer.$$$reportNull$$$0(3);
            }
            return result4;
        }
        if (SdkConstants.INT_DEF_ANNOTATION.isEquals(qualifiedName)) {
            Result result5 = AnnotationsRenderer.renderIntDefAnnotation(annotation, value);
            if (result5 == null) {
                AnnotationsRenderer.$$$reportNull$$$0(4);
            }
            return result5;
        }
        Result result6 = AnnotationsRenderer.renderUnknown(qualifiedName, value);
        if (result6 == null) {
            AnnotationsRenderer.$$$reportNull$$$0(5);
        }
        return result6;
    }

    @NotNull
    private static Result renderIntDefAnnotation(final @NotNull PsiAnnotation annotation, int value) {
        if (annotation == null) {
            AnnotationsRenderer.$$$reportNull$$$0(6);
        }
        final AtomicReference valuesRef = Atomics.newReference();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                valuesRef.set(AndroidResolveHelper.resolveIntDef(annotation));
            }
        });
        AndroidResolveHelper.IntDefResolution intDef = (AndroidResolveHelper.IntDefResolution)valuesRef.get();
        if (intDef.valuesMap == null) {
            AnnotationsRenderer.renderUnknown("IntDef", value);
        }
        Result result2 = new Result(String.format(Locale.US, "0x%1$08x {%2$s}", value, AnnotationsRenderer.renderIntDef(value, intDef)), null);
        if (result2 == null) {
            AnnotationsRenderer.$$$reportNull$$$0(7);
        }
        return result2;
    }

    @NotNull
    static String renderIntDef(int value, AndroidResolveHelper.IntDefResolution intDef) {
        if (intDef.valuesMap == null) {
            if ("" == null) {
                AnnotationsRenderer.$$$reportNull$$$0(8);
            }
            return "";
        }
        if (!intDef.canBeOred) {
            String name = intDef.valuesMap.get(value);
            String string = StringUtil.notNullize((String)name);
            if (string == null) {
                AnnotationsRenderer.$$$reportNull$$$0(9);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder(20);
        for (Map.Entry<Integer, String> entry : intDef.valuesMap.entrySet()) {
            int key = entry.getKey();
            if ((value & key) == 0) continue;
            if (sb.length() > 0) {
                sb.append(" | ");
            }
            sb.append(entry.getValue());
        }
        String string = sb.toString();
        if (string == null) {
            AnnotationsRenderer.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private static Result renderResourceRefAnnotation(@Nullable ResourceIdResolver resolver, int value, String qualifiedName) {
        String androidRes = null;
        if (resolver != null) {
            androidRes = resolver.getAndroidResourceName(value);
        }
        if (androidRes == null) {
            Result result2 = AnnotationsRenderer.renderUnknown(qualifiedName, value);
            if (result2 == null) {
                AnnotationsRenderer.$$$reportNull$$$0(11);
            }
            return result2;
        }
        String result3 = String.format(Locale.US, "0x%1$08x {%2$s}", value, androidRes);
        Result result4 = new Result(result3, null);
        if (result4 == null) {
            AnnotationsRenderer.$$$reportNull$$$0(12);
        }
        return result4;
    }

    @NotNull
    private static Result renderColorInt(int value) {
        int alpha = value >>> 24;
        boolean hasAlpha = alpha != 0;
        Color color = new Color(value, hasAlpha);
        String result2 = String.format(Locale.US, "0x%1$08x {a=%2$02d r=%3$02d g=%4$02d b=%5$02d}", value, color.getAlpha(), color.getRed(), color.getGreen(), color.getBlue());
        Result result3 = new Result(result2, (Icon)JBUI.scale((JBUI.JBIcon)new ColorIcon(16, 12, color, true)));
        if (result3 == null) {
            AnnotationsRenderer.$$$reportNull$$$0(13);
        }
        return result3;
    }

    @NotNull
    private static Result renderUnknown(@Nullable String annotationName, int value) {
        Result result2 = new Result(String.format("0x%1$08x {@%2$s ?}", value, annotationName == null ? "" : AnnotationsRenderer.getSimpleClassName(annotationName)), null);
        if (result2 == null) {
            AnnotationsRenderer.$$$reportNull$$$0(14);
        }
        return result2;
    }

    @Nullable
    private static String getQualifiedName(final PsiAnnotation annotation) {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return annotation.getQualifiedName();
            }
        });
    }

    private static String getSimpleClassName(@NotNull String fqcn) {
        int index;
        if (fqcn == null) {
            AnnotationsRenderer.$$$reportNull$$$0(15);
        }
        return (index = fqcn.lastIndexOf(46)) < fqcn.length() - 1 ? fqcn.substring(index + 1) : fqcn;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/debug/AnnotationsRenderer";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqcn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/debug/AnnotationsRenderer";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "render";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "renderIntDefAnnotation";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "renderIntDef";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "renderResourceRefAnnotation";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "renderColorInt";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "renderUnknown";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renderIntDefAnnotation";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleClassName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Result {
        @NotNull
        public final String label;
        @Nullable
        public final Icon icon;

        public Result(@NotNull String label, @Nullable Icon icon) {
            if (label == null) {
                Result.$$$reportNull$$$0(0);
            }
            this.label = label;
            this.icon = icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/debug/AnnotationsRenderer$Result", "<init>"));
        }
    }
}

