/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.android.tools.idea.debug.AndroidResolveHelper;
import com.android.tools.idea.debug.AnnotationsRenderer;
import com.android.tools.idea.debug.DynamicResourceIdResolver;
import com.android.tools.idea.debug.ResourceIdResolver;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.LocalVariableDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.ToStringCommand;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolveTypedIntegerCommand
extends ToStringCommand {
    private final ValueDescriptor myDescriptor;
    private final EvaluationContext myEvaluationContext;
    private final Value myValue;
    private final DescriptorLabelListener myListener;
    AnnotationsRenderer.Result myResult;

    public ResolveTypedIntegerCommand(@NotNull ValueDescriptor descriptor, @NotNull EvaluationContext evaluationContext, @NotNull Value value, @NotNull DescriptorLabelListener listener2) {
        if (descriptor == null) {
            ResolveTypedIntegerCommand.$$$reportNull$$$0(0);
        }
        if (evaluationContext == null) {
            ResolveTypedIntegerCommand.$$$reportNull$$$0(1);
        }
        if (value == null) {
            ResolveTypedIntegerCommand.$$$reportNull$$$0(2);
        }
        if (listener2 == null) {
            ResolveTypedIntegerCommand.$$$reportNull$$$0(3);
        }
        super(evaluationContext, value);
        this.myDescriptor = descriptor;
        this.myEvaluationContext = evaluationContext;
        this.myValue = value;
        this.myListener = listener2;
    }

    public void action() {
        DebugProcess debugProcess = this.myEvaluationContext.getDebugProcess();
        if (!(debugProcess instanceof DebugProcessImpl)) {
            return;
        }
        final DebuggerContextImpl debuggerContext = ((DebugProcessImpl)debugProcess).getDebuggerContext();
        PsiAnnotation annotation = (PsiAnnotation)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiAnnotation>(){

            public PsiAnnotation compute() {
                try {
                    return ResolveTypedIntegerCommand.this.getAnnotation(debuggerContext);
                }
                catch (IndexNotReadyException e) {
                    return null;
                }
            }
        });
        if (annotation != null) {
            ResourceIdResolver resolver = (ResourceIdResolver)ServiceManager.getService((Project)this.myEvaluationContext.getProject(), ResourceIdResolver.class);
            DynamicResourceIdResolver resolver1 = new DynamicResourceIdResolver(this.myEvaluationContext, resolver);
            this.myResult = AnnotationsRenderer.render(resolver1, annotation, ((IntegerValue)this.myValue).value());
        }
        this.evaluationResult("");
    }

    @Nullable
    private PsiAnnotation getAnnotation(DebuggerContextImpl debuggerContext) {
        PsiElement context = PositionUtil.getContextElement((StackFrameContext)debuggerContext);
        if (context == null) {
            return null;
        }
        if (this.myDescriptor instanceof LocalVariableDescriptor) {
            return AndroidResolveHelper.getAnnotationForLocal(context, this.myDescriptor.getName());
        }
        if (this.myDescriptor instanceof FieldDescriptor) {
            String className = ((FieldDescriptor)this.myDescriptor).getField().declaringType().name();
            return AndroidResolveHelper.getAnnotationForField(context, className, this.myDescriptor.getName());
        }
        return null;
    }

    public void evaluationResult(String message) {
        if (this.myResult == null) {
            return;
        }
        this.myDescriptor.setValueLabel(this.myResult.label);
        if (this.myResult.icon != null) {
            this.myDescriptor.setValueIcon(this.myResult.icon);
        }
        this.myListener.labelChanged();
    }

    public void evaluationError(String message) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "evaluationContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "value";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "listener";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/debug/ResolveTypedIntegerCommand";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

