/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.crash;

import com.android.tools.analytics.crash.CrashReport;
import com.android.tools.idea.diagnostics.crash.BaseStudioReport;
import com.android.tools.idea.diagnostics.crash.exception.NoPiiException;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import java.util.Arrays;
import java.util.Map;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class StudioExceptionReport
extends BaseStudioReport {
    private static final ImmutableSet<Class<? extends Throwable>> THROWABLE_CLASSES_TO_TRACK_MESSAGES = ImmutableSet.of(ArrayIndexOutOfBoundsException.class, ClassCastException.class, ClassNotFoundException.class, IndexOutOfBoundsException.class, NoPiiException.class);
    static final String KEY_EXCEPTION_INFO = "exception_info";
    private final String exceptionInfo;

    private StudioExceptionReport(String version2, String exceptionInfo, Map<String, String> productData) {
        super(version2, productData, "Exception");
        this.exceptionInfo = exceptionInfo;
    }

    @Override
    protected void serializeTo(MultipartEntityBuilder builder) {
        super.serializeTo(builder);
        builder.addTextBody(KEY_EXCEPTION_INFO, this.exceptionInfo);
        if (this.isKotlinOnStack()) {
            builder.addTextBody("kotlinVersion", this.getKotlinPluginVersionDescription());
        }
    }

    private boolean isKotlinOnStack() {
        return this.exceptionInfo.contains("\tat org.jetbrains.kotlin");
    }

    protected String getKotlinPluginVersionDescription() {
        try {
            IdeaPluginDescriptor[] pluginDescriptors = PluginManagerCore.getPlugins();
            return Arrays.stream(pluginDescriptors).filter(d -> d.getPluginId() != null && d.getPluginId().getIdString().equals("org.jetbrains.kotlin") && d.isEnabled()).findFirst().map(d -> d.getVersion()).orElse("pluginNotLoaded");
        }
        catch (Exception ignored) {
            return "exceptionWhenReadingVersion";
        }
    }

    public static Throwable getRootCause(Throwable t) {
        int depth = 0;
        while (depth++ < 20) {
            if (t.getCause() == null) {
                return t;
            }
            t = t.getCause();
        }
        return t;
    }

    public static String getDescription(Throwable t) {
        if (THROWABLE_CLASSES_TO_TRACK_MESSAGES.contains(t.getClass())) {
            return Throwables.getStackTraceAsString((Throwable)t);
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append(t.getClass().getName());
        sb.append(": <elided>\n");
        for (StackTraceElement el : t.getStackTrace()) {
            sb.append("\tat ");
            sb.append(el);
            sb.append('\n');
        }
        return sb.toString();
    }

    public static class Builder
    extends CrashReport.BaseBuilder<StudioExceptionReport, Builder> {
        private String exceptionInfo;

        protected Builder getThis() {
            return this;
        }

        public Builder setThrowable(Throwable throwable) {
            this.exceptionInfo = StudioExceptionReport.getDescription(StudioExceptionReport.getRootCause(throwable));
            return this;
        }

        public StudioExceptionReport build() {
            return new StudioExceptionReport(this.getVersion(), this.exceptionInfo, this.getProductData());
        }
    }
}

