/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.crash;

import com.android.tools.analytics.crash.CrashReport;
import com.android.tools.idea.diagnostics.crash.BaseStudioReport;
import com.google.common.base.Charsets;
import com.intellij.diagnostic.ThreadDumper;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class StudioPerformanceWatcherReport
extends BaseStudioReport {
    private static final String EMPTY_ANR_STACKTRACE = "com.android.ApplicationNotResponding: \n\tat " + StudioPerformanceWatcherReport.class.getName() + ".missingEdtStack(Unknown source)";
    private final String fileName;
    private final String threadDump;

    private StudioPerformanceWatcherReport(String version2, String fileName, String threadDump, Map<String, String> productData) {
        super(version2, productData, "Performance");
        this.fileName = fileName;
        this.threadDump = threadDump;
    }

    @Override
    protected void serializeTo(MultipartEntityBuilder builder) {
        super.serializeTo(builder);
        String edtStack = ThreadDumper.getEdtStackForCrash((String)this.threadDump);
        builder.addTextBody("exception_info", edtStack != null ? edtStack : EMPTY_ANR_STACKTRACE);
        builder.addTextBody(this.fileName, this.threadDump, ContentType.create((String)"text/plain", (Charset)Charsets.UTF_8));
    }

    public static final class Builder
    extends CrashReport.BaseBuilder<StudioPerformanceWatcherReport, Builder> {
        private String fileName;
        private String threadDump;

        protected Builder getThis() {
            return this;
        }

        public Builder setFile(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder setThreadDump(String threadDump) {
            this.threadDump = threadDump;
            return this;
        }

        public StudioPerformanceWatcherReport build() {
            return new StudioPerformanceWatcherReport(this.getVersion(), this.fileName, this.threadDump, this.getProductData());
        }
    }
}

