/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.error;

import com.android.tools.idea.diagnostics.crash.StudioCrashReport;
import com.android.tools.idea.diagnostics.crash.StudioCrashReporter;
import com.android.tools.idea.diagnostics.crash.StudioExceptionReport;
import com.android.tools.idea.diagnostics.crash.StudioPerformanceWatcherReport;
import com.android.tools.idea.diagnostics.error.ErrorReportCustomizer;
import com.android.tools.idea.diagnostics.error.SubmitCrashReportTask;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.ITNReporterKt;
import com.intellij.diagnostic.ReportMessages;
import com.intellij.errorreport.bean.ErrorBean;
import com.intellij.ide.DataManager;
import com.intellij.idea.IdeaLogger;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.android.diagnostics.error.IdeaITNProxy;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class ErrorReporter
extends ErrorReportSubmitter {
    private static final String FEEDBACK_TASK_TITLE = "Submitting error report";

    @NotNull
    public String getReportActionText() {
        String string = AndroidBundle.message("error.report.to.google.action", new Object[0]);
        if (string == null) {
            ErrorReporter.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean submit(@NotNull IdeaLoggingEvent[] events, String description, Component parentComponent, @NotNull Consumer<SubmittedReportInfo> callback) {
        if (events == null) {
            ErrorReporter.$$$reportNull$$$0(1);
        }
        if (callback == null) {
            ErrorReporter.$$$reportNull$$$0(2);
        }
        IdeaLoggingEvent event = events[0];
        ErrorBean bean = new ErrorBean(event.getThrowable(), IdeaLogger.ourLastActionId);
        bean.setDescription(description);
        bean.setMessage(event.getMessage());
        ITNReporterKt.setPluginInfo((IdeaLoggingEvent)event, (ErrorBean)bean);
        Object data = event.getData();
        if (ErrorReporter.handleAnalyticsReports(event.getThrowable(), data)) {
            return true;
        }
        if (data instanceof AbstractMessage) {
            bean.setAttachments(((AbstractMessage)data).getIncludedAttachments());
        }
        Consumer submitter = dataContext -> {
            Task.Backgroundable feedbackTask;
            if (callback == null) {
                ErrorReporter.$$$reportNull$$$0(5);
            }
            if (dataContext == null) {
                return;
            }
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            Consumer successCallback = token -> {
                if (callback == null) {
                    ErrorReporter.$$$reportNull$$$0(6);
                }
                SubmittedReportInfo reportInfo = new SubmittedReportInfo(null, "Issue " + token, SubmittedReportInfo.SubmissionStatus.NEW_ISSUE);
                callback.consume((Object)reportInfo);
                ReportMessages.GROUP.createNotification(ReportMessages.ERROR_REPORT, "Submitted", NotificationType.INFORMATION, null).setImportant(false).notify(project);
            };
            Consumer errorCallback = e -> {
                String message = AndroidBundle.message("error.report.at.b.android", e.getMessage());
                ReportMessages.GROUP.createNotification(ReportMessages.ERROR_REPORT, message, NotificationType.ERROR, NotificationListener.URL_OPENING_LISTENER).setImportant(false).notify(project);
            };
            if (data instanceof ErrorReportCustomizer) {
                feedbackTask = ((ErrorReportCustomizer)data).makeReportingTask(project, FEEDBACK_TASK_TITLE, true, bean, (Consumer<String>)successCallback, (Consumer<Exception>)errorCallback);
            } else {
                List<Pair<String, String>> kv = IdeaITNProxy.getKeyValuePairs(null, null, bean, IdeaLogger.getOurCompilationTimestamp(), ApplicationManager.getApplication(), (ApplicationInfoEx)ApplicationInfo.getInstance(), ApplicationNamesInfo.getInstance(), UpdateSettings.getInstance());
                feedbackTask = new SubmitCrashReportTask(project, FEEDBACK_TASK_TITLE, true, event.getThrowable(), ErrorReporter.pair2map(kv), (Consumer<String>)successCallback, (Consumer<Exception>)errorCallback);
            }
            if (project == null) {
                feedbackTask.run((ProgressIndicator)new EmptyProgressIndicator());
            } else {
                ProgressManager.getInstance().run((Task)feedbackTask);
            }
        };
        if (parentComponent != null) {
            submitter.consume((Object)DataManager.getInstance().getDataContext(parentComponent));
        } else {
            DataManager.getInstance().getDataContextFromFocus().doWhenDone(submitter);
        }
        return true;
    }

    private static boolean handleAnalyticsReports(Throwable t, Object data) {
        if (!(data instanceof Map)) {
            return false;
        }
        Map map2 = (Map)data;
        String type = (String)map2.get("Type");
        if ("Exception".equals(type)) {
            ImmutableMap productData = ImmutableMap.of((Object)"md5", (Object)((String)map2.get("md5")), (Object)"summary", (Object)((String)map2.get("summary")));
            StudioExceptionReport exceptionReport = ((StudioExceptionReport.Builder)new StudioExceptionReport.Builder().setThrowable(t).addProductData((Map)productData)).build();
            StudioCrashReporter.getInstance().submit(exceptionReport);
        } else if ("ANR".equals(type)) {
            StudioPerformanceWatcherReport perfReport = new StudioPerformanceWatcherReport.Builder().setFile((String)map2.get("file")).setThreadDump((String)map2.get("threadDump")).build();
            StudioCrashReporter.getInstance().submit(perfReport, true);
        } else if ("Crashes".equals(type)) {
            List crashDetails = (List)map2.get("crashDetails");
            List<String> descriptions = crashDetails.stream().map(details -> details.getDescription()).collect(Collectors.toList());
            boolean isJvmCrash = crashDetails.stream().anyMatch(details -> details.isJvmCrash());
            long uptimeInMs = crashDetails.stream().mapToLong(details -> details.getUptimeInMs()).min().orElse(-1L);
            StudioCrashReport report = new StudioCrashReport.Builder().setDescriptions(descriptions).setIsJvmCrash(isJvmCrash).setUptimeInMs(uptimeInMs).build();
            StudioCrashReporter.getInstance().submit(report, true);
        }
        return true;
    }

    @NotNull
    private static Map<String, String> pair2map(@NotNull List<Pair<String, String>> kv) {
        if (kv == null) {
            ErrorReporter.$$$reportNull$$$0(3);
        }
        HashMap m = Maps.newHashMapWithExpectedSize((int)kv.size());
        for (Pair<String, String> i : kv) {
            m.put(i.getFirst(), i.getSecond());
        }
        HashMap hashMap = m;
        if (hashMap == null) {
            ErrorReporter.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/diagnostics/error/ErrorReporter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kv";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReportActionText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/diagnostics/error/ErrorReporter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "pair2map";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "submit";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "pair2map";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$submit$2";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

