/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.fonts;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeInsight.template.emmet.generators.LoremGenerator;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.FontFormatException;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FontEditor
implements FileEditor {
    private static final Logger LOG = Logger.getInstance(FontEditor.class);
    private static final String NAME = "Font";
    private static final float MAX_FONT_SIZE = UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.NORMAL) + JBUI.scale((float)30.0f);
    private static final float MIN_FONT_SIZE = UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.MINI);
    private static final Border BORDER = JBUI.Borders.empty((int)50);
    private final UserDataHolderBase myUserDataHolder;
    private final JTextArea myTextArea;
    private final VirtualFile myFile;
    private final JPanel myRootPanel;
    private float myCurrentFontSize;

    public FontEditor(@NotNull VirtualFile file) {
        if (file == null) {
            FontEditor.$$$reportNull$$$0(0);
        }
        this.myUserDataHolder = new UserDataHolderBase();
        this.myFile = file;
        this.myRootPanel = new JPanel(new BorderLayout());
        this.myTextArea = new JTextArea("Center");
        this.myTextArea.setLineWrap(true);
        this.myTextArea.setWrapStyleWord(true);
        this.myTextArea.setBorder(BORDER);
        this.myCurrentFontSize = UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.NORMAL) + JBUI.scale((float)15.0f);
        try {
            Font font = Font.createFont(0, file.getInputStream()).deriveFont(this.myCurrentFontSize);
            this.myTextArea.setFont(font);
            this.myTextArea.setText(font.getFontName() + "\n\n" + new LoremGenerator().generate(50, true));
            this.myTextArea.addMouseWheelListener(e -> {
                float increment = e.getWheelRotation() < 0 ? -1.0f : 1.0f;
                float newFontSize = Math.min(Math.max(MIN_FONT_SIZE, this.myCurrentFontSize + increment), MAX_FONT_SIZE);
                if (newFontSize != this.myCurrentFontSize) {
                    this.myCurrentFontSize = newFontSize;
                    Font newFont = this.myTextArea.getFont().deriveFont(this.myCurrentFontSize);
                    this.myTextArea.setFont(newFont);
                }
            });
        }
        catch (FontFormatException | IOException e2) {
            String message = "Unable to open font " + file.getName();
            this.myTextArea.setFont(UIUtil.getLabelFont());
            this.myTextArea.setEditable(false);
            this.myTextArea.setText(message);
            LOG.warn(message, (Throwable)e2);
        }
        this.myRootPanel.add(this.myTextArea);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            FontEditor.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTextArea;
    }

    @NotNull
    public String getName() {
        if (NAME == null) {
            FontEditor.$$$reportNull$$$0(2);
        }
        return NAME;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            FontEditor.$$$reportNull$$$0(3);
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            FontEditor.$$$reportNull$$$0(4);
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            FontEditor.$$$reportNull$$$0(5);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return this.myFile.isValid();
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            FontEditor.$$$reportNull$$$0(6);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            FontEditor.$$$reportNull$$$0(7);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            FontEditor.$$$reportNull$$$0(8);
        }
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            FontEditor.$$$reportNull$$$0(9);
        }
        this.myUserDataHolder.putUserData(key, value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/fonts/FontEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/fonts/FontEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

