/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof;

import com.android.tools.idea.concurrent.EdtExecutor;
import com.android.tools.idea.editors.hprof.HprofView;
import com.android.tools.idea.editors.hprof.views.HprofAnalysisContentsDelegate;
import com.android.tools.idea.profiling.view.CaptureEditor;
import com.android.tools.idea.profiling.view.CapturePanel;
import com.android.tools.perflib.analyzer.AnalysisReport;
import com.android.tools.perflib.analyzer.AnalyzerTask;
import com.android.tools.perflib.analyzer.Capture;
import com.android.tools.perflib.analyzer.CaptureGroup;
import com.android.tools.perflib.captures.DataBuffer;
import com.android.tools.perflib.captures.MemoryMappedFileBuffer;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.analysis.ComputationProgress;
import com.android.tools.perflib.heap.memoryanalyzer.DuplicatedStringsAnalyzerTask;
import com.android.tools.perflib.heap.memoryanalyzer.LeakedActivityAnalyzerTask;
import com.android.tools.perflib.heap.memoryanalyzer.MemoryAnalyzer;
import com.google.common.base.Throwables;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.status.InlineProgressIndicator;
import com.intellij.util.ui.UIUtil;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HprofEditor
extends CaptureEditor {
    @NotNull
    private static final Logger LOG = Logger.getInstance(HprofEditor.class);
    @Nullable
    private HprofView myView;
    @Nullable
    private Snapshot mySnapshot;
    private boolean myIsValid;

    public HprofEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            HprofEditor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            HprofEditor.$$$reportNull$$$0(1);
        }
        this.myIsValid = true;
        AnalyzerTask[] tasks = new AnalyzerTask[]{new LeakedActivityAnalyzerTask(), new DuplicatedStringsAnalyzerTask()};
        this.myPanel = new CapturePanel(project, this, tasks, true);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Snapshot snapshot;
            if (file == null) {
                HprofEditor.$$$reportNull$$$0(21);
            }
            if (project == null) {
                HprofEditor.$$$reportNull$$$0(22);
            }
            File hprofFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
            InlineProgressIndicator indicator = this.myPanel.getProgressIndicator();
            assert (indicator != null);
            try {
                HprofEditor.updateIndicator(indicator, 0.01, "Parsing hprof file...");
                snapshot = Snapshot.createSnapshot((DataBuffer)new MemoryMappedFileBuffer(hprofFile));
            }
            catch (Throwable t) {
                this.showErrorWhileProcessingFile(project, indicator, t);
                return;
            }
            Timer timer2 = new Timer(33, actionEvent -> {
                Snapshot.DominatorComputationStage stage = snapshot.getDominatorComputationStage();
                ComputationProgress progress = snapshot.getComputationProgress();
                HprofEditor.updateIndicator(indicator, Snapshot.DominatorComputationStage.toAbsoluteProgressPercentage((Snapshot.DominatorComputationStage)stage, (ComputationProgress)progress), progress.getMessage());
            });
            timer2.start();
            try {
                snapshot.computeDominators();
            }
            catch (Throwable t) {
                this.showErrorWhileProcessingFile(project, indicator, t);
                return;
            }
            finally {
                timer2.stop();
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (project == null) {
                    HprofEditor.$$$reportNull$$$0(23);
                }
                if (!this.isValid()) {
                    snapshot.dispose();
                } else {
                    this.mySnapshot = snapshot;
                    this.myView = new HprofView(project, this, snapshot);
                    HprofAnalysisContentsDelegate delegate = new HprofAnalysisContentsDelegate(this);
                    this.myPanel.setEditorPanel(this.myView.getComponent(), delegate);
                    Disposer.register((Disposable)this, (Disposable)this.myView);
                    Disposer.register((Disposable)this, (Disposable)delegate);
                }
            });
        });
    }

    @Nullable
    public HprofView getView() {
        return this.myView;
    }

    @NotNull
    public JComponent getComponent() {
        CapturePanel capturePanel = this.myPanel;
        if (capturePanel == null) {
            HprofEditor.$$$reportNull$$$0(2);
        }
        return capturePanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        if ("HprofView" == null) {
            HprofEditor.$$$reportNull$$$0(3);
        }
        return "HprofView";
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            HprofEditor.$$$reportNull$$$0(4);
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            HprofEditor.$$$reportNull$$$0(5);
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            HprofEditor.$$$reportNull$$$0(6);
        }
    }

    public boolean isModified() {
        return false;
    }

    public void setInvalid() {
        this.myIsValid = false;
    }

    public boolean isValid() {
        return this.myIsValid;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            HprofEditor.$$$reportNull$$$0(7);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            HprofEditor.$$$reportNull$$$0(8);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        this.myIsValid = false;
        if (this.mySnapshot != null) {
            this.mySnapshot.dispose();
        }
        this.mySnapshot = null;
        this.myPanel = null;
    }

    @Override
    @NotNull
    public DesignerEditorPanelFacade getFacade() {
        CapturePanel capturePanel = this.myPanel;
        if (capturePanel == null) {
            HprofEditor.$$$reportNull$$$0(9);
        }
        return capturePanel;
    }

    @Override
    @NotNull
    public AnalysisReport performAnalysis(@NotNull Set<? extends AnalyzerTask> tasks, @NotNull Set<AnalysisReport.Listener> listeners) {
        if (tasks == null) {
            HprofEditor.$$$reportNull$$$0(10);
        }
        if (listeners == null) {
            HprofEditor.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        CaptureGroup captureGroup = new CaptureGroup();
        assert (this.mySnapshot != null);
        captureGroup.addCapture((Capture)this.mySnapshot);
        MemoryAnalyzer memoryAnalyzer = new MemoryAnalyzer();
        assert (memoryAnalyzer.accept(captureGroup));
        AnalysisReport analysisReport = memoryAnalyzer.analyze(captureGroup, listeners, tasks, (Executor)EdtExecutor.INSTANCE, Executors.newSingleThreadExecutor());
        if (analysisReport == null) {
            HprofEditor.$$$reportNull$$$0(12);
        }
        return analysisReport;
    }

    /*
     * WARNING - void declaration
     */
    private static void updateIndicator(@NotNull InlineProgressIndicator indicator, double fraction, @NotNull String string) {
        void text;
        if (indicator == null) {
            HprofEditor.$$$reportNull$$$0(13);
        }
        if (string == null) {
            HprofEditor.$$$reportNull$$$0(14);
        }
        UIUtil.invokeLaterIfNeeded(() -> HprofEditor.lambda$updateIndicator$3(indicator, fraction, (String)text));
    }

    private void showErrorWhileProcessingFile(@NotNull Project project, @NotNull InlineProgressIndicator indicator, @NotNull Throwable t) {
        if (project == null) {
            HprofEditor.$$$reportNull$$$0(15);
        }
        if (indicator == null) {
            HprofEditor.$$$reportNull$$$0(16);
        }
        if (t == null) {
            HprofEditor.$$$reportNull$$$0(17);
        }
        LOG.info(t);
        String errorMessage = "Unexpected error while processing hprof file: " + Throwables.getRootCause((Throwable)t).getMessage();
        indicator.cancel();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project == null) {
                HprofEditor.$$$reportNull$$$0(18);
            }
            Messages.showErrorDialog((Project)project, (String)errorMessage, (String)this.getName());
        });
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$updateIndicator$3(@NotNull InlineProgressIndicator indicator, double fraction, @NotNull String string) {
        void text;
        if (indicator == null) {
            HprofEditor.$$$reportNull$$$0(19);
        }
        if (string == null) {
            HprofEditor.$$$reportNull$$$0(20);
        }
        indicator.setFraction(fraction);
        indicator.setText((String)text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/hprof/HprofEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/hprof/HprofEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacade";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "performAnalysis";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "performAnalysis";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateIndicator";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showErrorWhileProcessingFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showErrorWhileProcessingFile$4";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateIndicator$3";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$2";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

