/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof.descriptors;

import com.android.tools.idea.editors.hprof.descriptors.HprofFieldDescriptorImpl;
import com.android.tools.idea.editors.hprof.jdi.ArrayReferenceImpl;
import com.android.tools.idea.editors.hprof.jdi.ClassObjectReferenceImpl;
import com.android.tools.idea.editors.hprof.jdi.ObjectReferenceImpl;
import com.android.tools.idea.editors.hprof.jdi.StringReferenceImpl;
import com.android.tools.perflib.heap.ArrayInstance;
import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Instance;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstanceFieldDescriptorImpl
extends HprofFieldDescriptorImpl {
    private static final int MAX_VALUE_TEXT_LENGTH = 1024;
    @NotNull
    private ObjectReferenceImpl myObjectReference;
    @Nullable
    private String myTruncatedValueText;

    public InstanceFieldDescriptorImpl(@NotNull Project project, @NotNull Field field2, @Nullable Instance instance, int memoryOrdering) {
        if (project == null) {
            InstanceFieldDescriptorImpl.$$$reportNull$$$0(0);
        }
        if (field2 == null) {
            InstanceFieldDescriptorImpl.$$$reportNull$$$0(1);
        }
        super(project, field2, instance, memoryOrdering);
        this.myObjectReference = this.initObjectReference();
    }

    @Nullable
    public Instance getInstance() {
        return (Instance)this.myValueData;
    }

    public boolean isString() {
        return this.myValueData != null && this.myValueData instanceof ClassInstance && ((ClassInstance)this.myValueData).isStringInstance();
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isExpandable() {
        if (this.myValueData instanceof ClassObj) {
            return false;
        }
        if (this.myValueData instanceof ArrayInstance) {
            return ((ArrayInstance)this.myValueData).getSize() > 0;
        }
        return !this.isNull();
    }

    @Override
    public Value getValue() {
        return this.calcValue(null);
    }

    @NotNull
    public String getIdLabel() {
        Instance instance = this.getInstance();
        if (instance == null) {
            if ("" == null) {
                InstanceFieldDescriptorImpl.$$$reportNull$$$0(2);
            }
            return "";
        }
        String string = String.format("%s (0x%x)", ValueDescriptorImpl.getIdLabel((ObjectReference)this.myObjectReference), instance.getUniqueId());
        if (string == null) {
            InstanceFieldDescriptorImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getValueText() {
        if (this.myTruncatedValueText != null) {
            String string = this.myTruncatedValueText;
            if (string == null) {
                InstanceFieldDescriptorImpl.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (this.myValueData == null) {
            this.myTruncatedValueText = "null";
        } else if (this.myValueData instanceof ClassObj) {
            this.myTruncatedValueText = String.format(" \"class %s\"", ((ClassObj)this.myValueData).getClassName());
        } else if (this.isString()) {
            String text = ((ClassInstance)this.myValueData).getAsString(1024);
            if (text != null) {
                int textLength = text.length();
                StringBuilder builder = new StringBuilder(6 + textLength);
                builder.append(" \"");
                if (textLength == 1024) {
                    builder.append(text, 0, textLength - 1).append("...");
                } else {
                    builder.append(text);
                }
                builder.append("\"");
                this.myTruncatedValueText = builder.toString();
            } else {
                this.myTruncatedValueText = " ...<invalid string value>...";
            }
        } else {
            this.myTruncatedValueText = "";
        }
        String string = this.myTruncatedValueText;
        if (string == null) {
            InstanceFieldDescriptorImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContext) {
        return this.myObjectReference;
    }

    private ObjectReferenceImpl initObjectReference() {
        if (this.isString()) {
            return new StringReferenceImpl(this.myField, (Instance)this.myValueData);
        }
        if (this.myValueData instanceof ArrayInstance) {
            return new ArrayReferenceImpl(this.myField, (Instance)((ArrayInstance)this.myValueData));
        }
        if (this.myValueData instanceof ClassObj) {
            return new ClassObjectReferenceImpl(this.myField, (Instance)((ClassObj)this.myValueData));
        }
        return new ObjectReferenceImpl(this.myField, (Instance)this.myValueData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/hprof/descriptors/InstanceFieldDescriptorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/hprof/descriptors/InstanceFieldDescriptorImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdLabel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

