/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layoutInspector.ui;

import com.android.layoutinspector.model.DisplayInfo;
import com.android.layoutinspector.model.ViewNode;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.ui.MaterialColors;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.intellij.ui.DoubleClickListener;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JComponent;
import org.intellij.images.options.GridOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewNodeActiveDisplay
extends JComponent {
    private static final double SHOW_GRID_LEVEL = 3.0;
    static final float DEFAULT_OVERLAY_ALPHA = 0.5f;
    private static final Color DEFAULT_COLOR = Color.GRAY;
    private static final Color HOVER_COLOR = MaterialColors.DEEP_ORANGE_900;
    private static final Color SELECTED_COLOR = MaterialColors.LIGHT_BLUE_800;
    private static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private static final Stroke THICK_STROKE = new BasicStroke(2.0f);
    @NotNull
    private ViewNode mRoot;
    @Nullable
    private Image mPreview;
    private final List<ViewNodeActiveDisplayListener> mListeners;
    private float mZoomFactor;
    private int mLastWidth;
    private int mLastHeight;
    private int mDrawShiftX;
    private int mDrawShiftY;
    @Nullable
    private ViewNode mHoverNode;
    @Nullable
    private ViewNode mSelectedNode;
    private boolean mGridVisible;
    @Nullable
    private Image mOverlay;
    private float mOverlayAlpha;
    @Nullable
    private String myOverlayFileName;
    private boolean updateBounds;

    public ViewNodeActiveDisplay(@NotNull ViewNode root, @Nullable Image preview) {
        if (root == null) {
            ViewNodeActiveDisplay.$$$reportNull$$$0(0);
        }
        this.mListeners = Lists.newArrayList();
        this.mZoomFactor = 1.0f;
        this.mGridVisible = false;
        this.mOverlayAlpha = 0.5f;
        this.updateBounds = false;
        this.mRoot = root;
        this.mPreview = preview;
        MyMouseAdapter adapter = new MyMouseAdapter();
        this.addMouseListener(adapter);
        this.addMouseMotionListener(adapter);
        if (((Boolean)StudioFlags.LAYOUT_INSPECTOR_SUB_VIEW_ENABLED.get()).booleanValue()) {
            this.addDoubleClickListener();
        }
    }

    private void addDoubleClickListener() {
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                ViewNode clicked = ViewNodeActiveDisplay.this.getNode(event);
                if (clicked == null) {
                    return false;
                }
                for (ViewNodeActiveDisplayListener listener2 : ViewNodeActiveDisplay.this.mListeners) {
                    listener2.onNodeDoubleClicked(clicked);
                }
                return true;
            }
        }.installOn((Component)this);
    }

    public void addViewNodeActiveDisplayListener(ViewNodeActiveDisplayListener listener2) {
        this.mListeners.add(listener2);
    }

    public void removeViewNodeActiveDisplayListener(ViewNodeActiveDisplayListener listener2) {
        this.mListeners.remove(listener2);
    }

    public void setHoverNode(@Nullable ViewNode node) {
        if (!Objects.equal((Object)node, (Object)this.mHoverNode)) {
            this.mHoverNode = node;
            this.repaint();
            for (ViewNodeActiveDisplayListener listener2 : this.mListeners) {
                listener2.onViewNodeOver(this.mHoverNode);
            }
        }
    }

    public void setSelectedNode(@NotNull ViewNode node) {
        if (node == null) {
            ViewNodeActiveDisplay.$$$reportNull$$$0(1);
        }
        if (!Objects.equal((Object)node, (Object)this.mSelectedNode)) {
            this.mSelectedNode = node;
            this.repaint();
            for (ViewNodeActiveDisplayListener listener2 : this.mListeners) {
                listener2.onNodeSelected(this.mSelectedNode);
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.mLastWidth != this.getWidth() || this.mLastHeight != this.getHeight() || this.updateBounds) {
            float rootHeight = this.mRoot.getDisplayInfo().getHeight();
            float rootWidth = this.mRoot.getDisplayInfo().getWidth();
            if (this.mLastHeight == 0 && this.mLastWidth == 0) {
                this.mZoomFactor = this.calcDrawScale(rootWidth, rootHeight);
            }
            this.mLastHeight = this.getHeight();
            this.mLastWidth = this.getWidth();
            this.mDrawShiftX = (int)((float)this.getWidth() - this.mZoomFactor * rootWidth) / 2;
            this.mDrawShiftY = (int)((float)this.getHeight() - this.mZoomFactor * rootHeight) / 2;
            this.calculateNodeBounds(this.mRoot, 0.0f, 0.0f, 1.0f, 1.0f, this.mZoomFactor);
            this.updateBounds = false;
        }
        this.paintPreview((Graphics2D)g);
    }

    private float calcDrawScale(float rootWidth, float rootHeight) {
        float width = this.getWidth() - 20;
        float height = this.getHeight() - 20;
        return Math.min(width / rootWidth, height / rootHeight);
    }

    public float getZoomFactor() {
        return this.mZoomFactor;
    }

    @Nullable
    public Image getPreview() {
        return this.mPreview;
    }

    private void calculateNodeBounds(@NotNull ViewNode node, float leftShift, float topshift, float scaleX, float scaleY, float drawScale) {
        if (node == null) {
            ViewNodeActiveDisplay.$$$reportNull$$$0(2);
        }
        DisplayInfo info = node.getDisplayInfo();
        float newScaleX = scaleX * info.getScaleX();
        float newScaleY = scaleY * info.getScaleY();
        float l = leftShift + ((float)info.getLeft() + info.getTranslateX()) * scaleX + (float)info.getWidth() * (scaleX - newScaleX) / 2.0f;
        float t = topshift + ((float)info.getTop() + info.getTranslateX()) * scaleY + (float)info.getHeight() * (scaleY - newScaleY) / 2.0f;
        node.getPreviewBox().setBounds((int)(l * drawScale), (int)(t * drawScale), (int)((float)info.getWidth() * newScaleX * drawScale), (int)((float)info.getHeight() * newScaleY * drawScale));
        if (!node.isLeaf()) {
            float shiftX = l - info.getScaleX();
            float shiftY = t - info.getScaleY();
            for (ViewNode child : node.getChildren()) {
                this.calculateNodeBounds(child, shiftX, shiftY, newScaleX, newScaleY, drawScale);
            }
        }
    }

    private void paintPreview(Graphics2D g) {
        g.translate(this.mDrawShiftX, this.mDrawShiftY);
        if (this.mPreview != null) {
            RenderingHints oldHints = g.getRenderingHints();
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            if (Float.compare(this.mZoomFactor, 1.0f) < 0) {
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            g.drawImage(this.mPreview, 0, 0, this.mRoot.getPreviewBox().width, this.mRoot.getPreviewBox().height, 0, 0, this.mPreview.getWidth(null), this.mPreview.getHeight(null), null);
            if (this.isGridVisible() && (double)this.mZoomFactor >= 3.0) {
                this.paintGrid(g, this.mPreview);
            }
            this.drawOverlay(g);
            g.setRenderingHints(oldHints);
        }
        g.clipRect(0, 0, this.mRoot.getPreviewBox().width, this.mRoot.getPreviewBox().height);
        g.setColor(DEFAULT_COLOR);
        g.setStroke(DEFAULT_STROKE);
        this.paintNode(this.mRoot, g);
        g.setStroke(THICK_STROKE);
        if (this.mHoverNode != null && this.mSelectedNode != this.mHoverNode) {
            g.setColor(HOVER_COLOR);
            this.paintBox(this.mHoverNode.getPreviewBox(), g);
        }
        if (this.mSelectedNode != null) {
            g.setColor(SELECTED_COLOR);
            this.paintBox(this.mSelectedNode.getPreviewBox(), g);
        }
    }

    private void drawOverlay(Graphics2D g) {
        if (this.mOverlay == null) {
            return;
        }
        Composite oldComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, this.mOverlayAlpha));
        g.drawImage(this.mOverlay, 0, 0, this.mRoot.getPreviewBox().width, this.mRoot.getPreviewBox().height, 0, 0, this.mOverlay.getWidth(null), this.mOverlay.getHeight(null), null);
        g.setComposite(oldComposite);
    }

    private void paintNode(ViewNode node, Graphics2D g) {
        if (node != this.mHoverNode && node != this.mSelectedNode) {
            this.paintBox(node.getPreviewBox(), g);
        }
        if (!node.isLeaf()) {
            for (ViewNode child : node.getChildren()) {
                if (!child.isDrawn()) continue;
                this.paintNode(child, g);
            }
        }
    }

    private void paintBox(Rectangle box, Graphics2D g) {
        g.drawRect(box.x, box.y, box.width, box.height);
    }

    @Nullable
    private ViewNode getNode(MouseEvent e) {
        int x = e.getX() - this.mDrawShiftX;
        int y = e.getY() - this.mDrawShiftY;
        if (!this.mRoot.getPreviewBox().contains(x, y)) {
            return null;
        }
        return this.updateSelection(this.mRoot, x, y, new ViewNode[1], 0, 0, this.mRoot.getPreviewBox().width, this.mRoot.getPreviewBox().height);
    }

    @Nullable
    private ViewNode updateSelection(@NotNull ViewNode node, int x, int y, @NotNull ViewNode[] firstNoDrawChild, int clipX1, int clipY1, int clipX2, int clipY2) {
        if (node == null) {
            ViewNodeActiveDisplay.$$$reportNull$$$0(3);
        }
        if (firstNoDrawChild == null) {
            ViewNodeActiveDisplay.$$$reportNull$$$0(4);
        }
        if (!node.isDrawn()) {
            return null;
        }
        boolean wasFirstNoDrawChildNull = firstNoDrawChild[0] == null;
        Rectangle boxpos = node.getPreviewBox();
        int boxRight = boxpos.x + boxpos.width;
        int boxBottom = boxpos.y + boxpos.height;
        int newClipX1 = clipX1;
        int newClipY1 = clipY1;
        int newClipX2 = clipX2;
        int newClipY2 = clipY2;
        if (node.getDisplayInfo().getClipChildren()) {
            newClipX1 = Math.max(clipX1, boxpos.x);
            newClipY1 = Math.max(clipY1, boxpos.y);
            newClipX2 = Math.min(clipX2, boxRight);
            newClipY2 = Math.min(clipY2, boxBottom);
        }
        if (newClipX1 < x && newClipX2 > x && newClipY1 < y && newClipY2 > y) {
            for (int i = node.getChildren().size() - 1; i >= 0; --i) {
                ViewNode child = node.getChildAt(i);
                ViewNode ret = this.updateSelection(child, x, y, firstNoDrawChild, newClipX1, newClipY1, newClipX2, newClipY2);
                if (ret == null) continue;
                return ret;
            }
        }
        if (boxpos.x < x && boxRight > x && boxpos.y < y && boxBottom > y) {
            if (node.getDisplayInfo().getWillNotDraw()) {
                if (firstNoDrawChild[0] == null) {
                    firstNoDrawChild[0] = node;
                }
                return null;
            }
            if (wasFirstNoDrawChildNull && firstNoDrawChild[0] != null) {
                return firstNoDrawChild[0];
            }
            return node;
        }
        return null;
    }

    public void setZoomFactor(float zoomFactor) {
        this.mZoomFactor = zoomFactor;
        float rootHeight = this.mRoot.getDisplayInfo().getHeight();
        float rootWidth = this.mRoot.getDisplayInfo().getWidth();
        this.setPreferredSize(new Dimension((int)(rootWidth * this.mZoomFactor), (int)(rootHeight * this.mZoomFactor)));
        this.revalidate();
    }

    public void setGridVisible(boolean gridVisible) {
        this.mGridVisible = gridVisible;
        this.repaint();
    }

    public boolean isGridVisible() {
        return this.mGridVisible;
    }

    private void paintGrid(@NotNull Graphics g, @NotNull Image image) {
        int lineSpan;
        if (g == null) {
            ViewNodeActiveDisplay.$$$reportNull$$$0(5);
        }
        if (image == null) {
            ViewNodeActiveDisplay.$$$reportNull$$$0(6);
        }
        Dimension size = this.getSize();
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        double zoomX = (double)size.width / (double)imageWidth;
        double zoomY = (double)size.height / (double)imageHeight;
        g.setColor(GridOptions.DEFAULT_LINE_COLOR);
        for (int dx = lineSpan = 1; dx < imageWidth; dx += lineSpan) {
            UIUtil.drawLine((Graphics)g, (int)((int)((double)dx * zoomX)), (int)0, (int)((int)((double)dx * zoomX)), (int)size.height);
        }
        for (int dy = lineSpan; dy < imageHeight; dy += lineSpan) {
            UIUtil.drawLine((Graphics)g, (int)0, (int)((int)((double)dy * zoomY)), (int)size.width, (int)((int)((double)dy * zoomY)));
        }
    }

    public void setOverLay(@Nullable Image overlay, @Nullable String fileName) {
        this.mOverlay = overlay;
        this.myOverlayFileName = fileName;
        this.mOverlayAlpha = 0.5f;
        this.repaint();
    }

    public boolean hasOverlay() {
        return this.mOverlay != null;
    }

    @Nullable
    public String getOverlayFileName() {
        return this.myOverlayFileName;
    }

    public float getOverlayAlpha() {
        return this.mOverlayAlpha;
    }

    public void setOverlayAlpha(float mOverlayAlpha) {
        this.mOverlayAlpha = mOverlayAlpha;
        this.repaint();
    }

    public void setPreview(@NotNull BufferedImage preview, ViewNode root) {
        if (preview == null) {
            ViewNodeActiveDisplay.$$$reportNull$$$0(7);
        }
        this.mPreview = preview;
        this.mRoot = root;
        this.updateBounds = true;
        this.repaint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstNoDrawChild";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preview";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/editors/layoutInspector/ui/ViewNodeActiveDisplay";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelectedNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateNodeBounds";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "updateSelection";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "paintGrid";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setPreview";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ViewNodeActiveDisplayListener {
        public void onViewNodeOver(@Nullable ViewNode var1);

        public void onNodeSelected(@NotNull ViewNode var1);

        public void onNodeDoubleClicked(@NotNull ViewNode var1);
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private MyMouseAdapter() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ViewNodeActiveDisplay.this.setHoverNode(ViewNodeActiveDisplay.this.getNode(e));
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            ViewNodeActiveDisplay.this.setHoverNode(ViewNodeActiveDisplay.this.getNode(e));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ViewNodeActiveDisplay.this.setHoverNode(null);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ViewNode clicked = ViewNodeActiveDisplay.this.getNode(e);
            if (clicked != null) {
                ViewNodeActiveDisplay.this.setSelectedNode(clicked);
            }
        }
    }
}

