/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layoutInspector.ui;

import com.android.layoutinspector.model.ViewNode;
import com.android.tools.adtui.font.FontUtil;
import com.android.tools.idea.AndroidTextUtils;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import java.awt.Font;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewNodeTreeRenderer
extends ColoredTreeCellRenderer {
    private static final Icon DEFAULT_VIEW_ICON = AndroidDomElementDescriptorProvider.getIconForViewTag("View");
    private static final String EMPTY_ID = "NO_ID";
    private String myHighlight;

    public void customizeCellRenderer(@NotNull JTree tree, Object nodeValue, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            ViewNodeTreeRenderer.$$$reportNull$$$0(0);
        }
        if (!(nodeValue instanceof ViewNode)) {
            return;
        }
        StringBuilder cellTextBuilder = new StringBuilder();
        ViewNode node = (ViewNode)nodeValue;
        SimpleTextAttributes attr2 = node.isDrawn() ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
        String id = ViewNodeTreeRenderer.getId(node);
        String elementName = ViewNodeTreeRenderer.getName(node);
        if (id != null) {
            cellTextBuilder.append(id + " (" + elementName + ") ");
        } else {
            cellTextBuilder.append(elementName + " ");
        }
        this.setIcon(ViewNodeTreeRenderer.findIconForNode(elementName));
        this.displayText(attr2, cellTextBuilder.toString());
        if (node.getDisplayInfo().getContentDesc() != null) {
            Font currentFont = this.getFont();
            Font f = FontUtil.getFontAbleToDisplay((String)node.getDisplayInfo().getContentDesc(), (Font)currentFont);
            if (f != currentFont) {
                this.setFont(f);
            }
            this.displayText(node.isDrawn() ? new SimpleTextAttributes(0, Color.GRAY) : attr2, "- \"" + node.getDisplayInfo().getContentDesc() + "\"");
        }
    }

    @Nullable
    public static String getId(@NotNull ViewNode node) {
        String id;
        if (node == null) {
            ViewNodeTreeRenderer.$$$reportNull$$$0(1);
        }
        if ((id = node.getId()) == null || id.equals(EMPTY_ID)) {
            return null;
        }
        return id;
    }

    @NotNull
    public static String getName(@NotNull ViewNode node) {
        if (node == null) {
            ViewNodeTreeRenderer.$$$reportNull$$$0(2);
        }
        String[] name = node.getName().split("\\.");
        String string = name[name.length - 1];
        if (string == null) {
            ViewNodeTreeRenderer.$$$reportNull$$$0(3);
        }
        return string;
    }

    private void displayText(SimpleTextAttributes attr2, String cellText) {
        if (this.myHighlight == null || this.myHighlight.isEmpty()) {
            this.append(cellText, attr2);
        } else {
            List outputs = AndroidTextUtils.splitKeepDelimiter((String)cellText, (String)this.myHighlight);
            SimpleTextAttributes highlightAttr = SimpleTextAttributes.SYNTHETIC_ATTRIBUTES;
            for (String s : outputs) {
                if (s.equals(this.myHighlight)) {
                    this.append(s, highlightAttr);
                    continue;
                }
                this.append(s, attr2);
            }
        }
    }

    @Nullable
    private static Icon findIconForNode(@NotNull String elementName) {
        if (elementName == null) {
            ViewNodeTreeRenderer.$$$reportNull$$$0(4);
        }
        Icon icon = null;
        String[] words = elementName.split("(?=\\p{Upper})");
        for (int index = 0; icon == null && index < words.length; ++index) {
            StringBuilder builder = new StringBuilder();
            for (int i = index; i < words.length; ++i) {
                builder.append(words[i]);
            }
            icon = AndroidDomElementDescriptorProvider.getIconForViewTag(builder.toString());
        }
        return icon != null ? icon : DEFAULT_VIEW_ICON;
    }

    public void setHighlight(@Nullable String highlight) {
        this.myHighlight = highlight;
    }

    @Nullable
    public String getHighlight() {
        return this.myHighlight;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/layoutInspector/ui/ViewNodeTreeRenderer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/layoutInspector/ui/ViewNodeTreeRenderer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "customizeCellRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getId";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findIconForNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

