/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.table.FrozenColumnTable;
import com.android.tools.idea.editors.strings.table.LocaleRenderer;
import com.android.tools.idea.editors.strings.table.StringResourceTableColumnFilter;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.editors.strings.table.StringResourceTableRowFilter;
import com.android.tools.idea.editors.strings.table.StringTableCellEditor;
import com.android.tools.idea.editors.strings.table.StringsCellRenderer;
import com.android.tools.idea.rendering.Locale;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import javax.swing.DefaultRowSorter;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringResourceTable
extends FrozenColumnTable {
    private final TableCellRenderer myLocaleRenderer;
    @Nullable
    private StringResourceTableColumnFilter myColumnFilter;
    private boolean myColumnPreferredWidthsSet;

    public StringResourceTable() {
        super(new StringResourceTableModel(), 2);
        this.setDefaultEditor(String.class, new StringTableCellEditor());
        this.setDefaultRenderer(String.class, (TableCellRenderer)((Object)new StringsCellRenderer()));
        this.setRowSorter(new ThreeStateTableRowSorter<StringResourceTableModel>(this.getModel()));
        this.putInInputMap(KeyStroke.getKeyStroke(8, 0), "delete");
        this.putInInputMap(KeyStroke.getKeyStroke(127, 0), "delete");
        this.myLocaleRenderer = new LocaleRenderer(this.getDefaultTableHeaderRenderer());
    }

    @Nullable
    public StringResourceData getData() {
        return this.getModel().getData();
    }

    @Nullable
    public StringResourceTableRowFilter getRowFilter() {
        return (StringResourceTableRowFilter)((DefaultRowSorter)this.getRowSorter()).getRowFilter();
    }

    public void setRowFilter(@Nullable StringResourceTableRowFilter filter2) {
        ((DefaultRowSorter)this.getRowSorter()).setRowFilter(filter2);
    }

    @Nullable
    public StringResourceTableColumnFilter getColumnFilter() {
        return this.myColumnFilter;
    }

    public void setColumnFilter(@Nullable StringResourceTableColumnFilter filter2) {
        this.myColumnFilter = filter2;
        this.createDefaultColumnsFromModel();
    }

    @Override
    boolean includeColumn(int modelColumnIndex) {
        if (modelColumnIndex < 4) {
            return true;
        }
        if (this.myColumnFilter == null) {
            return true;
        }
        Locale locale = this.getModel().getLocale(modelColumnIndex);
        assert (locale != null);
        return this.myColumnFilter.include(locale);
    }

    @Override
    @NotNull
    TableColumn createColumn(int modelColumnIndex) {
        TableColumn column = new TableColumn(modelColumnIndex);
        if (modelColumnIndex >= 4) {
            column.setHeaderRenderer(this.myLocaleRenderer);
        }
        TableColumn tableColumn = column;
        if (tableColumn == null) {
            StringResourceTable.$$$reportNull$$$0(0);
        }
        return tableColumn;
    }

    @NotNull
    public TableRowSorter<StringResourceTableModel> getRowSorter() {
        TableRowSorter tableRowSorter = (TableRowSorter)super.getRowSorter();
        if (tableRowSorter == null) {
            StringResourceTable.$$$reportNull$$$0(1);
        }
        return tableRowSorter;
    }

    @Override
    @NotNull
    public StringResourceTableModel getModel() {
        StringResourceTableModel stringResourceTableModel = (StringResourceTableModel)super.getModel();
        if (stringResourceTableModel == null) {
            StringResourceTable.$$$reportNull$$$0(2);
        }
        return stringResourceTableModel;
    }

    @Override
    public void setModel(@NotNull TableModel model) {
        if (model == null) {
            StringResourceTable.$$$reportNull$$$0(3);
        }
        super.setModel(model);
        ((TableRowSorter)this.getRowSorter()).setModel((StringResourceTableModel)model);
        if (this.myColumnPreferredWidthsSet) {
            return;
        }
        OptionalInt optionalWidth = this.getKeyColumnPreferredWidth();
        if (optionalWidth.isPresent()) {
            this.getColumn(0).setPreferredWidth(optionalWidth.getAsInt());
        }
        if ((optionalWidth = this.getDefaultValueAndLocaleColumnPreferredWidths()).isPresent()) {
            int width = optionalWidth.getAsInt();
            IntStream.range(this.convertColumnIndexToView(3), this.getColumnCount()).mapToObj(this::getColumn).forEach(column -> column.setPreferredWidth(width));
        }
        this.myColumnPreferredWidthsSet = true;
    }

    @NotNull
    public OptionalInt getKeyColumnPreferredWidth() {
        OptionalInt optionalInt = IntStream.range(0, this.getModel().getRowCount()).map(this::getPreferredKeyWidth).max();
        if (optionalInt == null) {
            StringResourceTable.$$$reportNull$$$0(4);
        }
        return optionalInt;
    }

    private int getPreferredKeyWidth(int modelRowIndex) {
        TableCellRenderer renderer = this.getCellRendererUsingModelIndices(modelRowIndex, 0);
        Object key = this.getModel().getValueAt(modelRowIndex, 0);
        int viewRowIndex = this.convertRowIndexToView(modelRowIndex);
        int viewColumnIndex = this.convertColumnIndexToView(0);
        return this.getPreferredWidth(renderer, key, viewRowIndex, viewColumnIndex);
    }

    @NotNull
    public OptionalInt getDefaultValueAndLocaleColumnPreferredWidths() {
        OptionalInt optionalInt = IntStream.range(this.convertColumnIndexToView(3), this.getColumnCount()).map(column -> this.getPreferredWidth(this.getHeaderRenderer(column), this.getColumnName(column), -1, column)).max();
        if (optionalInt == null) {
            StringResourceTable.$$$reportNull$$$0(5);
        }
        return optionalInt;
    }

    @NotNull
    private TableCellRenderer getHeaderRenderer(int column) {
        TableCellRenderer renderer = this.getColumn(column).getHeaderRenderer();
        TableCellRenderer tableCellRenderer = renderer == null ? this.getDefaultTableHeaderRenderer() : renderer;
        if (tableCellRenderer == null) {
            StringResourceTable.$$$reportNull$$$0(6);
        }
        return tableCellRenderer;
    }

    @Override
    boolean isPastePossible() {
        if (this.getSelectedRowCount() != 1 || this.getSelectedColumnCount() != 1) {
            return false;
        }
        int column = this.getSelectedColumn();
        return column != 0 && column != 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/strings/table/StringResourceTable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createColumn";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowSorter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/strings/table/StringResourceTable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyColumnPreferredWidth";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValueAndLocaleColumnPreferredWidths";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ThreeStateTableRowSorter<M extends TableModel>
    extends TableRowSorter<M> {
        public ThreeStateTableRowSorter(M model) {
            super(model);
        }

        @Override
        public void toggleSortOrder(int column) {
            List<RowSorter.SortKey> sortKeys = this.getSortKeys();
            if (!sortKeys.isEmpty() && sortKeys.get(0).getSortOrder() == SortOrder.DESCENDING) {
                this.setSortKeys(null);
                return;
            }
            super.toggleSortOrder(column);
        }

        @Override
        public void modelStructureChanged() {
            List<RowSorter.SortKey> sortKeys = this.getSortKeys();
            super.modelStructureChanged();
            this.setSortKeys(sortKeys);
        }
    }
}

