/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.adtui.TableUtils;
import com.android.tools.idea.editors.strings.table.FrozenColumnTable;
import com.android.tools.idea.editors.strings.table.FrozenColumnTableEvent;
import com.android.tools.idea.editors.strings.table.SubTableModel;
import com.google.common.collect.Maps;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.table.JBTable;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SubTable
extends JBTable
implements DataProvider,
PasteProvider {
    private final FrozenColumnTable myFrozenColumnTable;

    SubTable(@NotNull SubTableModel model, @NotNull FrozenColumnTable frozenColumnTable) {
        if (model == null) {
            SubTable.$$$reportNull$$$0(0);
        }
        if (frozenColumnTable == null) {
            SubTable.$$$reportNull$$$0(1);
        }
        super((TableModel)model);
        this.getSelectionModel().setSelectionMode(0);
        this.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.setAutoResizeMode(0);
        this.setCellSelectionEnabled(true);
        this.addMouseListener(new CellPopupTriggerListener(this));
        new TableSpeedSearch((JTable)((Object)this));
        this.myFrozenColumnTable = frozenColumnTable;
    }

    void setSelectedRow(int selectedViewRowIndex) {
        if (this.getSelectedRow() == selectedViewRowIndex) {
            return;
        }
        if (selectedViewRowIndex == -1) {
            this.getSelectionModel().clearSelection();
            return;
        }
        this.setRowSelectionInterval(selectedViewRowIndex, selectedViewRowIndex);
    }

    @NotNull
    int[] getSelectedModelRowIndices() {
        int[] nArray = Arrays.stream(this.getSelectedRows()).map(arg_0 -> this.convertRowIndexToModel(arg_0)).toArray();
        if (nArray == null) {
            SubTable.$$$reportNull$$$0(2);
        }
        return nArray;
    }

    @NotNull
    int[] getSelectedModelColumnIndices() {
        SubTableModel model = (SubTableModel)this.getModel();
        int[] nArray = Arrays.stream(this.getSelectedColumns()).map(arg_0 -> this.convertColumnIndexToModel(arg_0)).map(model::convertColumnIndexToDelegate).toArray();
        if (nArray == null) {
            SubTable.$$$reportNull$$$0(3);
        }
        return nArray;
    }

    @NotNull
    protected JTableHeader createDefaultTableHeader() {
        JBTable.JBTableHeader header = new JBTable.JBTableHeader((JBTable)this);
        header.setReorderingAllowed(false);
        header.addMouseListener(new HeaderPopupTriggerListener(this));
        JBTable.JBTableHeader jBTableHeader = header;
        if (jBTableHeader == null) {
            SubTable.$$$reportNull$$$0(4);
        }
        return jBTableHeader;
    }

    public int getRowHeight() {
        int frozenColumnTableRowHeight;
        int subTableRowHeight = super.getRowHeight();
        if (subTableRowHeight > (frozenColumnTableRowHeight = this.myFrozenColumnTable.getRowHeight())) {
            this.myFrozenColumnTable.setRowHeight(subTableRowHeight);
            return subTableRowHeight;
        }
        return frozenColumnTableRowHeight;
    }

    public void createDefaultColumnsFromModel() {
        if (this.myFrozenColumnTable == null) {
            return;
        }
        this.addColumns(this.removeAllColumns());
    }

    private void addColumns(@NotNull Map<Integer, TableColumn> map2) {
        if (map2 == null) {
            SubTable.$$$reportNull$$$0(5);
        }
        SubTableModel model = (SubTableModel)this.getModel();
        IntStream.range(0, this.dataModel.getColumnCount()).map(model::convertColumnIndexToDelegate).filter(this.myFrozenColumnTable::includeColumn).map(model::convertColumnIndexToModel).mapToObj(modelColumnIndex -> {
            if (map2 == null) {
                SubTable.$$$reportNull$$$0(14);
            }
            return this.getOrCreateColumn(map2, modelColumnIndex, model);
        }).forEach(arg_0 -> this.addColumn(arg_0));
    }

    @NotNull
    private TableColumn getOrCreateColumn(@NotNull Map<Integer, TableColumn> map2, int modelColumnIndex, @NotNull SubTableModel model) {
        TableColumn column;
        if (map2 == null) {
            SubTable.$$$reportNull$$$0(6);
        }
        if (model == null) {
            SubTable.$$$reportNull$$$0(7);
        }
        if ((column = map2.get(modelColumnIndex)) == null) {
            column = this.myFrozenColumnTable.createColumn(model.convertColumnIndexToDelegate(modelColumnIndex));
            column.setModelIndex(modelColumnIndex);
        }
        TableColumn tableColumn = column;
        if (tableColumn == null) {
            SubTable.$$$reportNull$$$0(8);
        }
        return tableColumn;
    }

    @NotNull
    private Map<Integer, TableColumn> removeAllColumns() {
        HashMap map2 = Maps.newHashMapWithExpectedSize((int)this.columnModel.getColumnCount());
        while (this.columnModel.getColumnCount() != 0) {
            TableColumn column = this.columnModel.getColumn(0);
            this.removeColumn(column);
            map2.put(column.getModelIndex(), column);
        }
        HashMap hashMap = map2;
        if (hashMap == null) {
            SubTable.$$$reportNull$$$0(9);
        }
        return hashMap;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            SubTable.$$$reportNull$$$0(10);
        }
        return dataId.equals(PlatformDataKeys.PASTE_PROVIDER.getName()) ? this : null;
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            SubTable.$$$reportNull$$$0(11);
        }
        return this.myFrozenColumnTable.isPastePossible();
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            SubTable.$$$reportNull$$$0(12);
        }
        return this.myFrozenColumnTable.isPastePossible();
    }

    public void performPaste(@NotNull DataContext dataContext) {
        Transferable transferable;
        if (dataContext == null) {
            SubTable.$$$reportNull$$$0(13);
        }
        if ((transferable = CopyPasteManager.getInstance().getContents()) != null) {
            TableUtils.paste((JTable)((Object)this), (Transferable)transferable);
        }
    }

    public String toString() {
        return this.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frozenColumnTable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/strings/table/SubTable";
                break;
            }
            case 5: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/strings/table/SubTable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedModelRowIndices";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedModelColumnIndices";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultTableHeader";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateColumn";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "removeAllColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addColumns";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateColumn";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isPastePossible";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isPasteEnabled";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "performPaste";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addColumns$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class HeaderPopupTriggerListener
    extends MouseAdapter {
        private final SubTable mySubTable;

        private HeaderPopupTriggerListener(@NotNull SubTable subTable) {
            if (subTable == null) {
                HeaderPopupTriggerListener.$$$reportNull$$$0(0);
            }
            this.mySubTable = subTable;
        }

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            if (event == null) {
                HeaderPopupTriggerListener.$$$reportNull$$$0(1);
            }
            this.mousePressedOrReleased(event);
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent event) {
            if (event == null) {
                HeaderPopupTriggerListener.$$$reportNull$$$0(2);
            }
            this.mousePressedOrReleased(event);
        }

        private void mousePressedOrReleased(@NotNull MouseEvent event) {
            if (event == null) {
                HeaderPopupTriggerListener.$$$reportNull$$$0(3);
            }
            if (!event.isPopupTrigger()) {
                return;
            }
            JTableHeader header = (JTableHeader)event.getSource();
            int viewColumnIndex = header.columnAtPoint(event.getPoint());
            if (viewColumnIndex == -1) {
                return;
            }
            FrozenColumnTable source = this.mySubTable.myFrozenColumnTable;
            FrozenColumnTableEvent frozenColumnTableEvent = new FrozenColumnTableEvent(source, -1, ((SubTableModel)this.mySubTable.getModel()).convertColumnIndexToDelegate(this.mySubTable.convertColumnIndexToModel(viewColumnIndex)), event.getPoint(), header);
            source.getListeners().forEach(listener2 -> listener2.headerPopupTriggered(frozenColumnTableEvent));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "subTable";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/editors/strings/table/SubTable$HeaderPopupTriggerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mousePressed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseReleased";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mousePressedOrReleased";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class CellPopupTriggerListener
    extends MouseAdapter {
        private final SubTable mySubTable;

        private CellPopupTriggerListener(@NotNull SubTable subTable) {
            if (subTable == null) {
                CellPopupTriggerListener.$$$reportNull$$$0(0);
            }
            this.mySubTable = subTable;
        }

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            if (event == null) {
                CellPopupTriggerListener.$$$reportNull$$$0(1);
            }
            this.mousePressedOrReleased(event);
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent event) {
            if (event == null) {
                CellPopupTriggerListener.$$$reportNull$$$0(2);
            }
            this.mousePressedOrReleased(event);
        }

        private void mousePressedOrReleased(@NotNull MouseEvent event) {
            if (event == null) {
                CellPopupTriggerListener.$$$reportNull$$$0(3);
            }
            if (!event.isPopupTrigger()) {
                return;
            }
            FrozenColumnTable source = this.mySubTable.myFrozenColumnTable;
            Point point = event.getPoint();
            int viewRowIndex = this.mySubTable.rowAtPoint(point);
            int viewColumnIndex = this.mySubTable.columnAtPoint(point);
            FrozenColumnTableEvent frozenColumnTableEvent = new FrozenColumnTableEvent(source, this.mySubTable.convertRowIndexToModel(viewRowIndex), ((SubTableModel)this.mySubTable.getModel()).convertColumnIndexToDelegate(this.mySubTable.convertColumnIndexToModel(viewColumnIndex)), point, (Component)((Object)this.mySubTable));
            source.getListeners().forEach(listener2 -> listener2.cellPopupTriggered(frozenColumnTableEvent));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "subTable";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/editors/strings/table/SubTable$CellPopupTriggerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mousePressed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseReleased";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mousePressedOrReleased";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

