/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredElement;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.android.tools.idea.editors.theme.qualifiers.RestrictedConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeAttributeResolver {
    private static final Logger LOG = Logger.getInstance(ThemeAttributeResolver.class);
    private final ConfigurationManager myManager;
    private final ConfiguredThemeEditorStyle myStyle;
    private final MultiMap<String, ConfiguredElement<StyleItemResourceValue>> myItemValueMap = new MultiMap();

    private ThemeAttributeResolver(ConfiguredThemeEditorStyle style, ConfigurationManager manager) {
        this.myStyle = style;
        this.myManager = manager;
    }

    @Nullable
    private static RestrictedConfiguration getRestrictedConfiguration(@NotNull ThemeEditorStyle theme, @NotNull FolderConfiguration compatible) {
        if (theme == null) {
            ThemeAttributeResolver.$$$reportNull$$$0(0);
        }
        if (compatible == null) {
            ThemeAttributeResolver.$$$reportNull$$$0(1);
        }
        ArrayList<FolderConfiguration> incompatibles = new ArrayList<FolderConfiguration>();
        for (FolderConfiguration folder : theme.getFolders()) {
            if (compatible.equals((Object)folder)) continue;
            incompatibles.add(folder);
        }
        return RestrictedConfiguration.restrict(compatible, incompatibles);
    }

    private void resolveFromInheritance(@NotNull ThemeEditorStyle themeEditorStyle, @NotNull FolderConfiguration configuration, @NotNull RestrictedConfiguration restricted, @NotNull Set<String> seenAttributes) {
        RestrictedConfiguration styleRestricted;
        if (themeEditorStyle == null) {
            ThemeAttributeResolver.$$$reportNull$$$0(2);
        }
        if (configuration == null) {
            ThemeAttributeResolver.$$$reportNull$$$0(3);
        }
        if (restricted == null) {
            ThemeAttributeResolver.$$$reportNull$$$0(4);
        }
        if (seenAttributes == null) {
            ThemeAttributeResolver.$$$reportNull$$$0(5);
        }
        if ((styleRestricted = ThemeAttributeResolver.getRestrictedConfiguration(themeEditorStyle, configuration)) == null) {
            LOG.warn(configuration + " is unreachable");
            return;
        }
        if ((styleRestricted = restricted.intersect(styleRestricted)) == null) {
            return;
        }
        HashSet<String> newSeenAttributes = new HashSet<String>(seenAttributes);
        for (StyleItemResourceValue item : themeEditorStyle.getValues(configuration)) {
            String itemName = ResolutionUtils.getQualifiedItemAttrName(item);
            if (newSeenAttributes.contains(itemName)) continue;
            this.myItemValueMap.putValue((Object)itemName, ConfiguredElement.create(styleRestricted.getAny(), item));
            newSeenAttributes.add(itemName);
        }
        String parentName = themeEditorStyle.getParentName(configuration);
        if (parentName == null) {
            return;
        }
        ThemeEditorStyle parent = new ThemeEditorStyle(this.myManager, parentName);
        for (FolderConfiguration folder : parent.getFolders()) {
            this.resolveFromInheritance(parent, folder, styleRestricted, newSeenAttributes);
        }
    }

    @NotNull
    private List<EditedStyleItem> resolveAll() {
        ThemeEditorStyle theme = new ThemeEditorStyle(this.myManager, this.myStyle.getQualifiedName());
        for (FolderConfiguration folder : theme.getFolders()) {
            this.resolveFromInheritance(this.myStyle, folder, new RestrictedConfiguration(), new HashSet<String>());
        }
        ArrayList<EditedStyleItem> result2 = new ArrayList<EditedStyleItem>();
        FolderConfiguration configuration = this.myStyle.getConfiguration().getFullConfig();
        for (String key : this.myItemValueMap.keySet()) {
            Collection itemValues = this.myItemValueMap.get((Object)key);
            ConfiguredElement selectedValue = (ConfiguredElement)configuration.findMatchingConfigurable(new ArrayList(itemValues));
            if (selectedValue == null) {
                result2.add(new EditedStyleItem((ConfiguredElement)itemValues.iterator().next(), itemValues, this.myStyle));
                continue;
            }
            itemValues.remove(selectedValue);
            assert (!itemValues.contains(selectedValue));
            result2.add(new EditedStyleItem(selectedValue, itemValues, this.myStyle));
        }
        ArrayList<EditedStyleItem> arrayList = result2;
        if (arrayList == null) {
            ThemeAttributeResolver.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public static List<EditedStyleItem> resolveAll(ConfiguredThemeEditorStyle style, ConfigurationManager manager) {
        return new ThemeAttributeResolver(style, manager).resolveAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "theme";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compatible";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "themeEditorStyle";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restricted";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seenAttributes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/ThemeAttributeResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/ThemeAttributeResolver";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRestrictedConfiguration";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveFromInheritance";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

