/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.TypedCellRendererEditor;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.intellij.openapi.ui.ComboBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JTable;
import org.jetbrains.android.dom.attrs.AttributeDefinition;

public class EnumRendererEditor
extends TypedCellRendererEditor<EditedStyleItem, String> {
    private final ComboBox myComboBox = new ComboBox(){

        public boolean isShowing() {
            return true;
        }
    };

    public EnumRendererEditor() {
        this.myComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnumRendererEditor.this.stopCellEditing();
            }
        });
    }

    @Override
    public Component getRendererComponent(JTable table2, EditedStyleItem value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component component;
        if (column == 0) {
            component = table2.getDefaultRenderer(String.class).getTableCellRendererComponent(table2, ThemeEditorUtils.getDisplayHtml(value), isSelected, hasFocus, row, column);
        } else {
            String itemValue = value.getValue();
            this.myComboBox.removeAllItems();
            this.myComboBox.addItem((Object)itemValue);
            this.myComboBox.setSelectedItem((Object)itemValue);
            component = this.myComboBox;
        }
        return component;
    }

    @Override
    public Component getEditorComponent(JTable table2, EditedStyleItem value, boolean isSelected, int row, int column) {
        AttributeDefinition attrDefinition = ResolutionUtils.getAttributeDefinition(value.getSourceStyle().getConfiguration(), value.getSelectedValue());
        if (attrDefinition != null) {
            if (attrDefinition.getFormats().size() > 1) {
                this.myComboBox.setEditable(true);
            } else {
                this.myComboBox.setEditable(false);
            }
            this.myComboBox.setModel(new DefaultComboBoxModel<String>(attrDefinition.getValues()));
        }
        this.myComboBox.setSelectedItem((Object)value.getValue());
        return this.myComboBox;
    }

    @Override
    public String getEditorValue() {
        return (String)this.myComboBox.getSelectedItem();
    }
}

