/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.qualifiers;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.ResourceEnum;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredElement;
import com.android.tools.idea.editors.theme.qualifiers.QualifierUtils;
import com.android.tools.idea.editors.theme.qualifiers.RestrictedEnum;
import com.android.tools.idea.editors.theme.qualifiers.RestrictedLocale;
import com.android.tools.idea.editors.theme.qualifiers.RestrictedQualifier;
import com.android.tools.idea.editors.theme.qualifiers.RestrictedValue;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestrictedConfiguration {
    private final RestrictedQualifier[] myRestrictedQualifiers = new RestrictedQualifier[FolderConfiguration.getQualifierCount()];
    private final Class<? extends ResourceQualifier>[] myQualifiersClasses = new Class[FolderConfiguration.getQualifierCount()];

    public RestrictedConfiguration() {
        FolderConfiguration configuration = FolderConfiguration.createDefault();
        for (int i = 0; i < FolderConfiguration.getQualifierCount(); ++i) {
            ResourceQualifier qualifier = configuration.getQualifier(i);
            assert (qualifier != null);
            this.myQualifiersClasses[i] = qualifier.getClass();
            if (this.myQualifiersClasses[i].equals(LocaleQualifier.class)) {
                this.myRestrictedQualifiers[i] = new RestrictedLocale();
                continue;
            }
            if (this.myQualifiersClasses[i].equals(VersionQualifier.class)) {
                this.myRestrictedQualifiers[i] = new RestrictedValue();
                continue;
            }
            Class getValueType = QualifierUtils.getValueReturnType(this.myQualifiersClasses[i]);
            if (getValueType == null) continue;
            if (getValueType.equals(Integer.TYPE)) {
                this.myRestrictedQualifiers[i] = new RestrictedValue();
                continue;
            }
            assert (Arrays.asList(getValueType.getInterfaces()).contains(ResourceEnum.class));
            this.myRestrictedQualifiers[i] = new RestrictedEnum(getValueType);
        }
    }

    @Nullable
    public RestrictedConfiguration intersect(@NotNull RestrictedConfiguration otherRestricted) {
        if (otherRestricted == null) {
            RestrictedConfiguration.$$$reportNull$$$0(0);
        }
        RestrictedConfiguration resultRestricted = new RestrictedConfiguration();
        for (int i = 0; i < FolderConfiguration.getQualifierCount(); ++i) {
            RestrictedQualifier thisQualifier = this.myRestrictedQualifiers[i];
            RestrictedQualifier otherQualifier = otherRestricted.myRestrictedQualifiers[i];
            if (thisQualifier == null) {
                assert (otherQualifier == null);
                continue;
            }
            RestrictedQualifier intersection = thisQualifier.intersect(otherQualifier);
            if (intersection == null) {
                return null;
            }
            resultRestricted.myRestrictedQualifiers[i] = intersection;
        }
        return resultRestricted;
    }

    @NotNull
    public FolderConfiguration getAny() {
        FolderConfiguration configuration = new FolderConfiguration();
        for (int i = 0; i < FolderConfiguration.getQualifierCount(); ++i) {
            Object value;
            if (this.myRestrictedQualifiers[i] == null || (value = this.myRestrictedQualifiers[i].getAny()) == null) continue;
            configuration.addQualifier(QualifierUtils.createNewResourceQualifier(this.myQualifiersClasses[i], value));
        }
        FolderConfiguration folderConfiguration = configuration;
        if (folderConfiguration == null) {
            RestrictedConfiguration.$$$reportNull$$$0(1);
        }
        return folderConfiguration;
    }

    @Nullable
    public static RestrictedConfiguration restrict(@NotNull FolderConfiguration compatible, @NotNull Collection<FolderConfiguration> incompatibles) {
        if (compatible == null) {
            RestrictedConfiguration.$$$reportNull$$$0(2);
        }
        if (incompatibles == null) {
            RestrictedConfiguration.$$$reportNull$$$0(3);
        }
        RestrictedConfiguration restricted = new RestrictedConfiguration();
        if (incompatibles.isEmpty()) {
            return restricted;
        }
        ArrayList matchingIncompatibles = Lists.newArrayList(incompatibles);
        for (int qualifierIndex = 0; qualifierIndex < FolderConfiguration.getQualifierCount(); ++qualifierIndex) {
            ResourceQualifier compatibleQualifier = compatible.getQualifier(qualifierIndex);
            RestrictedQualifier restrictedQualifier = restricted.myRestrictedQualifiers[qualifierIndex];
            ArrayList incompatibleQualifiers = Lists.newArrayList();
            for (FolderConfiguration matching : matchingIncompatibles) {
                ResourceQualifier qualifier = matching.getQualifier(qualifierIndex);
                if (!ResourceQualifier.isValid((ResourceQualifier)qualifier)) continue;
                incompatibleQualifiers.add(qualifier);
            }
            if (!ResourceQualifier.isValid((ResourceQualifier)compatibleQualifier) && incompatibleQualifiers.isEmpty()) continue;
            assert (restrictedQualifier != null);
            restrictedQualifier.setRestrictions(compatibleQualifier, incompatibleQualifiers);
            if (restrictedQualifier.isEmpty()) {
                return null;
            }
            Iterator matchingIterator = matchingIncompatibles.iterator();
            while (matchingIterator.hasNext()) {
                ResourceQualifier incompatibleQualifier = ((FolderConfiguration)matchingIterator.next()).getQualifier(qualifierIndex);
                if (compatibleQualifier != null && !restrictedQualifier.isMatchFor(incompatibleQualifier)) {
                    matchingIterator.remove();
                    continue;
                }
                if (compatibleQualifier != null || incompatibleQualifier == null) continue;
                matchingIterator.remove();
            }
            if (!matchingIncompatibles.isEmpty()) continue;
            return restricted;
        }
        return null;
    }

    @Nullable
    public static <T> FolderConfiguration restrict(@NotNull ConfiguredElement<T> compatible, Collection<ConfiguredElement<T>> allItems) {
        if (compatible == null) {
            RestrictedConfiguration.$$$reportNull$$$0(4);
        }
        ArrayList incompatibleConfigurations = Lists.newArrayListWithCapacity((int)allItems.size());
        boolean found = false;
        for (ConfiguredElement<T> configuredItem : allItems) {
            FolderConfiguration configuration = configuredItem.getConfiguration();
            if (configuredItem.equals(compatible)) {
                found = true;
                continue;
            }
            incompatibleConfigurations.add(configuration);
        }
        assert (found);
        RestrictedConfiguration restricted = RestrictedConfiguration.restrict(compatible.getConfiguration(), incompatibleConfigurations);
        return restricted != null ? restricted.getAny() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherRestricted";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/qualifiers/RestrictedConfiguration";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compatible";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incompatibles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/qualifiers/RestrictedConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAny";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "intersect";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "restrict";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

