/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.vmtrace.treemodel;

import com.android.tools.idea.editors.vmtrace.treemodel.StatsTableColumn;
import com.android.tools.idea.editors.vmtrace.treemodel.VmStatsTreeTableModel;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class VmStatsTreeUtils {
    public static void adjustTableColumnWidths(TreeTable table2) {
        TableColumnModel columnModel = table2.getColumnModel();
        FontMetrics fm = table2.getFontMetrics(table2.getFont());
        for (int i = 0; i < table2.getColumnCount(); ++i) {
            TableColumn column = columnModel.getColumn(i);
            column.setPreferredWidth(fm.stringWidth(VmStatsTreeUtils.getSampleTextForColumn(i)));
        }
    }

    private static String getSampleTextForColumn(int index) {
        return StatsTableColumn.fromColumnIndex(index).getSampleText();
    }

    public static void setCellRenderers(TreeTable table2) {
        TableHeaderCellRenderer headerRenderer = new TableHeaderCellRenderer(table2);
        for (StatsTableColumn c : StatsTableColumn.values()) {
            VmStatsTreeUtils.getTableColumn(table2, c).setHeaderRenderer(headerRenderer);
        }
        ProfileTimeRenderer renderer = new ProfileTimeRenderer();
        VmStatsTreeUtils.getTableColumn(table2, StatsTableColumn.INVOCATION_COUNT).setCellRenderer((TableCellRenderer)((Object)renderer));
        VmStatsTreeUtils.getTableColumn(table2, StatsTableColumn.INCLUSIVE_TIME).setCellRenderer((TableCellRenderer)((Object)renderer));
        VmStatsTreeUtils.getTableColumn(table2, StatsTableColumn.EXCLUSIVE_TIME).setCellRenderer((TableCellRenderer)((Object)renderer));
    }

    private static TableColumn getTableColumn(TreeTable table2, StatsTableColumn column) {
        return table2.getColumnModel().getColumn(column.getColumnIndex());
    }

    public static void setSpeedSearch(TreeTable treeTable) {
        new TableSpeedSearch((JTable)treeTable){

            protected boolean isMatchingElement(Object element, String pattern) {
                String text = super.getElementText(element);
                return text != null && text.contains(pattern);
            }
        };
    }

    public static void enableSorting(final TreeTable treeTable, final VmStatsTreeTableModel vmStatsTreeTableModel) {
        JTableHeader header = treeTable.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = treeTable.getColumnModel();
                int index = columnModel.getColumnIndexAtX(e.getX());
                vmStatsTreeTableModel.sortByColumn(StatsTableColumn.fromColumnIndex(index));
            }
        });
    }

    private static class TableHeaderCellRenderer
    implements TableCellRenderer {
        private final TableCellRenderer myDefaultRenderer;

        public TableHeaderCellRenderer(TreeTable table2) {
            this.myDefaultRenderer = table2.getTableHeader().getDefaultRenderer();
            if (this.myDefaultRenderer instanceof DefaultTableCellRenderer) {
                ((DefaultTableCellRenderer)this.myDefaultRenderer).setHorizontalAlignment(0);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.myDefaultRenderer.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row, column);
        }
    }

    private static class ProfileTimeRenderer
    extends ColoredTableCellRenderer {
        private static final char FIGURE_SPACE_CHAR = '\u2007';
        private final NumberFormat myNumberFormat;
        private final NumberFormat myPercentFormat = NumberFormat.getPercentInstance(Locale.getDefault());
        private boolean myFontCanDisplayFigureSpace;
        private double mySpacesPerFigureSpaceChar = -1.0;

        public ProfileTimeRenderer() {
            this.myPercentFormat.setMaximumFractionDigits(1);
            this.myPercentFormat.setMinimumFractionDigits(1);
            this.myNumberFormat = NumberFormat.getNumberInstance();
        }

        protected void customizeCellRenderer(JTable table2, Object value, boolean selected, boolean hasFocus, int row, int column) {
            this.setTextAlign(4);
            if (value instanceof Long) {
                this.append(this.myNumberFormat.format(value));
            } else if (value instanceof Pair) {
                Pair p = (Pair)value;
                this.append(this.myNumberFormat.format(p.getFirst()));
                this.append(" ");
                this.append(this.formatPercentage((Double)p.getSecond()), SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }

        private String formatPercentage(Double d) {
            String format = this.myPercentFormat.format(d);
            return format.length() < 6 ? this.prefixWithSpaces(format, 6 - format.length()) : format;
        }

        private String prefixWithSpaces(String s, int nSpaces) {
            if (this.mySpacesPerFigureSpaceChar < 0.0) {
                this.mySpacesPerFigureSpaceChar = 1.0;
                this.myFontCanDisplayFigureSpace = this.getFont().canDisplay('\u2007');
                if (!this.myFontCanDisplayFigureSpace) {
                    FontMetrics fm = this.getFontMetrics(this.getFont());
                    this.mySpacesPerFigureSpaceChar = fm.charWidth('\u2007') / fm.charWidth(' ');
                }
            }
            StringBuilder sb = new StringBuilder();
            if (this.myFontCanDisplayFigureSpace) {
                StringUtil.repeatSymbol((Appendable)sb, (char)'\u2007', (int)nSpaces);
            } else {
                StringUtil.repeatSymbol((Appendable)sb, (char)' ', (int)((int)((double)nSpaces * this.mySpacesPerFigureSpaceChar) + 1));
            }
            sb.append(s);
            return sb.toString();
        }
    }
}

