/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.experimental;

import com.android.tools.idea.experimental.CodeAnalysisMain;
import com.android.tools.idea.experimental.actions.PermissionUsageQuickFix;
import com.android.tools.idea.experimental.codeanalysis.PsiCFGScene;
import com.android.tools.idea.experimental.codeanalysis.callgraph.Callgraph;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGClass;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGMethod;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGPartialMethodSignature;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGPartialMethodSignatureBuilder;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.GraphNode;
import com.android.tools.idea.experimental.codeanalysis.datastructs.stmt.AssignStmt;
import com.android.tools.idea.experimental.codeanalysis.datastructs.stmt.Stmt;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.Value;
import com.android.tools.lint.detector.api.Category;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermissionUsageInspection
extends GlobalInspectionTool {
    private static final String LOCATION_MANAGER_CLASS_NAME = "android.location.LocationManager";
    private static final String GOOGLE_MAPS_API_CLASS = "com.google.android.maps.MyLocationOverlay";
    private static final String PROBLEM_DESC = "Permission not checked for statement :";
    private PsiCFGClass LocationManagerCFGClass;
    private PsiCFGClass GoogleMapsAPIClass;
    private List<PsiCFGMethod> targetMethodList;
    private Project mProject;
    private PsiCFGScene mScene;
    private Callgraph mCG;
    private List<PsiCFGMethod> longestMethodStack;
    private List<GraphNode> longestNodeStack;
    private List<Pair<PsiCFGMethod, PsiElement>> invocationSiteCollection;
    private Map<PsiMethod, PsiElement> taggedMethodsWithElement;
    public final String DISPLAY_NAME = "Permission Check for Location APIs";
    public final String SHORT_NAME = "PermissionUsageInspection";

    @NotNull
    public String getDisplayName() {
        if ("Permission Check for Location APIs" == null) {
            PermissionUsageInspection.$$$reportNull$$$0(0);
        }
        return "Permission Check for Location APIs";
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = AndroidBundle.message("android.lint.inspections.group.name", new Object[0]);
        if (string == null) {
            PermissionUsageInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String[] getGroupPath() {
        String[] stringArray = ArrayUtil.mergeArrays((String[])new String[]{AndroidBundle.message("android.inspections.group.name", new Object[0]), AndroidBundle.message("android.lint.inspections.subgroup.name", new Object[0]), Category.CORRECTNESS.getName()}, (String[])new String[0]);
        if (stringArray == null) {
            PermissionUsageInspection.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    @NotNull
    public String getShortName() {
        if ("PermissionUsageInspection" == null) {
            PermissionUsageInspection.$$$reportNull$$$0(3);
        }
        return "PermissionUsageInspection";
    }

    public boolean isGraphNeeded() {
        return true;
    }

    public void runInspection(@NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (scope == null) {
            PermissionUsageInspection.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            PermissionUsageInspection.$$$reportNull$$$0(5);
        }
        if (globalContext == null) {
            PermissionUsageInspection.$$$reportNull$$$0(6);
        }
        if (problemDescriptionsProcessor == null) {
            PermissionUsageInspection.$$$reportNull$$$0(7);
        }
        this.mProject = globalContext.getProject();
        CodeAnalysisMain analysisMain = CodeAnalysisMain.getInstance(this.mProject);
        analysisMain.analyze(scope);
        this.mScene = PsiCFGScene.getInstance(this.mProject);
        this.mCG = this.mScene.getCallGraph();
        this.targetMethodList = Lists.newArrayList();
        this.LocationManagerCFGClass = null;
        this.GoogleMapsAPIClass = null;
        this.invocationSiteCollection = Lists.newArrayList();
        this.taggedMethodsWithElement = Maps.newHashMap();
        this.runAnalysis();
        super.runInspection(scope, manager, globalContext, problemDescriptionsProcessor);
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        PsiModifierListOwner methodRefRAW;
        if (refEntity == null) {
            PermissionUsageInspection.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            PermissionUsageInspection.$$$reportNull$$$0(9);
        }
        if (manager == null) {
            PermissionUsageInspection.$$$reportNull$$$0(10);
        }
        if (globalContext == null) {
            PermissionUsageInspection.$$$reportNull$$$0(11);
        }
        if (refEntity instanceof RefMethod && (methodRefRAW = ((RefMethod)refEntity).getElement()) != null && methodRefRAW instanceof PsiMethod) {
            PsiMethod methodRef = (PsiMethod)methodRefRAW;
            return this.checkPsiMethod(methodRef, manager);
        }
        return null;
    }

    private CommonProblemDescriptor[] checkPsiMethod(PsiMethod method, InspectionManager manager) {
        if (!this.taggedMethodsWithElement.containsKey(method)) {
            return null;
        }
        ArrayList retList = Lists.newArrayList();
        PsiElement invocationStmt = this.taggedMethodsWithElement.get(method);
        ProblemDescriptor desc = manager.createProblemDescriptor(invocationStmt, PROBLEM_DESC, true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[]{new PermissionUsageQuickFix(invocationStmt)});
        retList.add(desc);
        return retList.toArray(CommonProblemDescriptor.EMPTY_ARRAY);
    }

    public void runAnalysis() {
        this.getTargetMethodsList();
        if (this.targetMethodList.isEmpty()) {
            return;
        }
        for (PsiCFGMethod currentTarget : this.targetMethodList) {
            this.resolveInitialCaller(currentTarget);
        }
        this.tagTheResult();
    }

    public void outputInvocationSiteInfos() {
        for (Pair<PsiCFGMethod, PsiElement> singleInvoke : this.invocationSiteCollection) {
            PsiCFGMethod currentMethod = (PsiCFGMethod)singleInvoke.getFirst();
            PsiElement currentElement = (PsiElement)singleInvoke.getSecond();
            if (currentElement == null) continue;
        }
    }

    private void resolveInitialCaller(PsiCFGMethod method) {
        HashSet calledMethods = Sets.newHashSet();
        Stack<GraphNode> nodeStack = new Stack<GraphNode>();
        Stack<PsiCFGMethod> methodStack = new Stack<PsiCFGMethod>();
        this.longestMethodStack = Lists.newArrayList();
        this.longestNodeStack = Lists.newArrayList();
        if (!this.mCG.calleeMethodToCallerMethodReturnMap.containsKey((Object)method) && !this.mCG.callerMethodToCalleeMethodMap.containsKey((Object)method)) {
            return;
        }
        this.dfsFindCallChain(nodeStack, methodStack, null, method);
        for (int i = 0; i < this.longestMethodStack.size(); ++i) {
            GraphNode currentNode = this.longestNodeStack.get(i);
            PsiCFGMethod psiCFGMethod = this.longestMethodStack.get(i);
        }
        PsiCFGMethod topMethod = this.longestMethodStack.get(this.longestMethodStack.size() - 1);
        GraphNode topNode = this.longestNodeStack.get(this.longestNodeStack.size() - 1);
        PsiElement psiRef = this.extractPsiElement(topNode);
        this.invocationSiteCollection.add((Pair<PsiCFGMethod, PsiElement>)new Pair((Object)topMethod, (Object)psiRef));
    }

    private PsiElement extractPsiElement(GraphNode node) {
        Stmt invocationStatement = node.getStatements()[0];
        if (invocationStatement instanceof AssignStmt) {
            Value rOP = ((AssignStmt)invocationStatement).getROp();
            return rOP.getPsiRef();
        }
        return null;
    }

    private void dfsFindCallChain(Stack<GraphNode> nodeStack, Stack<PsiCFGMethod> methodStack, GraphNode node, PsiCFGMethod target) {
        if (methodStack.size() > 5 || methodStack.contains(target)) {
            if (this.longestMethodStack.size() < methodStack.size()) {
                this.longestNodeStack = Lists.newArrayList(nodeStack);
                this.longestMethodStack = Lists.newArrayList(methodStack);
            }
            return;
        }
        methodStack.push(target);
        nodeStack.push(node);
        if (this.mCG.calleeMethodToCallerGraphNodeMap.containsKey((Object)target)) {
            Collection invocationSites = this.mCG.calleeMethodToCallerGraphNodeMap.get((Object)target);
            for (GraphNode nextTarget : invocationSites) {
                PsiCFGMethod targetMethod = this.mCG.getNodesParentMethod(nextTarget);
                if (targetMethod == null) continue;
                this.dfsFindCallChain(nodeStack, methodStack, nextTarget, targetMethod);
            }
        } else if (this.longestMethodStack.size() < methodStack.size()) {
            this.longestNodeStack = Lists.newArrayList(nodeStack);
            this.longestMethodStack = Lists.newArrayList(methodStack);
        }
    }

    private void getTargetMethodsListFromPsiClass(@NotNull PsiClass clazz) {
        if (clazz == null) {
            PermissionUsageInspection.$$$reportNull$$$0(12);
        }
        PsiMethod[] methodsArray = clazz.getMethods();
        methodsArray = this.removeMethodsRequireNoPermission(methodsArray);
        PsiCFGClass cfgClazz = this.mScene.getPsiCFGClass(clazz);
        if (cfgClazz == null) {
            return;
        }
        for (PsiMethod currentMethod : methodsArray) {
            PsiCFGPartialMethodSignature signature = PsiCFGPartialMethodSignatureBuilder.buildFromPsiMethod(currentMethod);
            PsiCFGMethod cfgMethod = cfgClazz.getMethod(signature);
            if (cfgMethod == null) continue;
            this.targetMethodList.add(cfgMethod);
        }
    }

    private void getTargetMethodsList() {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)this.mProject);
        PsiClass locationClass = javaPsiFacade.findClass(LOCATION_MANAGER_CLASS_NAME, GlobalSearchScope.allScope((Project)this.mProject));
        PsiClass googleMapsClass = javaPsiFacade.findClass(GOOGLE_MAPS_API_CLASS, GlobalSearchScope.allScope((Project)this.mProject));
        if (locationClass == null && googleMapsClass == null) {
            return;
        }
        if (locationClass != null) {
            this.getTargetMethodsListFromPsiClass(locationClass);
        }
        if (googleMapsClass != null) {
            this.getTargetMethodsListFromPsiClass(googleMapsClass);
        }
    }

    @Nullable
    public String getStaticDescription() {
        return "Description is under construction";
    }

    private PsiMethod[] removeMethodsRequireNoPermission(PsiMethod[] methodsArray) {
        return methodsArray;
    }

    private void tagTheResult() {
        for (Pair<PsiCFGMethod, PsiElement> invocationSite : this.invocationSiteCollection) {
            PsiMethod methodRefRAW;
            PsiElement element = (PsiElement)invocationSite.getSecond();
            if (!(element instanceof PsiMethodCallExpression) || (methodRefRAW = ((PsiCFGMethod)invocationSite.getFirst()).getMethodRef()) == null || !(methodRefRAW instanceof PsiMethod)) continue;
            PsiMethod methodRef = methodRefRAW;
            this.taggedMethodsWithElement.put(methodRef, element);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/experimental/PermissionUsageInspection";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptionsProcessor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/experimental/PermissionUsageInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runInspection";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTargetMethodsListFromPsiClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

