/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.explorer.adbimpl.AdbPathUtil;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandBuilder;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandException;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandResult;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandsUtil;
import com.android.tools.idea.explorer.adbimpl.DeviceUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbDeviceCapabilities {
    @NotNull
    private static final Logger LOGGER = Logger.getInstance(AdbDeviceCapabilities.class);
    @NotNull
    private static final String PROBE_FILES_TEMP_PATH = AdbPathUtil.resolve("/data/local/tmp", "device-explorer");
    @NotNull
    private static final String ESCAPING_LS_ESCAPED_PATH = AdbPathUtil.resolve("/data/local/tmp", "oyX2HCKL\\ acuauQGJ");
    @NotNull
    private static final String ESCAPING_LS_NOT_ESCAPED_PATH = AdbPathUtil.resolve("/data/local/tmp", "oyX2HCKL acuauQGJ");
    @NotNull
    private final IDevice myDevice;
    @Nullable
    private Boolean mySupportsTestCommand;
    @Nullable
    private Boolean mySupportsRmForceFlag;
    @Nullable
    private Boolean mySupportsTouchCommand;
    @Nullable
    private Boolean mySupportsSuRootCommand;
    @Nullable
    private Boolean myIsRoot;
    @Nullable
    private Boolean mySupportsCpCommand;
    @Nullable
    private Boolean myEscapingLs;
    @Nullable
    private Boolean mySupportsMkTempCommand;

    public AdbDeviceCapabilities(@NotNull IDevice device) {
        if (device == null) {
            AdbDeviceCapabilities.$$$reportNull$$$0(0);
        }
        this.myDevice = device;
    }

    public synchronized boolean supportsTestCommand() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, SyncException {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        if (this.mySupportsTestCommand == null) {
            this.mySupportsTestCommand = this.supportsTestCommandWorker();
        }
        return this.mySupportsTestCommand;
    }

    public synchronized boolean supportsRmForceFlag() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, SyncException {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        if (this.mySupportsRmForceFlag == null) {
            this.mySupportsRmForceFlag = this.supportsRmForceFlagWorker();
        }
        return this.mySupportsRmForceFlag;
    }

    public synchronized boolean supportsTouchCommand() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        if (this.mySupportsTouchCommand == null) {
            this.mySupportsTouchCommand = this.supportsTouchCommandWorker();
        }
        return this.mySupportsTouchCommand;
    }

    public synchronized boolean supportsSuRootCommand() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        if (this.mySupportsSuRootCommand == null) {
            this.mySupportsSuRootCommand = this.supportsSuRootCommandWorker();
        }
        return this.mySupportsSuRootCommand;
    }

    public synchronized boolean isRoot() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        if (this.myIsRoot == null) {
            this.myIsRoot = this.isRootWorker();
        }
        return this.myIsRoot;
    }

    public synchronized boolean supportsCpCommand() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, SyncException {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        if (this.mySupportsCpCommand == null) {
            this.mySupportsCpCommand = this.supportsCpCommandWorker();
        }
        return this.mySupportsCpCommand;
    }

    synchronized boolean hasEscapingLs() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        if (this.myEscapingLs == null) {
            this.myEscapingLs = this.hasEscapingLsWorker();
        }
        return this.myEscapingLs;
    }

    public synchronized boolean supportsMkTempCommand() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        if (this.mySupportsMkTempCommand == null) {
            this.mySupportsMkTempCommand = this.supportsMkTempCommandWorker();
        }
        return this.mySupportsMkTempCommand;
    }

    @NotNull
    private static String getCommandOutputExtract(@NotNull AdbShellCommandResult commandResult) {
        List<String> output;
        if (commandResult == null) {
            AdbDeviceCapabilities.$$$reportNull$$$0(1);
        }
        if ((output = commandResult.getOutput()).isEmpty()) {
            if ("[command output is empty]" == null) {
                AdbDeviceCapabilities.$$$reportNull$$$0(2);
            }
            return "[command output is empty]";
        }
        String string = output.stream().limit(5L).collect(Collectors.joining("\n  ", "\n  ", ""));
        if (string == null) {
            AdbDeviceCapabilities.$$$reportNull$$$0(3);
        }
        return string;
    }

    /*
     * Loose catch block
     */
    private boolean supportsTestCommandWorker() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, SyncException {
        Throwable throwable = null;
        try (ScopedRemoteFile tempFile = new ScopedRemoteFile(AdbPathUtil.resolve(PROBE_FILES_TEMP_PATH, ".__temp_test_test__file__.tmp"));){
            tempFile.create();
            String command = new AdbShellCommandBuilder().withText("test -e ").withEscapedPath(tempFile.getRemotePath()).build();
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
            try {
                commandResult.throwIfError();
                boolean bl = true;
                return bl;
            }
            catch (AdbShellCommandException e) {
                boolean bl;
                block17: {
                    block18: {
                        LOGGER.info(String.format("Device \"%s\" does not seem to support the \"test\" command: %s", DeviceUtil.toDebugString(this.myDevice), AdbDeviceCapabilities.getCommandOutputExtract(commandResult)), (Throwable)e);
                        bl = false;
                        if (tempFile == null) break block17;
                        if (throwable == null) break block18;
                        try {
                            tempFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block17;
                    }
                    tempFile.close();
                }
                return bl;
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean supportsRmForceFlagWorker() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, SyncException {
        Throwable throwable = null;
        try (ScopedRemoteFile tempFile = new ScopedRemoteFile(AdbPathUtil.resolve(PROBE_FILES_TEMP_PATH, ".__temp_rm_test_file__.tmp"));){
            tempFile.create();
            String command = new AdbShellCommandBuilder().withText("rm -f ").withEscapedPath(tempFile.getRemotePath()).build();
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
            try {
                commandResult.throwIfError();
                tempFile.setDeleteOnClose(false);
                boolean bl = true;
                return bl;
            }
            catch (AdbShellCommandException e) {
                boolean bl;
                block17: {
                    block18: {
                        LOGGER.info(String.format("Device \"%s\" does not seem to support \"-f\" flag for rm: %s", DeviceUtil.toDebugString(this.myDevice), AdbDeviceCapabilities.getCommandOutputExtract(commandResult)), (Throwable)e);
                        bl = false;
                        if (tempFile == null) break block17;
                        if (throwable == null) break block18;
                        try {
                            tempFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block17;
                    }
                    tempFile.close();
                }
                return bl;
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    private boolean supportsTouchCommandWorker() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        Throwable throwable = null;
        try (ScopedRemoteFile tempFile = new ScopedRemoteFile(AdbPathUtil.resolve(PROBE_FILES_TEMP_PATH, ".__temp_touch_test_file__.tmp"));){
            String command = new AdbShellCommandBuilder().withText("touch ").withEscapedPath(tempFile.getRemotePath()).build();
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
            try {
                commandResult.throwIfError();
                tempFile.setDeleteOnClose(true);
                boolean bl = true;
                return bl;
            }
            catch (AdbShellCommandException e) {
                boolean bl;
                block17: {
                    block18: {
                        LOGGER.info(String.format("Device \"%s\" does not seem to support \"touch\" command: %s", DeviceUtil.toDebugString(this.myDevice), AdbDeviceCapabilities.getCommandOutputExtract(commandResult)), (Throwable)e);
                        bl = false;
                        if (tempFile == null) break block17;
                        if (throwable == null) break block18;
                        try {
                            tempFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block17;
                    }
                    tempFile.close();
                }
                return bl;
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
    }

    private boolean supportsSuRootCommandWorker() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        String command = new AdbShellCommandBuilder().withSuRootPrefix().withText("id").build();
        AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
        try {
            commandResult.throwIfError();
            return true;
        }
        catch (AdbShellCommandException e) {
            LOGGER.info(String.format("Device \"%s\" does not seem to support the \"su 0\" command: %s", DeviceUtil.toDebugString(this.myDevice), AdbDeviceCapabilities.getCommandOutputExtract(commandResult)), (Throwable)e);
            return false;
        }
    }

    private boolean isRootWorker() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        return this.myDevice.isRoot();
    }

    /*
     * Exception decompiling
     */
    private boolean supportsCpCommandWorker() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, SyncException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasEscapingLsWorker() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        try {
            this.touchEscapedPath();
        }
        catch (AdbShellCommandException exception) {
            LOGGER.info("Device \"" + DeviceUtil.toDebugString(this.myDevice) + "\" does not seem to support the touch command", (Throwable)exception);
            return false;
        }
        try (ScopedRemoteFile file = new ScopedRemoteFile(ESCAPING_LS_NOT_ESCAPED_PATH);){
            file.setDeleteOnClose(true);
            boolean bl = this.lsEscapedPath();
            return bl;
        }
        catch (AdbShellCommandException exception) {
            LOGGER.info("Device \"" + DeviceUtil.toDebugString(this.myDevice) + "\" does not seem to support the ls command", (Throwable)exception);
            return false;
        }
    }

    private void touchEscapedPath() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, AdbShellCommandException {
        String command = new AdbShellCommandBuilder().withText("touch " + ESCAPING_LS_ESCAPED_PATH).build();
        AdbShellCommandResult result2 = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
        result2.throwIfError();
        if (!result2.getOutput().isEmpty()) {
            throw new AdbShellCommandException("Unexpected output from touch");
        }
    }

    private boolean lsEscapedPath() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, AdbShellCommandException {
        String command = new AdbShellCommandBuilder().withText("ls " + ESCAPING_LS_ESCAPED_PATH).build();
        AdbShellCommandResult result2 = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
        result2.throwIfError();
        String output = result2.getOutput().get(0);
        if (output.equals(ESCAPING_LS_ESCAPED_PATH)) {
            return true;
        }
        if (output.equals(ESCAPING_LS_NOT_ESCAPED_PATH)) {
            return false;
        }
        throw new AdbShellCommandException("Unexpected output from ls");
    }

    private boolean supportsMkTempCommandWorker() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        String command = new AdbShellCommandBuilder().withText("mktemp -p ").withEscapedPath("/data/local/tmp").build();
        AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
        try {
            commandResult.throwIfError();
            if (commandResult.getOutput().isEmpty()) {
                throw new AdbShellCommandException("Unexpected output from mktemp, assuming not supported");
            }
            String remotePath = commandResult.getOutput().get(0);
            try (ScopedRemoteFile tempFile = new ScopedRemoteFile(remotePath);){
                tempFile.setDeleteOnClose(true);
            }
            return true;
        }
        catch (AdbShellCommandException e) {
            LOGGER.info(String.format("Device \"%s\" does not seem to support the \"cp\" command: %s", DeviceUtil.toDebugString(this.myDevice), AdbDeviceCapabilities.getCommandOutputExtract(commandResult)), (Throwable)e);
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandResult";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/explorer/adbimpl/AdbDeviceCapabilities";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/explorer/adbimpl/AdbDeviceCapabilities";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandOutputExtract";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCommandOutputExtract";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ScopedRemoteFile
    implements AutoCloseable {
        @NotNull
        private final String myRemotePath;
        private boolean myDeleteOnClose;

        public ScopedRemoteFile(String remotePath) {
            if (remotePath == null) {
                ScopedRemoteFile.$$$reportNull$$$0(0);
            }
            this.myRemotePath = remotePath;
        }

        public void setDeleteOnClose(boolean value) {
            this.myDeleteOnClose = value;
        }

        @NotNull
        public String getRemotePath() {
            String string = this.myRemotePath;
            if (string == null) {
                ScopedRemoteFile.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void create() throws TimeoutException, AdbCommandRejectedException, SyncException, IOException {
            assert (!this.myDeleteOnClose);
            this.myDeleteOnClose = this.createRemoteTemporaryFile();
        }

        @Override
        public void close() {
            if (!this.myDeleteOnClose) {
                return;
            }
            try {
                String command = new AdbShellCommandBuilder().withText("rm ").withEscapedPath(this.myRemotePath).build();
                AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(AdbDeviceCapabilities.this.myDevice, command);
                try {
                    commandResult.throwIfError();
                }
                catch (AdbShellCommandException e) {
                    LOGGER.warn(String.format("Device \"%s\": Error deleting temporary test file \"%s\": %s", DeviceUtil.toDebugString(AdbDeviceCapabilities.this.myDevice), this.myRemotePath, AdbDeviceCapabilities.getCommandOutputExtract(commandResult)), (Throwable)e);
                }
            }
            catch (Exception e) {
                LOGGER.warn(String.format("Device \"%s\": Error deleting temporary test file \"%s\"", DeviceUtil.toDebugString(AdbDeviceCapabilities.this.myDevice), this.myRemotePath), (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private boolean createRemoteTemporaryFile() throws IOException, TimeoutException, AdbCommandRejectedException, SyncException {
            File file = FileUtil.createTempFile((String)this.myRemotePath, (String)"", (boolean)true);
            SyncService sync = AdbDeviceCapabilities.this.myDevice.getSyncService();
            if (sync == null) {
                throw new IOException(String.format("Device \"%s\": Unable to open sync connection", DeviceUtil.toDebugString(AdbDeviceCapabilities.this.myDevice)));
            }
            LOGGER.trace(String.format("Device \"%s\": Uploading temporary file \"%s\" to remote file \"%s\"", DeviceUtil.toDebugString(AdbDeviceCapabilities.this.myDevice), file, this.myRemotePath));
            sync.pushFile(file.getPath(), this.myRemotePath, SyncService.getNullProgressMonitor());
            boolean bl = true;
            sync.close();
            try {
                FileUtil.delete((File)file);
            }
            catch (Exception e) {
                LOGGER.warn(String.format("Device \"%s\": Error deleting temporary file \"%s\"", DeviceUtil.toDebugString(AdbDeviceCapabilities.this.myDevice), file), (Throwable)e);
            }
            return bl;
            {
                catch (Throwable throwable) {
                    try {
                        sync.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        try {
                            FileUtil.delete((File)file);
                        }
                        catch (Exception e) {
                            LOGGER.warn(String.format("Device \"%s\": Error deleting temporary file \"%s\"", DeviceUtil.toDebugString(AdbDeviceCapabilities.this.myDevice), file), (Throwable)e);
                        }
                        throw throwable2;
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remotePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/explorer/adbimpl/AdbDeviceCapabilities$ScopedRemoteFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/explorer/adbimpl/AdbDeviceCapabilities$ScopedRemoteFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRemotePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

