/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceDefaultFileEntry;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileEntry;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileSystem;
import com.android.tools.idea.explorer.adbimpl.AdbFileListingEntry;
import com.android.tools.idea.explorer.adbimpl.AdbPathUtil;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandException;
import com.android.tools.idea.explorer.fs.DeviceFileEntry;
import com.android.tools.idea.explorer.fs.FileTransferProgress;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbDeviceDirectFileEntry
extends AdbDeviceFileEntry {
    @Nullable
    private final String myRunAs;

    public AdbDeviceDirectFileEntry(@NotNull AdbDeviceFileSystem device, @NotNull AdbFileListingEntry entry, @Nullable AdbDeviceFileEntry parent, @Nullable String runAs) {
        if (device == null) {
            AdbDeviceDirectFileEntry.$$$reportNull$$$0(0);
        }
        if (entry == null) {
            AdbDeviceDirectFileEntry.$$$reportNull$$$0(1);
        }
        super(device, entry, parent);
        this.myRunAs = runAs;
    }

    @Override
    @NotNull
    public ListenableFuture<List<DeviceFileEntry>> getEntries() {
        ListenableFuture<List<AdbFileListingEntry>> children = this.myDevice.getAdbFileListing().getChildrenRunAs(this.myEntry, this.myRunAs);
        ListenableFuture listenableFuture = this.myDevice.getTaskExecutor().transform(children, result2 -> {
            assert (result2 != null);
            return result2.stream().map(listingEntry -> new AdbDeviceDefaultFileEntry(this.myDevice, (AdbFileListingEntry)listingEntry, this)).collect(Collectors.toList());
        });
        if (listenableFuture == null) {
            AdbDeviceDirectFileEntry.$$$reportNull$$$0(2);
        }
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<Void> delete() {
        if (this.isDirectory()) {
            ListenableFuture<Void> listenableFuture = this.myDevice.getAdbFileOperations().deleteRecursiveRunAs(this.getFullPath(), this.myRunAs);
            if (listenableFuture == null) {
                AdbDeviceDirectFileEntry.$$$reportNull$$$0(3);
            }
            return listenableFuture;
        }
        ListenableFuture<Void> listenableFuture = this.myDevice.getAdbFileOperations().deleteFileRunAs(this.getFullPath(), this.myRunAs);
        if (listenableFuture == null) {
            AdbDeviceDirectFileEntry.$$$reportNull$$$0(4);
        }
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<Void> createNewFile(@NotNull String fileName) {
        if (fileName == null) {
            AdbDeviceDirectFileEntry.$$$reportNull$$$0(5);
        }
        ListenableFuture<Void> listenableFuture = this.myDevice.getAdbFileOperations().createNewFileRunAs(this.getFullPath(), fileName, this.myRunAs);
        if (listenableFuture == null) {
            AdbDeviceDirectFileEntry.$$$reportNull$$$0(6);
        }
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<Void> createNewDirectory(@NotNull String directoryName) {
        if (directoryName == null) {
            AdbDeviceDirectFileEntry.$$$reportNull$$$0(7);
        }
        ListenableFuture<Void> listenableFuture = this.myDevice.getAdbFileOperations().createNewDirectoryRunAs(this.getFullPath(), directoryName, this.myRunAs);
        if (listenableFuture == null) {
            AdbDeviceDirectFileEntry.$$$reportNull$$$0(8);
        }
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<Boolean> isSymbolicLinkToDirectory() {
        ListenableFuture<Boolean> listenableFuture = this.myDevice.getAdbFileListing().isDirectoryLinkRunAs(this.myEntry, this.myRunAs);
        if (listenableFuture == null) {
            AdbDeviceDirectFileEntry.$$$reportNull$$$0(9);
        }
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<Void> downloadFile(@NotNull Path localPath, @NotNull FileTransferProgress progress) {
        if (localPath == null) {
            AdbDeviceDirectFileEntry.$$$reportNull$$$0(10);
        }
        if (progress == null) {
            AdbDeviceDirectFileEntry.$$$reportNull$$$0(11);
        }
        ListenableFuture<Void> futureDownload = this.myDevice.getAdbFileTransfer().downloadFile(this.myEntry, localPath, progress);
        ListenableFuture listenableFuture = this.myDevice.getTaskExecutor().catchingAsync(futureDownload, SyncException.class, syncError -> {
            if (localPath == null) {
                AdbDeviceDirectFileEntry.$$$reportNull$$$0(24);
            }
            if (progress == null) {
                AdbDeviceDirectFileEntry.$$$reportNull$$$0(25);
            }
            assert (syncError != null);
            if (AdbDeviceDirectFileEntry.isSyncPermissionError(syncError) && this.isDeviceSuAndNotRoot()) {
                return this.myDevice.getAdbFileTransfer().downloadFileViaTempLocation(this.getFullPath(), this.getSize(), localPath, progress, null);
            }
            return Futures.immediateFailedFuture((Throwable)syncError);
        });
        if (listenableFuture == null) {
            AdbDeviceDirectFileEntry.$$$reportNull$$$0(12);
        }
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<Void> uploadFile(@NotNull Path localPath, @NotNull String fileName, @NotNull FileTransferProgress progress) {
        if (localPath == null) {
            AdbDeviceDirectFileEntry.$$$reportNull$$$0(13);
        }
        if (fileName == null) {
            AdbDeviceDirectFileEntry.$$$reportNull$$$0(14);
        }
        if (progress == null) {
            AdbDeviceDirectFileEntry.$$$reportNull$$$0(15);
        }
        String remotePath = AdbPathUtil.resolve(this.myEntry.getFullPath(), fileName);
        ListenableFuture futureShouldCreateRemote = this.myDevice.getTaskExecutor().executeAsync(this::isDeviceSuAndNotRoot);
        ListenableFuture listenableFuture = this.myDevice.getTaskExecutor().transformAsync(futureShouldCreateRemote, shouldCreateRemote -> {
            if (localPath == null) {
                AdbDeviceDirectFileEntry.$$$reportNull$$$0(18);
            }
            if (progress == null) {
                AdbDeviceDirectFileEntry.$$$reportNull$$$0(19);
            }
            assert (shouldCreateRemote != null);
            if (shouldCreateRemote.booleanValue()) {
                ListenableFuture<Void> futureTouchFile = this.myDevice.getAdbFileOperations().touchFileAsDefaultUser(remotePath);
                ListenableFuture futureUpload = this.myDevice.getTaskExecutor().transformAsync(futureTouchFile, aVoid -> {
                    if (localPath == null) {
                        AdbDeviceDirectFileEntry.$$$reportNull$$$0(22);
                    }
                    if (progress == null) {
                        AdbDeviceDirectFileEntry.$$$reportNull$$$0(23);
                    }
                    return this.myDevice.getAdbFileTransfer().uploadFile(localPath, remotePath, progress);
                });
                return this.myDevice.getTaskExecutor().catchingAsync(futureUpload, AdbShellCommandException.class, error -> {
                    if (localPath == null) {
                        AdbDeviceDirectFileEntry.$$$reportNull$$$0(20);
                    }
                    if (progress == null) {
                        AdbDeviceDirectFileEntry.$$$reportNull$$$0(21);
                    }
                    return this.myDevice.getAdbFileTransfer().uploadFileViaTempLocation(localPath, remotePath, progress, null);
                });
            }
            return this.myDevice.getAdbFileTransfer().uploadFile(localPath, remotePath, progress);
        });
        if (listenableFuture == null) {
            AdbDeviceDirectFileEntry.$$$reportNull$$$0(16);
        }
        return listenableFuture;
    }

    private static boolean isSyncPermissionError(@NotNull SyncException pullError) {
        if (pullError == null) {
            AdbDeviceDirectFileEntry.$$$reportNull$$$0(17);
        }
        return pullError.getErrorCode() == SyncException.SyncError.NO_REMOTE_OBJECT || pullError.getErrorCode() == SyncException.SyncError.TRANSFER_PROTOCOL_ERROR;
    }

    private boolean isDeviceSuAndNotRoot() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        return this.myDevice.getCapabilities().supportsSuRootCommand() && !this.myDevice.getCapabilities().isRoot();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/explorer/adbimpl/AdbDeviceDirectFileEntry";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryName";
                break;
            }
            case 10: 
            case 13: 
            case 18: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 11: 
            case 15: 
            case 19: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pullError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/explorer/adbimpl/AdbDeviceDirectFileEntry";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntries";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "delete";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "isSymbolicLinkToDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadFile";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "uploadFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createNewFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNewDirectory";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "downloadFile";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "uploadFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isSyncPermissionError";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$uploadFile$5";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$4";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$downloadFile$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

