/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.tools.idea.concurrent.FutureCallbackExecutor;
import com.android.tools.idea.explorer.adbimpl.AdbFileListingEntry;
import com.android.tools.idea.explorer.adbimpl.AdbFileOperations;
import com.android.tools.idea.explorer.fs.FileTransferProgress;
import com.android.tools.idea.explorer.fs.ThrottledProgress;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbFileTransfer {
    @NotNull
    private static Logger LOGGER = Logger.getInstance(AdbFileTransfer.class);
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private final AdbFileOperations myFileOperations;
    @NotNull
    private final FutureCallbackExecutor myProgressExecutor;
    @NotNull
    private final FutureCallbackExecutor myTaskExecutor;

    public AdbFileTransfer(@NotNull IDevice device, @NotNull AdbFileOperations fileOperations, @NotNull Executor progressExecutor, @NotNull Executor taskExecutor) {
        if (device == null) {
            AdbFileTransfer.$$$reportNull$$$0(0);
        }
        if (fileOperations == null) {
            AdbFileTransfer.$$$reportNull$$$0(1);
        }
        if (progressExecutor == null) {
            AdbFileTransfer.$$$reportNull$$$0(2);
        }
        if (taskExecutor == null) {
            AdbFileTransfer.$$$reportNull$$$0(3);
        }
        this.myDevice = device;
        this.myFileOperations = fileOperations;
        this.myProgressExecutor = FutureCallbackExecutor.wrap((Executor)progressExecutor);
        this.myTaskExecutor = FutureCallbackExecutor.wrap((Executor)taskExecutor);
    }

    @NotNull
    public ListenableFuture<Void> downloadFile(@NotNull AdbFileListingEntry remoteFileEntry, @NotNull Path localPath, @NotNull FileTransferProgress progress) {
        if (remoteFileEntry == null) {
            AdbFileTransfer.$$$reportNull$$$0(4);
        }
        if (localPath == null) {
            AdbFileTransfer.$$$reportNull$$$0(5);
        }
        if (progress == null) {
            AdbFileTransfer.$$$reportNull$$$0(6);
        }
        ListenableFuture<Void> listenableFuture = this.downloadFileWorker(remoteFileEntry.getFullPath(), remoteFileEntry.getSize(), localPath, progress);
        if (listenableFuture == null) {
            AdbFileTransfer.$$$reportNull$$$0(7);
        }
        return listenableFuture;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ListenableFuture<Void> downloadFile(@NotNull String remotePath, long remotePathSize, @NotNull Path localPath, @NotNull FileTransferProgress fileTransferProgress) {
        void progress;
        if (remotePath == null) {
            AdbFileTransfer.$$$reportNull$$$0(8);
        }
        if (localPath == null) {
            AdbFileTransfer.$$$reportNull$$$0(9);
        }
        if (fileTransferProgress == null) {
            AdbFileTransfer.$$$reportNull$$$0(10);
        }
        ListenableFuture<Void> listenableFuture = this.downloadFileWorker(remotePath, remotePathSize, localPath, (FileTransferProgress)progress);
        if (listenableFuture == null) {
            AdbFileTransfer.$$$reportNull$$$0(11);
        }
        return listenableFuture;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ListenableFuture<Void> downloadFileViaTempLocation(@NotNull String remotePath, long remotePathSize, @NotNull Path localPath, @NotNull FileTransferProgress progress, @Nullable String string) {
        void runAs;
        if (remotePath == null) {
            AdbFileTransfer.$$$reportNull$$$0(12);
        }
        if (localPath == null) {
            AdbFileTransfer.$$$reportNull$$$0(13);
        }
        if (progress == null) {
            AdbFileTransfer.$$$reportNull$$$0(14);
        }
        ListenableFuture<String> futureTempFile = this.myFileOperations.createTempFile("/data/local/tmp");
        ListenableFuture listenableFuture = this.myTaskExecutor.transformAsync(futureTempFile, arg_0 -> this.lambda$downloadFileViaTempLocation$2(remotePath, (String)runAs, remotePathSize, localPath, progress, arg_0));
        if (listenableFuture == null) {
            AdbFileTransfer.$$$reportNull$$$0(15);
        }
        return listenableFuture;
    }

    @NotNull
    public ListenableFuture<Void> uploadFile(@NotNull Path localPath, @NotNull String remotePath, @NotNull FileTransferProgress progress) {
        if (localPath == null) {
            AdbFileTransfer.$$$reportNull$$$0(16);
        }
        if (remotePath == null) {
            AdbFileTransfer.$$$reportNull$$$0(17);
        }
        if (progress == null) {
            AdbFileTransfer.$$$reportNull$$$0(18);
        }
        ListenableFuture<Void> listenableFuture = this.uploadFileWorker(localPath, remotePath, progress);
        if (listenableFuture == null) {
            AdbFileTransfer.$$$reportNull$$$0(19);
        }
        return listenableFuture;
    }

    public ListenableFuture<Void> uploadFileViaTempLocation(@NotNull Path localPath, @NotNull String remotePath, @NotNull FileTransferProgress progress, @Nullable String runAs) {
        if (localPath == null) {
            AdbFileTransfer.$$$reportNull$$$0(20);
        }
        if (remotePath == null) {
            AdbFileTransfer.$$$reportNull$$$0(21);
        }
        if (progress == null) {
            AdbFileTransfer.$$$reportNull$$$0(22);
        }
        ListenableFuture<String> futureTempFile = this.myFileOperations.createTempFile("/data/local/tmp");
        return this.myTaskExecutor.transformAsync(futureTempFile, tempFile -> {
            if (localPath == null) {
                AdbFileTransfer.$$$reportNull$$$0(42);
            }
            if (progress == null) {
                AdbFileTransfer.$$$reportNull$$$0(43);
            }
            if (remotePath == null) {
                AdbFileTransfer.$$$reportNull$$$0(44);
            }
            assert (tempFile != null);
            ListenableFuture<Void> futureUpload = this.uploadFile(localPath, (String)tempFile, progress);
            ListenableFuture futureCopy = this.myTaskExecutor.transformAsync(futureUpload, aVoid -> {
                if (remotePath == null) {
                    AdbFileTransfer.$$$reportNull$$$0(45);
                }
                return this.myFileOperations.copyFileRunAs((String)tempFile, remotePath, runAs);
            });
            return this.myTaskExecutor.finallyAsync(futureCopy, () -> this.myFileOperations.deleteFile((String)tempFile));
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private ListenableFuture<Void> downloadFileWorker(@NotNull String remotePath, long remotePathSize, @NotNull Path localPath, @NotNull FileTransferProgress fileTransferProgress) {
        void progress;
        if (remotePath == null) {
            AdbFileTransfer.$$$reportNull$$$0(23);
        }
        if (localPath == null) {
            AdbFileTransfer.$$$reportNull$$$0(24);
        }
        if (fileTransferProgress == null) {
            AdbFileTransfer.$$$reportNull$$$0(25);
        }
        ListenableFuture<SyncService> futureSyncService = this.getSyncService();
        ListenableFuture futurePull = this.myTaskExecutor.transform(futureSyncService, arg_0 -> this.lambda$downloadFileWorker$6(remotePath, localPath, (FileTransferProgress)progress, remotePathSize, arg_0));
        ListenableFuture listenableFuture = this.myTaskExecutor.catchingAsync(futurePull, SyncException.class, syncError -> {
            if (remotePath == null) {
                AdbFileTransfer.$$$reportNull$$$0(37);
            }
            if (localPath == null) {
                AdbFileTransfer.$$$reportNull$$$0(38);
            }
            assert (syncError != null);
            if (syncError.wasCanceled()) {
                return Futures.immediateCancelledFuture();
            }
            LOGGER.info(String.format("Error pulling file from \"%s\" to \"%s\"", remotePath, localPath), (Throwable)syncError);
            return Futures.immediateFailedFuture((Throwable)syncError);
        });
        if (listenableFuture == null) {
            AdbFileTransfer.$$$reportNull$$$0(26);
        }
        return listenableFuture;
    }

    @NotNull
    private ListenableFuture<Void> uploadFileWorker(@NotNull Path localPath, @NotNull String remotePath, @NotNull FileTransferProgress progress) {
        if (localPath == null) {
            AdbFileTransfer.$$$reportNull$$$0(27);
        }
        if (remotePath == null) {
            AdbFileTransfer.$$$reportNull$$$0(28);
        }
        if (progress == null) {
            AdbFileTransfer.$$$reportNull$$$0(29);
        }
        ListenableFuture<SyncService> futureSyncService = this.getSyncService();
        ListenableFuture futurePush = this.myTaskExecutor.transform(futureSyncService, syncService -> {
            if (localPath == null) {
                AdbFileTransfer.$$$reportNull$$$0(34);
            }
            if (remotePath == null) {
                AdbFileTransfer.$$$reportNull$$$0(35);
            }
            if (progress == null) {
                AdbFileTransfer.$$$reportNull$$$0(36);
            }
            assert (syncService != null);
            try {
                long fileLength = localPath.toFile().length();
                long startTime = System.nanoTime();
                syncService.pushFile(localPath.toString(), remotePath, (SyncService.ISyncProgressMonitor)new SingleFileProgressMonitor((Executor)this.myProgressExecutor, progress, fileLength));
                long endTime = System.nanoTime();
                LOGGER.info(String.format("Push file took %,d ms to execute: \"%s\" -> \"%s\"", (endTime - startTime) / 1000000L, localPath, remotePath));
                Void void_ = null;
                return void_;
            }
            finally {
                syncService.close();
            }
        });
        ListenableFuture listenableFuture = this.myTaskExecutor.catchingAsync(futurePush, SyncException.class, syncError -> {
            if (localPath == null) {
                AdbFileTransfer.$$$reportNull$$$0(32);
            }
            if (remotePath == null) {
                AdbFileTransfer.$$$reportNull$$$0(33);
            }
            assert (syncError != null);
            if (syncError.wasCanceled()) {
                return Futures.immediateCancelledFuture();
            }
            LOGGER.info(String.format("Error pushing file from \"%s\" to \"%s\"", localPath, remotePath), (Throwable)syncError);
            return Futures.immediateFailedFuture((Throwable)syncError);
        });
        if (listenableFuture == null) {
            AdbFileTransfer.$$$reportNull$$$0(30);
        }
        return listenableFuture;
    }

    @NotNull
    private ListenableFuture<SyncService> getSyncService() {
        ListenableFuture listenableFuture = this.myTaskExecutor.executeAsync(() -> {
            SyncService sync = this.myDevice.getSyncService();
            if (sync == null) {
                throw new IOException("Unable to open synchronization service to device");
            }
            return sync;
        });
        if (listenableFuture == null) {
            AdbFileTransfer.$$$reportNull$$$0(31);
        }
        return listenableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private /* synthetic */ Void lambda$downloadFileWorker$6(@NotNull String remotePath, @NotNull Path localPath, @NotNull FileTransferProgress progress, long remotePathSize, SyncService syncService) throws Exception {
        void syncService2;
        if (remotePath == null) {
            AdbFileTransfer.$$$reportNull$$$0(39);
        }
        if (localPath == null) {
            AdbFileTransfer.$$$reportNull$$$0(40);
        }
        if (progress == null) {
            AdbFileTransfer.$$$reportNull$$$0(41);
        }
        assert (syncService2 != null);
        try {
            long startTime = System.nanoTime();
            syncService2.pullFile(remotePath, localPath.toString(), (SyncService.ISyncProgressMonitor)new SingleFileProgressMonitor((Executor)this.myProgressExecutor, progress, remotePathSize));
            long endTime = System.nanoTime();
            LOGGER.info(String.format("Pull file took %,d ms to execute: \"%s\" -> \"%s\"", (endTime - startTime) / 1000000L, remotePath, localPath));
            Void void_ = null;
            return void_;
        }
        finally {
            syncService2.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ListenableFuture lambda$downloadFileViaTempLocation$2(@NotNull String remotePath, @Nullable String runAs, long remotePathSize, @NotNull Path localPath, @NotNull FileTransferProgress progress, String string) throws Exception {
        void tempFile;
        if (remotePath == null) {
            AdbFileTransfer.$$$reportNull$$$0(46);
        }
        if (localPath == null) {
            AdbFileTransfer.$$$reportNull$$$0(47);
        }
        if (progress == null) {
            AdbFileTransfer.$$$reportNull$$$0(48);
        }
        assert (tempFile != null);
        ListenableFuture<Void> futureCopy = this.myFileOperations.copyFileRunAs(remotePath, (String)tempFile, runAs);
        ListenableFuture futureDownload = this.myTaskExecutor.transformAsync(futureCopy, arg_0 -> this.lambda$null$0((String)tempFile, remotePathSize, localPath, progress, arg_0));
        return this.myTaskExecutor.finallyAsync(futureDownload, () -> this.lambda$null$1((String)tempFile));
    }

    private /* synthetic */ ListenableFuture lambda$null$1(String tempFile) throws Exception {
        return this.myFileOperations.deleteFile(tempFile);
    }

    private /* synthetic */ ListenableFuture lambda$null$0(String tempFile, long remotePathSize, @NotNull Path localPath, @NotNull FileTransferProgress progress, Void void_) throws Exception {
        if (localPath == null) {
            AdbFileTransfer.$$$reportNull$$$0(49);
        }
        if (progress == null) {
            AdbFileTransfer.$$$reportNull$$$0(50);
        }
        return this.downloadFile(tempFile, remotePathSize, localPath, progress);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 26: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 26: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOperations";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressExecutor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskExecutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFileEntry";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 16: 
            case 20: 
            case 24: 
            case 27: 
            case 32: 
            case 34: 
            case 38: 
            case 40: 
            case 42: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 18: 
            case 22: 
            case 25: 
            case 29: 
            case 36: 
            case 41: 
            case 43: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 26: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/explorer/adbimpl/AdbFileTransfer";
                break;
            }
            case 8: 
            case 12: 
            case 17: 
            case 21: 
            case 23: 
            case 28: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 44: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/explorer/adbimpl/AdbFileTransfer";
                break;
            }
            case 7: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadFileViaTempLocation";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "uploadFile";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadFileWorker";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "uploadFileWorker";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyncService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "downloadFile";
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 26: 
            case 30: 
            case 31: {
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "downloadFileViaTempLocation";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "uploadFile";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "uploadFileViaTempLocation";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "downloadFileWorker";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "uploadFileWorker";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$uploadFileWorker$9";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$uploadFileWorker$8";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$downloadFileWorker$7";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$downloadFileWorker$6";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$uploadFileViaTempLocation$5";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$downloadFileViaTempLocation$2";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 26: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SingleFileProgressMonitor
    implements SyncService.ISyncProgressMonitor {
        private static final int PROGRESS_REPORT_INTERVAL_MILLIS = 50;
        @NotNull
        private final Executor myCallbackExecutor;
        @NotNull
        private final FileTransferProgress myProgress;
        @NotNull
        private final ThrottledProgress myThrottledProgress;
        private final long myTotalBytes;
        private long myCurrentBytes;

        public SingleFileProgressMonitor(@NotNull Executor callbackExecutor, @NotNull FileTransferProgress progress, long totalBytes) {
            if (callbackExecutor == null) {
                SingleFileProgressMonitor.$$$reportNull$$$0(0);
            }
            if (progress == null) {
                SingleFileProgressMonitor.$$$reportNull$$$0(1);
            }
            this.myCallbackExecutor = callbackExecutor;
            this.myProgress = progress;
            this.myTotalBytes = totalBytes;
            this.myThrottledProgress = new ThrottledProgress(50L);
        }

        public void start(int totalWork) {
            this.myCallbackExecutor.execute(() -> this.myProgress.progress(0L, this.myTotalBytes));
        }

        public void stop() {
            this.myCallbackExecutor.execute(() -> this.myProgress.progress(this.myTotalBytes, this.myTotalBytes));
        }

        public boolean isCanceled() {
            return this.myProgress.isCancelled();
        }

        public void startSubTask(String name) {
            assert (false) : "A single file sync should not have multiple tasks";
        }

        public void advance(int work) {
            this.myCurrentBytes += (long)work;
            if (this.myThrottledProgress.check()) {
                long currentBytes = this.myCurrentBytes;
                this.myCallbackExecutor.execute(() -> this.myProgress.progress(currentBytes, this.myTotalBytes));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "callbackExecutor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "progress";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/explorer/adbimpl/AdbFileTransfer$SingleFileProgressMonitor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

