/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.flags;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.NumberFormatter;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExperimentalSettingsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @NotNull
    private final GradleExperimentalSettings mySettings;
    private JPanel myPanel;
    private JSpinner myModuleNumberSpinner;
    private JCheckBox mySkipSourceGenOnSyncCheckbox;
    private JCheckBox myUseL2DependenciesCheckBox;
    private JCheckBox myEnableNavEditorCheckbox;

    public ExperimentalSettingsConfigurable() {
        this(GradleExperimentalSettings.getInstance());
    }

    @VisibleForTesting
    ExperimentalSettingsConfigurable(@NotNull GradleExperimentalSettings settings) {
        if (settings == null) {
            ExperimentalSettingsConfigurable.$$$reportNull$$$0(0);
        }
        this.mySettings = settings;
        this.$$$setupUI$$$();
        this.myUseL2DependenciesCheckBox.setVisible(false);
        this.reset();
    }

    @NotNull
    public String getId() {
        if ("gradle.experimental" == null) {
            ExperimentalSettingsConfigurable.$$$reportNull$$$0(1);
        }
        return "gradle.experimental";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return "Experimental";
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            ExperimentalSettingsConfigurable.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public boolean isModified() {
        if (this.mySettings.SKIP_SOURCE_GEN_ON_PROJECT_SYNC != this.isSkipSourceGenOnSync() || this.mySettings.USE_L2_DEPENDENCIES_ON_SYNC != this.isUseL2DependenciesInSync() || ((Boolean)StudioFlags.ENABLE_NAV_EDITOR.get()).booleanValue() != this.enableNavEditor()) {
            return true;
        }
        Integer value = this.getMaxModuleCountForSourceGen();
        return value != null && this.mySettings.MAX_MODULE_COUNT_FOR_SOURCE_GEN != value;
    }

    public void apply() throws ConfigurationException {
        this.mySettings.SKIP_SOURCE_GEN_ON_PROJECT_SYNC = this.isSkipSourceGenOnSync();
        this.mySettings.USE_L2_DEPENDENCIES_ON_SYNC = this.isUseL2DependenciesInSync();
        Integer value = this.getMaxModuleCountForSourceGen();
        if (value != null) {
            this.mySettings.MAX_MODULE_COUNT_FOR_SOURCE_GEN = value;
        }
        StudioFlags.ENABLE_NAV_EDITOR.override(this.enableNavEditor());
    }

    @VisibleForTesting
    @Nullable
    Integer getMaxModuleCountForSourceGen() {
        Object value = this.myModuleNumberSpinner.getValue();
        return value instanceof Integer ? (Integer)value : null;
    }

    void setMaxModuleCountForSourceGen(int value) {
        this.myModuleNumberSpinner.setValue(value);
    }

    @VisibleForTesting
    boolean isSkipSourceGenOnSync() {
        return this.mySkipSourceGenOnSyncCheckbox.isSelected();
    }

    void setSkipSourceGenOnSync(boolean value) {
        this.mySkipSourceGenOnSyncCheckbox.setSelected(value);
    }

    @VisibleForTesting
    boolean isUseL2DependenciesInSync() {
        return this.myUseL2DependenciesCheckBox.isSelected();
    }

    void setUseL2DependenciesInSync(boolean value) {
        this.myUseL2DependenciesCheckBox.setSelected(value);
    }

    private boolean enableNavEditor() {
        return this.myEnableNavEditorCheckbox.isSelected();
    }

    public void reset() {
        this.mySkipSourceGenOnSyncCheckbox.setSelected(this.mySettings.SKIP_SOURCE_GEN_ON_PROJECT_SYNC);
        this.myModuleNumberSpinner.setValue(this.mySettings.MAX_MODULE_COUNT_FOR_SOURCE_GEN);
        this.myUseL2DependenciesCheckBox.setSelected(this.mySettings.USE_L2_DEPENDENCIES_ON_SYNC);
        this.myEnableNavEditorCheckbox.setSelected((Boolean)StudioFlags.ENABLE_NAV_EDITOR.get());
    }

    private void createUIComponents() {
        JFormattedTextField textField2;
        JFormattedTextField.AbstractFormatter formatter;
        int value = GradleExperimentalSettings.getInstance().MAX_MODULE_COUNT_FOR_SOURCE_GEN;
        this.myModuleNumberSpinner = new JSpinner(new SpinnerNumberModel(value, 0, Integer.MAX_VALUE, 1));
        JComponent editor = this.myModuleNumberSpinner.getEditor();
        if (editor instanceof JSpinner.NumberEditor && (formatter = (textField2 = ((JSpinner.NumberEditor)editor).getTextField()).getFormatter()) instanceof NumberFormatter) {
            ((NumberFormatter)formatter).setAllowsInvalid(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/flags/ExperimentalSettingsConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/flags/ExperimentalSettingsConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("<html><b>Note:</b> This settings are for features that are considered <b>experimental</b>.</html>");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 3, 0, 1, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(8, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("<html><br></html>");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 3, 0, 0, 0, 0, null, null, null));
        this.mySkipSourceGenOnSyncCheckbox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Skip source generation on Gradle sync if a project has more than");
        jPanel.add((Component)jCheckBox3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("<html><br></html>");
        jPanel.add((Component)jBLabel3, new GridConstraints(4, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        JSpinner jSpinner = this.myModuleNumberSpinner;
        jPanel.add((Component)jSpinner, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("modules.");
        jPanel.add((Component)jBLabel4, new GridConstraints(3, 2, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myUseL2DependenciesCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Use new dependency mechanism during Gradle sync");
        jPanel.add((Component)jCheckBox2, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("Gradle");
        jPanel.add((Component)titledSeparator, new GridConstraints(2, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("Editor");
        jPanel.add((Component)titledSeparator2, new GridConstraints(6, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        this.myEnableNavEditorCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Enable Navigation Editor");
        jPanel.add((Component)jCheckBox, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

