/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.flags;

import com.android.flags.Flag;
import com.android.flags.FlagGroup;
import com.android.flags.FlagOverrides;
import com.android.flags.ImmutableFlagOverrides;
import com.android.flags.overrides.DefaultFlagOverrides;
import com.android.tools.idea.flags.StudioFlagSettings;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.expressions.bool.BooleanExpressions;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.VisibleProperty;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.LightColors;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StudioFlagsDialog
extends DialogWrapper {
    private static final String DIMENSION_KEY = StudioFlagsDialog.class.getSimpleName();
    public static final String TITLE = "Edit Studio Flags";
    private final FlagOverrides myBackupOverrides;
    private final BindingsManager myBindings;
    private final ListMultimap<FlagGroup, Flag<?>> myGroupedFlags;
    private JPanel myRootPanel;
    private JPanel myContentPanel;
    private JBScrollPane myScrollPane;
    private SearchTextField mySearchTextField;

    public StudioFlagsDialog(@Nullable Project project) {
        super(project);
        this.$$$setupUI$$$();
        this.myBackupOverrides = new DefaultFlagOverrides();
        this.myBindings = new BindingsManager();
        this.setTitle(TITLE);
        this.setPreferredBounds(project);
        this.myGroupedFlags = StudioFlagsDialog.collectAllFlags();
        this.replaceOverrides(this.myBackupOverrides, (ImmutableFlagOverrides)StudioFlagSettings.getInstance());
        this.updateFlagsComponents(null);
        this.mySearchTextField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                StudioFlagsDialog.this.searchTextChanged(this.getText(e));
            }

            @NotNull
            private String getText(DocumentEvent e) {
                String string;
                try {
                    string = e.getDocument().getText(0, e.getDocument().getLength());
                }
                catch (BadLocationException e1) {
                    if ("" == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return "";
                }
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/flags/StudioFlagsDialog$1", "getText"));
            }
        });
        this.init();
        ApplicationManager.getApplication().invokeLater(() -> this.myScrollPane.getVerticalScrollBar().setValue(0), ModalityState.any());
    }

    private void setPreferredBounds(@Nullable Project project) {
        Window window = WindowManager.getInstance().suggestParentWindow(project);
        if (window != null) {
            Rectangle bounds = window.getBounds();
            bounds.grow(-(bounds.width / 4), -(bounds.height / 6));
            this.setInitialLocationCallback(() -> bounds.getLocation());
            this.myRootPanel.setPreferredSize(bounds.getSize());
        }
    }

    @Nullable
    public Point getInitialLocation() {
        return super.getInitialLocation();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.mySearchTextField;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return DIMENSION_KEY;
    }

    private void searchTextChanged(@NotNull String text) {
        if (text == null) {
            StudioFlagsDialog.$$$reportNull$$$0(0);
        }
        this.updateFlagsComponents(text);
        this.myContentPanel.revalidate();
        this.myContentPanel.repaint();
    }

    private void updateFlagsComponents(@Nullable String searchText) {
        this.myContentPanel.removeAll();
        this.myContentPanel.setLayout((LayoutManager)StudioFlagsDialog.getFlagsPanelDefaultLayout());
        this.myGroupedFlags.asMap().entrySet().stream().sorted(Comparator.comparing(entry -> ((FlagGroup)entry.getKey()).getDisplayName())).forEach(entry -> {
            FlagGroup group = (FlagGroup)entry.getKey();
            List flagMatches = ((Collection)entry.getValue()).stream().filter(flag -> StudioFlagsDialog.showFlag(flag, searchText)).collect(Collectors.toList());
            if (flagMatches.isEmpty()) {
                return;
            }
            JPanel groupPanel = new JPanel((LayoutManager)new VerticalFlowLayout(5, 0));
            TitledBorder titledBorder = BorderFactory.createTitledBorder(group.getDisplayName());
            titledBorder.setTitleFont(titledBorder.getTitleFont().deriveFont(1, titledBorder.getTitleFont().getSize() + 2));
            groupPanel.setBorder(titledBorder);
            boolean firstFlag = true;
            for (Flag flag2 : flagMatches) {
                JPanel flagPanel = new JPanel((LayoutManager)new VerticalFlowLayout(5, 0));
                if (!firstFlag) {
                    flagPanel.add(new JSeparator(0));
                }
                JBLabel name = new JBLabel(flag2.getDisplayName());
                name.setFont(UIUtil.getLabelFont().deriveFont(1));
                name.setToolTipText(flag2.getId());
                JTextArea description = new JTextArea(flag2.getDescription());
                description.setFont(UIUtil.getLabelFont());
                description.setLineWrap(true);
                description.setWrapStyleWord(true);
                description.setEditable(false);
                description.setOpaque(false);
                description.setForeground(UIUtil.getInactiveTextColor());
                final FlagEditor<?> flagEditor = this.createFlagEditor(flag2);
                HyperlinkLabel resetLink = new HyperlinkLabel("Reset to default");
                resetLink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

                    protected void hyperlinkActivated(HyperlinkEvent e) {
                        flagEditor.flagProperty().clearOverride();
                    }
                });
                this.myBindings.bind(new VisibleProperty((JComponent)resetLink), flagEditor.flagProperty().isOverridden());
                JPanel flagEditorPanel = new JPanel(new FlowLayout(0, 5, 0));
                flagEditorPanel.add(flagEditor.editorComponent());
                flagEditorPanel.add((Component)resetLink);
                flagPanel.add((Component)name);
                flagPanel.add(description);
                flagPanel.add(flagEditorPanel);
                groupPanel.add(flagPanel);
                firstFlag = false;
            }
            this.myContentPanel.add(groupPanel);
        });
        boolean emptySearchResult = !StringUtil.isEmptyOrSpaces((String)searchText) && this.myContentPanel.getComponentCount() == 0;
        this.mySearchTextField.getTextEditor().setBackground(emptySearchResult ? LightColors.RED : UIUtil.getTextFieldBackground());
        if (emptySearchResult) {
            JLabel label = new JLabel();
            label.setText(UIBundle.message((String)"message.nothingToShow", (Object[])new Object[0]));
            label.setHorizontalAlignment(0);
            this.myContentPanel.setLayout(new BorderLayout());
            this.myContentPanel.add((Component)label, "Center");
        }
    }

    private static boolean showFlag(@NotNull Flag<?> flag, @Nullable String searchText) {
        if (flag == null) {
            StudioFlagsDialog.$$$reportNull$$$0(1);
        }
        return StringUtil.isEmptyOrSpaces((String)searchText) || StringUtil.containsIgnoreCase((String)flag.getDisplayName(), (String)searchText) || StringUtil.containsIgnoreCase((String)flag.getDescription(), (String)searchText);
    }

    private void replaceOverrides(FlagOverrides overridesDest, ImmutableFlagOverrides overridesSrc) {
        overridesDest.clear();
        for (Flag flag : this.myGroupedFlags.values()) {
            String flagValue = overridesSrc.get(flag);
            if (flagValue == null) continue;
            overridesDest.put(flag, flagValue);
        }
    }

    private static ListMultimap<FlagGroup, Flag<?>> collectAllFlags() {
        ArrayListMultimap allFlags = ArrayListMultimap.create();
        for (Field field2 : StudioFlags.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field2.getModifiers())) continue;
            try {
                Object instance = field2.get(null);
                if (!(instance instanceof Flag)) continue;
                Flag flag = (Flag)instance;
                allFlags.put((Object)flag.getGroup(), (Object)flag);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return allFlags;
    }

    @NotNull
    private FlagEditor<?> createFlagEditor(Flag<?> flag) {
        if (flag.get().getClass() == Boolean.class) {
            final Flag<?> boolFlag = flag;
            FlagEditor<Boolean> flagEditor = new FlagEditor<Boolean>(){
                FlagProperty<Boolean> myFlagProperty;
                {
                    this.myFlagProperty = new FlagProperty(boolFlag);
                }

                @Override
                @NotNull
                public FlagProperty<Boolean> flagProperty() {
                    FlagProperty<Boolean> flagProperty = this.myFlagProperty;
                    if (flagProperty == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return flagProperty;
                }

                @Override
                @NotNull
                public JComponent editorComponent() {
                    JPanel choicesPanel = new JPanel(new FlowLayout(0, 2, 0));
                    JRadioButton onButton = new JRadioButton("On");
                    JRadioButton offButton = new JRadioButton("Off");
                    ButtonGroup group = new ButtonGroup();
                    group.add(onButton);
                    group.add(offButton);
                    StudioFlagsDialog.this.myBindings.bind(new SelectedProperty(onButton), this.myFlagProperty);
                    StudioFlagsDialog.this.myBindings.bind(new SelectedProperty(offButton), BooleanExpressions.not(this.myFlagProperty));
                    onButton.addActionListener(l -> this.myFlagProperty.set(true));
                    offButton.addActionListener(l -> this.myFlagProperty.set(false));
                    choicesPanel.add(onButton);
                    choicesPanel.add(offButton);
                    JPanel jPanel = choicesPanel;
                    if (jPanel == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    return jPanel;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/android/tools/idea/flags/StudioFlagsDialog$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "flagProperty";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "editorComponent";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
            if (flagEditor == null) {
                StudioFlagsDialog.$$$reportNull$$$0(2);
            }
            return flagEditor;
        }
        throw new IllegalStateException(String.format("Unhandled flag type (\"%s\"): Flag<%s>", flag.getId(), flag.get().getClass().getSimpleName()));
    }

    public void doCancelAction() {
        this.replaceOverrides((FlagOverrides)StudioFlagSettings.getInstance(), this.myBackupOverrides);
        super.doCancelAction();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            StudioFlagsDialog.$$$reportNull$$$0(3);
        }
        return actionArray;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myRootPanel;
    }

    private void createUIComponents() {
        this.myContentPanel = new JPanel((LayoutManager)StudioFlagsDialog.getFlagsPanelDefaultLayout());
    }

    @NotNull
    private static VerticalFlowLayout getFlagsPanelDefaultLayout() {
        VerticalFlowLayout verticalFlowLayout = new VerticalFlowLayout(5, 15);
        if (verticalFlowLayout == null) {
            StudioFlagsDialog.$$$reportNull$$$0(4);
        }
        return verticalFlowLayout;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flag";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/flags/StudioFlagsDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/flags/StudioFlagsDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFlagEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlagsPanelDefaultLayout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "searchTextChanged";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "showFlag";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBScrollPane jBScrollPane;
        SearchTextField searchTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jPanel2, "North");
        this.mySearchTextField = searchTextField = new SearchTextField();
        jPanel2.add((Component)searchTextField, "Center");
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel.add((Component)jBScrollPane, "Center");
        JPanel jPanel3 = this.myContentPanel;
        jBScrollPane.setViewportView(jPanel3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private static final class FlagProperty<T>
    extends AbstractProperty<T> {
        private final Flag<T> myFlag;
        private final BoolProperty myOverridden;

        public FlagProperty(Flag<T> flag) {
            this.myFlag = flag;
            this.myOverridden = new BoolValueProperty(this.myFlag.isOverridden());
        }

        @Override
        @NotNull
        public T get() {
            T t = this.myFlag.get();
            if (t == null) {
                FlagProperty.$$$reportNull$$$0(0);
            }
            return t;
        }

        public ObservableBool isOverridden() {
            return this.myOverridden;
        }

        @Override
        protected void setDirectly(@NotNull T value) {
            if (value == null) {
                FlagProperty.$$$reportNull$$$0(1);
            }
            this.myFlag.override(value);
            this.myOverridden.set(true);
        }

        public void clearOverride() {
            this.myFlag.clearOverride();
            this.myOverridden.set(false);
            this.notifyInvalidated();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/flags/StudioFlagsDialog$FlagProperty";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/flags/StudioFlagsDialog$FlagProperty";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setDirectly";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface FlagEditor<T> {
        @NotNull
        public FlagProperty<T> flagProperty();

        @NotNull
        public JComponent editorComponent();
    }
}

