/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.build.OutputFile;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.InstantAppProjectBuildOutput;
import com.android.builder.model.InstantAppVariantBuildOutput;
import com.android.builder.model.ProjectBuildOutput;
import com.android.builder.model.VariantBuildOutput;
import com.android.tools.idea.apk.viewer.ApkFileSystem;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.run.OutputBuildAction;
import com.android.tools.idea.gradle.run.PostBuildModel;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoToApkLocationTask
implements GradleBuildInvoker.AfterGradleInvocationTask {
    public static final String ANALYZE = "analyze:";
    public static final String MODULE = "module:";
    @NotNull
    private final Project myProject;
    @Nullable
    private final Collection<Module> myModules;
    @NotNull
    private final String myNotificationTitle;
    private Map<Module, File> myModulesAndApkPaths;

    public GoToApkLocationTask(@NotNull Map<Module, File> modulesAndPaths, @NotNull String notificationTitle) {
        if (modulesAndPaths == null) {
            GoToApkLocationTask.$$$reportNull$$$0(0);
        }
        if (notificationTitle == null) {
            GoToApkLocationTask.$$$reportNull$$$0(1);
        }
        this(modulesAndPaths.entrySet().iterator().next().getKey().getProject(), modulesAndPaths, null, notificationTitle);
    }

    public GoToApkLocationTask(@NotNull Collection<Module> modules, @NotNull String notificationTitle) {
        if (modules == null) {
            GoToApkLocationTask.$$$reportNull$$$0(2);
        }
        if (notificationTitle == null) {
            GoToApkLocationTask.$$$reportNull$$$0(3);
        }
        this(modules.iterator().next().getProject(), null, modules, notificationTitle);
    }

    @VisibleForTesting
    GoToApkLocationTask(@NotNull Project project, @Nullable Map<Module, File> modulesAndPaths, @Nullable Collection<Module> modules, @NotNull String notificationTitle) {
        if (project == null) {
            GoToApkLocationTask.$$$reportNull$$$0(4);
        }
        if (notificationTitle == null) {
            GoToApkLocationTask.$$$reportNull$$$0(5);
        }
        this.myProject = project;
        this.myModulesAndApkPaths = modulesAndPaths;
        this.myModules = modules;
        this.myNotificationTitle = notificationTitle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(@NotNull GradleInvocationResult result2) {
        if (result2 == null) {
            GoToApkLocationTask.$$$reportNull$$$0(6);
        }
        try {
            String moduleName;
            if (this.myModulesAndApkPaths == null) {
                this.myModulesAndApkPaths = this.getModulesAndPaths(result2.getModel());
            }
            ArrayList<String> moduleNames = new ArrayList<String>();
            HashMap<String, File> apkPathsByModule = new HashMap<String, File>();
            for (Map.Entry<Module, File> moduleAndApkPath : this.myModulesAndApkPaths.entrySet()) {
                Module module = moduleAndApkPath.getKey();
                File apkPath = moduleAndApkPath.getValue();
                if (apkPath == null) continue;
                moduleName = module.getName();
                moduleNames.add(moduleName);
                apkPathsByModule.put(moduleName, apkPath);
            }
            Collections.sort(moduleNames);
            AndroidNotification notification = AndroidNotification.getInstance(this.myProject);
            if (result2.isBuildSuccessful()) {
                StringBuilder buffer;
                if (ShowFilePathAction.isSupported()) {
                    buffer = new StringBuilder();
                    buffer.append("APK(s) generated successfully:<br/>");
                    int moduleCount = moduleNames.size();
                    for (int i = 0; i < moduleCount; ++i) {
                        moduleName = (String)moduleNames.get(i);
                        buffer.append("Module '").append(moduleName).append("': ");
                        buffer.append("<a href=\"").append(MODULE).append(moduleName).append("\">locate</a> or ");
                        buffer.append("<a href=\"").append(ANALYZE).append(moduleName).append("\">analyze</a> the APK.");
                        if (i >= moduleCount - 1) continue;
                        buffer.append("<br/>");
                    }
                    String text = buffer.toString();
                    notification.showBalloon(this.myNotificationTitle, text, NotificationType.INFORMATION, (NotificationListener)new OpenFolderNotificationListener(apkPathsByModule, this.myProject));
                } else {
                    buffer = new StringBuilder();
                    buffer.append("APK(s) generated successfully:\n");
                    int moduleCount = moduleNames.size();
                    for (int i = 0; i < moduleCount; ++i) {
                        moduleName = (String)moduleNames.get(i);
                        buffer.append(" - ").append(moduleName).append(": ");
                        buffer.append(((File)apkPathsByModule.get(moduleName)).getPath());
                        if (i >= moduleCount - 1) continue;
                        buffer.append("\n");
                    }
                    notification.showBalloon(this.myNotificationTitle, "APK(s) generated successfully.", NotificationType.INFORMATION, new OpenEventLogHyperlink());
                    notification.addLogEvent(this.myNotificationTitle, buffer.toString(), NotificationType.INFORMATION);
                }
            } else if (result2.isBuildCancelled()) {
                notification.showBalloon(this.myNotificationTitle, "Build cancelled.", NotificationType.INFORMATION);
            } else {
                String msg = "Errors while building APK. You can find the errors in the 'Messages' view.";
                notification.showBalloon(this.myNotificationTitle, msg, NotificationType.ERROR);
            }
        }
        finally {
            GradleBuildInvoker.getInstance(this.myProject).remove(this);
        }
    }

    @NotNull
    @VisibleForTesting
    Map<Module, File> getModulesAndPaths(@Nullable Object model) {
        assert (this.myModules != null);
        HashMap<Module, File> modulesAndPaths = new HashMap<Module, File>();
        PostBuildModel postBuildModel = null;
        if (model != null && model instanceof OutputBuildAction.PostBuildProjectModels) {
            postBuildModel = new PostBuildModel((OutputBuildAction.PostBuildProjectModels)model);
        }
        for (Module module : this.myModules) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(module);
            if (androidModel == null) continue;
            File outputFolderOrApk = null;
            if (postBuildModel != null && (outputFolderOrApk = GoToApkLocationTask.tryToGetOutputPostBuild(androidModel, module, postBuildModel)) == null) {
                outputFolderOrApk = GoToApkLocationTask.tryToGetOutputPostBuildInstantApp(androidModel, module, postBuildModel);
            }
            if (outputFolderOrApk == null) {
                outputFolderOrApk = GoToApkLocationTask.tryToGetOutputPreBuild(androidModel);
            }
            modulesAndPaths.put(module, outputFolderOrApk);
        }
        HashMap<Module, File> hashMap = modulesAndPaths;
        if (hashMap == null) {
            GoToApkLocationTask.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    @Nullable
    private static File tryToGetOutputPostBuild(@NotNull AndroidModuleModel androidModel, @NotNull Module module, @NotNull PostBuildModel postBuildModel) {
        ProjectBuildOutput projectBuildOutput;
        if (androidModel == null) {
            GoToApkLocationTask.$$$reportNull$$$0(8);
        }
        if (module == null) {
            GoToApkLocationTask.$$$reportNull$$$0(9);
        }
        if (postBuildModel == null) {
            GoToApkLocationTask.$$$reportNull$$$0(10);
        }
        if (androidModel.getAndroidProject().getProjectType() == 0 && (projectBuildOutput = postBuildModel.findProjectBuildOutput(module)) != null) {
            for (VariantBuildOutput variantBuildOutput : projectBuildOutput.getVariantsBuildOutput()) {
                if (!variantBuildOutput.getName().equals(androidModel.getSelectedVariant().getName())) continue;
                Collection outputs = variantBuildOutput.getOutputs();
                File outputFolderOrApk = outputs.size() == 1 ? ((OutputFile)outputs.iterator().next()).getOutputFile() : ((OutputFile)outputs.iterator().next()).getOutputFile().getParentFile();
                return outputFolderOrApk;
            }
        }
        return null;
    }

    @Nullable
    private static File tryToGetOutputPostBuildInstantApp(@NotNull AndroidModuleModel androidModel, @NotNull Module module, @NotNull PostBuildModel postBuildModel) {
        InstantAppProjectBuildOutput instantAppProjectBuildOutput;
        if (androidModel == null) {
            GoToApkLocationTask.$$$reportNull$$$0(11);
        }
        if (module == null) {
            GoToApkLocationTask.$$$reportNull$$$0(12);
        }
        if (postBuildModel == null) {
            GoToApkLocationTask.$$$reportNull$$$0(13);
        }
        if (androidModel.getAndroidProject().getProjectType() == 4 && (instantAppProjectBuildOutput = postBuildModel.findInstantAppProjectBuildOutput(module)) != null) {
            for (InstantAppVariantBuildOutput variantBuildOutput : instantAppProjectBuildOutput.getInstantAppVariantsBuildOutput()) {
                if (!variantBuildOutput.getName().equals(androidModel.getSelectedVariant().getName())) continue;
                return variantBuildOutput.getOutput().getOutputFile();
            }
        }
        return null;
    }

    @Nullable
    private static File tryToGetOutputPreBuild(@NotNull AndroidModuleModel androidModel) {
        Collection outputs;
        if (androidModel == null) {
            GoToApkLocationTask.$$$reportNull$$$0(14);
        }
        if ((outputs = androidModel.getMainArtifact().getOutputs()).size() == 1) {
            return ((AndroidArtifactOutput)outputs.iterator().next()).getOutputFile();
        }
        return ((AndroidArtifactOutput)outputs.iterator().next()).getOutputFile().getParentFile();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesAndPaths";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationTitle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/actions/GoToApkLocationTask";
                break;
            }
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postBuildModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/actions/GoToApkLocationTask";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesAndPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryToGetOutputPostBuild";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "tryToGetOutputPostBuildInstantApp";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "tryToGetOutputPreBuild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OpenEventLogHyperlink
    extends NotificationHyperlink {
        OpenEventLogHyperlink() {
            super("open.event.log", "Show APK path(s) in the 'Event Log' view");
        }

        @Override
        protected void execute(@NotNull Project project) {
            ToolWindow tw;
            if (project == null) {
                OpenEventLogHyperlink.$$$reportNull$$$0(0);
            }
            if ((tw = ToolWindowManager.getInstance((Project)project).getToolWindow("Event Log")) != null) {
                tw.activate(null, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/actions/GoToApkLocationTask$OpenEventLogHyperlink", "execute"));
        }
    }

    @VisibleForTesting
    static class OpenFolderNotificationListener
    extends NotificationListener.Adapter {
        @NotNull
        private final Map<String, File> myApkPathsPerModule;
        @NotNull
        private final Project myProject;

        OpenFolderNotificationListener(@NotNull Map<String, File> apkPathsPerModule, @NotNull Project project) {
            if (apkPathsPerModule == null) {
                OpenFolderNotificationListener.$$$reportNull$$$0(0);
            }
            if (project == null) {
                OpenFolderNotificationListener.$$$reportNull$$$0(1);
            }
            this.myApkPathsPerModule = apkPathsPerModule;
            this.myProject = project;
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
            String description;
            if (notification == null) {
                OpenFolderNotificationListener.$$$reportNull$$$0(2);
            }
            if (e == null) {
                OpenFolderNotificationListener.$$$reportNull$$$0(3);
            }
            if ((description = e.getDescription()).startsWith(GoToApkLocationTask.ANALYZE)) {
                VirtualFile apk;
                File apkPath = this.myApkPathsPerModule.get(description.substring(GoToApkLocationTask.ANALYZE.length()));
                if (apkPath.isFile()) {
                    apk = LocalFileSystem.getInstance().findFileByIoFile(apkPath);
                } else {
                    FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor().withDescription("Select APK to analyze").withFileFilter(file -> ApkFileSystem.EXTENSIONS.contains(file.getExtension()));
                    apk = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)this.myProject, (VirtualFile)LocalFileSystem.getInstance().findFileByIoFile(apkPath));
                }
                if (apk != null) {
                    OpenFileDescriptor fd = new OpenFileDescriptor(this.myProject, apk);
                    FileEditorManager.getInstance((Project)this.myProject).openEditor(fd, true);
                }
            } else if (description.startsWith(GoToApkLocationTask.MODULE)) {
                File apkPath = this.myApkPathsPerModule.get(description.substring(GoToApkLocationTask.MODULE.length()));
                assert (apkPath != null);
                if (apkPath.isFile()) {
                    apkPath = apkPath.getParentFile();
                }
                ShowFilePathAction.openDirectory((File)apkPath);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            OpenFolderNotificationListener listener2 = (OpenFolderNotificationListener)((Object)o);
            return Objects.equals(this.myApkPathsPerModule, listener2.myApkPathsPerModule);
        }

        public int hashCode() {
            return Objects.hash(this.myApkPathsPerModule);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "apkPathsPerModule";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/actions/GoToApkLocationTask$OpenFolderNotificationListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hyperlinkActivated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

