/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.builder.model.AppBundleProjectBuildOutput;
import com.android.builder.model.AppBundleVariantBuildOutput;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.run.OutputBuildAction;
import com.android.tools.idea.gradle.run.PostBuildModel;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoToBundleLocationTask
implements GradleBuildInvoker.AfterGradleInvocationTask {
    public static final String ANALYZE_URL_PREFIX = "analyze:";
    public static final String LOCATE_URL_PREFIX = "module:";
    public static final String LOCATE_KEY_URL_PREFIX = "key:";
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myNotificationTitle;
    @Nullable
    private final Collection<Module> myModules;
    @Nullable
    private final File myExportedKeyFile;
    @Nullable
    private Map<Module, File> myModulesAndBundlePaths;

    public GoToBundleLocationTask(@NotNull Project project, @NotNull String notificationTitle, @NotNull Collection<Module> modules) {
        if (project == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(0);
        }
        if (notificationTitle == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(1);
        }
        if (modules == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(2);
        }
        this(project, notificationTitle, modules, null, null);
    }

    public GoToBundleLocationTask(@NotNull Project project, @NotNull String notificationTitle, @NotNull Map<Module, File> modulesAndBundlePaths) {
        if (project == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(3);
        }
        if (notificationTitle == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(4);
        }
        if (modulesAndBundlePaths == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(5);
        }
        this(project, notificationTitle, null, modulesAndBundlePaths, null);
    }

    public GoToBundleLocationTask(@NotNull Project project, @NotNull String notificationTitle, @NotNull Map<Module, File> modulesAndBundlePaths, @NotNull File exportedKeyFile) {
        if (project == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(6);
        }
        if (notificationTitle == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(7);
        }
        if (modulesAndBundlePaths == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(8);
        }
        if (exportedKeyFile == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(9);
        }
        this(project, notificationTitle, null, modulesAndBundlePaths, exportedKeyFile);
    }

    @VisibleForTesting
    GoToBundleLocationTask(@NotNull Project project, @NotNull String notificationTitle, @Nullable Collection<Module> modules, @Nullable Map<Module, File> modulesAndPaths, @Nullable File exportedKeyFile) {
        if (project == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(10);
        }
        if (notificationTitle == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(11);
        }
        this.myProject = project;
        this.myNotificationTitle = notificationTitle;
        this.myModulesAndBundlePaths = modulesAndPaths;
        this.myModules = modules;
        this.myExportedKeyFile = exportedKeyFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(@NotNull GradleInvocationResult result2) {
        if (result2 == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(12);
        }
        try {
            if (this.myModulesAndBundlePaths == null) {
                this.myModulesAndBundlePaths = this.getModulesAndPaths(result2.getModel());
            }
            SortedMap<String, File> bundlePathsByModule = GoToBundleLocationTask.sortModules(this.myModulesAndBundlePaths);
            AndroidNotification notification = AndroidNotification.getInstance(this.myProject);
            if (result2.isBuildSuccessful()) {
                this.notifySuccess(notification, bundlePathsByModule);
            } else if (result2.isBuildCancelled()) {
                notification.showBalloon(this.myNotificationTitle, "Build cancelled.", NotificationType.INFORMATION);
            } else {
                String msg = "Errors while building Bundle file. You can find the errors in the 'Messages' view.";
                notification.showBalloon(this.myNotificationTitle, msg, NotificationType.ERROR);
            }
        }
        finally {
            GradleBuildInvoker.getInstance(this.myProject).remove(this);
        }
    }

    private void notifySuccess(@NotNull AndroidNotification notification, @NotNull SortedMap<String, File> bundlePathsByModule) {
        if (notification == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(13);
        }
        if (bundlePathsByModule == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(14);
        }
        if (ShowFilePathAction.isSupported()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("App bundle(s) generated successfully:<br/>");
            int moduleIndex = 0;
            for (Map.Entry<String, File> entry : bundlePathsByModule.entrySet()) {
                String moduleName = entry.getKey();
                buffer.append("Module '").append(moduleName).append("': ");
                buffer.append("<a href=\"").append(LOCATE_URL_PREFIX).append(moduleName).append("\">locate</a> or ");
                buffer.append("<a href=\"").append(ANALYZE_URL_PREFIX).append(moduleName).append("\">analyze</a> the app bundle.");
                if (moduleIndex >= bundlePathsByModule.size() - 1) continue;
                buffer.append("<br/>");
            }
            if (this.myExportedKeyFile != null) {
                buffer.append("<br/>");
                buffer.append("<a href=\"").append(LOCATE_KEY_URL_PREFIX).append("\">Locate</a> exported key file.");
            }
            String text = buffer.toString();
            notification.showBalloon(this.myNotificationTitle, text, NotificationType.INFORMATION, (NotificationListener)new OpenFolderNotificationListener(this.myProject, bundlePathsByModule, this.myExportedKeyFile));
        } else {
            StringBuilder buffer = new StringBuilder();
            buffer.append("App bundle(s) generated successfully:\n");
            int moduleIndex = 0;
            for (Map.Entry<String, File> entry : bundlePathsByModule.entrySet()) {
                String moduleName = entry.getKey();
                buffer.append(" - ").append(moduleName).append(": ");
                buffer.append(entry.getValue().getPath());
                if (moduleIndex >= bundlePathsByModule.size() - 1) continue;
                buffer.append("\n");
            }
            notification.showBalloon(this.myNotificationTitle, "App bundle(s) generated successfully.", NotificationType.INFORMATION, new OpenEventLogHyperlink());
            notification.addLogEvent(this.myNotificationTitle, buffer.toString(), NotificationType.INFORMATION);
        }
    }

    @NotNull
    @VisibleForTesting
    Map<Module, File> getModulesAndPaths(@Nullable Object model) {
        assert (this.myModules != null);
        HashMap<Module, File> modulesAndPaths = new HashMap<Module, File>();
        if (model instanceof OutputBuildAction.PostBuildProjectModels) {
            PostBuildModel postBuildModel = new PostBuildModel((OutputBuildAction.PostBuildProjectModels)model);
            for (Module module : this.myModules) {
                File bundleFile;
                AndroidModuleModel androidModel = AndroidModuleModel.get(module);
                if (androidModel == null || (bundleFile = GoToBundleLocationTask.tryToGetOutputPostBuildBundleFile(androidModel, module, postBuildModel)) == null) continue;
                modulesAndPaths.put(module, bundleFile);
            }
        }
        HashMap<Module, File> hashMap = modulesAndPaths;
        if (hashMap == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(15);
        }
        return hashMap;
    }

    @NotNull
    private static SortedMap<String, File> sortModules(@NotNull Map<Module, File> modulesAndBundlePaths) {
        if (modulesAndBundlePaths == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(16);
        }
        TreeMap<String, File> bundlePathsByModule = new TreeMap<String, File>();
        for (Map.Entry<Module, File> moduleAndBundlePath : modulesAndBundlePaths.entrySet()) {
            Module module = moduleAndBundlePath.getKey();
            File bundlePath = moduleAndBundlePath.getValue();
            if (bundlePath == null) continue;
            String moduleName = module.getName();
            bundlePathsByModule.put(moduleName, bundlePath);
        }
        TreeMap<String, File> treeMap = bundlePathsByModule;
        if (treeMap == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(17);
        }
        return treeMap;
    }

    @Nullable
    private static File tryToGetOutputPostBuildBundleFile(@NotNull AndroidModuleModel androidModel, @NotNull Module module, @NotNull PostBuildModel postBuildModel) {
        AppBundleProjectBuildOutput appBundleProjectBuildOutput;
        if (androidModel == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(18);
        }
        if (module == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(19);
        }
        if (postBuildModel == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(20);
        }
        if (androidModel.getAndroidProject().getProjectType() == 0 && (appBundleProjectBuildOutput = postBuildModel.findAppBundleProjectBuildOutput(module)) != null) {
            for (AppBundleVariantBuildOutput variantBuildOutput : appBundleProjectBuildOutput.getAppBundleVariantsBuildOutput()) {
                if (!variantBuildOutput.getName().equals(androidModel.getSelectedVariant().getName())) continue;
                return variantBuildOutput.getBundleFile();
            }
        }
        return null;
    }

    private static Logger getLog() {
        return Logger.getInstance(GoToBundleLocationTask.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationTitle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 5: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesAndBundlePaths";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportedKeyFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundlePathsByModule";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/actions/GoToBundleLocationTask";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postBuildModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/actions/GoToBundleLocationTask";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesAndPaths";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "sortModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "notifySuccess";
                break;
            }
            case 15: 
            case 17: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sortModules";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "tryToGetOutputPostBuildBundleFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OpenEventLogHyperlink
    extends NotificationHyperlink {
        OpenEventLogHyperlink() {
            super("open.event.log", "Show app bundle path(s) in the 'Event Log' view");
        }

        @Override
        protected void execute(@NotNull Project project) {
            ToolWindow tw;
            if (project == null) {
                OpenEventLogHyperlink.$$$reportNull$$$0(0);
            }
            if ((tw = ToolWindowManager.getInstance((Project)project).getToolWindow("Event Log")) != null) {
                tw.activate(null, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/actions/GoToBundleLocationTask$OpenEventLogHyperlink", "execute"));
        }
    }

    @VisibleForTesting
    static class OpenFolderNotificationListener
    extends NotificationListener.Adapter {
        @NotNull
        private final Project myProject;
        @NotNull
        private final Map<String, File> myBundlePathsPerModule;
        @Nullable
        private final File myExportedKeyFile;

        OpenFolderNotificationListener(@NotNull Project project, @NotNull Map<String, File> apkPathsPerModule, @Nullable File exportedKeyFile) {
            if (project == null) {
                OpenFolderNotificationListener.$$$reportNull$$$0(0);
            }
            if (apkPathsPerModule == null) {
                OpenFolderNotificationListener.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myBundlePathsPerModule = apkPathsPerModule;
            this.myExportedKeyFile = exportedKeyFile;
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
            if (notification == null) {
                OpenFolderNotificationListener.$$$reportNull$$$0(2);
            }
            if (e == null) {
                OpenFolderNotificationListener.$$$reportNull$$$0(3);
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            String description = e.getDescription();
            if (description.startsWith(GoToBundleLocationTask.ANALYZE_URL_PREFIX)) {
                this.openBundleAnalyzer(description.substring(GoToBundleLocationTask.ANALYZE_URL_PREFIX.length()));
            } else if (description.startsWith(GoToBundleLocationTask.LOCATE_URL_PREFIX)) {
                this.openBundleDirectory(description.substring(GoToBundleLocationTask.LOCATE_URL_PREFIX.length()));
            } else if (description.startsWith(GoToBundleLocationTask.LOCATE_KEY_URL_PREFIX)) {
                this.openKeyDirectory();
            }
        }

        private void openBundleAnalyzer(@NotNull String bundlePath) {
            File bundleFile;
            if (bundlePath == null) {
                OpenFolderNotificationListener.$$$reportNull$$$0(4);
            }
            if ((bundleFile = this.myBundlePathsPerModule.get(bundlePath)) == null) {
                GoToBundleLocationTask.getLog().warn(String.format("Error finding bundle file \"%s\"", bundlePath));
                return;
            }
            if (!bundleFile.isFile()) {
                GoToBundleLocationTask.getLog().warn(String.format("Bundle file is not a file (directory?) \"%s\"", bundlePath));
                return;
            }
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(bundleFile);
            if (virtualFile == null) {
                GoToBundleLocationTask.getLog().warn(String.format("Bundle file not found in virtual file system \"%s\"", bundlePath));
                return;
            }
            OpenFileDescriptor fd = new OpenFileDescriptor(this.myProject, virtualFile);
            List editors = FileEditorManager.getInstance((Project)this.myProject).openEditor(fd, true);
            if (editors.isEmpty()) {
                GoToBundleLocationTask.getLog().warn(String.format("Could not open editor for bundle file \"%s\"", bundlePath));
            }
        }

        private void openBundleDirectory(String path) {
            OpenFolderNotificationListener.showFileOrDirectory(this.myBundlePathsPerModule.get(path));
        }

        private void openKeyDirectory() {
            assert (this.myExportedKeyFile != null);
            OpenFolderNotificationListener.showFileOrDirectory(this.myExportedKeyFile);
        }

        private static void showFileOrDirectory(@NotNull File file) {
            if (file == null) {
                OpenFolderNotificationListener.$$$reportNull$$$0(5);
            }
            if (file.isFile()) {
                ShowFilePathAction.openFile((File)file);
            } else {
                ShowFilePathAction.openDirectory((File)file.getParentFile());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            OpenFolderNotificationListener listener2 = (OpenFolderNotificationListener)((Object)o);
            return Objects.equals(this.myBundlePathsPerModule, listener2.myBundlePathsPerModule);
        }

        public int hashCode() {
            return Objects.hash(this.myBundlePathsPerModule);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "apkPathsPerModule";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bundlePath";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/actions/GoToBundleLocationTask$OpenFolderNotificationListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hyperlinkActivated";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "openBundleAnalyzer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showFileOrDirectory";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

