/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.FileDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.FileTreeDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ModuleDependencyModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpecImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.FileDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.FileTreeDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.ModuleDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependenciesDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependenciesModelImpl
extends GradleDslBlockModel
implements DependenciesModel {
    public DependenciesModelImpl(@NotNull DependenciesDslElement dslElement) {
        if (dslElement == null) {
            DependenciesModelImpl.$$$reportNull$$$0(0);
        }
        super(dslElement);
    }

    @Override
    @NotNull
    public List<DependencyModel> all() {
        ArrayList dependencies = Lists.newArrayList();
        for (GradleDslElement element : this.myDslElement.getAllPropertyElements()) {
            DependencyModel model;
            String configurationName = element.getName();
            dependencies.addAll(ArtifactDependencyModelImpl.create(configurationName, element));
            if (!(element instanceof GradleDslMethodCall)) continue;
            GradleDslMethodCall methodCall = (GradleDslMethodCall)element;
            if (methodCall.getMethodName().equals("project")) {
                model = ModuleDependencyModelImpl.create(configurationName, methodCall);
                if (model == null || model.path().getValueType() == GradlePropertyModel.ValueType.NONE) continue;
                dependencies.add(model);
                continue;
            }
            if (methodCall.getMethodName().equals("files")) {
                dependencies.addAll(FileDependencyModelImpl.create(configurationName, methodCall));
                continue;
            }
            if (!methodCall.getMethodName().equals("fileTree") || (model = FileTreeDependencyModelImpl.create(this.myDslElement, methodCall, configurationName)) == null || model.dir().getValueType() == GradlePropertyModel.ValueType.NONE) continue;
            dependencies.add(model);
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            DependenciesModelImpl.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<ArtifactDependencyModel> artifacts(@NotNull String configurationName) {
        if (configurationName == null) {
            DependenciesModelImpl.$$$reportNull$$$0(2);
        }
        ArrayList dependencies = Lists.newArrayList();
        this.addArtifacts(configurationName, dependencies);
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            DependenciesModelImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<ArtifactDependencyModel> artifacts() {
        ArrayList dependencies = Lists.newArrayList();
        for (GradleDslElement element : this.myDslElement.getAllPropertyElements()) {
            dependencies.addAll(ArtifactDependencyModelImpl.create(element.getName(), element));
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            DependenciesModelImpl.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private void addArtifacts(@NotNull String configurationName, @NotNull List<ArtifactDependencyModel> dependencies) {
        if (configurationName == null) {
            DependenciesModelImpl.$$$reportNull$$$0(5);
        }
        if (dependencies == null) {
            DependenciesModelImpl.$$$reportNull$$$0(6);
        }
        List<GradleDslElement> list = this.myDslElement.getPropertyElementsByName(configurationName);
        for (GradleDslElement element : list) {
            dependencies.addAll(ArtifactDependencyModelImpl.create(configurationName, element));
        }
    }

    @Override
    public boolean containsArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency) {
        if (configurationName == null) {
            DependenciesModelImpl.$$$reportNull$$$0(7);
        }
        if (dependency == null) {
            DependenciesModelImpl.$$$reportNull$$$0(8);
        }
        for (ArtifactDependencyModel artifactDependencyModel : this.artifacts(configurationName)) {
            if (!ArtifactDependencySpecImpl.create(artifactDependencyModel).equals(dependency)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addArtifact(@NotNull String configurationName, @NotNull String compactNotation) {
        ArtifactDependencySpec dependency;
        if (configurationName == null) {
            DependenciesModelImpl.$$$reportNull$$$0(9);
        }
        if (compactNotation == null) {
            DependenciesModelImpl.$$$reportNull$$$0(10);
        }
        if ((dependency = ArtifactDependencySpecImpl.create(compactNotation)) == null) {
            String msg = String.format("'%1$s' is not a valid artifact dependency", compactNotation);
            throw new IllegalArgumentException(msg);
        }
        this.addArtifact(configurationName, dependency);
    }

    @Override
    public void addArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency) {
        if (configurationName == null) {
            DependenciesModelImpl.$$$reportNull$$$0(11);
        }
        if (dependency == null) {
            DependenciesModelImpl.$$$reportNull$$$0(12);
        }
        this.addArtifact(configurationName, dependency, Collections.emptyList());
    }

    @Override
    public void addArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency, @NotNull List<ArtifactDependencySpec> excludes) {
        if (configurationName == null) {
            DependenciesModelImpl.$$$reportNull$$$0(13);
        }
        if (dependency == null) {
            DependenciesModelImpl.$$$reportNull$$$0(14);
        }
        if (excludes == null) {
            DependenciesModelImpl.$$$reportNull$$$0(15);
        }
        ArtifactDependencyModelImpl.create(this.myDslElement, configurationName, dependency, excludes);
    }

    @Override
    public boolean replaceArtifactByPsiElement(@NotNull PsiElement psiElement, @NotNull ArtifactDependencySpec dependency) {
        GradleDslElement element;
        if (psiElement == null) {
            DependenciesModelImpl.$$$reportNull$$$0(16);
        }
        if (dependency == null) {
            DependenciesModelImpl.$$$reportNull$$$0(17);
        }
        if ((element = this.findByPsiElement(psiElement)) == null) {
            return false;
        }
        DependenciesModelImpl.performDependencyReplace(psiElement, element, dependency);
        return true;
    }

    @Override
    @NotNull
    public List<ModuleDependencyModel> modules() {
        ArrayList dependencies = Lists.newArrayList();
        for (GradleDslElement gradleDslElement : this.myDslElement.getPropertyElements(GradleDslMethodCall.class)) {
            ModuleDependencyModel model = ModuleDependencyModelImpl.create(gradleDslElement.getName(), (GradleDslMethodCall)gradleDslElement);
            if (model == null || model.path().getValueType() == GradlePropertyModel.ValueType.NONE) continue;
            dependencies.add(model);
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            DependenciesModelImpl.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @Override
    public void addModule(@NotNull String configurationName, @NotNull String path) {
        if (configurationName == null) {
            DependenciesModelImpl.$$$reportNull$$$0(19);
        }
        if (path == null) {
            DependenciesModelImpl.$$$reportNull$$$0(20);
        }
        this.addModule(configurationName, path, null);
    }

    @Override
    public void addModule(@NotNull String configurationName, @NotNull String path, @Nullable String config) {
        if (configurationName == null) {
            DependenciesModelImpl.$$$reportNull$$$0(21);
        }
        if (path == null) {
            DependenciesModelImpl.$$$reportNull$$$0(22);
        }
        ModuleDependencyModelImpl.create(this.myDslElement, configurationName, path, config);
    }

    @Override
    @NotNull
    public List<FileTreeDependencyModel> fileTrees() {
        ArrayList dependencies = Lists.newArrayList();
        for (GradleDslMethodCall element : this.myDslElement.getPropertyElements(GradleDslMethodCall.class)) {
            FileTreeDependencyModel model = FileTreeDependencyModelImpl.create(this.myDslElement, element, element.getName());
            if (model == null || model.dir().getValueType() == GradlePropertyModel.ValueType.NONE) continue;
            dependencies.add(model);
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            DependenciesModelImpl.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    @Override
    public void addFileTree(@NotNull String configurationName, @NotNull String dir) {
        if (configurationName == null) {
            DependenciesModelImpl.$$$reportNull$$$0(24);
        }
        if (dir == null) {
            DependenciesModelImpl.$$$reportNull$$$0(25);
        }
        this.addFileTree(configurationName, dir, null, null);
    }

    @Override
    public void addFileTree(@NotNull String configurationName, @NotNull String dir, @Nullable List<String> includes, @Nullable List<String> excludes) {
        if (configurationName == null) {
            DependenciesModelImpl.$$$reportNull$$$0(26);
        }
        if (dir == null) {
            DependenciesModelImpl.$$$reportNull$$$0(27);
        }
        FileTreeDependencyModelImpl.create(this.myDslElement, configurationName, dir, includes, excludes);
    }

    @Override
    @NotNull
    public List<FileDependencyModel> files() {
        ArrayList dependencies = Lists.newArrayList();
        for (GradleDslMethodCall element : this.myDslElement.getPropertyElements(GradleDslMethodCall.class)) {
            dependencies.addAll(FileDependencyModelImpl.create(element.getName(), element));
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            DependenciesModelImpl.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    @Override
    public void addFile(@NotNull String configurationName, @NotNull String file) {
        if (configurationName == null) {
            DependenciesModelImpl.$$$reportNull$$$0(29);
        }
        if (file == null) {
            DependenciesModelImpl.$$$reportNull$$$0(30);
        }
        FileDependencyModelImpl.create(this.myDslElement, configurationName, file);
    }

    @Override
    public void remove(@NotNull DependencyModel dependency) {
        if (dependency == null) {
            DependenciesModelImpl.$$$reportNull$$$0(31);
        }
        if (!(dependency instanceof DependencyModelImpl)) {
            Logger.getInstance(DependenciesModelImpl.class).warn("Tried to remove an unknown dependency type!");
            return;
        }
        GradleDslElement dependencyElement = ((DependencyModelImpl)dependency).getDslElement();
        GradleDslElement parent = dependencyElement.getParent();
        if (parent instanceof GradleDslMethodCall) {
            GradleDslMethodCall methodCall = (GradleDslMethodCall)parent;
            List<GradleDslExpression> arguments = methodCall.getArguments();
            if (arguments.size() == 1 && arguments.get(0).equals(dependencyElement)) {
                this.myDslElement.removeProperty(methodCall);
            } else {
                methodCall.remove(dependencyElement);
            }
        } else if (parent instanceof GradleDslExpressionList) {
            List<GradleDslExpression> expressions = ((GradleDslExpressionList)parent).getExpressions();
            if (expressions.size() == 1 && expressions.get(0).equals(dependencyElement)) {
                if (parent.getParent() instanceof GradleDslMethodCall) {
                    this.myDslElement.removeProperty(parent.getParent());
                } else {
                    this.myDslElement.removeProperty(parent);
                }
            } else {
                ((GradleDslExpressionList)parent).removeElement(dependencyElement);
            }
        } else {
            this.myDslElement.removeProperty(dependencyElement);
        }
    }

    private static void performDependencyReplace(@NotNull PsiElement psiElement, @NotNull GradleDslElement element, @NotNull ArtifactDependencySpec dependency) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (psiElement == null) {
                            DependenciesModelImpl.$$$reportNull$$$0(32);
                        }
                        if (element == null) {
                            DependenciesModelImpl.$$$reportNull$$$0(33);
                        }
                        if (dependency == null) {
                            DependenciesModelImpl.$$$reportNull$$$0(34);
                        }
                        if (!(element instanceof GradleDslLiteral)) break block5;
                        ((GradleDslLiteral)element).setValue(dependency.compactNotation());
                        break block6;
                    }
                    if (!(element instanceof GradleDslExpressionMap)) break block7;
                    DependenciesModelImpl.updateGradleExpressionMapWithDependency((GradleDslExpressionMap)element, dependency);
                    break block6;
                }
                if (!(element instanceof GradleDslMethodCall)) break block8;
                GradleDslMethodCall methodCall = (GradleDslMethodCall)element;
                for (GradleDslElement gradleDslElement : methodCall.getArguments()) {
                    if (gradleDslElement.getPsiElement() != psiElement) continue;
                    DependenciesModelImpl.performDependencyReplace(psiElement, gradleDslElement, dependency);
                }
                break block6;
            }
            if (!(element instanceof GradleDslExpressionList)) break block6;
            for (GradleDslSimpleExpression expression : ((GradleDslExpressionList)element).getSimpleExpressions()) {
                if (element.getPsiElement() != psiElement) continue;
                DependenciesModelImpl.performDependencyReplace(psiElement, expression, dependency);
            }
        }
    }

    private static void updateGradleExpressionMapWithDependency(@NotNull GradleDslExpressionMap map2, @NotNull ArtifactDependencySpec dependency) {
        String value;
        if (map2 == null) {
            DependenciesModelImpl.$$$reportNull$$$0(35);
        }
        if (dependency == null) {
            DependenciesModelImpl.$$$reportNull$$$0(36);
        }
        LinkedHashMap<String, Function<ArtifactDependencySpec, String>> properties = new LinkedHashMap<String, Function<ArtifactDependencySpec, String>>(ArtifactDependencySpecImpl.COMPONENT_MAP);
        for (Map.Entry<String, GradleDslElement> entry : map2.getPropertyElements().entrySet()) {
            if (properties.containsKey(entry.getKey())) {
                value = (String)((Function)properties.get(entry.getKey())).fun((Object)dependency);
                if (value == null) continue;
                map2.setNewLiteral(entry.getKey(), value);
                properties.remove(entry.getKey());
                continue;
            }
            map2.removeProperty(entry.getKey());
        }
        for (Map.Entry<String, GradleDslElement> entry : properties.entrySet()) {
            value = (String)((Function)entry.getValue()).fun((Object)dependency);
            if (value != null) {
                map2.addNewLiteral(entry.getKey(), value);
                continue;
            }
            map2.removeProperty(entry.getKey());
        }
    }

    private static boolean isChildOfParent(@NotNull PsiElement child, @NotNull PsiElement parent) {
        if (child == null) {
            DependenciesModelImpl.$$$reportNull$$$0(37);
        }
        if (parent == null) {
            DependenciesModelImpl.$$$reportNull$$$0(38);
        }
        ArrayList childElements = Lists.newArrayList((Object[])new PsiElement[]{parent});
        while (!childElements.isEmpty()) {
            PsiElement element = (PsiElement)childElements.remove(0);
            if (element.equals(child)) {
                return true;
            }
            childElements.addAll(Arrays.asList(element.getChildren()));
        }
        return false;
    }

    @Nullable
    private GradleDslElement findByPsiElement(@NotNull PsiElement child) {
        if (child == null) {
            DependenciesModelImpl.$$$reportNull$$$0(39);
        }
        for (String configurationName : this.myDslElement.getProperties()) {
            for (GradleDslElement element : this.myDslElement.getPropertyElementsByName(configurationName)) {
                if (element instanceof GradleDslMethodCall) {
                    GradleDslMethodCall methodCall = (GradleDslMethodCall)element;
                    for (GradleDslElement gradleDslElement : methodCall.getArguments()) {
                        if (gradleDslElement.getPsiElement() == null || !DependenciesModelImpl.isChildOfParent(child, gradleDslElement.getPsiElement())) continue;
                        return gradleDslElement;
                    }
                    continue;
                }
                if (element instanceof GradleDslExpressionList) {
                    for (GradleDslSimpleExpression e : ((GradleDslExpressionList)element).getSimpleExpressions()) {
                        if (e.getPsiElement() == null || !DependenciesModelImpl.isChildOfParent(child, e.getPsiElement())) continue;
                        return e;
                    }
                    continue;
                }
                if (element.getPsiElement() == null || !DependenciesModelImpl.isChildOfParent(child, element.getPsiElement())) continue;
                return element;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 18: 
            case 23: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 18: 
            case 23: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dslElement";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 18: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModelImpl";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 19: 
            case 21: 
            case 24: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 8: 
            case 12: 
            case 14: 
            case 17: 
            case 31: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compactNotation";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludes";
                break;
            }
            case 16: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModelImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "all";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "artifacts";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "modules";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "fileTrees";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 18: 
            case 23: 
            case 28: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "artifacts";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addArtifacts";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "containsArtifact";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addArtifact";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "replaceArtifactByPsiElement";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addModule";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addFileTree";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "performDependencyReplace";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "updateGradleExpressionMapWithDependency";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isChildOfParent";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findByPsiElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 18: 
            case 23: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

