/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.repositories;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoryModel;
import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.repositories.FlatDirRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.GoogleDefaultRepositoryModelImpl;
import com.android.tools.idea.gradle.dsl.model.repositories.JCenterDefaultRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.JCenterRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.MavenCentralRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.MavenRepositoryModelImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.FlatDirRepositoryDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.MavenRepositoryDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.RepositoriesDslElement;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RepositoriesModelImpl
extends GradleDslBlockModel
implements RepositoriesModel {
    public RepositoriesModelImpl(@NotNull RepositoriesDslElement dslElement) {
        if (dslElement == null) {
            RepositoriesModelImpl.$$$reportNull$$$0(0);
        }
        super(dslElement);
    }

    @Override
    @NotNull
    public List<RepositoryModel> repositories() {
        ArrayList result2 = Lists.newArrayList();
        for (GradleDslElement element : this.myDslElement.getAllPropertyElements()) {
            if (element instanceof GradleDslMethodCall) {
                String methodName = ((GradleDslMethodCall)element).getMethodName();
                if ("mavenCentral".equals(methodName)) {
                    result2.add(new MavenCentralRepositoryModel(this.myDslElement, element));
                    continue;
                }
                if ("jcenter".equals(methodName)) {
                    result2.add(new JCenterDefaultRepositoryModel(this.myDslElement, element));
                    continue;
                }
                if (!"google".equals(methodName)) continue;
                result2.add(new GoogleDefaultRepositoryModelImpl(this.myDslElement, element));
                continue;
            }
            if (element instanceof MavenRepositoryDslElement) {
                if ("maven".equals(element.getName())) {
                    result2.add(new MavenRepositoryModelImpl(this.myDslElement, (MavenRepositoryDslElement)element));
                    continue;
                }
                if (!"jcenter".equals(element.getName())) continue;
                result2.add(new JCenterRepositoryModel(this.myDslElement, (MavenRepositoryDslElement)element));
                continue;
            }
            if (element instanceof FlatDirRepositoryDslElement) {
                result2.add(new FlatDirRepositoryModel(this.myDslElement, (FlatDirRepositoryDslElement)element));
                continue;
            }
            if (!(element instanceof GradleDslExpressionMap)) continue;
            if ("mavenCentral".equals(element.getName())) {
                result2.add(new MavenCentralRepositoryModel(this.myDslElement, element));
                continue;
            }
            if (!"flatDir".equals(element.getName())) continue;
            result2.add(new FlatDirRepositoryModel(this.myDslElement, (GradlePropertiesDslElement)element));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            RepositoriesModelImpl.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    public void addRepositoryByMethodName(@NotNull String methodName) {
        if (methodName == null) {
            RepositoriesModelImpl.$$$reportNull$$$0(2);
        }
        if (this.containsMethodCall(methodName)) {
            return;
        }
        this.myDslElement.setNewElement(new GradleDslMethodCall((GradleDslElement)this.myDslElement, GradleNameElement.empty(), methodName));
    }

    @Override
    public void addFlatDirRepository(@NotNull String dirName) {
        List<FlatDirRepositoryDslElement> flatDirElements;
        if (dirName == null) {
            RepositoriesModelImpl.$$$reportNull$$$0(3);
        }
        if (!(flatDirElements = this.myDslElement.getPropertyElements(FlatDirRepositoryDslElement.class)).isEmpty()) {
            new FlatDirRepositoryModel(this.myDslElement, flatDirElements.get(0)).dirs().addListValue().setValue(dirName);
        } else {
            FlatDirRepositoryDslElement gradleDslElement = new FlatDirRepositoryDslElement(this.myDslElement);
            this.myDslElement.setNewElement(gradleDslElement);
            new FlatDirRepositoryModel(this.myDslElement, gradleDslElement).dirs().addListValue().setValue(dirName);
        }
    }

    @Override
    public boolean containsMethodCall(@NotNull String methodName) {
        if (methodName == null) {
            RepositoriesModelImpl.$$$reportNull$$$0(4);
        }
        List<GradleDslMethodCall> elements = this.myDslElement.getPropertyElements(GradleDslMethodCall.class);
        for (GradleDslMethodCall element : elements) {
            if (!methodName.equals(element.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addMavenRepositoryByUrl(@NotNull String url, @NotNull String name) {
        if (url == null) {
            RepositoriesModelImpl.$$$reportNull$$$0(5);
        }
        if (name == null) {
            RepositoriesModelImpl.$$$reportNull$$$0(6);
        }
        if (this.containsMavenRepositoryByUrl(url)) {
            return;
        }
        GradleNameElement nameElement = GradleNameElement.create("maven");
        MavenRepositoryDslElement newElement = new MavenRepositoryDslElement(this.myDslElement, nameElement);
        newElement.setNewLiteral("url", url);
        newElement.setNewLiteral("name", name);
        this.myDslElement.setNewElement(newElement);
    }

    @Override
    public boolean containsMavenRepositoryByUrl(@NotNull String repositoryUrl) {
        if (repositoryUrl == null) {
            RepositoriesModelImpl.$$$reportNull$$$0(7);
        }
        List<MavenRepositoryDslElement> elements = this.myDslElement.getPropertyElements(MavenRepositoryDslElement.class);
        for (MavenRepositoryDslElement element : elements) {
            String urlElement = element.getLiteral("url", String.class);
            if (!repositoryUrl.equals(urlElement)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasGoogleMavenRepository() {
        PsiElement psiElement = this.getPsiElement();
        if (psiElement == null) {
            return false;
        }
        Project project = this.getPsiElement().getProject();
        if (GradleVersions.getInstance().isGradle4OrNewer(project) && this.containsMethodCall("google")) {
            return true;
        }
        return this.containsMavenRepositoryByUrl("https://maven.google.com/");
    }

    @Override
    public void addGoogleMavenRepository(@NotNull Project project) {
        if (project == null) {
            RepositoriesModelImpl.$$$reportNull$$$0(8);
        }
        if (GradleVersions.getInstance().isGradle4OrNewer(project)) {
            this.addRepositoryByMethodName("google");
        } else {
            this.addMavenRepositoryByUrl("https://maven.google.com/", "Google");
        }
    }

    @Override
    public void addGoogleMavenRepository(@NotNull GradleVersion gradleVersion) {
        if (gradleVersion == null) {
            RepositoriesModelImpl.$$$reportNull$$$0(9);
        }
        if (gradleVersion.compareIgnoringQualifiers("4.0") >= 0) {
            this.addRepositoryByMethodName("google");
        } else {
            this.addMavenRepositoryByUrl("https://maven.google.com/", "Google");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dslElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/repositories/RepositoriesModelImpl";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryUrl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/repositories/RepositoriesModelImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "repositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addRepositoryByMethodName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addFlatDirRepository";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "containsMethodCall";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addMavenRepositoryByUrl";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "containsMavenRepositoryByUrl";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addGoogleMavenRepository";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

