/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser;

import com.android.tools.idea.gradle.dsl.api.BuildModelNotification;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.DependencyManager;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFileCache;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuildModelContext {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleDslFileCache myFileCache;
    @NotNull
    private final ClassToInstanceMap<BuildModelNotification> myNotifications;
    @NotNull
    private final DependencyManager myDependencyManager;

    @NotNull
    public static BuildModelContext create(@NotNull Project project) {
        if (project == null) {
            BuildModelContext.$$$reportNull$$$0(0);
        }
        BuildModelContext buildModelContext = new BuildModelContext(project);
        if (buildModelContext == null) {
            BuildModelContext.$$$reportNull$$$0(1);
        }
        return buildModelContext;
    }

    private BuildModelContext(@NotNull Project project) {
        if (project == null) {
            BuildModelContext.$$$reportNull$$$0(2);
        }
        this.myNotifications = MutableClassToInstanceMap.create();
        this.myProject = project;
        this.myFileCache = new GradleDslFileCache(project);
        this.myDependencyManager = DependencyManager.create();
    }

    @NotNull
    public DependencyManager getDependencyManager() {
        DependencyManager dependencyManager = this.myDependencyManager;
        if (dependencyManager == null) {
            BuildModelContext.$$$reportNull$$$0(3);
        }
        return dependencyManager;
    }

    @NotNull
    public List<BuildModelNotification> getPublicNotifications() {
        ArrayList<BuildModelNotification> arrayList = new ArrayList<BuildModelNotification>(this.myNotifications.values());
        if (arrayList == null) {
            BuildModelContext.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public <T extends BuildModelNotification> T getNotificationForType(@NotNull NotificationTypeReference<T> type) {
        if (type == null) {
            BuildModelContext.$$$reportNull$$$0(5);
        }
        if (this.myNotifications.containsKey(type.getClazz())) {
            BuildModelNotification buildModelNotification = (BuildModelNotification)this.myNotifications.getInstance(type.getClazz());
            if (buildModelNotification == null) {
                BuildModelContext.$$$reportNull$$$0(6);
            }
            return (T)buildModelNotification;
        }
        BuildModelNotification notification = (BuildModelNotification)type.getConstructor().produce();
        this.myNotifications.putInstance(type.getClazz(), (Object)notification);
        BuildModelNotification buildModelNotification = notification;
        if (buildModelNotification == null) {
            BuildModelContext.$$$reportNull$$$0(7);
        }
        return (T)buildModelNotification;
    }

    public void reset() {
        this.myFileCache.clearAllFiles();
    }

    @NotNull
    public GradleBuildFile getOrCreateBuildFile(@NotNull VirtualFile file, @NotNull String name) {
        if (file == null) {
            BuildModelContext.$$$reportNull$$$0(8);
        }
        if (name == null) {
            BuildModelContext.$$$reportNull$$$0(9);
        }
        GradleBuildFile gradleBuildFile = this.myFileCache.getOrCreateBuildFile(file, name, this);
        if (gradleBuildFile == null) {
            BuildModelContext.$$$reportNull$$$0(10);
        }
        return gradleBuildFile;
    }

    @NotNull
    public GradleBuildFile getOrCreateBuildFile(@NotNull VirtualFile file) {
        if (file == null) {
            BuildModelContext.$$$reportNull$$$0(11);
        }
        GradleBuildFile gradleBuildFile = this.getOrCreateBuildFile(file, file.getName());
        if (gradleBuildFile == null) {
            BuildModelContext.$$$reportNull$$$0(12);
        }
        return gradleBuildFile;
    }

    @Nullable
    public GradleSettingsFile getSettingsFile(@NotNull Project project) {
        if (project == null) {
            BuildModelContext.$$$reportNull$$$0(13);
        }
        return this.myFileCache.getSettingsFile(project);
    }

    @Nullable
    public GradleSettingsFile getOrCreateSettingsFile(@NotNull Project project) {
        if (project == null) {
            BuildModelContext.$$$reportNull$$$0(14);
        }
        return this.myFileCache.getOrCreateSettingsFile(project, this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/BuildModelContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/BuildModelContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublicNotifications";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationForType";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateBuildFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNotificationForType";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateBuildFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSettingsFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateSettingsFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

