/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.ElementState;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslBlockElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ElementSort;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GradlePropertiesDslElement
extends GradleDslElementImpl {
    @NotNull
    private static final Predicate<ElementList.ElementItem> VARIABLE_FILTER = e -> ((ElementList.ElementItem)e).myElement.getElementType() == PropertyType.VARIABLE;
    @NotNull
    private static final Predicate<ElementList.ElementItem> PROPERTY_FILTER = VARIABLE_FILTER.negate();
    @NotNull
    private static final Predicate<ElementList.ElementItem> ANY_FILTER = e -> true;
    @NotNull
    private final ElementList myProperties;

    protected GradlePropertiesDslElement(@Nullable GradleDslElement parent, @Nullable PsiElement psiElement, @NotNull GradleNameElement name) {
        if (name == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(0);
        }
        super(parent, psiElement, name);
        this.myProperties = new ElementList();
    }

    private void addPropertyInternal(@NotNull GradleDslElement element, @NotNull ElementState state) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(1);
        }
        if (state == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(2);
        }
        if (this instanceof ExtDslElement && state == ElementState.TO_BE_ADDED) {
            int index = this.reorderAndMaybeGetNewIndex(element);
            this.myProperties.addElementAtIndex(element, state, index, false);
        } else {
            this.myProperties.addElement(element, state, state == ElementState.EXISTING);
        }
        if (state == ElementState.TO_BE_ADDED) {
            this.updateDependenciesOnAddElement(element);
            element.setModified();
        }
    }

    private void addPropertyInternal(int index, @NotNull GradleDslElement element, @NotNull ElementState state) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(3);
        }
        if (state == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(4);
        }
        this.myProperties.addElementAtIndex(element, state, index, state == ElementState.EXISTING);
        if (state == ElementState.TO_BE_ADDED) {
            this.updateDependenciesOnAddElement(element);
            element.setModified();
        }
    }

    private void addAppliedProperty(@NotNull GradleDslElement element) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(5);
        }
        element.addHolder(this);
        this.addPropertyInternal(element, ElementState.APPLIED);
    }

    private void removePropertyInternal(@NotNull String property2) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(6);
        }
        List elements = this.myProperties.removeAll(e -> {
            if (property2 == null) {
                GradlePropertiesDslElement.$$$reportNull$$$0(107);
            }
            return ((ElementList.ElementItem)e).myElement.getName().equals(property2);
        });
        elements.forEach(e -> {
            e.setModified();
            this.updateDependenciesOnRemoveElement((GradleDslElement)e);
        });
        this.setModified();
    }

    private ElementState removePropertyInternal(@NotNull GradleDslElement element) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(7);
        }
        element.setModified();
        ElementState state = this.myProperties.remove(element);
        this.updateDependenciesOnRemoveElement(element);
        return state;
    }

    private ElementState replacePropertyInternal(@NotNull GradleDslElement element, @NotNull GradleDslElement newElement) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(8);
        }
        if (newElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(9);
        }
        element.setModified();
        this.updateDependenciesOnReplaceElement(element, newElement);
        newElement.setModified();
        ElementState oldState = this.myProperties.replaceElement(element, newElement);
        this.reorderAndMaybeGetNewIndex(newElement);
        return oldState;
    }

    private void hidePropertyInternal(@NotNull String property2) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(10);
        }
        this.myProperties.hideAll(e -> {
            if (property2 == null) {
                GradlePropertiesDslElement.$$$reportNull$$$0(106);
            }
            return ((ElementList.ElementItem)e).myElement.getName().equals(property2);
        });
    }

    public void addAppliedModelProperties(@NotNull GradleDslFile file) {
        if (file == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(11);
        }
        this.mergePropertiesFrom(file);
    }

    private void mergePropertiesFrom(@NotNull GradlePropertiesDslElement other) {
        if (other == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(12);
        }
        Map<String, GradleDslElement> ourProperties = this.getPropertyElements();
        for (Map.Entry<String, GradleDslElement> entry : other.getPropertyElements().entrySet()) {
            GradlePropertiesDslElement createdElement;
            GradleDslElement newProperty = entry.getValue();
            if (ourProperties.containsKey(entry.getKey())) {
                GradleDslElement existingProperty = this.getElementWhere(entry.getKey(), PROPERTY_FILTER);
                if (newProperty instanceof GradleDslBlockElement && existingProperty instanceof GradleDslBlockElement) {
                    ((GradlePropertiesDslElement)existingProperty).mergePropertiesFrom((GradlePropertiesDslElement)newProperty);
                    continue;
                }
            } else if (PropertyUtil.isPropertiesElementOrMap(newProperty) && (createdElement = this.getDslFile().getParser().getBlockElement(Arrays.asList(entry.getKey().split("\\.")), this)) != null) {
                createdElement.mergePropertiesFrom((GradlePropertiesDslElement)newProperty);
                continue;
            }
            this.addAppliedProperty(entry.getValue());
        }
    }

    public void setParsedElement(@NotNull GradleDslElement element) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(13);
        }
        element.setParent(this);
        this.addPropertyInternal(element, ElementState.EXISTING);
    }

    public void addParsedElement(@NotNull GradleDslElement element) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(14);
        }
        element.setParent(this);
        this.addPropertyInternal(element, ElementState.EXISTING);
    }

    protected void addParsedResettingElement(@NotNull GradleDslElement element, @NotNull String propertyToReset) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(15);
        }
        if (propertyToReset == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(16);
        }
        element.setParent(this);
        this.addPropertyInternal(element, ElementState.EXISTING);
        this.hidePropertyInternal(propertyToReset);
    }

    protected void addAsParsedDslExpressionList(GradleDslSimpleExpression expression) {
        PsiElement psiElement = expression.getPsiElement();
        if (psiElement == null) {
            return;
        }
        GradleDslExpressionList literalList = new GradleDslExpressionList((GradleDslElement)this, psiElement, GradleNameElement.create(expression.getName()), true);
        if (expression instanceof GradleDslMethodCall) {
            literalList.setPsiElement(((GradleDslMethodCall)expression).getArgumentListPsiElement());
            for (GradleDslElement gradleDslElement : ((GradleDslMethodCall)expression).getArguments()) {
                if (!(gradleDslElement instanceof GradleDslSimpleExpression)) continue;
                literalList.addParsedExpression((GradleDslSimpleExpression)gradleDslElement);
            }
        } else {
            literalList.addParsedExpression(expression);
        }
        this.addPropertyInternal(literalList, ElementState.EXISTING);
    }

    public void addToParsedExpressionList(@NotNull String property2, @NotNull GradleDslElement element) {
        PsiElement psiElement;
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(17);
        }
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(18);
        }
        if ((psiElement = element.getPsiElement()) == null) {
            return;
        }
        GradleDslExpressionList gradleDslExpressionList = this.getPropertyElement(property2, GradleDslExpressionList.class);
        if (gradleDslExpressionList == null) {
            gradleDslExpressionList = new GradleDslExpressionList((GradleDslElement)this, psiElement, GradleNameElement.create(property2), false);
            this.addPropertyInternal(gradleDslExpressionList, ElementState.EXISTING);
        } else {
            gradleDslExpressionList.setPsiElement(psiElement);
        }
        if (element instanceof GradleDslSimpleExpression) {
            gradleDslExpressionList.addParsedExpression((GradleDslSimpleExpression)element);
        } else if (element instanceof GradleDslExpressionList) {
            List<GradleDslExpression> gradleExpressions = ((GradleDslExpressionList)element).getExpressions();
            for (GradleDslExpression expression : gradleExpressions) {
                gradleDslExpressionList.addParsedExpression(expression);
            }
        }
    }

    @NotNull
    public Set<String> getProperties() {
        Set<String> set = this.getPropertyElements().keySet();
        if (set == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(19);
        }
        return set;
    }

    @NotNull
    public Map<String, GradleDslElement> getPropertyElements() {
        Map<String, GradleDslElement> map2 = this.getElementsWhere(PROPERTY_FILTER);
        if (map2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(20);
        }
        return map2;
    }

    @NotNull
    public <T extends GradleDslElement> List<T> getPropertyElements(@NotNull String name, @NotNull Class<T> clazz) {
        if (name == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(21);
        }
        if (clazz == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(22);
        }
        List list = this.myProperties.getElementsWhere(GradlePropertiesDslElement.PROPERTY_FILTER).stream().filter(e -> {
            if (clazz == null) {
                GradlePropertiesDslElement.$$$reportNull$$$0(104);
            }
            if (name == null) {
                GradlePropertiesDslElement.$$$reportNull$$$0(105);
            }
            return clazz.isAssignableFrom(e.getClass()) && e.getName().equals(name);
        }).map(e -> {
            if (clazz == null) {
                GradlePropertiesDslElement.$$$reportNull$$$0(103);
            }
            return (GradleDslElement)clazz.cast(e);
        }).collect(Collectors.toList());
        if (list == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    public List<GradleDslElement> getAllPropertyElements() {
        List list = this.myProperties.getElementsWhere(GradlePropertiesDslElement.PROPERTY_FILTER);
        if (list == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(24);
        }
        return list;
    }

    @NotNull
    public Map<String, GradleDslElement> getVariableElements() {
        Map<String, GradleDslElement> map2 = this.getElementsWhere(VARIABLE_FILTER);
        if (map2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(25);
        }
        return map2;
    }

    @NotNull
    public Map<String, GradleDslElement> getElements() {
        Map<String, GradleDslElement> map2 = this.getElementsWhere(ANY_FILTER);
        if (map2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(26);
        }
        return map2;
    }

    @NotNull
    public List<GradleDslElement> getAllElements() {
        List list = this.myProperties.getElementsWhere(GradlePropertiesDslElement.ANY_FILTER);
        if (list == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(27);
        }
        return list;
    }

    @NotNull
    private Map<String, GradleDslElement> getElementsWhere(@NotNull Predicate<ElementList.ElementItem> predicate) {
        if (predicate == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(28);
        }
        LinkedHashMap<String, GradleDslElement> results = new LinkedHashMap<String, GradleDslElement>();
        List elements = this.myProperties.getElementsWhere(predicate);
        for (GradleDslElement element : elements) {
            if (element == null) continue;
            results.put(element.getName(), element);
        }
        LinkedHashMap<String, GradleDslElement> linkedHashMap = results;
        if (linkedHashMap == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(29);
        }
        return linkedHashMap;
    }

    private GradleDslElement getElementWhere(@NotNull String name, @NotNull Predicate<ElementList.ElementItem> predicate) {
        if (name == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(30);
        }
        if (predicate == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(31);
        }
        return this.getElementsWhere(predicate).get(name);
    }

    @Nullable
    public GradleDslElement getVariableElement(@NotNull String property2) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(32);
        }
        return this.getElementWhere(property2, VARIABLE_FILTER);
    }

    @Nullable
    public GradleDslElement getPropertyElement(@NotNull String property2) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(33);
        }
        return this.getElementWhere(property2, PROPERTY_FILTER);
    }

    @Nullable
    public GradleDslElement getElement(@NotNull String property2) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(34);
        }
        return this.getElementWhere(property2, ANY_FILTER);
    }

    @Nullable
    public GradleDslElement getPropertyElementBefore(@Nullable GradleDslElement element, @NotNull String property2) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(35);
        }
        if (element == null) {
            return this.getElementWhere(property2, PROPERTY_FILTER);
        }
        return this.myProperties.getElementBeforeChildWhere(e -> {
            if (property2 == null) {
                GradlePropertiesDslElement.$$$reportNull$$$0(102);
            }
            return GradlePropertiesDslElement.PROPERTY_FILTER.test((ElementList.ElementItem)e) && ((ElementList.ElementItem)e).myElement.getName().equals(property2);
        }, element);
    }

    @Nullable
    GradleDslElement getElementBefore(@Nullable GradleDslElement element, @NotNull String property2) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(36);
        }
        if (element == null) {
            return this.getElementWhere(property2, ANY_FILTER);
        }
        return this.myProperties.getElementBeforeChildWhere(e -> {
            if (property2 == null) {
                GradlePropertiesDslElement.$$$reportNull$$$0(101);
            }
            return GradlePropertiesDslElement.ANY_FILTER.test((ElementList.ElementItem)e) && ((ElementList.ElementItem)e).myElement.getName().equals(property2);
        }, element);
    }

    @Nullable
    public <T extends GradleDslElement> T getPropertyElement(@NotNull String property2, @NotNull Class<T> clazz) {
        GradleDslElement propertyElement;
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(37);
        }
        if (clazz == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(38);
        }
        return (T)(clazz.isInstance(propertyElement = this.getPropertyElement(property2)) ? (GradleDslElement)clazz.cast(propertyElement) : null);
    }

    @Nullable
    public <T extends GradleDslElement> T getPropertyElement(@NotNull List<String> properties, @NotNull Class<T> clazz) {
        GradleDslElement propertyElement;
        if (properties == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(39);
        }
        if (clazz == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(40);
        }
        return (T)(clazz.isInstance(propertyElement = this.myProperties.getElementWhere(e -> {
            if (properties == null) {
                GradlePropertiesDslElement.$$$reportNull$$$0(100);
            }
            return properties.contains(((ElementList.ElementItem)e).myElement.getName());
        })) ? (GradleDslElement)clazz.cast(propertyElement) : null);
    }

    @NotNull
    public <T extends GradleDslElement> List<T> getPropertyElements(@NotNull Class<T> clazz) {
        if (clazz == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(41);
        }
        List list = this.myProperties.getElementsWhere(GradlePropertiesDslElement.PROPERTY_FILTER).stream().filter(e -> {
            if (clazz == null) {
                GradlePropertiesDslElement.$$$reportNull$$$0(99);
            }
            return clazz.isAssignableFrom(e.getClass());
        }).map(e -> {
            if (clazz == null) {
                GradlePropertiesDslElement.$$$reportNull$$$0(98);
            }
            return (GradleDslElement)clazz.cast(e);
        }).collect(Collectors.toList());
        if (list == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(42);
        }
        return list;
    }

    @NotNull
    public List<GradleDslElement> getPropertyElementsByName(@NotNull String propertyName) {
        if (propertyName == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(43);
        }
        List list = this.myProperties.getElementsWhere(e -> {
            if (propertyName == null) {
                GradlePropertiesDslElement.$$$reportNull$$$0(97);
            }
            return ((ElementList.ElementItem)e).myElement.getName().equals(propertyName) && GradlePropertiesDslElement.PROPERTY_FILTER.test((ElementList.ElementItem)e);
        });
        if (list == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(44);
        }
        return list;
    }

    @NotNull
    public List<GradleDslElement> getOriginalElements() {
        List<GradleDslElement> list = this.myProperties.myElements.stream().filter(e -> ((ElementList.ElementItem)e).myExistsOnFile).map(e -> ((ElementList.ElementItem)e).myElement).collect(Collectors.toList());
        if (list == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(45);
        }
        return list;
    }

    @Nullable
    public GradleDslElement getOriginalElementForNameAndType(@NotNull String name, @NotNull PropertyType type) {
        if (name == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(46);
        }
        if (type == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(47);
        }
        return this.myProperties.myElements.stream().filter(e -> {
            if (name == null) {
                GradlePropertiesDslElement.$$$reportNull$$$0(95);
            }
            if (type == null) {
                GradlePropertiesDslElement.$$$reportNull$$$0(96);
            }
            return ((ElementList.ElementItem)e).myElement.getName().equals(name) && ((ElementList.ElementItem)e).myExistsOnFile && ((ElementList.ElementItem)e).myElement.getElementType() == type;
        }).map(e -> ((ElementList.ElementItem)e).myElement).reduce((a, b) -> b).orElse(null);
    }

    @NotNull
    public List<GradleDslElement> getCurrentElements() {
        List<GradleDslElement> list = this.myProperties.myElements.stream().filter(e -> ((ElementList.ElementItem)e).myElementState == ElementState.TO_BE_ADDED || ((ElementList.ElementItem)e).myElementState == ElementState.EXISTING).map(e -> ((ElementList.ElementItem)e).myElement).collect(Collectors.toList());
        if (list == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(48);
        }
        return list;
    }

    @NotNull
    public GradleDslElement setNewElement(@NotNull GradleDslElement newElement) {
        if (newElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(49);
        }
        newElement.setParent(this);
        this.addPropertyInternal(newElement, ElementState.TO_BE_ADDED);
        this.setModified();
        GradleDslElement gradleDslElement = newElement;
        if (gradleDslElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(50);
        }
        return gradleDslElement;
    }

    public void addNewElementAt(int index, @NotNull GradleDslElement newElement) {
        if (newElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(51);
        }
        newElement.setParent(this);
        this.addPropertyInternal(index, newElement, ElementState.TO_BE_ADDED);
        this.setModified();
    }

    public <T> void addNewElementBeforeAllOfClass(@NotNull GradleDslElement newElement, @NotNull Class<T> clazz) {
        if (newElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(52);
        }
        if (clazz == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(53);
        }
        List<GradleDslElement> elements = this.getAllElements();
        int index = elements.size() - 1;
        for (int i = 0; i < elements.size() - 1; ++i) {
            if (!clazz.isInstance(elements.get(i))) continue;
            index = i;
        }
        this.addNewElementAt(index, newElement);
    }

    public void moveElementTo(int index, @NotNull GradleDslElement newElement) {
        if (newElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(54);
        }
        assert (newElement.getParent() == this);
        this.myProperties.moveElementToIndex(newElement, index);
    }

    @NotNull
    public GradleDslElement replaceElement(@NotNull GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        if (oldElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(55);
        }
        if (newElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(56);
        }
        newElement.setParent(this);
        ArrayList<GradlePropertiesDslElement> holders = new ArrayList<GradlePropertiesDslElement>();
        holders.add(this);
        holders.addAll(oldElement.getHolders());
        for (GradlePropertiesDslElement holder : holders) {
            holder.replacePropertyInternal(oldElement, newElement);
        }
        GradleDslElement gradleDslElement = newElement;
        if (gradleDslElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(57);
        }
        return gradleDslElement;
    }

    @Nullable
    public <T> T getLiteral(@NotNull String property2, @NotNull Class<T> clazz) {
        GradleDslSimpleExpression expression;
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(58);
        }
        if (clazz == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(59);
        }
        if ((expression = this.getPropertyElement(property2, GradleDslSimpleExpression.class)) == null) {
            return null;
        }
        return expression.getValue(clazz);
    }

    @NotNull
    public GradleDslElement setNewLiteral(@NotNull String property2, @NotNull Object value) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(60);
        }
        if (value == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(61);
        }
        GradleDslElement gradleDslElement = this.setNewLiteralImpl(property2, value);
        if (gradleDslElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(62);
        }
        return gradleDslElement;
    }

    @NotNull
    private GradleDslElement setNewLiteralImpl(@NotNull String property2, @NotNull Object value) {
        GradleDslLiteral literalElement;
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(63);
        }
        if (value == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(64);
        }
        if ((literalElement = this.getPropertyElement(property2, GradleDslLiteral.class)) == null) {
            literalElement = new GradleDslLiteral(this, GradleNameElement.create(property2));
            this.addPropertyInternal(literalElement, ElementState.TO_BE_ADDED);
        }
        literalElement.setValue(value);
        GradleDslLiteral gradleDslLiteral = literalElement;
        if (gradleDslLiteral == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(65);
        }
        return gradleDslLiteral;
    }

    @NotNull
    public GradlePropertiesDslElement addToNewLiteralList(@NotNull String property2, @NotNull String value) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(66);
        }
        if (value == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(67);
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.addToNewLiteralListImpl(property2, value);
        if (gradlePropertiesDslElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(68);
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    private GradlePropertiesDslElement addToNewLiteralListImpl(@NotNull String property2, @NotNull Object value) {
        GradleDslExpressionList gradleDslExpressionList;
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(69);
        }
        if (value == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(70);
        }
        if ((gradleDslExpressionList = this.getPropertyElement(property2, GradleDslExpressionList.class)) == null) {
            gradleDslExpressionList = new GradleDslExpressionList((GradleDslElement)this, GradleNameElement.create(property2), false);
            this.addPropertyInternal(gradleDslExpressionList, ElementState.TO_BE_ADDED);
        }
        gradleDslExpressionList.addNewLiteral(value);
        GradlePropertiesDslElement gradlePropertiesDslElement = this;
        if (gradlePropertiesDslElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(71);
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement removeFromExpressionList(@NotNull String property2, @NotNull String value) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(72);
        }
        if (value == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(73);
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.removeFromExpressionListImpl(property2, value);
        if (gradlePropertiesDslElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(74);
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    private GradlePropertiesDslElement removeFromExpressionListImpl(@NotNull String property2, @NotNull Object value) {
        GradleDslExpressionList gradleDslExpressionList;
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(75);
        }
        if (value == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(76);
        }
        if ((gradleDslExpressionList = this.getPropertyElement(property2, GradleDslExpressionList.class)) != null) {
            gradleDslExpressionList.removeExpression(value);
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this;
        if (gradlePropertiesDslElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(77);
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement replaceInExpressionList(@NotNull String property2, @NotNull String oldValue, @NotNull String newValue) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(78);
        }
        if (oldValue == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(79);
        }
        if (newValue == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(80);
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.replaceInExpressionListImpl(property2, oldValue, newValue);
        if (gradlePropertiesDslElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(81);
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    private GradlePropertiesDslElement replaceInExpressionListImpl(@NotNull String property2, @NotNull Object oldValue, @NotNull Object newValue) {
        GradleDslExpressionList gradleDslExpressionList;
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(82);
        }
        if (oldValue == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(83);
        }
        if (newValue == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(84);
        }
        if ((gradleDslExpressionList = this.getPropertyElement(property2, GradleDslExpressionList.class)) != null) {
            gradleDslExpressionList.replaceExpression(oldValue, newValue);
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this;
        if (gradlePropertiesDslElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(85);
        }
        return gradlePropertiesDslElement;
    }

    public void removeProperty(@NotNull String property2) {
        if (property2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(86);
        }
        this.removePropertyInternal(property2);
    }

    public void removeProperty(@NotNull GradleDslElement element) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(87);
        }
        this.removePropertyInternal(element);
    }

    @Override
    @Nullable
    public GradleDslElement requestAnchor(@NotNull GradleDslElement element) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(88);
        }
        GradleDslElement lastElement = null;
        for (ElementList.ElementItem item : this.myProperties.myElements) {
            if (item.myElement == element) {
                return lastElement;
            }
            if (item.myElementState == ElementState.TO_BE_REMOVED || item.myElementState == ElementState.HIDDEN || item.myElementState == ElementState.APPLIED || !item.myElement.getNameElement().qualifyingParts().equals(element.getNameElement().qualifyingParts())) continue;
            if (item.myElement instanceof ApplyDslElement) {
                lastElement = item.myElement.requestAnchor(element);
                continue;
            }
            lastElement = item.myElement;
        }
        return lastElement;
    }

    @Override
    @NotNull
    public Collection<GradleDslElement> getChildren() {
        List<GradleDslElement> list = this.getAllElements();
        if (list == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(89);
        }
        return list;
    }

    @Override
    @NotNull
    public List<GradleDslElement> getContainedElements(boolean includeProperties) {
        ArrayList<GradleDslElement> result2 = new ArrayList<GradleDslElement>();
        if (includeProperties) {
            result2.addAll(this.getElementsWhere(e -> ((ElementList.ElementItem)e).myElementState != ElementState.APPLIED).values());
        } else {
            result2.addAll(this.getVariableElements().values());
        }
        List<GradlePropertiesDslElement> holders = this.getPropertyElements(GradlePropertiesDslElement.class).stream().filter(e -> !(e instanceof GradleDslExpression)).collect(Collectors.toList());
        holders.forEach(e -> result2.addAll(e.getContainedElements(includeProperties)));
        ArrayList<GradleDslElement> arrayList = result2;
        if (arrayList == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(90);
        }
        return arrayList;
    }

    @Override
    protected void apply() {
        this.myProperties.removeElements(GradleDslElement::delete);
        this.myProperties.createElements(e -> e.create() != null);
        this.myProperties.applyElements(e -> {
            if (e.isModified()) {
                e.applyChanges();
            }
        });
        this.myProperties.forEach(item -> {
            if (((ElementList.ElementItem)item).myElementState == ElementState.MOVED) {
                ((ElementList.ElementItem)item).myElement.move();
            }
        });
    }

    @Override
    protected void reset() {
        this.myProperties.reset();
    }

    protected void clear() {
        this.myProperties.clear();
    }

    public int reorderAndMaybeGetNewIndex(@NotNull GradleDslElement element) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(91);
        }
        int result2 = this.sortElementsAndMaybeGetNewIndex(element);
        element.resolve();
        return result2;
    }

    private int sortElementsAndMaybeGetNewIndex(@NotNull GradleDslElement element) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(92);
        }
        List currentElements = this.myProperties.getElementsWhere(e -> ((ElementList.ElementItem)e).myElementState == ElementState.EXISTING || ((ElementList.ElementItem)e).myElementState == ElementState.TO_BE_ADDED);
        ArrayList<GradleDslElement> sortedElements = new ArrayList<GradleDslElement>();
        boolean result2 = ElementSort.create(this, element).sort(currentElements, sortedElements);
        int resultIndex = this.myProperties.myElements.size();
        if (!result2) {
            this.notification(NotificationTypeReference.PROPERTY_PLACEMENT);
            return resultIndex;
        }
        int i = 0;
        int j = 0;
        while (i < currentElements.size() && j < sortedElements.size()) {
            if (currentElements.get(i) == sortedElements.get(i)) {
                ++i;
                ++j;
                continue;
            }
            if (sortedElements.get(i) == element && !currentElements.contains(element)) {
                resultIndex = i;
                ++j;
                continue;
            }
            this.moveElementTo(i, (GradleDslElement)sortedElements.get(j));
            ++i;
            ++j;
        }
        return resultIndex;
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getDependencies() {
        List<GradleReferenceInjection> list = this.myProperties.getElementsWhere(e -> ((ElementList.ElementItem)e).myElementState != ElementState.APPLIED).stream().map(GradleDslElement::getDependencies).flatMap(Collection::stream).collect(Collectors.toList());
        if (list == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(93);
        }
        return list;
    }

    public boolean isApplied(@NotNull GradleDslElement element) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(94);
        }
        for (ElementList.ElementItem item : this.myProperties.myElements) {
            if (item.myElement != element) continue;
            return item.myElementState == ElementState.APPLIED;
        }
        throw new IllegalStateException("Element not found in parent");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 42: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 57: 
            case 62: 
            case 65: 
            case 68: 
            case 71: 
            case 74: 
            case 77: 
            case 81: 
            case 85: 
            case 89: 
            case 90: 
            case 93: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 42: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 57: 
            case 62: 
            case 65: 
            case 68: 
            case 71: 
            case 74: 
            case 77: 
            case 81: 
            case 85: 
            case 89: 
            case 90: 
            case 93: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 87: 
            case 88: 
            case 91: 
            case 92: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: 
            case 10: 
            case 17: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 58: 
            case 60: 
            case 63: 
            case 66: 
            case 69: 
            case 72: 
            case 75: 
            case 78: 
            case 82: 
            case 86: 
            case 101: 
            case 102: 
            case 106: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 9: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyToReset";
                break;
            }
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 42: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 57: 
            case 62: 
            case 65: 
            case 68: 
            case 71: 
            case 74: 
            case 77: 
            case 81: 
            case 85: 
            case 89: 
            case 90: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement";
                break;
            }
            case 22: 
            case 38: 
            case 40: 
            case 41: 
            case 53: 
            case 59: 
            case 98: 
            case 99: 
            case 103: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 39: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 43: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 47: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldElement";
                break;
            }
            case 61: 
            case 64: 
            case 67: 
            case 70: 
            case 73: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 79: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldValue";
                break;
            }
            case 80: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 20: 
            case 23: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyElements";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPropertyElements";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableElements";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllElements";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsWhere";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyElementsByName";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalElements";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentElements";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "setNewElement";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceElement";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "setNewLiteral";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "setNewLiteralImpl";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "addToNewLiteralList";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "addToNewLiteralListImpl";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "removeFromExpressionList";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "removeFromExpressionListImpl";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceInExpressionList";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceInExpressionListImpl";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainedElements";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyInternal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addAppliedProperty";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyInternal";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "replacePropertyInternal";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hidePropertyInternal";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addAppliedModelProperties";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "mergePropertiesFrom";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setParsedElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addParsedElement";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addParsedResettingElement";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addToParsedExpressionList";
                break;
            }
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 42: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 57: 
            case 62: 
            case 65: 
            case 68: 
            case 71: 
            case 74: 
            case 77: 
            case 81: 
            case 85: 
            case 89: 
            case 90: 
            case 93: {
                break;
            }
            case 21: 
            case 22: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyElements";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getElementsWhere";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getElementWhere";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getVariableElement";
                break;
            }
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyElement";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyElementBefore";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getElementBefore";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyElementsByName";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalElementForNameAndType";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "setNewElement";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addNewElementAt";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "addNewElementBeforeAllOfClass";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "moveElementTo";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "replaceElement";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getLiteral";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "setNewLiteral";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "setNewLiteralImpl";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "addToNewLiteralList";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "addToNewLiteralListImpl";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "removeFromExpressionList";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "removeFromExpressionListImpl";
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "replaceInExpressionList";
                break;
            }
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "replaceInExpressionListImpl";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "removeProperty";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "requestAnchor";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "reorderAndMaybeGetNewIndex";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "sortElementsAndMaybeGetNewIndex";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "isApplied";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getOriginalElementForNameAndType$15";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getPropertyElementsByName$12";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getPropertyElements$11";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getPropertyElements$10";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getPropertyElement$9";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getElementBefore$8";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getPropertyElementBefore$7";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getPropertyElements$6";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getPropertyElements$5";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "lambda$hidePropertyInternal$4";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removePropertyInternal$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 42: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 57: 
            case 62: 
            case 65: 
            case 68: 
            case 71: 
            case 74: 
            case 77: 
            case 81: 
            case 85: 
            case 89: 
            case 90: 
            case 93: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ElementList {
        @NotNull
        private final List<ElementItem> myElements = new ArrayList<ElementItem>();

        private ElementList() {
        }

        private void forEach(@NotNull Consumer<ElementItem> func) {
            if (func == null) {
                ElementList.$$$reportNull$$$0(0);
            }
            this.myElements.forEach(func);
        }

        @NotNull
        private List<GradleDslElement> getElementsWhere(@NotNull Predicate<ElementItem> predicate) {
            if (predicate == null) {
                ElementList.$$$reportNull$$$0(1);
            }
            List<GradleDslElement> list = this.myElements.stream().filter(e -> ((ElementItem)e).myElementState != ElementState.TO_BE_REMOVED && ((ElementItem)e).myElementState != ElementState.HIDDEN).filter(predicate).map(e -> ((ElementItem)e).myElement).collect(Collectors.toList());
            if (list == null) {
                ElementList.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Nullable
        private GradleDslElement getElementWhere(@NotNull Predicate<ElementItem> predicate) {
            if (predicate == null) {
                ElementList.$$$reportNull$$$0(3);
            }
            return this.myElements.stream().filter(e -> ((ElementItem)e).myElementState != ElementState.TO_BE_REMOVED && ((ElementItem)e).myElementState != ElementState.HIDDEN).filter(predicate).map(e -> ((ElementItem)e).myElement).reduce((first, second) -> second).orElse(null);
        }

        @Nullable
        private GradleDslElement getElementBeforeChildWhere(@NotNull Predicate<ElementItem> predicate, @NotNull GradleDslElement child) {
            if (predicate == null) {
                ElementList.$$$reportNull$$$0(4);
            }
            if (child == null) {
                ElementList.$$$reportNull$$$0(5);
            }
            GradleDslElement lastElement = null;
            for (ElementItem i : this.myElements) {
                if (i.myElementState == ElementState.TO_BE_REMOVED || i.myElementState == ElementState.HIDDEN) continue;
                if (predicate.test(i)) {
                    lastElement = i.myElement;
                }
                if (i.myElement != child) continue;
                return lastElement;
            }
            return lastElement;
        }

        private void addElement(@NotNull GradleDslElement newElement, @NotNull ElementState state, boolean onFile) {
            if (newElement == null) {
                ElementList.$$$reportNull$$$0(6);
            }
            if (state == null) {
                ElementList.$$$reportNull$$$0(7);
            }
            this.myElements.add(new ElementItem(newElement, state, onFile));
        }

        private void addElementAtIndex(@NotNull GradleDslElement newElement, @NotNull ElementState state, int index, boolean onFile) {
            if (newElement == null) {
                ElementList.$$$reportNull$$$0(8);
            }
            if (state == null) {
                ElementList.$$$reportNull$$$0(9);
            }
            this.myElements.add(this.getRealIndex(index, newElement), new ElementItem(newElement, state, onFile));
        }

        private void moveElementToIndex(@NotNull GradleDslElement element, int index) {
            ElementItem item;
            if (element == null) {
                ElementList.$$$reportNull$$$0(10);
            }
            if ((item = (ElementItem)this.myElements.stream().filter(e -> {
                if (element == null) {
                    ElementList.$$$reportNull$$$0(22);
                }
                return ((ElementItem)e).myElement == element;
            }).findFirst().orElse(null)) == null) {
                return;
            }
            this.myElements.remove(item);
            ElementList.moveElementTree(item);
            this.myElements.add(this.getRealIndex(index, element), item);
        }

        private int getRealIndex(int index, @NotNull GradleDslElement element) {
            if (element == null) {
                ElementList.$$$reportNull$$$0(11);
            }
            if (index <= 0) {
                return 0;
            }
            for (int i = 0; i < this.myElements.size(); ++i) {
                if (index == 0) {
                    return i;
                }
                ElementItem item = this.myElements.get(i);
                if (item.myElementState == ElementState.TO_BE_REMOVED || item.myElementState == ElementState.APPLIED || item.myElementState == ElementState.HIDDEN) continue;
                --index;
            }
            return this.myElements.size();
        }

        @Nullable
        private ElementState remove(@NotNull GradleDslElement element) {
            ElementItem item;
            if (element == null) {
                ElementList.$$$reportNull$$$0(12);
            }
            if ((item = (ElementItem)this.myElements.stream().filter(e -> {
                if (element == null) {
                    ElementList.$$$reportNull$$$0(21);
                }
                return element == ((ElementItem)e).myElement;
            }).findFirst().orElse(null)) == null) {
                return null;
            }
            ElementState oldState = item.myElementState;
            item.myElementState = ElementState.TO_BE_REMOVED;
            return oldState;
        }

        @Nullable
        private ElementState replaceElement(@Nullable GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
            if (newElement == null) {
                ElementList.$$$reportNull$$$0(13);
            }
            for (int i = 0; i < this.myElements.size(); ++i) {
                ElementItem item = this.myElements.get(i);
                if (oldElement != item.myElement) continue;
                ElementState oldState = item.myElementState;
                item.myElementState = ElementState.TO_BE_REMOVED;
                ElementState newState = ElementState.TO_BE_ADDED;
                if (oldState == ElementState.APPLIED || oldState == ElementState.HIDDEN) {
                    newState = oldState;
                }
                this.myElements.add(i, new ElementItem(newElement, newState, false));
                return oldState;
            }
            return null;
        }

        @NotNull
        private List<GradleDslElement> removeAll(@NotNull Predicate<ElementItem> filter2) {
            if (filter2 == null) {
                ElementList.$$$reportNull$$$0(14);
            }
            List<ElementItem> toBeRemoved = this.myElements.stream().filter(filter2).collect(Collectors.toList());
            toBeRemoved.forEach((? super T e) -> ((ElementItem)e).myElementState = ElementState.TO_BE_REMOVED);
            List<GradleDslElement> list = toBeRemoved.stream().map(e -> ((ElementItem)e).myElement).collect(Collectors.toList());
            if (list == null) {
                ElementList.$$$reportNull$$$0(15);
            }
            return list;
        }

        private void hideAll(@NotNull Predicate<ElementItem> filter2) {
            if (filter2 == null) {
                ElementList.$$$reportNull$$$0(16);
            }
            this.myElements.stream().filter(filter2).forEach((? super T e) -> ((ElementItem)e).myElementState = ElementState.HIDDEN);
        }

        private boolean isEmpty() {
            return this.myElements.isEmpty();
        }

        private void reset() {
            Iterator<ElementItem> i = this.myElements.iterator();
            while (i.hasNext()) {
                ElementItem item = i.next();
                item.myElement.resetState();
                if (item.myElementState == ElementState.TO_BE_REMOVED) {
                    item.myElementState = ElementState.EXISTING;
                }
                if (item.myElementState != ElementState.TO_BE_ADDED) continue;
                i.remove();
            }
        }

        private void removeElements(@NotNull Consumer<GradleDslElement> removeFunc) {
            if (removeFunc == null) {
                ElementList.$$$reportNull$$$0(17);
            }
            Iterator<ElementItem> i = this.myElements.iterator();
            while (i.hasNext()) {
                ElementItem item = i.next();
                if (item.myElementState != ElementState.TO_BE_REMOVED) continue;
                removeFunc.accept(item.myElement);
                i.remove();
            }
        }

        private void createElements(@NotNull Predicate<GradleDslElement> addFunc) {
            if (addFunc == null) {
                ElementList.$$$reportNull$$$0(18);
            }
            Iterator<ElementItem> i = this.myElements.iterator();
            while (i.hasNext()) {
                ElementItem item = i.next();
                if (item.myElementState != ElementState.TO_BE_ADDED) continue;
                if (addFunc.test(item.myElement)) {
                    item.myElementState = ElementState.EXISTING;
                    continue;
                }
                i.remove();
            }
        }

        private void applyElements(@NotNull Consumer<GradleDslElement> func) {
            if (func == null) {
                ElementList.$$$reportNull$$$0(19);
            }
            this.myElements.stream().filter(e -> ((ElementItem)e).myElementState != ElementState.APPLIED).map(e -> ((ElementItem)e).myElement).forEach(func);
        }

        private void clear() {
            this.myElements.clear();
        }

        private static void moveElementTree(@NotNull ElementItem item) {
            if (item == null) {
                ElementList.$$$reportNull$$$0(20);
            }
            if (item.myElementState != ElementState.TO_BE_ADDED) {
                item.myElementState = ElementState.MOVED;
            }
            item.myElement.setModified();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 15: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "func";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
                case 2: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement$ElementList";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
                case 6: 
                case 8: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElement";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 21: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 14: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "removeFunc";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "addFunc";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement$ElementList";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementsWhere";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "removeAll";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "forEach";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementsWhere";
                    break;
                }
                case 2: 
                case 15: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementWhere";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementBeforeChildWhere";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addElement";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addElementAtIndex";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "moveElementToIndex";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getRealIndex";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceElement";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "removeAll";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "hideAll";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "removeElements";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "createElements";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "applyElements";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "moveElementTree";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$remove$6";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$moveElementToIndex$5";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 15: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class ElementItem {
            @NotNull
            private GradleDslElement myElement;
            @NotNull
            private ElementState myElementState;
            private boolean myExistsOnFile;

            private ElementItem(@NotNull GradleDslElement element, @NotNull ElementState state, boolean existsOnFile) {
                if (element == null) {
                    ElementItem.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    ElementItem.$$$reportNull$$$0(1);
                }
                this.myElement = element;
                this.myElementState = state;
                this.myExistsOnFile = existsOnFile;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement$ElementList$ElementItem";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

