/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.groovy;

import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.GradleDslParser;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.android.AaptOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.AdbOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.AndroidDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.BuildTypeDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.BuildTypesDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.CompileOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.DataBindingDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.DexOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.ExternalNativeBuildDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.LintOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.PackagingOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.ProductFlavorDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.ProductFlavorsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.SigningConfigDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.SigningConfigsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.SourceSetDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.SourceSetsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.SplitsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.TestOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.externalNativeBuild.CMakeDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.externalNativeBuild.NdkBuildDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.productFlavors.ExternalNativeBuildOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.productFlavors.NdkOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.productFlavors.VectorDrawablesOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.productFlavors.externalNativeBuild.CMakeOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.productFlavors.externalNativeBuild.NdkBuildOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.sourceSets.SourceDirectoryDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.sourceSets.SourceFileDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.splits.AbiDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.splits.DensityDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.splits.LanguageDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.testOptions.UnitTestsDslElement;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.BuildScriptDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.SubProjectsDslElement;
import com.android.tools.idea.gradle.dsl.parser.configurations.ConfigurationDslElement;
import com.android.tools.idea.gradle.dsl.parser.configurations.ConfigurationsDslElement;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependenciesDslElement;
import com.android.tools.idea.gradle.dsl.parser.dependencies.FakeArtifactElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslClosure;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSettableExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslUnknownElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.groovy.GroovyDslUtil;
import com.android.tools.idea.gradle.dsl.parser.repositories.FlatDirRepositoryDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.MavenCredentialsDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.MavenRepositoryDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.RepositoriesDslElement;
import com.android.tools.idea.gradle.dsl.parser.settings.ProjectPropertiesDslElement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class GroovyDslParser
implements GradleDslParser {
    @NotNull
    private final GroovyFile myPsiFile;
    @NotNull
    private final GradleDslFile myDslFile;

    public GroovyDslParser(@NotNull GroovyFile file, @NotNull GradleDslFile dslFile) {
        if (file == null) {
            GroovyDslParser.$$$reportNull$$$0(0);
        }
        if (dslFile == null) {
            GroovyDslParser.$$$reportNull$$$0(1);
        }
        this.myPsiFile = file;
        this.myDslFile = dslFile;
    }

    @Override
    public void parse() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.myPsiFile.acceptChildren((PsiElementVisitor)new GroovyPsiElementVisitor(new GroovyElementVisitor(){

            public void visitMethodCallExpression(@NotNull GrMethodCallExpression e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.process((GroovyPsiElement)e);
            }

            public void visitAssignmentExpression(@NotNull GrAssignmentExpression e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.process((GroovyPsiElement)e);
            }

            public void visitReferenceExpression(@NotNull GrReferenceExpression e) {
                if (e == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.process((GroovyPsiElement)e);
            }

            public void visitApplicationStatement(@NotNull GrApplicationStatement e) {
                if (e == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.process((GroovyPsiElement)e);
            }

            public void visitVariableDeclaration(@NotNull GrVariableDeclaration e) {
                if (e == null) {
                    1.$$$reportNull$$$0(4);
                }
                this.process((GroovyPsiElement)e);
            }

            void process(GroovyPsiElement e) {
                GroovyDslParser.this.parse((PsiElement)e, GroovyDslParser.this.myDslFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/groovy/GroovyDslParser$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAssignmentExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitApplicationStatement";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitVariableDeclaration";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
    }

    @Override
    @Nullable
    public PsiElement convertToPsiElement(@NotNull Object literal) {
        if (literal == null) {
            GroovyDslParser.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return GroovyDslUtil.createLiteral(this.myDslFile, literal);
    }

    @Override
    public void setUpForNewValue(@NotNull GradleDslLiteral context, @Nullable PsiElement newValue) {
        if (context == null) {
            GroovyDslParser.$$$reportNull$$$0(3);
        }
        if (newValue == null) {
            return;
        }
        boolean isReference = newValue instanceof GrReferenceExpression || newValue instanceof GrIndexProperty;
        context.setReference(isReference);
    }

    @Override
    @Nullable
    public Object extractValue(@NotNull GradleDslSimpleExpression context, @NotNull PsiElement literal, boolean resolve2) {
        if (context == null) {
            GroovyDslParser.$$$reportNull$$$0(4);
        }
        if (literal == null) {
            GroovyDslParser.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (literal instanceof GrReferenceExpression || literal instanceof GrIndexProperty) {
            GradleDslElement e;
            if (resolve2 && (e = context.resolveReference(literal.getText(), true)) instanceof GradleDslSimpleExpression) {
                return ((GradleDslSimpleExpression)e).getValue();
            }
            return literal.getText();
        }
        if (!(literal instanceof GrLiteral)) {
            return new ReferenceTo(literal.getText());
        }
        Object value = ((GrLiteral)literal).getValue();
        if (value != null) {
            return value;
        }
        if (!(literal instanceof GrString)) {
            return null;
        }
        if (!resolve2) {
            return GroovyDslUtil.ensureUnquotedText(literal.getText());
        }
        if (context.hasCycle()) {
            return GroovyDslUtil.ensureUnquotedText(literal.getText());
        }
        List<GradleReferenceInjection> injections = context.getResolvedVariables();
        return GroovyDslUtil.ensureUnquotedText(GradleReferenceInjection.injectAll(literal, injections));
    }

    @Override
    @Nullable
    public PsiElement convertToExcludesBlock(@NotNull List<ArtifactDependencySpec> excludes) {
        if (excludes == null) {
            GroovyDslParser.$$$reportNull$$$0(6);
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)this.myDslFile.getProject());
        GrClosableBlock block = factory.createClosureFromText("{\n}");
        for (ArtifactDependencySpec spec : excludes) {
            String group = FakeArtifactElement.shouldInterpolate(spec.getGroup()) ? GradlePropertyModel.iStr(spec.getGroup()) : "'" + spec.getGroup() + "'";
            String name = FakeArtifactElement.shouldInterpolate(spec.getName()) ? GradlePropertyModel.iStr(spec.getName()) : "'" + spec.getName() + "'";
            String text = String.format("exclude group: %s, module: %s", group, name);
            block.addBefore((PsiElement)factory.createStatementFromText((CharSequence)text), block.getLastChild());
            PsiElement lineTerminator = factory.createLineTerminator(1);
            block.addBefore(lineTerminator, block.getLastChild());
        }
        return block;
    }

    @Override
    public boolean shouldInterpolate(@NotNull GradleDslElement elementToCheck) {
        if (elementToCheck == null) {
            GroovyDslParser.$$$reportNull$$$0(7);
        }
        PsiElement element = elementToCheck instanceof GradleDslSettableExpression ? ((GradleDslSettableExpression)elementToCheck).getCurrentElement() : (elementToCheck instanceof GradleDslSimpleExpression ? ((GradleDslSimpleExpression)elementToCheck).getExpression() : elementToCheck.getPsiElement());
        return element instanceof GrString;
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getResolvedInjections(@NotNull GradleDslSimpleExpression context, @NotNull PsiElement psiElement) {
        if (context == null) {
            GroovyDslParser.$$$reportNull$$$0(8);
        }
        if (psiElement == null) {
            GroovyDslParser.$$$reportNull$$$0(9);
        }
        List<GradleReferenceInjection> list = GroovyDslUtil.findInjections(context, psiElement, false);
        if (list == null) {
            GroovyDslParser.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getInjections(@NotNull GradleDslSimpleExpression context, @NotNull PsiElement psiElement) {
        if (context == null) {
            GroovyDslParser.$$$reportNull$$$0(11);
        }
        if (psiElement == null) {
            GroovyDslParser.$$$reportNull$$$0(12);
        }
        List<GradleReferenceInjection> list = GroovyDslUtil.findInjections(context, psiElement, true);
        if (list == null) {
            GroovyDslParser.$$$reportNull$$$0(13);
        }
        return list;
    }

    private void parse(@NotNull PsiElement psiElement, @NotNull GradleDslFile gradleDslFile) {
        if (psiElement == null) {
            GroovyDslParser.$$$reportNull$$$0(14);
        }
        if (gradleDslFile == null) {
            GroovyDslParser.$$$reportNull$$$0(15);
        }
        boolean success = false;
        if (psiElement instanceof GrMethodCallExpression) {
            success = this.parse((GrMethodCallExpression)psiElement, (GradlePropertiesDslElement)gradleDslFile);
        } else if (psiElement instanceof GrAssignmentExpression) {
            success = this.parse((GrAssignmentExpression)psiElement, (GradlePropertiesDslElement)gradleDslFile);
        } else if (psiElement instanceof GrApplicationStatement) {
            success = this.parse((GrApplicationStatement)psiElement, (GradlePropertiesDslElement)gradleDslFile);
        } else if (psiElement instanceof GrVariableDeclaration) {
            success = this.parse((GrVariableDeclaration)psiElement, (GradlePropertiesDslElement)gradleDslFile);
        } else if (psiElement instanceof GrReferenceExpression) {
            success = this.parse((GrReferenceExpression)psiElement, (GradlePropertiesDslElement)gradleDslFile);
        }
        if (!success) {
            gradleDslFile.notification(NotificationTypeReference.INCOMPLETE_PARSING).addUnknownElement(psiElement);
        }
    }

    private boolean parse(@NotNull GrReferenceExpression element, @NotNull GradlePropertiesDslElement dslElement) {
        GradlePropertiesDslElement nestedElement;
        GradleNameElement name;
        if (element == null) {
            GroovyDslParser.$$$reportNull$$$0(16);
        }
        if (dslElement == null) {
            GroovyDslParser.$$$reportNull$$$0(17);
        }
        if ((name = GradleNameElement.from((PsiElement)element)).isQualified() && (nestedElement = this.getBlockElement(name.qualifyingParts(), dslElement)) != null) {
            dslElement = nestedElement;
        }
        if (!(dslElement instanceof ConfigurationsDslElement)) {
            return false;
        }
        ConfigurationDslElement resultElement = new ConfigurationDslElement(dslElement, (PsiElement)element, name, false);
        resultElement.setElementType(PropertyType.REGULAR);
        dslElement.addParsedElement(resultElement);
        return true;
    }

    private boolean parse(@NotNull GrMethodCallExpression expression, @NotNull GradlePropertiesDslElement dslElement) {
        GradlePropertiesDslElement blockElement;
        GrReferenceExpression referenceExpression;
        if (expression == null) {
            GroovyDslParser.$$$reportNull$$$0(18);
        }
        if (dslElement == null) {
            GroovyDslParser.$$$reportNull$$$0(19);
        }
        if ((referenceExpression = (GrReferenceExpression)PsiTreeUtil.findChildOfType((PsiElement)expression, GrReferenceExpression.class)) == null) {
            return false;
        }
        GradleNameElement name = GradleNameElement.from((PsiElement)referenceExpression);
        if (name.isEmpty()) {
            return false;
        }
        if (name.isQualified()) {
            dslElement = this.getBlockElement(name.qualifyingParts(), dslElement);
        }
        if (dslElement == null) {
            return false;
        }
        GrClosableBlock[] closureArguments = expression.getClosureArguments();
        GrArgumentList argumentList = expression.getArgumentList();
        if (argumentList.getAllArguments().length > 0 || closureArguments.length == 0) {
            GradleDslMethodCall methodCall = this.getMethodCall(dslElement, (PsiElement)expression, name, argumentList, name.fullName(), false);
            if (closureArguments.length > 0) {
                methodCall.setParsedClosureElement(this.getClosureElement(methodCall, closureArguments[0], name));
            }
            methodCall.setElementType(PropertyType.REGULAR);
            dslElement.addParsedElement(methodCall);
            return true;
        }
        GrClosableBlock closableBlock = closureArguments[0];
        ArrayList blockElements = Lists.newArrayList();
        if (dslElement instanceof GradleDslFile && name.name().equals("allprojects")) {
            blockElements.add(dslElement);
            name = GradleNameElement.create("subprojects");
        }
        if ((blockElement = this.getBlockElement((List<String>)ImmutableList.of((Object)name.name()), dslElement)) != null) {
            blockElement.setPsiElement((PsiElement)closableBlock);
            blockElements.add(blockElement);
        }
        if (blockElements.isEmpty()) {
            return false;
        }
        for (GradlePropertiesDslElement element : blockElements) {
            this.parse(closableBlock, element);
        }
        return true;
    }

    private void parse(@NotNull GrClosableBlock closure, final @NotNull GradlePropertiesDslElement blockElement) {
        if (closure == null) {
            GroovyDslParser.$$$reportNull$$$0(20);
        }
        if (blockElement == null) {
            GroovyDslParser.$$$reportNull$$$0(21);
        }
        closure.acceptChildren(new GroovyElementVisitor(){

            public void visitMethodCallExpression(@NotNull GrMethodCallExpression methodCallExpression) {
                if (methodCallExpression == null) {
                    2.$$$reportNull$$$0(0);
                }
                GroovyDslParser.this.parse(methodCallExpression, blockElement);
            }

            public void visitApplicationStatement(@NotNull GrApplicationStatement applicationStatement) {
                if (applicationStatement == null) {
                    2.$$$reportNull$$$0(1);
                }
                GroovyDslParser.this.parse(applicationStatement, blockElement);
            }

            public void visitAssignmentExpression(@NotNull GrAssignmentExpression expression) {
                if (expression == null) {
                    2.$$$reportNull$$$0(2);
                }
                GroovyDslParser.this.parse(expression, blockElement);
            }

            public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
                if (referenceExpression == null) {
                    2.$$$reportNull$$$0(3);
                }
                GroovyDslParser.this.parse(referenceExpression, blockElement);
            }

            public void visitVariableDeclaration(@NotNull GrVariableDeclaration variableDeclaration) {
                if (variableDeclaration == null) {
                    2.$$$reportNull$$$0(4);
                }
                GroovyDslParser.this.parse(variableDeclaration, blockElement);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "methodCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "applicationStatement";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceExpression";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "variableDeclaration";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/groovy/GroovyDslParser$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitApplicationStatement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAssignmentExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitVariableDeclaration";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private boolean parse(@NotNull GrApplicationStatement statement, @NotNull GradlePropertiesDslElement blockElement) {
        GrReferenceExpression referenceExpression;
        if (statement == null) {
            GroovyDslParser.$$$reportNull$$$0(22);
        }
        if (blockElement == null) {
            GroovyDslParser.$$$reportNull$$$0(23);
        }
        if ((referenceExpression = (GrReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)statement, GrReferenceExpression.class)) == null) {
            return false;
        }
        GrCommandArgumentList argumentList = (GrCommandArgumentList)PsiTreeUtil.getNextSiblingOfType((PsiElement)referenceExpression, GrCommandArgumentList.class);
        if (argumentList == null) {
            return false;
        }
        GroovyPsiElement[] arguments = argumentList.getAllArguments();
        if (arguments.length == 0) {
            return false;
        }
        GradleNameElement name = GradleNameElement.from((PsiElement)referenceExpression);
        if (name.isEmpty()) {
            return false;
        }
        if (name.isQualified()) {
            GradlePropertiesDslElement nestedElement = this.getBlockElement(name.qualifyingParts(), blockElement);
            if (nestedElement != null) {
                blockElement = nestedElement;
            } else {
                return false;
            }
        }
        GradleNameElement propertyName = GradleNameElement.from((PsiElement)referenceExpression);
        GradleDslElement propertyElement = null;
        if (arguments[0] instanceof GrExpression) {
            ArrayList<GrExpression> expressions = new ArrayList<GrExpression>(arguments.length);
            for (GroovyPsiElement element : arguments) {
                if (!(element instanceof GrExpression) || element instanceof GrClosableBlock) continue;
                expressions.add((GrExpression)element);
            }
            propertyElement = expressions.size() == 1 ? this.createExpressionElement(blockElement, (GroovyPsiElement)argumentList, propertyName, (GrExpression)expressions.get(0)) : this.getExpressionList(blockElement, (GroovyPsiElement)argumentList, propertyName, expressions, false);
        } else if (arguments[0] instanceof GrNamedArgument) {
            ArrayList<GrNamedArgument> namedArguments = new ArrayList<GrNamedArgument>(arguments.length);
            for (GroovyPsiElement element : arguments) {
                if (!(element instanceof GrNamedArgument) || element instanceof GrClosableBlock) continue;
                namedArguments.add((GrNamedArgument)element);
            }
            propertyElement = this.getExpressionMap(blockElement, (GroovyPsiElement)argumentList, propertyName, namedArguments, false);
        }
        if (propertyElement == null) {
            return false;
        }
        GroovyPsiElement lastArgument = arguments[arguments.length - 1];
        if (lastArgument instanceof GrClosableBlock) {
            propertyElement.setParsedClosureElement(this.getClosureElement(propertyElement, (GrClosableBlock)lastArgument, propertyName));
        }
        propertyElement.setElementType(PropertyType.REGULAR);
        blockElement.addParsedElement(propertyElement);
        return true;
    }

    @NotNull
    private GradleDslExpression createExpressionElement(@NotNull GradleDslElement parent, @NotNull GroovyPsiElement psiElement, @NotNull GradleNameElement name, @NotNull GrExpression expression) {
        GrListOrMap listOrMap;
        if (parent == null) {
            GroovyDslParser.$$$reportNull$$$0(24);
        }
        if (psiElement == null) {
            GroovyDslParser.$$$reportNull$$$0(25);
        }
        if (name == null) {
            GroovyDslParser.$$$reportNull$$$0(26);
        }
        if (expression == null) {
            GroovyDslParser.$$$reportNull$$$0(27);
        }
        GradleDslElement propertyElement = expression instanceof GrListOrMap ? ((listOrMap = (GrListOrMap)expression).isMap() ? this.getExpressionMap(parent, (GroovyPsiElement)listOrMap, name, Arrays.asList(listOrMap.getNamedArguments()), true) : this.getExpressionList(parent, (GroovyPsiElement)listOrMap, name, Arrays.asList(listOrMap.getInitializers()), true)) : (expression instanceof GrClosableBlock ? this.getClosureElement(parent, (GrClosableBlock)expression, name) : this.getExpressionElement(parent, psiElement, name, expression));
        GradleDslExpression gradleDslExpression = propertyElement;
        if (gradleDslExpression == null) {
            GroovyDslParser.$$$reportNull$$$0(28);
        }
        return gradleDslExpression;
    }

    private boolean parse(@NotNull GrVariableDeclaration declaration, @NotNull GradlePropertiesDslElement blockElement) {
        if (declaration == null) {
            GroovyDslParser.$$$reportNull$$$0(29);
        }
        if (blockElement == null) {
            GroovyDslParser.$$$reportNull$$$0(30);
        }
        if (declaration.getVariables().length == 0) {
            return false;
        }
        for (GrVariable variable : declaration.getVariables()) {
            if (variable == null) {
                return false;
            }
            GrExpression init = variable.getInitializerGroovy();
            if (init == null) {
                return false;
            }
            GradleNameElement name = GradleNameElement.from((PsiElement)variable);
            GradleDslExpression variableElement = this.createExpressionElement(blockElement, (GroovyPsiElement)declaration, name, init);
            variableElement.setElementType(PropertyType.VARIABLE);
            blockElement.setParsedElement(variableElement);
        }
        return true;
    }

    private boolean parse(@NotNull GrAssignmentExpression assignment, @NotNull GradlePropertiesDslElement blockElement) {
        GrExpression right;
        PsiElement operationToken;
        if (assignment == null) {
            GroovyDslParser.$$$reportNull$$$0(31);
        }
        if (blockElement == null) {
            GroovyDslParser.$$$reportNull$$$0(32);
        }
        if (!(operationToken = assignment.getOperationToken()).getText().equals("=")) {
            return false;
        }
        GrExpression left = assignment.getLValue();
        GradleNameElement name = GradleNameElement.from((PsiElement)left);
        if (name.isEmpty()) {
            return false;
        }
        if (name.isQualified()) {
            GradlePropertiesDslElement nestedElement = this.getBlockElement(name.qualifyingParts(), blockElement);
            if (nestedElement != null) {
                blockElement = nestedElement;
            } else {
                return false;
            }
        }
        if ((right = assignment.getRValue()) == null) {
            return false;
        }
        GradleDslExpression propertyElement = this.createExpressionElement(blockElement, (GroovyPsiElement)assignment, name, right);
        propertyElement.setUseAssignment(true);
        propertyElement.setElementType(PropertyType.REGULAR);
        blockElement.setParsedElement(propertyElement);
        return true;
    }

    @NotNull
    private GradleDslExpression getExpressionElement(@NotNull GradleDslElement parentElement, @NotNull GroovyPsiElement psiElement, @NotNull GradleNameElement propertyName, @NotNull GrExpression propertyExpression) {
        GrArgumentList argumentList;
        String objectName;
        GrNewExpression newExpression;
        GrCodeReferenceElement referenceElement;
        String methodName;
        GrMethodCallExpression methodCall;
        GrReferenceExpression callReferenceExpression;
        if (parentElement == null) {
            GroovyDslParser.$$$reportNull$$$0(33);
        }
        if (psiElement == null) {
            GroovyDslParser.$$$reportNull$$$0(34);
        }
        if (propertyName == null) {
            GroovyDslParser.$$$reportNull$$$0(35);
        }
        if (propertyExpression == null) {
            GroovyDslParser.$$$reportNull$$$0(36);
        }
        if (propertyExpression instanceof GrLiteral) {
            GradleDslLiteral gradleDslLiteral = new GradleDslLiteral(parentElement, (PsiElement)psiElement, propertyName, (PsiElement)propertyExpression, false);
            if (gradleDslLiteral == null) {
                GroovyDslParser.$$$reportNull$$$0(37);
            }
            return gradleDslLiteral;
        }
        if (propertyExpression instanceof GrReferenceExpression) {
            GradleDslLiteral gradleDslLiteral = new GradleDslLiteral(parentElement, (PsiElement)psiElement, propertyName, (PsiElement)propertyExpression, true);
            if (gradleDslLiteral == null) {
                GroovyDslParser.$$$reportNull$$$0(38);
            }
            return gradleDslLiteral;
        }
        if (propertyExpression instanceof GrMethodCallExpression && (callReferenceExpression = (GrReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)(methodCall = (GrMethodCallExpression)propertyExpression), GrReferenceExpression.class)) != null && !(methodName = callReferenceExpression.getText()).isEmpty()) {
            GrArgumentList argumentList2 = methodCall.getArgumentList();
            GradleDslMethodCall gradleDslMethodCall = this.getMethodCall(parentElement, (PsiElement)methodCall, propertyName, argumentList2, methodName, false);
            if (gradleDslMethodCall == null) {
                GroovyDslParser.$$$reportNull$$$0(39);
            }
            return gradleDslMethodCall;
        }
        if (propertyExpression instanceof GrIndexProperty) {
            GradleDslLiteral gradleDslLiteral = new GradleDslLiteral(parentElement, (PsiElement)psiElement, propertyName, (PsiElement)propertyExpression, true);
            if (gradleDslLiteral == null) {
                GroovyDslParser.$$$reportNull$$$0(40);
            }
            return gradleDslLiteral;
        }
        if (propertyExpression instanceof GrNewExpression && (referenceElement = (newExpression = (GrNewExpression)propertyExpression).getReferenceElement()) != null && (objectName = referenceElement.getReferenceName()) != null && !objectName.isEmpty() && (argumentList = newExpression.getArgumentList()) != null && argumentList.getAllArguments().length > 0) {
            GradleDslMethodCall gradleDslMethodCall = this.getMethodCall(parentElement, (PsiElement)newExpression, propertyName, argumentList, objectName, true);
            if (gradleDslMethodCall == null) {
                GroovyDslParser.$$$reportNull$$$0(41);
            }
            return gradleDslMethodCall;
        }
        parentElement.notification(NotificationTypeReference.INCOMPLETE_PARSING).addUnknownElement((PsiElement)propertyExpression);
        GradleDslUnknownElement gradleDslUnknownElement = new GradleDslUnknownElement(parentElement, (PsiElement)propertyExpression, propertyName);
        if (gradleDslUnknownElement == null) {
            GroovyDslParser.$$$reportNull$$$0(42);
        }
        return gradleDslUnknownElement;
    }

    @NotNull
    private GradleDslMethodCall getMethodCall(@NotNull GradleDslElement parentElement, @NotNull PsiElement psiElement, @NotNull GradleNameElement propertyName, @NotNull GrArgumentList argumentList, @NotNull String methodName, boolean isConstructor) {
        if (parentElement == null) {
            GroovyDslParser.$$$reportNull$$$0(43);
        }
        if (psiElement == null) {
            GroovyDslParser.$$$reportNull$$$0(44);
        }
        if (propertyName == null) {
            GroovyDslParser.$$$reportNull$$$0(45);
        }
        if (argumentList == null) {
            GroovyDslParser.$$$reportNull$$$0(46);
        }
        if (methodName == null) {
            GroovyDslParser.$$$reportNull$$$0(47);
        }
        GradleDslMethodCall methodCall = new GradleDslMethodCall(parentElement, psiElement, propertyName, methodName, isConstructor);
        GradleDslExpressionList arguments = this.getExpressionList(methodCall, (GroovyPsiElement)argumentList, GradleNameElement.empty(), Arrays.asList(argumentList.getExpressionArguments()), false);
        methodCall.setParsedArgumentList(arguments);
        GrNamedArgument[] namedArguments = argumentList.getNamedArguments();
        if (namedArguments.length > 0) {
            methodCall.addParsedExpression(this.getExpressionMap(methodCall, (GroovyPsiElement)argumentList, GradleNameElement.empty(), Arrays.asList(namedArguments), false));
        }
        GradleDslMethodCall gradleDslMethodCall = methodCall;
        if (gradleDslMethodCall == null) {
            GroovyDslParser.$$$reportNull$$$0(48);
        }
        return gradleDslMethodCall;
    }

    @NotNull
    private GradleDslExpressionList getExpressionList(@NotNull GradleDslElement parentElement, @NotNull GroovyPsiElement listPsiElement, @NotNull GradleNameElement propertyName, @NotNull List<GrExpression> propertyExpressions, boolean isLiteral) {
        if (parentElement == null) {
            GroovyDslParser.$$$reportNull$$$0(49);
        }
        if (listPsiElement == null) {
            GroovyDslParser.$$$reportNull$$$0(50);
        }
        if (propertyName == null) {
            GroovyDslParser.$$$reportNull$$$0(51);
        }
        if (propertyExpressions == null) {
            GroovyDslParser.$$$reportNull$$$0(52);
        }
        GradleDslExpressionList expressionList = new GradleDslExpressionList(parentElement, (PsiElement)listPsiElement, isLiteral, propertyName);
        for (GrExpression expression : propertyExpressions) {
            GradleDslExpression expressionElement = this.createExpressionElement(expressionList, (GroovyPsiElement)expression, GradleNameElement.empty(), expression);
            if (expressionElement instanceof GradleDslClosure) {
                parentElement.setParsedClosureElement((GradleDslClosure)expressionElement);
                continue;
            }
            expressionList.addParsedExpression(expressionElement);
        }
        GradleDslExpressionList gradleDslExpressionList = expressionList;
        if (gradleDslExpressionList == null) {
            GroovyDslParser.$$$reportNull$$$0(53);
        }
        return gradleDslExpressionList;
    }

    @NotNull
    private GradleDslExpressionMap getExpressionMap(@NotNull GradleDslElement parentElement, @NotNull GroovyPsiElement mapPsiElement, @NotNull GradleNameElement propertyName, @NotNull List<GrNamedArgument> namedArguments, boolean isLiteralMap) {
        if (parentElement == null) {
            GroovyDslParser.$$$reportNull$$$0(54);
        }
        if (mapPsiElement == null) {
            GroovyDslParser.$$$reportNull$$$0(55);
        }
        if (propertyName == null) {
            GroovyDslParser.$$$reportNull$$$0(56);
        }
        if (namedArguments == null) {
            GroovyDslParser.$$$reportNull$$$0(57);
        }
        GradleDslExpressionMap expressionMap = new GradleDslExpressionMap(parentElement, (PsiElement)mapPsiElement, propertyName, isLiteralMap);
        for (GrNamedArgument namedArgument : namedArguments) {
            GrExpression valueExpression;
            GradleNameElement argName;
            GrArgumentLabel nameLabel = namedArgument.getLabel();
            if (nameLabel == null || (argName = GradleNameElement.from(nameLabel.getNameElement())).isEmpty() || (valueExpression = namedArgument.getExpression()) == null) continue;
            GradleDslExpression valueElement = this.createExpressionElement(expressionMap, mapPsiElement, argName, valueExpression);
            if (valueElement instanceof GradleDslUnknownElement && valueExpression instanceof GrListOrMap) {
                GrListOrMap listOrMap = (GrListOrMap)valueExpression;
                valueElement = listOrMap.isMap() ? this.getExpressionMap(expressionMap, (GroovyPsiElement)listOrMap, argName, Arrays.asList(listOrMap.getNamedArguments()), true) : this.getExpressionList(expressionMap, (GroovyPsiElement)listOrMap, argName, Arrays.asList(listOrMap.getInitializers()), true);
            }
            expressionMap.setParsedElement(valueElement);
        }
        GradleDslExpressionMap gradleDslExpressionMap = expressionMap;
        if (gradleDslExpressionMap == null) {
            GroovyDslParser.$$$reportNull$$$0(58);
        }
        return gradleDslExpressionMap;
    }

    @NotNull
    private GradleDslClosure getClosureElement(@NotNull GradleDslElement parentElement, @NotNull GrClosableBlock closableBlock, @NotNull GradleNameElement propertyName) {
        if (parentElement == null) {
            GroovyDslParser.$$$reportNull$$$0(59);
        }
        if (closableBlock == null) {
            GroovyDslParser.$$$reportNull$$$0(60);
        }
        if (propertyName == null) {
            GroovyDslParser.$$$reportNull$$$0(61);
        }
        GradleDslClosure closureElement = new GradleDslClosure(parentElement, (PsiElement)closableBlock, propertyName);
        this.parse(closableBlock, (GradlePropertiesDslElement)closureElement);
        GradleDslClosure gradleDslClosure = closureElement;
        if (gradleDslClosure == null) {
            GroovyDslParser.$$$reportNull$$$0(62);
        }
        return gradleDslClosure;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public GradlePropertiesDslElement getBlockElement(@NotNull List<String> nameParts, @NotNull GradlePropertiesDslElement parentElement) {
        if (nameParts == null) {
            GroovyDslParser.$$$reportNull$$$0(63);
        }
        if (parentElement == null) {
            GroovyDslParser.$$$reportNull$$$0(64);
        }
        GradlePropertiesDslElement resultElement = parentElement;
        for (String nestedElementName : nameParts) {
            nestedElementName = nestedElementName.trim();
            GradleNameElement elementName = GradleNameElement.fake(nestedElementName);
            GradleDslElement element = resultElement.getElement(nestedElementName);
            if (element == null) {
                void var8_8;
                if ("rootProject".equals(nestedElementName)) {
                    resultElement = this.myDslFile;
                    continue;
                }
                if (!(resultElement instanceof BuildScriptDslElement) && "ext".equals(nestedElementName)) {
                    ExtDslElement extDslElement = new ExtDslElement(resultElement);
                } else if ("apply".equals(nestedElementName)) {
                    ApplyDslElement applyDslElement = new ApplyDslElement(resultElement);
                } else if (resultElement instanceof GradleDslFile || resultElement instanceof SubProjectsDslElement) {
                    if ("ext".equals(nestedElementName)) {
                        ExtDslElement extDslElement = new ExtDslElement(resultElement);
                    } else if ("android".equals(nestedElementName)) {
                        AndroidDslElement androidDslElement = new AndroidDslElement(resultElement);
                    } else if ("configurations".equals(nestedElementName)) {
                        ConfigurationsDslElement configurationsDslElement = new ConfigurationsDslElement(resultElement);
                    } else if ("dependencies".equals(nestedElementName)) {
                        DependenciesDslElement dependenciesDslElement = new DependenciesDslElement(resultElement);
                    } else if ("subprojects".equals(nestedElementName)) {
                        SubProjectsDslElement subProjectsDslElement = new SubProjectsDslElement(resultElement);
                    } else if ("buildscript".equals(nestedElementName)) {
                        BuildScriptDslElement buildScriptDslElement = new BuildScriptDslElement(resultElement);
                    } else if ("repositories".equals(nestedElementName)) {
                        RepositoriesDslElement repositoriesDslElement = new RepositoriesDslElement(resultElement);
                    } else {
                        String projectKey = ProjectPropertiesDslElement.getStandardProjectKey(nestedElementName);
                        if (projectKey == null) return null;
                        elementName = GradleNameElement.fake(projectKey);
                        ProjectPropertiesDslElement projectPropertiesDslElement = new ProjectPropertiesDslElement(resultElement, elementName);
                    }
                } else if (resultElement instanceof BuildScriptDslElement) {
                    if ("dependencies".equals(nestedElementName)) {
                        DependenciesDslElement dependenciesDslElement = new DependenciesDslElement(resultElement);
                    } else {
                        if (!"repositories".equals(nestedElementName)) return null;
                        RepositoriesDslElement repositoriesDslElement = new RepositoriesDslElement(resultElement);
                    }
                } else if (resultElement instanceof RepositoriesDslElement) {
                    if ("maven".equals(nestedElementName) || "jcenter".equals(nestedElementName)) {
                        MavenRepositoryDslElement mavenRepositoryDslElement = new MavenRepositoryDslElement(resultElement, elementName);
                    } else {
                        if (!"flatDir".equals(nestedElementName)) return null;
                        FlatDirRepositoryDslElement flatDirRepositoryDslElement = new FlatDirRepositoryDslElement(resultElement);
                    }
                } else if (resultElement instanceof MavenRepositoryDslElement) {
                    if (!"credentials".equals(nestedElementName)) return null;
                    MavenCredentialsDslElement mavenCredentialsDslElement = new MavenCredentialsDslElement(resultElement);
                } else if (resultElement instanceof AndroidDslElement) {
                    if ("defaultConfig".equals(nestedElementName)) {
                        ProductFlavorDslElement productFlavorDslElement = new ProductFlavorDslElement(resultElement, elementName);
                    } else if ("productFlavors".equals(nestedElementName)) {
                        ProductFlavorsDslElement productFlavorsDslElement = new ProductFlavorsDslElement(resultElement);
                    } else if ("buildTypes".equals(nestedElementName)) {
                        BuildTypesDslElement buildTypesDslElement = new BuildTypesDslElement(resultElement);
                    } else if ("compileOptions".equals(nestedElementName)) {
                        CompileOptionsDslElement compileOptionsDslElement = new CompileOptionsDslElement(resultElement);
                    } else if ("externalNativeBuild".equals(nestedElementName)) {
                        ExternalNativeBuildDslElement externalNativeBuildDslElement = new ExternalNativeBuildDslElement(resultElement);
                    } else if ("signingConfigs".equals(nestedElementName)) {
                        SigningConfigsDslElement signingConfigsDslElement = new SigningConfigsDslElement(resultElement);
                    } else if ("sourceSets".equals(nestedElementName)) {
                        SourceSetsDslElement sourceSetsDslElement = new SourceSetsDslElement(resultElement);
                    } else if ("aaptOptions".equals(nestedElementName)) {
                        AaptOptionsDslElement aaptOptionsDslElement = new AaptOptionsDslElement(resultElement);
                    } else if ("adbOptions".equals(nestedElementName)) {
                        AdbOptionsDslElement adbOptionsDslElement = new AdbOptionsDslElement(resultElement);
                    } else if ("dataBinding".equals(nestedElementName)) {
                        DataBindingDslElement dataBindingDslElement = new DataBindingDslElement(resultElement);
                    } else if ("dexOptions".equals(nestedElementName)) {
                        DexOptionsDslElement dexOptionsDslElement = new DexOptionsDslElement(resultElement);
                    } else if ("lintOptions".equals(nestedElementName)) {
                        LintOptionsDslElement lintOptionsDslElement = new LintOptionsDslElement(resultElement);
                    } else if ("packagingOptions".equals(nestedElementName)) {
                        PackagingOptionsDslElement packagingOptionsDslElement = new PackagingOptionsDslElement(resultElement);
                    } else if ("splits".equals(nestedElementName)) {
                        SplitsDslElement splitsDslElement = new SplitsDslElement(resultElement);
                    } else {
                        if (!"testOptions".equals(nestedElementName)) return null;
                        TestOptionsDslElement testOptionsDslElement = new TestOptionsDslElement(resultElement);
                    }
                } else if (resultElement instanceof ExternalNativeBuildDslElement) {
                    if ("cmake".equals(nestedElementName)) {
                        CMakeDslElement cMakeDslElement = new CMakeDslElement(resultElement);
                    } else {
                        if (!"ndkBuild".equals(nestedElementName)) return null;
                        NdkBuildDslElement ndkBuildDslElement = new NdkBuildDslElement(resultElement);
                    }
                } else if (resultElement instanceof ProductFlavorsDslElement) {
                    ProductFlavorDslElement productFlavorDslElement = new ProductFlavorDslElement(resultElement, elementName);
                } else if (resultElement instanceof ProductFlavorDslElement) {
                    if ("manifestPlaceholders".equals(nestedElementName) || "testInstrumentationRunnerArguments".equals(nestedElementName)) {
                        GradleDslExpressionMap gradleDslExpressionMap = new GradleDslExpressionMap(resultElement, elementName);
                    } else if ("externalNativeBuild".equals(nestedElementName)) {
                        ExternalNativeBuildOptionsDslElement externalNativeBuildOptionsDslElement = new ExternalNativeBuildOptionsDslElement(resultElement);
                    } else if ("ndk".equals(nestedElementName)) {
                        NdkOptionsDslElement ndkOptionsDslElement = new NdkOptionsDslElement(resultElement);
                    } else {
                        if (!"vectorDrawables".equals(nestedElementName)) return null;
                        VectorDrawablesOptionsDslElement vectorDrawablesOptionsDslElement = new VectorDrawablesOptionsDslElement(resultElement);
                    }
                } else if (resultElement instanceof BuildTypesDslElement) {
                    BuildTypeDslElement buildTypeDslElement = new BuildTypeDslElement(resultElement, elementName);
                } else if (resultElement instanceof BuildTypeDslElement && "manifestPlaceholders".equals(nestedElementName)) {
                    GradleDslExpressionMap gradleDslExpressionMap = new GradleDslExpressionMap(resultElement, elementName);
                } else if (resultElement instanceof SigningConfigsDslElement) {
                    SigningConfigDslElement signingConfigDslElement = new SigningConfigDslElement(resultElement, elementName);
                } else if (resultElement instanceof SourceSetsDslElement) {
                    SourceSetDslElement sourceSetDslElement = new SourceSetDslElement(resultElement, elementName);
                } else if (resultElement instanceof SourceSetDslElement) {
                    if ("manifest".equals(nestedElementName)) {
                        SourceFileDslElement sourceFileDslElement = new SourceFileDslElement(resultElement, elementName);
                    } else {
                        SourceDirectoryDslElement sourceDirectoryDslElement = new SourceDirectoryDslElement(resultElement, elementName);
                    }
                } else if (resultElement instanceof ExternalNativeBuildOptionsDslElement) {
                    if ("cmake".equals(nestedElementName)) {
                        CMakeOptionsDslElement cMakeOptionsDslElement = new CMakeOptionsDslElement(resultElement);
                    } else {
                        if (!"ndkBuild".equals(nestedElementName)) return null;
                        NdkBuildOptionsDslElement ndkBuildOptionsDslElement = new NdkBuildOptionsDslElement(resultElement);
                    }
                } else if (resultElement instanceof SplitsDslElement) {
                    if ("abi".equals(nestedElementName)) {
                        AbiDslElement abiDslElement = new AbiDslElement(resultElement);
                    } else if ("density".equals(nestedElementName)) {
                        DensityDslElement densityDslElement = new DensityDslElement(resultElement);
                    } else {
                        if (!"language".equals(nestedElementName)) return null;
                        LanguageDslElement languageDslElement = new LanguageDslElement(resultElement);
                    }
                } else if (resultElement instanceof TestOptionsDslElement) {
                    if (!"unitTests".equals(nestedElementName)) return null;
                    UnitTestsDslElement unitTestsDslElement = new UnitTestsDslElement(resultElement);
                } else {
                    if (!(resultElement instanceof ConfigurationsDslElement)) return null;
                    ConfigurationDslElement configurationDslElement = new ConfigurationDslElement(resultElement, elementName);
                }
                resultElement.setParsedElement((GradleDslElement)var8_8);
                resultElement = var8_8;
                continue;
            }
            if (!(element instanceof GradlePropertiesDslElement)) return null;
            resultElement = (GradlePropertiesDslElement)element;
        }
        return resultElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 13: 
            case 28: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 48: 
            case 53: 
            case 58: 
            case 62: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 13: 
            case 28: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 48: 
            case 53: 
            case 58: 
            case 62: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dslFile";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToCheck";
                break;
            }
            case 9: 
            case 12: 
            case 14: 
            case 25: 
            case 34: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 10: 
            case 13: 
            case 28: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 48: 
            case 53: 
            case 58: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/groovy/GroovyDslParser";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleDslFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dslElement";
                break;
            }
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 21: 
            case 23: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockElement";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 33: 
            case 43: 
            case 49: 
            case 54: 
            case 59: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 35: 
            case 45: 
            case 51: 
            case 56: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyExpression";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listPsiElement";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyExpressions";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapPsiElement";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedArguments";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closableBlock";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameParts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/groovy/GroovyDslParser";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedInjections";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjections";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpressionElement";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionElement";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodCall";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionList";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionMap";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getClosureElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertToPsiElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setUpForNewValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertToExcludesBlock";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "shouldInterpolate";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedInjections";
                break;
            }
            case 10: 
            case 13: 
            case 28: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 48: 
            case 53: 
            case 58: 
            case 62: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getInjections";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionElement";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionElement";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getMethodCall";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionList";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionMap";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getClosureElement";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getBlockElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 13: 
            case 28: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 48: 
            case 53: 
            case 58: 
            case 62: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

